/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans;

import chemaxon.marvin.beans.MarvinPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.CommonActions;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.TableSupport;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.GridBagView;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MMoleculeMovie;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MViewPane
extends MarvinPane {
    private static final long serialVersionUID = -4430811090653077262L;
    public static final int VIEW_ONLY = 0;
    public static final int EDITABLE = 1;
    public static final int SKETCHABLE = 2;
    private TableSupport tableSupport;
    private boolean preferredSizeSet = false;
    private ActionListener myActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            String cmd = ev.getActionCommand();
            if (cmd != null) {
                if (cmd.equals("scaleCellsSeparately")) {
                    MViewPane.this.scaleCellsSeparately();
                    return;
                }
                if (cmd.equals("scaleCellsUniformly")) {
                    Timer t = new Timer(20, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            MViewPane.this.scaleCellsUniformly();
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                    return;
                }
            }
        }
    };

    public MViewPane() {
        this(null);
    }

    public MViewPane(UserSettings settings) {
        this.molPanel = new ViewPanel(null, 2, settings);
        this.init(this.molPanel);
        this.molPanel.addPropertyChangeListener(this);
    }

    @Override
    public CommonActions getCommonActions() {
        return ((ViewPanel)this.molPanel).getCommonActions();
    }

    public void makeSaveAsMenu(Container menu) {
        ((ViewPanel)this.molPanel).makeSaveAsMenu(menu, false, null);
    }

    public void makeRecentFileListMenu(Container menu) {
        ((ViewPanel)this.molPanel).makeRecentFileListMenu(menu);
    }

    public void makeEditMenu(Container menu) {
        ((ViewPanel)this.molPanel).makeEditMenu(menu, false, null);
    }

    public void makeViewMenu(Container menu) {
        ViewPanel v = (ViewPanel)this.molPanel;
        JMenu submenu = v.createTransformMenu(false);
        menu.add(submenu);
        v.addTransformViewMenuItems(submenu, false, null);
        v.addAnimationMenu(menu, false, -1, null);
        menu.add(new JSeparator());
        v.addViewSubmenus(menu, false);
        submenu = new JMenu("Rescale Cells");
        submenu.setMnemonic('R');
        JMenuItem mi = new JMenuItem("Separately");
        submenu.add(mi);
        mi.setActionCommand("scaleCellsSeparately");
        mi.setMnemonic('S');
        mi.addActionListener(this.myActionListener);
        mi = new JMenuItem("Uniformly");
        submenu.add(mi);
        mi.setActionCommand("scaleCellsUniformly");
        mi.setMnemonic('U');
        mi.addActionListener(this.myActionListener);
        menu.add(submenu);
        menu.add(new JSeparator());
        v.addOpenMSpaceMenuItem(menu);
    }

    public void makeStructureMenu(Container menu) {
        ((ViewPanel)this.molPanel).makeStructureMenu(menu, false, null);
    }

    public JMenu makeToolsMenu() {
        return this.molPanel.addToolsMenu(null, null);
    }

    public void makeHelpMenu(Container menu) {
        this.molPanel.makeHelpMenu(menu, false, null);
    }

    public TableSupport getTableSupport() {
        return ((ViewPanel)this.molPanel).getTableSupport();
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    private void scaleCellsSeparately() {
        ViewPanel v = (ViewPanel)this.molPanel;
        v.beginHourglass();
        v.setAutoTabScale(false);
        v.setTabScale(-1.0);
        v.endHourglass();
    }

    private void scaleCellsUniformly() {
        final ViewPanel v = (ViewPanel)this.molPanel;
        final MDialogProgressMonitor pmon = new MDialogProgressMonitor(v, "Calculating best scale");
        v.beginHourglass();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    double scale = v.getBestTabScale(pmon);
                    v.setAutoTabScale(true);
                    v.setTabScale(scale);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            v.endHourglass();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        t.start();
    }

    public Color getRecordIDBackground(int k) {
        int rgba = this.getDocStorage().getIDBackgroundRGBA(k);
        return rgba != 0 ? new Color(rgba, true) : null;
    }

    public void setRecordIDBackground(int k, Color color) {
        ViewPanel v = (ViewPanel)this.molPanel;
        v.getViewHandler().setRecordIDBackground(k, color);
    }

    public Color getRecordIDForeground(int k) {
        int rgba = this.getDocStorage().getIDForegroundRGBA(k);
        return rgba != 0 ? new Color(rgba, true) : null;
    }

    public void setRecordIDForeground(int k, Color color) {
        ViewPanel v = (ViewPanel)this.molPanel;
        v.getViewHandler().setRecordIDForeground(k, color);
    }

    public boolean setSetSeq(int i, int atom, int id) {
        return this.setAtomSetSeq(i, atom, id);
    }

    public int getTopLeftIndex() {
        return ((ViewPanel)this.molPanel).getViewHandler().getTopLeft();
    }

    public void setTopLeftIndex(int v) {
        ((ViewPanel)this.molPanel).getViewHandler().setTopLeft(v);
    }

    public JComponent getCanvasComponent(int i) {
        return this.getVisibleCellComponent(i);
    }

    public JComponent getVisibleCellComponent(int i) {
        ViewHandler h = ((ViewPanel)this.molPanel).getViewHandler();
        if (h != null) {
            return h.getCanvas(this.getAbsoluteCellIndex(i));
        }
        return null;
    }

    public int getVisibleCellCount() {
        ViewHandler h = ((ViewPanel)this.molPanel).getViewHandler();
        if (h != null && h instanceof GridBagView) {
            return ((GridBagView)h).getVisibleCanvasCount();
        }
        return 0;
    }

    public int getVisibleCellIndex(int absoluteIndex) {
        return ((ViewPanel)this.molPanel).getVisibleCellIndex(absoluteIndex);
    }

    public int getAbsoluteCellIndex(int visibleIndex) {
        return ((ViewPanel)this.molPanel).getAbsoluteCellIndex(visibleIndex);
    }

    public int getAbsoluteCellIndex(JComponent component) {
        return ((ViewPanel)this.molPanel).getAbsoluteCellIndex(component);
    }

    public String getAnimated() {
        if (this.molPanel == null) {
            return null;
        }
        return ((ViewPanel)this.molPanel).getAnimated();
    }

    public boolean isAnimated(int index) throws ArrayIndexOutOfBoundsException {
        if (this.molPanel != null) {
            return ((ViewPanel)this.molPanel).isAnimated(index);
        }
        return false;
    }

    public boolean setAtomSetSeq(int i, int atom, int id) {
        try {
            ((ViewPanel)this.molPanel).getViewHandler().setAtomSetSeq(i, atom, id);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void setAnimated(boolean animated) {
        this.setAnimated(animated ? "all" : "off");
    }

    public void setAnimated(int index, boolean animated) {
        if (index < 0 || index >= this.getCellCount()) {
            throw new ArrayIndexOutOfBoundsException("Invalid cell index:" + index);
        }
        int arg = index;
        if (!animated) {
            arg = (arg + 1) * -1;
        }
        String si = new Integer(arg).toString();
        this.setAnimated(si);
    }

    private void setAnimated(String args) {
        if (this.molPanel != null) {
            ((ViewPanel)this.molPanel).animate(args);
        }
    }

    public MDocument[] getDocuments() {
        return ((ViewPanel)this.molPanel).getDocuments();
    }

    public MDocStorage getDocStorage() {
        return ((ViewPanel)this.molPanel).getViewHandler().getStorage();
    }

    public Molecule getM(int n) {
        MDocument doc = ((ViewPanel)this.molPanel).getDocument(n);
        if (doc == null) {
            return null;
        }
        Molecule m = doc.getPrimaryMolecule();
        if (m != null) {
            m = doc.cloneMainMolecule();
            m.setGUIContracted(false);
        }
        return m;
    }

    public void setM(int n, Molecule m) {
        ((ViewPanel)this.molPanel).setM(n, m);
    }

    public void setM(int n, Molecule[] mols) {
        if (mols != null) {
            for (int i = 0; i < mols.length; ++i) {
                mols[i].setGUIContracted(true);
            }
        }
        ((ViewPanel)this.molPanel).molLoaded(mols, n);
    }

    public String getM(int n, String fmt) {
        try {
            return this.getM(n).toFormat(fmt);
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
            return null;
        }
    }

    public void setM(int n, String s) {
        this.setM(n, s, null);
    }

    public void setM(int n, String s, String opts) {
        if (s == null || s.equals("") || s.equals(" ")) {
            s = "\n  Marvin  07140517162D          \n\n  0  0  0  0  0  0            999 V2000\nM  END\n";
        }
        ((ViewPanel)this.molPanel).setM(n, s, opts);
    }

    public void setM(int n, File f, String opts) {
        ((ViewPanel)this.molPanel).setM(n, f, opts);
    }

    public MDocument getDocument(int i) {
        Molecule m = this.getM(i);
        MDocument doc = m != null ? m.getDocument() : null;
        return doc;
    }

    public void setDocument(int i, MDocument doc) {
        Molecule m = null;
        if (doc != null) {
            m = (Molecule)doc.getMainMoleculeGraph();
        }
        this.setM(i, m);
    }

    public String getL(int i) {
        return ((ViewPanel)this.molPanel).getL(i);
    }

    public void setL(int i, String s) {
        ((ViewPanel)this.molPanel).setL(i, s);
    }

    public boolean getC(int i) {
        return ((ViewPanel)this.molPanel).getC(i);
    }

    public void setC(int i, boolean s) {
        ((ViewPanel)this.molPanel).setC(i, s);
    }

    public void setActionB(int i, String s) {
        ((ViewPanel)this.molPanel).setActionB(i, s);
    }

    public void setActionC(int i, String s) {
        ((ViewPanel)this.molPanel).setActionC(i, s);
    }

    public String getT(int i) {
        return ((ViewPanel)this.molPanel).getT(i);
    }

    public void setT(int i, String s) {
        ((ViewPanel)this.molPanel).setT(i, s);
    }

    public int getCellCount() {
        return ((ViewPanel)this.molPanel).getCellCount();
    }

    public String getNavmode() {
        return this.molPanel.getNavmode();
    }

    public void setNavmode(String s) {
        this.molPanel.setNavmode(s);
    }

    public int getEditable() {
        return ((ViewPanel)this.molPanel).getEditable();
    }

    public void setEditable(int e) {
        ((ViewPanel)this.molPanel).setEditable(e);
    }

    public boolean isSelectable() {
        return ((ViewPanel)this.molPanel).isSelectable();
    }

    public void setSelectable(boolean v) {
        ((ViewPanel)this.molPanel).setSelectable(v);
    }

    public int getSelectedIndex() {
        return ((ViewPanel)this.molPanel).getSelectedCellIndex();
    }

    public void setSelectedIndex(int i) {
        ((ViewPanel)this.molPanel).setSelectedCellIndex(i);
    }

    public int getBorderWidth() {
        return ((ViewPanel)this.molPanel).getBorderWidth();
    }

    public void setBorderWidth(int w) {
        ((ViewPanel)this.molPanel).setBorderWidth(w);
    }

    public double getAnimFPS() {
        return ((ViewPanel)this.molPanel).getAnimFPS();
    }

    public void setAnimFPS(double r) {
        ((ViewPanel)this.molPanel).setAnimFPS(r);
    }

    public double getAnimDelay() {
        return ((ViewPanel)this.molPanel).getAnimDelay();
    }

    public void setAnimDelay(double delay) {
        ((ViewPanel)this.molPanel).setAnimDelay(delay);
    }

    public boolean isAnimSync() {
        return ((ViewPanel)this.molPanel).isAnimSync();
    }

    public void setAnimSync(boolean sync) {
        ((ViewPanel)this.molPanel).setAnimSync(sync);
    }

    public double getWinScale() {
        return ((ViewPanel)this.molPanel).getWinScale();
    }

    public void setWinScale(double scale) {
        ((ViewPanel)this.molPanel).setWinScale(scale);
    }

    public double getTabScale() {
        return ((ViewPanel)this.molPanel).getTabScale(false);
    }

    public double getTabScale(int i) {
        return ((ViewPanel)this.molPanel).getTabScale(i);
    }

    public void setTabScale(double scale) {
        ((ViewPanel)this.molPanel).setTabScale(scale);
    }

    public double getBestTabScale(int i) {
        return ((ViewPanel)this.molPanel).getBestTabScale(i);
    }

    public double getBestTabScale() {
        return ((ViewPanel)this.molPanel).getBestTabScale(null);
    }

    public boolean getAutoTabScale() {
        return ((ViewPanel)this.molPanel).getAutoTabScale();
    }

    public void setAutoTabScale(boolean a) {
        ((ViewPanel)this.molPanel).setAutoTabScale(a);
    }

    public void print() {
        ((ViewPanel)this.molPanel).print();
    }

    public CTransform3D getRotationMatrix(int cellIndex) {
        MolPainter p = ((ViewPanel)this.molPanel).getPainter(cellIndex);
        return p != null ? this.getRotationMatrix(p.getRTransform()) : null;
    }

    private CTransform3D getRotationMatrix(CTransform3D preTransform) {
        CTransform3D t = new CTransform3D();
        t.setIdentity();
        t.m00 = preTransform.m00;
        t.m01 = preTransform.m01;
        t.m02 = preTransform.m02;
        t.m10 = preTransform.m10;
        t.m11 = preTransform.m11;
        t.m12 = preTransform.m12;
        t.m20 = preTransform.m20;
        t.m21 = preTransform.m21;
        t.m22 = preTransform.m22;
        t.setScale(1.0);
        return t;
    }

    public void applyRotationMatrix(int cellIndex) {
        MolPainter p = ((ViewPanel)this.molPanel).getPainter(cellIndex);
        MDocument doc = ((ViewPanel)this.molPanel).getDocument(cellIndex);
        Molecule[] mols = doc.getAllNonEmptyMolecules();
        if (p != null && mols != null) {
            CTransform3D preTransform = p.getRTransform();
            CTransform3D t = this.getRotationMatrix(preTransform);
            for (int i = 0; i < mols.length; ++i) {
                mols[i].transform(t);
            }
            t.invert();
            preTransform.mul(t);
            p.setRTransform(preTransform);
        }
    }

    public void applyRotationMatrices() {
        int n = this.getCellCount();
        for (int i = 0; i < n; ++i) {
            this.applyRotationMatrix(i);
        }
    }

    public boolean openSketcher(int index) {
        return ((ViewPanel)this.molPanel).openSketcher(index);
    }

    public boolean isViewWindowOpened(int index) {
        return ((ViewPanel)this.molPanel).getViewHandler().getFrame(index) != null;
    }

    public boolean isSketchWindowOpened(int index) {
        return ((ViewPanel)this.molPanel).isSketchOpened(index);
    }

    public boolean openWindow(int index) {
        return ((ViewPanel)this.molPanel).openViewer(index);
    }

    public void closeWindow(int index) {
        ((ViewPanel)this.molPanel).setWinmode(0, index);
    }

    public void closeSketcher(int index) {
        ((ViewPanel)this.molPanel).closeSketcher(index);
    }

    public void destroySketcher() {
        ((ViewPanel)this.molPanel).destroySketcher();
    }

    public boolean isDetachable() {
        ViewPanel v = (ViewPanel)this.molPanel;
        return v.isDetachable();
    }

    public void setDetachable(boolean b) {
        ViewPanel v = (ViewPanel)this.molPanel;
        v.setDetachable(b);
    }

    public AbstractButton getVisibleButtonB(int i) {
        return ((ViewPanel)this.molPanel).getVisibleButtonB(i);
    }

    public AbstractButton getVisibleButtonC(int i) {
        return ((ViewPanel)this.molPanel).getVisibleButtonC(i);
    }

    public int indexOfButtonC(AbstractButton checkbox) {
        return ((ViewPanel)this.molPanel).indexOfButtonC(checkbox);
    }

    public int indexOfButtonB(AbstractButton button) {
        return ((ViewPanel)this.molPanel).indexOfButtonB(button);
    }

    public Font getFieldFont(String key) {
        return ((ViewPanel)this.molPanel).getFieldFont(key);
    }

    public void setFieldFont(String key, Font f) {
        ((ViewPanel)this.molPanel).setFieldFont(key, f);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String animatedstr;
        out.writeInt(1);
        out.writeUTF(this.getParams());
        super.writeExternal(out);
        out.writeShort(this.getEditable());
        out.writeInt(this.getBorderWidth());
        int flags = 0;
        if (this.isSelectable()) {
            flags |= 1;
        }
        if (this.isDetachable()) {
            flags |= 2;
        }
        if (this.isAnimSync()) {
            flags |= 4;
        }
        if (this.getAutoTabScale()) {
            flags |= 8;
        }
        if ((animatedstr = this.getAnimated()) != null) {
            flags |= 0x10;
        }
        out.writeInt(flags);
        if ((flags & 0x10) != 0) {
            out.writeUTF(animatedstr);
        }
        out.writeInt(this.getSelectedIndex());
        out.writeDouble(this.getAnimFPS());
        out.writeDouble(this.getAnimDelay());
        out.writeDouble(this.getWinScale());
        out.writeDouble(this.getTabScale());
        MDocument[] docs = this.getDocuments();
        if (docs == null) {
            out.writeInt(0);
        } else {
            out.writeInt(docs.length);
            ViewPanel viewPanel = (ViewPanel)this.molPanel;
            CTransform3D t = new CTransform3D();
            for (int i = 0; i < docs.length; ++i) {
                MDocument d = docs[i];
                MMoleculeMovie mmm = d.getMoleculeMovie();
                int n = mmm != null ? mmm.getMoleculeCount() : 0;
                out.writeInt(++n);
                MViewPane.writeMol(out, (Molecule)d.getMainMoleculeGraph());
                for (int j = 0; j < n; ++j) {
                    MViewPane.writeMol(out, mmm.getMolecule(j));
                }
                viewPanel.getPainter(i).getRTransform(t);
                t.write16floats(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 1) {
            throw new IOException("Cannot deserialize MViewPane with future version (" + version + ")");
        }
        this.setParams(in.readUTF());
        super.readExternal(in);
        this.setEditable(in.readShort());
        this.setBorderWidth(in.readInt());
        int flags = in.readInt();
        this.setSelectable((flags & 1) != 0);
        this.setDetachable((flags & 2) != 0);
        this.setAnimSync((flags & 4) != 0);
        this.setAutoTabScale((flags & 8) != 0);
        if ((flags & 0x10) != 0) {
            this.setAnimated(in.readUTF());
        }
        this.setSelectedIndex(in.readInt());
        this.setAnimFPS(in.readDouble());
        this.setAnimDelay(in.readDouble());
        this.setWinScale(in.readDouble());
        this.setTabScale(in.readDouble());
        int n = in.readInt();
        CTransform3D t = new CTransform3D();
        ViewPanel viewPanel = (ViewPanel)this.molPanel;
        for (int i = 0; i < n; ++i) {
            MDocument doc;
            int nm = in.readInt();
            Molecule m = MViewPane.readMol(in);
            if (nm == 1) {
                doc = new MDocument(m);
            } else {
                if (version > 0) {
                    --nm;
                }
                Molecule[] mols = new Molecule[nm];
                for (int j = 0; j < nm; ++j) {
                    mols[j] = MViewPane.readMol(in);
                }
                doc = new MDocument(mols);
                if (version > 0) {
                    doc.setMainMoleculeGraph(m);
                }
            }
            this.setDocument(i, doc);
            t.read16floats(in);
            viewPanel.getPainter(i).setRTransform(t);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JMenuBar menubar = MolPanel.getMarvinMenuBar(this);
        if (menubar != null) {
            menubar.setEnabled(enabled);
            for (int i = 0; i < menubar.getMenuCount(); ++i) {
                if (menubar.getMenu(i) == null) continue;
                menubar.getMenu(i).setEnabled(enabled);
            }
        }
    }

    public boolean isDraggable() {
        return ((ViewPanel)this.molPanel).isDraggable();
    }

    public void setDraggable(boolean enabled) {
        ((ViewPanel)this.molPanel).setDraggable(enabled);
    }

    @Override
    public void doPaste() {
        this.molPanel.doPaste();
    }

    private ViewPanel getViewPanel() {
        return (ViewPanel)this.molPanel;
    }

    public boolean isValenceErrorVisibleInView() {
        return this.getViewPanel().getUserSettings().isValenceErrorVisibleInView();
    }

    public synchronized void setValenceErrorVisibleInView(boolean v) {
        this.getViewPanel().setValenceErrorVisibleInView(v);
    }

    @Override
    public void setPreferredSize(Dimension sz) {
        super.setPreferredSize(sz);
        this.preferredSizeSet = true;
    }

    @Override
    public Dimension getPreferredSize() {
        TableSupport tblsup = this.tableSupport;
        Dimension sz = tblsup != null && !this.preferredSizeSet ? tblsup.getDefaultSize() : super.getPreferredSize();
        return sz;
    }

    static {
        MViewPane.readResources(MViewPane.class, "MViewPane.properties");
    }
}

