/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.CommonActions;
import chemaxon.marvin.common.swing.MenuBarChangeListener;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class MarvinPane
extends JRootPane
implements KeyListener,
PropertyChangeListener,
ComponentListener {
    private static final long serialVersionUID = -9042549845769941129L;
    public static final String VERSION = VersionInfo.MARVIN_VERSION;
    protected MolPanel molPanel;
    protected String params = "";
    private static StringBuffer resourceSbuf = new StringBuffer();
    protected static Container topLevelContainer;
    private MarvinActionListener actionListener = new MarvinActionListener();

    protected MarvinPane() {
    }

    public void addMenuBarChangeListener(MenuBarChangeListener l) {
        this.molPanel.addMenuBarChangeListener(l);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListener.size() == 0) {
            this.molPanel.addActionListener(this.actionListener);
        }
        this.actionListener.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener.remove(l);
        if (this.actionListener.size() == 0) {
            this.molPanel.removeActionListener(this.actionListener);
        }
    }

    protected void init(MolPanel m) {
        this.init(m, true);
    }

    protected void init(MolPanel m, boolean start) {
        Color bg = this.getBackground();
        if (bg != null) {
            m.setBackground(bg);
        }
        this.molPanel = m;
        this.setContentPane(this.molPanel);
        m.setLoadingEnabled(start);
        this.setParams(resourceSbuf.toString());
        m.init();
    }

    public MolPanel getMolPanel() {
        return this.molPanel;
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        this.molPanel.keyPressed(ev);
    }

    @Override
    public void keyTyped(KeyEvent ev) {
        this.molPanel.keyTyped(ev);
    }

    @Override
    public void keyReleased(KeyEvent ev) {
        this.molPanel.keyReleased(ev);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        final Object old = ev.getOldValue();
        final Object val = ev.getNewValue();
        if (name.equals("ancestor")) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.ancestorChange(old, val);
            } else {
                Runnable inAwtThread = new Runnable(){

                    @Override
                    public void run() {
                        MarvinPane.this.ancestorChange(old, val);
                    }
                };
                SwingUtilities.invokeLater(inAwtThread);
            }
        } else {
            super.firePropertyChange(name, old, val);
            if (name.equals("scale")) {
                name = "mag";
            }
        }
    }

    private void ancestorChange(Object old, Object val) {
        super.firePropertyChange("ancestor", old, val);
        this.removeComponentListener(this);
        if (val != null) {
            this.componentShown(new ComponentEvent(this, 102));
            this.addComponentListener(this);
        } else {
            this.componentHidden(new ComponentEvent(this, 103));
        }
    }

    @Override
    public void componentResized(ComponentEvent ev) {
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        if (ev.getSource() == this) {
            this.molPanel.startstop(false);
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
        if (ev.getSource() == this) {
            this.molPanel.startstop(true);
        }
    }

    public boolean getPopupMenusEnabled() {
        return this.arePopupMenusEnabled();
    }

    public boolean arePopupMenusEnabled() {
        if (this.molPanel == null) {
            return false;
        }
        return this.molPanel.arePopupMenusEnabled();
    }

    public void setPopupMenusEnabled(boolean b) {
        if (this.molPanel != null) {
            this.molPanel.setPopupMenusEnabled(b);
        }
    }

    public String getParams() {
        return this.params;
    }

    public synchronized void setParams(String s) {
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        Properties props = new Properties();
        props.putAll(this.getUserSettings().getPropertyMap("persistent"));
        try {
            props.load(bais);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.molPanel.setProperties(props);
        this.params = s;
    }

    public String getParameter(String key) {
        return this.molPanel.getParameter(key);
    }

    public Color getMolbg() {
        return this.molPanel != null ? this.molPanel.getMolbg() : null;
    }

    public void setMolbg(Color c) {
        if (this.molPanel != null) {
            this.molPanel.setMolbg(c);
        }
    }

    public double getAtomsize() {
        return this.molPanel.getUserSettings().getAtomSize();
    }

    public void setAtomsize(double r) {
        this.molPanel.setAtomsize(r);
    }

    public double getBondSpacing() {
        return this.molPanel.getBondSpacing();
    }

    public void setBondSpacing(double w) {
        this.molPanel.setBondSpacing(w);
    }

    public int getCleanDim() {
        return this.molPanel.getCleanDim();
    }

    public void setCleanDim(int d) {
        this.molPanel.setCleanDim(d);
    }

    public int getDispopts() {
        return this.molPanel.getDispopts();
    }

    public void setDispopts(int f) {
        this.molPanel.setDispopts(f, false, true);
    }

    public String getColorScheme() {
        return this.molPanel.getColorScheme();
    }

    public void setColorScheme(String s) {
        this.molPanel.setColorScheme(s);
    }

    public boolean isSetColoringEnabled() {
        return this.molPanel.isSetColoringEnabled();
    }

    public void setSetColoringEnabled(boolean v) {
        this.molPanel.setSetColoringEnabled(v);
    }

    public String getRendering() {
        return this.molPanel.getRendering();
    }

    public void setRendering(String s) {
        this.molPanel.setRendering(s);
    }

    public int getDispQuality() {
        return this.molPanel.getDispQuality();
    }

    public void setDispQuality(int q) {
        this.molPanel.setDispQuality(q);
    }

    public double getWireThickness() {
        return this.molPanel.getUserSettings().getWireThickness();
    }

    public void setWireThickness(double d) {
        this.molPanel.setWireThickness(d);
    }

    public double getStickThickness() {
        return this.molPanel.getUserSettings().getStickThickness();
    }

    public void setStickThickness(double d) {
        this.molPanel.setStickThickness(d);
    }

    public double getBallRadius() {
        return this.molPanel.getBallRadius();
    }

    public void setBallRadius(double r) {
        this.molPanel.setBallRadius(r);
    }

    public String getDownWedge() {
        return this.molPanel.getUserSettings().getDownWedge();
    }

    public void setDownWedge(String s) {
        this.molPanel.setDownWedge(s);
    }

    public boolean isAtomNumbersVisible() {
        return this.molPanel.isAtomNumbersVisible();
    }

    public void setAtomNumbersVisible(boolean v) {
        this.molPanel.setAtomNumbersVisible(v);
    }

    public boolean isAtomMappingVisible() {
        return this.molPanel.isAtomMappingVisible();
    }

    public void setAtomMappingVisible(boolean v) {
        this.molPanel.setAtomMappingVisible(v);
    }

    public boolean isAtomSymbolsVisible() {
        return this.molPanel.isAtomSymbolsVisible();
    }

    public void setAtomSymbolsVisible(boolean v) {
        this.molPanel.setAtomSymbolsVisible(v);
    }

    public boolean getLonePairsVisible() {
        return this.molPanel.getLonePairsVisible();
    }

    public void setLonePairsVisible(boolean v) {
        this.molPanel.setLonePairsVisible(v);
    }

    public boolean isGrinvVisible() {
        return this.molPanel.isGrinvVisible();
    }

    public void setGrinvVisible(boolean v) {
        this.molPanel.setGrinvVisible(v);
    }

    public String getImplicitH() {
        return this.molPanel.getImplicitH();
    }

    public void setImplicitH(String s) {
        this.molPanel.setImplicitH(s);
    }

    @Deprecated
    public boolean getExplicitH() {
        return false;
    }

    @Deprecated
    public void setExplicitH(boolean show) {
    }

    public int getChiralitySupport() {
        return this.molPanel.getChiralitySupport();
    }

    public void setChiralitySupport(int l) {
        this.molPanel.setChiralitySupport(l);
    }

    public boolean isEzVisible() {
        return this.molPanel.isEzVisible();
    }

    public void setEzVisible(boolean v) {
        this.molPanel.setEzVisible(v);
    }

    public boolean isBondLengthVisible() {
        return this.molPanel.isBondLengthVisible();
    }

    public void setBondLengthVisible(boolean v) {
        this.molPanel.setBondLengthVisible(v);
    }

    public long getInvisibleSets() {
        return this.molPanel.getInvisibleSets();
    }

    public synchronized void setInvisibleSets(long v) {
        this.molPanel.setInvisibleSets(v);
    }

    public Color getAtomSetColor(int i) {
        return this.molPanel.getAtomSetColor(i);
    }

    public synchronized void setAtomSetColor(int i, Color color) {
        this.molPanel.setAtomSetColor(i, color);
    }

    public synchronized void setBondSetColor(int i, Color color) {
        this.molPanel.setBondSetColor(i, color);
    }

    public String getFormat() {
        String fmt = this.molPanel.getFormat();
        return fmt == null ? "DEFAULT" : fmt;
    }

    public void setFormat(String fmt) {
        if (fmt == null) {
            fmt = "DEFAULT";
        }
        this.molPanel.setFormat(fmt);
    }

    public File getFile() {
        return this.molPanel.getFile();
    }

    public void setFile(File f) {
        this.molPanel.setFile(f);
    }

    public void showFileDialog(String what, Molecule mol) {
        if (what.equals("open")) {
            this.molPanel.openMolfile(null, null);
        } else {
            this.molPanel.saveMolfile(null, null, what, mol, null, false);
        }
    }

    public int getDebug() {
        return this.molPanel.getDebug();
    }

    public void setDebug(int debug) {
        this.molPanel.setDebug(debug);
    }

    public void closeWindows() {
        this.molPanel.closeWindows();
    }

    public boolean isExitCanceled() {
        return this.molPanel.isExitCanceled();
    }

    public void exit() {
        this.molPanel.exit();
    }

    public UserSettings getUserSettings() {
        return this.molPanel.getUserSettings();
    }

    public void setUserSettings(UserSettings settings) {
        this.molPanel.setUserSettings(settings);
    }

    public boolean isSaveIniEnabled() {
        return this.molPanel.isSaveIniEnabled();
    }

    public void setSaveIniEnabled(boolean v) {
        this.molPanel.setSaveIniEnabled(v);
    }

    public File getDirectory() {
        return this.molPanel.getDirectory();
    }

    public void setDirectory(File wd) {
        this.molPanel.setDirectory(wd);
    }

    public boolean isExperimentalEnabled() {
        return this.molPanel.experimentalEnabled;
    }

    public void setExperimentalEnabled(boolean v) {
        this.molPanel.experimentalEnabled = v;
    }

    public void showFileOpenDialog() {
        this.molPanel.openMolfile(null, null);
    }

    public CommonActions getCommonActions() {
        return null;
    }

    public JMenu addToolsMenu(Container m) {
        return this.molPanel.addToolsMenu(m, null);
    }

    public JMenu addHelpMenu(Container m) {
        return this.molPanel.addHelpMenu(m, false, null);
    }

    public static ResourceBundle getResourceBundle(String name) {
        return MolPanel.getResourceBundle(name);
    }

    public void beginHourglass() {
        this.molPanel.beginHourglass();
    }

    public void endHourglass() {
        this.molPanel.endHourglass();
    }

    public void showErrorDialog(String msg, Throwable ex) {
        this.molPanel.getErrorDisplay().error(msg, ex);
    }

    protected static void readResources(Class cl, String fname) {
        StringBuffer sbuf = resourceSbuf;
        InputStream is = cl.getResourceAsStream(fname);
        if (is != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String s;
                while ((s = br.readLine()) != null) {
                    sbuf.append(s);
                    sbuf.append('\n');
                }
            }
            catch (IOException ex) {
                System.err.println(fname + " not found");
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        UserSettings settings = this.molPanel.getUserSettings();
        out.writeInt(1);
        int flags = 0;
        if (this.arePopupMenusEnabled()) {
            flags |= 1;
        }
        if (this.isSetColoringEnabled()) {
            flags |= 2;
        }
        if (this.isAtomSymbolsVisible()) {
            flags |= 4;
        }
        if (this.isAtomNumbersVisible()) {
            flags |= 8;
        }
        if (this.isAtomMappingVisible()) {
            flags |= 0x10;
        }
        if (this.isGrinvVisible()) {
            flags |= 0x20;
        }
        if (this.isEzVisible()) {
            flags |= 0x100;
        }
        if (this.isBondLengthVisible()) {
            flags |= 0x200;
        }
        if (settings.isBondDraggedAlong()) {
            flags |= 0x400;
        }
        if (settings.isValenceErrorVisible()) {
            flags |= 0x800;
        }
        if (settings.isValenceErrorVisibleInView()) {
            flags |= 0x2000;
        }
        out.writeInt(flags);
        out.writeInt(this.getBackground().getRGB());
        out.writeInt(this.getMolbg().getRGB());
        out.writeInt(settings.getSketchMolbg2d().getRGB());
        out.writeInt(settings.getSketchMolbg3d().getRGB());
        out.writeInt(settings.getViewMolbg2d().getRGB());
        out.writeInt(settings.getViewMolbg3d().getRGB());
        out.writeShort(this.getCleanDim());
        out.writeShort(this.getDispQuality());
        int chir = this.getChiralitySupport();
        out.writeShort(chir == 1 ? 1 : (chir == 2 ? 2 : 0));
        out.writeLong(this.getInvisibleSets());
        out.writeDouble(this.getAtomsize());
        out.writeDouble(this.getBondSpacing());
        out.writeDouble(this.getWireThickness());
        out.writeDouble(this.getStickThickness());
        out.writeDouble(this.getBallRadius());
        out.writeDouble(settings.getSketchArrowHeadLength());
        out.writeDouble(settings.getSketchArrowHeadWidth());
        out.writeDouble(settings.getSketchArrowTailLength());
        out.writeDouble(settings.getSketchArrowTailWidth());
        out.writeUTF(this.molPanel.getColorScheme());
        out.writeUTF(settings.getSketchColorScheme());
        out.writeUTF(settings.getViewColorScheme());
        out.writeUTF(this.molPanel.getRendering());
        out.writeUTF(settings.getSketchRendering2d());
        out.writeUTF(settings.getSketchRendering3d());
        out.writeUTF(settings.getViewRendering2d());
        out.writeUTF(settings.getViewRendering3d());
        out.writeUTF(this.molPanel.getNavmode());
        out.writeUTF(settings.getViewNavmode2d());
        out.writeUTF(settings.getViewNavmode3d());
        out.writeUTF(this.getDownWedge());
        out.writeUTF(this.molPanel.getImplicitH());
        out.writeUTF(settings.getSketchImplicitH());
        out.writeUTF(settings.getViewImplicitH());
        out.writeUTF(this.molPanel.getAnyBond());
        out.writeUTF(settings.getSketchAnyBond());
        out.writeUTF(settings.getViewAnyBond());
        out.writeUTF(this.getFormat());
        out.writeUTF(settings.getClean2dOpts());
        out.writeUTF(settings.getClean3dOpts());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        UserSettings settings = this.molPanel.getUserSettings();
        int version = in.readInt();
        if (version > 1) {
            throw new IOException("Cannot deserialize MarvinPane with future version (" + version + ")");
        }
        int flags = in.readInt();
        this.setPopupMenusEnabled((flags & 1) != 0);
        this.setSetColoringEnabled((flags & 2) != 0);
        this.setAtomSymbolsVisible((flags & 4) != 0);
        this.setAtomNumbersVisible((flags & 8) != 0);
        this.setAtomMappingVisible((flags & 0x10) != 0);
        this.setGrinvVisible((flags & 0x20) != 0);
        this.setEzVisible((flags & 0x100) != 0);
        this.setBondLengthVisible((flags & 0x200) != 0);
        this.molPanel.setBondDraggedAlong((flags & 0x400) != 0);
        this.molPanel.setValenceErrorVisible((flags & 0x800) != 0);
        this.molPanel.setValenceErrorVisibleInView((flags & 0x2000) != 0);
        this.setBackground(new Color(in.readInt(), true));
        this.molPanel.setMolbg(new Color(in.readInt(), true));
        this.molPanel.setSketchMolbg2d(new Color(in.readInt(), true));
        if (version > 0) {
            this.molPanel.setSketchMolbg3d(new Color(in.readInt(), true));
        }
        this.molPanel.setViewMolbg2d(new Color(in.readInt(), true));
        this.molPanel.setViewMolbg3d(new Color(in.readInt(), true));
        this.setCleanDim(in.readShort());
        this.setDispQuality(in.readShort());
        short chirsupi = in.readShort();
        int[] chirsups = new int[]{0, 1, 2};
        this.setChiralitySupport(chirsups[chirsupi]);
        this.setInvisibleSets(in.readLong());
        this.setAtomsize(in.readDouble());
        this.setBondSpacing(in.readDouble());
        this.setWireThickness(in.readDouble());
        this.setStickThickness(in.readDouble());
        this.setBallRadius(in.readDouble());
        settings.setSketchArrowHeadLength(in.readDouble());
        settings.setSketchArrowHeadWidth(in.readDouble());
        settings.setSketchArrowTailLength(in.readDouble());
        settings.setSketchArrowTailWidth(in.readDouble());
        this.molPanel.setColorScheme(in.readUTF());
        this.molPanel.setSketchColorScheme(in.readUTF());
        this.molPanel.setViewColorScheme(in.readUTF());
        this.molPanel.setRendering(in.readUTF());
        this.molPanel.setSketchRendering2d(in.readUTF());
        if (version > 0) {
            this.molPanel.setSketchRendering3d(in.readUTF());
        }
        this.molPanel.setViewRendering2d(in.readUTF());
        this.molPanel.setViewRendering3d(in.readUTF());
        this.molPanel.setNavmode(in.readUTF());
        this.molPanel.setViewNavmode2d(in.readUTF());
        this.molPanel.setViewNavmode3d(in.readUTF());
        this.setDownWedge(in.readUTF());
        this.molPanel.setImplicitH(in.readUTF());
        this.molPanel.setSketchImplicitH(in.readUTF());
        this.molPanel.setViewImplicitH(in.readUTF());
        this.molPanel.setAnyBond(in.readUTF());
        this.molPanel.setSketchAnyBond(in.readUTF());
        this.molPanel.setViewAnyBond(in.readUTF());
        this.setFormat(in.readUTF());
        this.molPanel.setClean2dOpts(in.readUTF());
        this.molPanel.setClean3dOpts(in.readUTF());
    }

    protected static void writeMol(ObjectOutput out, Molecule mol) throws IOException {
        byte[] mrv = mol.toBinFormat("mrv");
        out.writeInt(mrv.length);
        out.write(mrv);
    }

    protected static Molecule readMol(ObjectInput in) throws IOException {
        return (Molecule)MarvinPane.readDoc(in).getMainMoleculeGraph();
    }

    protected static MDocument readDoc(ObjectInput in) throws IOException {
        int len = in.readInt();
        byte[] data = new byte[len];
        in.readFully(data);
        ByteArrayInputStream datain = new ByteArrayInputStream(data);
        MolImporter mi = new MolImporter(datain, "mrv");
        return mi.readDoc(null, null);
    }

    public double getBondWidth() {
        return this.getBondSpacing();
    }

    public void setBondWidth(double w) {
        this.setBondSpacing(w);
    }

    public Color getSetColor(int i) {
        return this.getAtomSetColor(i);
    }

    public void setSetColor(int i, Color color) {
        this.setAtomSetColor(i, color);
    }

    public boolean getLabels() {
        return this.molPanel.isAtomSymbolsVisible();
    }

    public void setLabels(boolean v) {
        this.molPanel.setAtomSymbolsVisible(v);
    }

    public boolean getAtomNumbersVisible() {
        return this.isAtomNumbersVisible();
    }

    public boolean isGrinv() {
        return this.isGrinvVisible();
    }

    public void setGrinv(boolean v) {
        this.setGrinvVisible(v);
    }

    public static JMenu createMenu(ResourceBundle rc, String key) {
        return SwingUtil.createMenu(rc, key);
    }

    public static void initButton(AbstractButton b, ResourceBundle rc, String key) {
        SwingUtil.initButton(b, rc, key);
    }

    public static void initAction(Action action, ResourceBundle rc, String key, KeyStroke accel) {
        SwingUtil.initAction(action, rc, key, accel);
    }

    public void setTopLevelContainer(Container tlc) {
        topLevelContainer = tlc;
    }

    public Container getTopLevelContainer() {
        return topLevelContainer;
    }

    public boolean getReadGlobalGUIProperties() {
        return this.getSaveGlobalGUIProperties();
    }

    public boolean getSaveGlobalGUIProperties() {
        return this.molPanel != null && this.molPanel.getSaveGlobalGUIProperties();
    }

    public void setGlobalGUIProperties(MPropertyContainer gp) {
        this.molPanel.setGlobalGUIProperties(gp);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.molPanel.setEnabled(b);
    }

    public abstract void doPaste();

    public synchronized void setRgroupsVisible(boolean b) {
        this.molPanel.setRgroupsVisible(b);
    }

    public boolean isRgroupsVisible() {
        return this.molPanel.isRgroupsVisible();
    }

    public boolean isPrintEnabled() {
        return this.molPanel.isPrintEnabled();
    }

    public void setPrintEnabled(boolean b) {
        this.molPanel.setPrintEnabled(b);
    }

    static {
        MarvinPane.readResources(MarvinPane.class, "MarvinPane.properties");
    }

    private class MarvinActionListener
    implements ActionListener,
    Serializable {
        private List<ActionListener> listeners = new ArrayList<ActionListener>();

        private MarvinActionListener() {
        }

        public int size() {
            return this.listeners.size();
        }

        public void add(ActionListener l) {
            this.listeners.add(l);
        }

        public void remove(ActionListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ActionEvent ev2 = ev;
            if (ev.getSource() == MarvinPane.this.molPanel) {
                ev2 = new ActionEvent(this, ev.getID(), ev.getActionCommand(), ev.getModifiers());
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ActionListener l = this.listeners.get(i);
                l.actionPerformed(ev2);
            }
        }
    }
}

