/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans;

import chemaxon.marvin.MolPrinter;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MolRenderer
extends JPanel
implements TableCellRenderer {
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private MolPrinter printer;

    public MolRenderer() {
        this.setOpaque(true);
        this.printer = new MolPrinter();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackgroundColor(table, isSelected, hasFocus, row, column);
        this.setBorder(table, isSelected, hasFocus, row, column);
        this.printer.setMol((Molecule)value);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        double scale = this.printer.maxScale(this.getSize());
        if (scale > 28.0) {
            scale = 28.0;
        }
        this.printer.setScale(scale);
        this.printer.paint((Graphics2D)g, this.getSize());
    }

    protected void setBackgroundColor(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        super.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.printer.setBackgroundColor(isSelected ? table.getSelectionBackground() : table.getBackground());
    }

    protected void setBorder(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
    }
}

