/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class BemisMurckoPlugin
extends CalculatorPlugin {
    private Object[] types = new Object[]{"structure"};
    private Molecule m = null;
    private Molecule result = null;
    boolean keepSingleForAcyclic = true;
    boolean processOnlyLargestInputFragment = false;
    boolean keepOnlyLargestResultFragment = false;
    String format = "sdf";
    private VerbosePrinter verb = null;

    @Override
    public String getProductName() {
        return "Free Plugin";
    }

    public void setVerbosePrinter(VerbosePrinter verb) {
        this.verb = verb;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        if (this.verb != null) {
            this.verb.verbose("Set input molecule");
            this.verb.verbose(mol);
        }
        this.m = mol;
    }

    public static Molecule largestFragment(Molecule m) {
        return BemisMurckoPlugin.largestFragment(m, null);
    }

    public static Molecule largestFragment(Molecule m, VerbosePrinter v) {
        Molecule[] frags = m.convertToFrags();
        if (frags.length > 0) {
            int ls = 0;
            int lsi = -1;
            for (int i = 0; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= ls) continue;
                ls = frags[i].getAtomCount();
                lsi = i;
            }
            if (v != null) {
                v.verbose("largestFragment() found " + frags.length + " framents. Largest: " + lsi + " (" + ls + " atoms)");
                v.verbose(m);
            }
            return frags[lsi];
        }
        if (v != null) {
            v.verbose("largestFragment() found 0 frament");
            v.verbose(m);
        }
        return m;
    }

    @Override
    public boolean run() throws PluginException {
        int i;
        if (this.verb != null) {
            this.verb.verbose("run()");
        }
        this.result = this.m.cloneMolecule();
        this.result.ungroupSgroups();
        this.result.hydrogenize(false);
        if (this.processOnlyLargestInputFragment) {
            if (this.verb != null) {
                this.verb.verbose("Find largest input fragemnt");
            }
            this.result = BemisMurckoPlugin.largestFragment(this.result, this.verb);
        }
        for (i = 0; i < this.result.getAtomCount(); ++i) {
            MolAtom ai = this.result.getAtom(i);
            ai.setAtno(6);
            ai.setFlags(0);
        }
        for (i = 0; i < this.result.getBondCount(); ++i) {
            MolBond bi = this.result.getBond(i);
            bi.setFlags(0);
            bi.setType(1);
        }
        boolean found = true;
        while (found) {
            found = false;
            for (int i2 = 0; !found && i2 < this.result.getAtomCount(); ++i2) {
                int bci = this.result.getAtom(i2).getBondCount();
                if (bci == 1) {
                    this.result.removeAtom(i2);
                    found = true;
                    continue;
                }
                if (this.keepSingleForAcyclic || bci != 0) continue;
                this.result.removeAtom(i2);
                found = true;
            }
        }
        if (this.keepOnlyLargestResultFragment) {
            if (this.verb != null) {
                this.verb.verbose("Find largest output fragemnt");
            }
            this.result = BemisMurckoPlugin.largestFragment(this.result, this.verb);
        }
        return true;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        if (this.verb != null) {
            this.verb.verbose("Return result molecule");
        }
        return this.result;
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    public void setKeepSingleForAcyclic(boolean b) {
        this.keepSingleForAcyclic = b;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public void setProcessOnlyLargestInputFragment(boolean b) {
        this.processOnlyLargestInputFragment = b;
    }

    public void setKeepOnlyLargestResultFragment(boolean b) {
        this.keepOnlyLargestResultFragment = b;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String f;
        if (this.verb != null) {
            this.verb.verbose("Set parameters");
            this.verb.verbose(params);
        }
        super.setParameters(params);
        String s = params.getProperty("keepsingleatom");
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                this.keepSingleForAcyclic = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.keepSingleForAcyclic = false;
            } else {
                throw new PluginException("Parameter value for --keepsingleatom \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("lfin")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.processOnlyLargestInputFragment = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.processOnlyLargestInputFragment = false;
            } else {
                throw new PluginException("Parameter value for --lfin \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("lfout")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.keepOnlyLargestResultFragment = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.keepOnlyLargestResultFragment = false;
            } else {
                throw new PluginException("Parameter value for --lfout \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((f = params.getProperty("format")) != null) {
            this.format = f;
        }
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            Molecule mol = (Molecule)result;
            return mol.toFormat(this.format);
        }
        throw new PluginException("Cannot convert result to String: " + result);
    }

    @Override
    public String getTypeString(Object type) {
        return type.toString().toLowerCase();
    }

    public static interface VerbosePrinter {
        public void verbose(Object var1);
    }
}

