/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.calculations.BemisMurckoPlugin;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class BemisMurckoPluginOutput
extends CalculatorPluginOutput {
    private String format = null;
    private MolExporter exporter = null;

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.format = params.getProperty("format");
        if (this.format == null) {
            this.format = "sdf";
            System.err.println("Warning! No format given, using " + this.format);
        }
    }

    @Override
    public boolean isMolecular() {
        return this.format != null;
    }

    @Override
    public void setOutputStream(OutputStream os) throws IOException {
        if (this.format != null) {
            this.exporter = new MolExporter(os, this.format);
        }
    }

    @Override
    public void close(int opts) throws IOException {
        if (this.exporter != null) {
            this.exporter.close(opts);
        }
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        BemisMurckoPlugin p = (BemisMurckoPlugin)this.getPlugin();
        try {
            this.exporter.write(p.getResultMolecule());
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        return "";
    }
}

