/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Charge;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class ChargePlugin
extends MajorMicrospeciesAccessorPlugin {
    private static String[] TYPE_RANGE = new String[]{"total", "pi", "sigma", "formalcharge", "atomicformalcharge", "aromaticsystem", "aromaticsystemtotal", "aromaticsystemsigma", "aromaticsystempi", "aromaticring", "aromaticringtotal", "aromaticringsigma", "aromaticringpi"};
    private Charge charge = null;
    private Object[] types = new Object[]{"total"};
    private String[] result = null;
    private boolean implh = false;
    private boolean resonance = false;

    public ChargePlugin() {
        this.charge = new Charge();
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Charge Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                token = ChargePlugin.removeWhitespace(token);
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        this.implh = "true".equalsIgnoreCase(params.getProperty("implh"));
        this.resonance = "true".equalsIgnoreCase(params.getProperty("resonance"));
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    public void setTakeResonantStructures(boolean resonance) {
        this.resonance = resonance;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.charge.setMolecule(mol);
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.resonance) {
            this.charge.calcMajorResonanceCharge();
        } else {
            this.charge.calcCharges();
        }
        return !this.charge.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.charge.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public int getFormalCharge() {
        return this.charge.getMolecule().getFormalCharge();
    }

    public int getFormalCharge(int index) {
        return this.charge.getMolecule().getAtom(index).getCharge();
    }

    public double getTotalCharge(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getTotalCharge(index);
    }

    public double getSigmaCharge(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getSigmaCharge(index);
    }

    public double getPiCharge(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getPiCharge(index);
    }

    public double getResultantImplicitHCharge(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getResultantImplicitHCharge(index);
    }

    public double getAromaticSystemCharge(int index) {
        return this.getAromaticSystemCharge(index, 0);
    }

    public double getAromaticSystemCharge(int index, int chgtype) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getAromaticSystemCharge(index, chgtype);
    }

    public double getAromaticRingCharge(int index) {
        return this.getAromaticRingCharge(index, 0);
    }

    public double getAromaticRingCharge(int index, int chgtype) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.charge.getAromaticRingCharge(index, chgtype);
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        if (type.toString().equalsIgnoreCase("formalcharge")) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        if (type.toString().equalsIgnoreCase("formalcharge")) {
            return 1;
        }
        return this.getAtomCount();
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("total")) {
            return "Total charge";
        }
        if (typestr.equals("formalcharge")) {
            return "Formal charge";
        }
        if (typestr.equals("atomicformalcharge")) {
            return "Atomic formal charge";
        }
        if (typestr.equals("sigma")) {
            return "Sigma charge";
        }
        if (typestr.equals("pi")) {
            return "Pi charge";
        }
        if (typestr.equals("aromaticsystem")) {
            return "Aromatic system charge";
        }
        if (typestr.equals("aromaticsystemtotal")) {
            return "Aromatic system total charge";
        }
        if (typestr.equals("aromaticsystemsigma")) {
            return "Aromatic system sigma charge";
        }
        if (typestr.equals("aromaticsystempi")) {
            return "Aromatic system pi charge";
        }
        if (typestr.equals("aromaticring")) {
            return "Aromatic ring charge";
        }
        if (typestr.equals("aromaticringtotal")) {
            return "Aromatic ring total charge";
        }
        if (typestr.equals("aromaticringsigma")) {
            return "Aromatic ring sigma charge";
        }
        if (typestr.equals("aromaticringpi")) {
            return "Aromatic ring pi charge";
        }
        return type.toString();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("total")) {
            return new Double(this.getTotalCharge(index));
        }
        if (typestr.equals("formalcharge")) {
            return new Integer(this.getFormalCharge());
        }
        if (typestr.equals("atomicformalcharge")) {
            return new Integer(this.getFormalCharge(index));
        }
        if (typestr.equals("sigma")) {
            return new Double(this.getSigmaCharge(index));
        }
        if (typestr.equals("pi")) {
            return new Double(this.getPiCharge(index));
        }
        if (typestr.indexOf("aromaticsystem") != -1) {
            return new Double(this.getAromaticSystemCharge(index, ChargePlugin.getChargeType(typestr)));
        }
        if (typestr.indexOf("aromaticring") != -1) {
            return new Double(this.getAromaticRingCharge(index, ChargePlugin.getChargeType(typestr)));
        }
        if (typestr.equals("implh")) {
            return new Double(this.getResultantImplicitHCharge(index));
        }
        throw new PluginException("Unknown type: " + type);
    }

    private static int getChargeType(String str) {
        if (str.indexOf("sigma") != -1) {
            return 1;
        }
        if (str.indexOf("pi") != -1) {
            return 2;
        }
        return 0;
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Integer) {
            if ((Integer)result == Integer.MAX_VALUE) {
                return this.format(Double.POSITIVE_INFINITY);
            }
            return result.toString();
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        String str = Double.isNaN(x) ? "" : this.format(x);
        String typestr = type.toString().toLowerCase();
        if (!this.implh || typestr.equals("pi") || typestr.indexOf("aromaticsystem") != -1 || typestr.indexOf("aromaticring") != -1 || typestr.equals("implh")) {
            return str;
        }
        if ((index = this.getAtomIndex(index)) == -1) {
            return str;
        }
        double y = this.charge.getResultantImplicitHCharge(index);
        str = str + (Double.isNaN(y) ? "" : " (" + this.format(y) + ")");
        return str;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        Object type = this.types[0];
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            Object result = this.getResult(type, i);
            String label = this.getResultAsString(type, i, result);
            mol.getAtom(i).setExtraLabel(label);
        }
        return mol;
    }
}

