/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modelling.gui.MoleculeLoader;
import chemaxon.marvin.modelling.gui.StructureStream;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.newmd.MD;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.marvin.modelling.struc.ConformationMatch;
import chemaxon.marvin.modelling.struc.ConformationStream;
import chemaxon.marvin.modelling.util.Canceller;
import chemaxon.marvin.modelling.util.RunClass;
import chemaxon.marvin.modelling.util.TimeoutCancellerImpl;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.Callable;

public class ConformationPlugin
extends CalculatorPlugin
implements Callable {
    private Molecule mol = null;
    private double energyWindow = 5.0;
    private double lowestEnergy = 0.0;
    private final double baseMatchLimit = 0.4;
    private double matchLimit = 0.4;
    private int countLimit = 100;
    private boolean automatic = false;
    private ForceField ff = null;
    private String ffNAme = "cxn";
    private StructureStream ss = null;
    private Molecule[] conformations = null;
    private int conformationCount = 0;
    private ConformationMatch cm = null;
    private boolean opt = false;
    private boolean raw = false;
    private boolean hasConformations = false;
    private String conformationInput = null;
    private Canceller canceller = null;
    private int maxNumberOfConformations = Integer.MAX_VALUE;
    private long timeLimit = 900000L;
    private int verboseLevel = 0;
    private boolean coolinternals = true;
    private boolean naturals = true;
    private double temperature = 900.0;
    private double timestep = 0.5;
    private int termostat = 1;

    @Override
    public String getProductName() {
        return "ConformationPlugin";
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.setMol(mol);
    }

    @Override
    public boolean run() throws PluginException {
        MDSettings mdsettings = new MDSettings();
        if (this.ffNAme == "mmff94") {
            mdsettings.setForceFieldType(2);
        } else {
            mdsettings.setForceFieldType(0);
        }
        mdsettings.setNaturals(this.isNaturals());
        mdsettings.setCoolInternals(this.isCoolinternals());
        mdsettings.setStepSize(this.getTimestep());
        mdsettings.setTemperature(this.getTemperature());
        mdsettings.setThermostatTimeConstant(10.0);
        mdsettings.setCoolInternals(this.coolinternals);
        mdsettings.setNaturals(this.naturals);
        MD md = new MD(mdsettings, this.mol);
        if (md.getCanceller() != null && md.getCanceller().isCancelled()) {
            return false;
        }
        this.setStructureStream(md);
        if (this.isAutomatic()) {
            this.setCountlimit(this.mol.getAtomCount() * 10);
        }
        if (this.ff == null) {
            if (this.ffNAme.equals("mmff94")) {
                this.setFf(new MMFF94());
            } else {
                this.setFf(new Dreiding());
            }
        }
        if (this.ss == null) {
            throw new PluginException("Structure source (like MD) is not given for ConformationPlugin.");
        }
        if (this.mol == null && this.conformationInput == null) {
            throw new PluginException("Input molecule is not given for ConformationPlugin.");
        }
        if (this.mol != null && this.mol.getFragCount(0) > 1) {
            throw new PluginException("Conformation plugin works only for single fragment molecules.");
        }
        this.cm = this.getConformationInput() != null ? new ConformationMatch(new ConformationStream(new MoleculeLoader(this.conformationInput)), this.mol) : new ConformationMatch(this.ss, this.mol);
        this.cm.setFf(this.getFf());
        TimeoutCancellerImpl canceller = new TimeoutCancellerImpl(this.getTimeLimit());
        canceller.reset();
        if (this.getVerboseLevel() > 0) {
            System.err.println("Set canceller with time limit: " + this.getTimeLimit());
        }
        this.cm.setHasConformations(this.hasConformations);
        if (this.getVerboseLevel() > 0) {
            System.err.println("Forcefield is: " + this.ffNAme);
            if (this.getFf() != null) {
                System.err.println("Forcefield class is: " + this.ff.getClass().getName());
            }
            System.err.println("Energy window: " + this.energyWindow);
            if (this.isOpt()) {
                System.err.println("Conformations will be optimized, conformer mode.");
            } else {
                System.err.println("Conformations won't be optimized, conformation mode.");
            }
            if (this.automatic) {
                System.err.println("Count limit will be set automatically.");
            } else {
                System.err.println("Maximum count limit is: " + this.getCountlimit());
            }
            System.err.println("Maximum number of conformations is " + this.getMaxNumberOfConformations());
        }
        if (this.getFf() == null) {
            if (this.ffNAme == "mmff94") {
                this.setFf(new MMFF94());
            } else {
                this.setFf(new Dreiding());
            }
        }
        this.cm.setFf(this.getFf());
        this.cm.setEnergyWindow(this.getEnergyWindow());
        this.cm.setOpt(this.isOpt());
        this.cm.setHasConformations(this.hasConformations);
        this.cm.setAutomatic(this.automatic);
        this.cm.setCanceller(this.getCanceller());
        this.cm.setMaxNumberOfConformations(this.maxNumberOfConformations);
        this.cm.setCanceller(canceller);
        if (this.automatic) {
            System.err.println("Use automatic count stop criteria.");
            long limit = Math.round((double)this.getCountlimit() * (this.matchLimit / 0.4));
            this.cm.setCountLimit(limit);
        } else {
            this.cm.setCountLimit(this.getCountlimit());
        }
        this.cm.setMatchLimit(this.getMatchLimit());
        if (this.getCanceller() != null && this.getCanceller().isCancelled()) {
            return false;
        }
        this.cm.run();
        System.err.println("CM finished.");
        this.conformations = this.cm.getConformations();
        if (this.getCanceller() != null && this.getCanceller().isCancelled()) {
            System.err.println("Run cancelled.");
        }
        if (this.conformations == null || this.conformations.length < 1) {
            System.err.println("There are no available conformations.");
            return false;
        }
        if (this.conformations != null) {
            System.err.println("Run finished, # of conformations is " + this.conformations.length);
        }
        return true;
    }

    public Molecule getMol() {
        return this.mol;
    }

    public void setMol(Molecule mol) {
        this.mol = mol;
        this.conformations = null;
    }

    public double getEnergyWindow() {
        return this.energyWindow;
    }

    public void setEnergyWindow(double energyWindow) {
        this.energyWindow = energyWindow;
    }

    public double getLowestEnergy() {
        return this.lowestEnergy;
    }

    public void setLowestEnergy(double lowestEnergy) {
        this.lowestEnergy = lowestEnergy;
    }

    public int getCountlimit() {
        return this.countLimit;
    }

    public void setCountlimit(int countlimit) {
        this.countLimit = countlimit;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public ForceField getFf() {
        return this.ff;
    }

    public void setFf(ForceField ff) {
        System.err.println("Set ff to: " + ff.getClass().getName());
        this.ff = ff;
    }

    public void setFf(String ffName) {
        System.err.println("Set ffName to: " + ffName);
        this.ffNAme = ffName;
    }

    public StructureStream getStructueStream() {
        return this.ss;
    }

    public void setStructureStream(StructureStream ss) {
        this.ss = ss;
    }

    public static void main(String[] args) throws PluginException {
        int speedLevel = 0;
        ConformationPlugin cp = new ConformationPlugin();
        String usage = "Usage:\nConformationPlugin [options] <input_molecule>\n\toptions are:\n General options:\n\t-v               \t:\tincrease verbose level\n\t-help           \t:\tPrint this help message\n\t-o <filename>\t\t:\toutput file in SDF format\n\t-ci <filename>\t\t:\tthe structures are taken from file \"filename\", no simulation\n\t-mc <num>       \t:\tmaximum number of conformations\n\t-timelimit <num>\t:\ttime limit in seconds\n Selection options:\n\t-raw        \t\t:\tno selection, results trajectory\n\t-matchlimit <num>\t:\tthe RMS limit between resulting conformations is num\n                           If -raw is set use simple pairwise fit\n\t-energywindow <num>\t:\tSet the energy window for allowed conformations or conformers\n\t-opt\t    \t\t:\toptimize, results conformers\n\t-countlimit <num>\t:\tSet the starting limit of the number of structures to evaluate\n\t-auto           \t:\tAdjust count limit automatically\n Simulation options\n\t-dt              \t:\tStep size in femtoseconds\n\t-T <num>          \t:\tSimulation temperature in Kelvin is num\n\t-dc             \t:\tdisable cooling, the default is enable intenal coordinate cooling\n\t-ric\t\t       \t:\tUee redundant internal coordinates for cooling instead of non-redundant natural internals\n\t-ff [mmff94|cxn]\t:\tForcefield: use MMFF94 or ChemAxon version of the DREIDING forcefield";
        String outname = null;
        cp.setEnergyWindow(Double.POSITIVE_INFINITY);
        cp.setMatchLimit(cp.matchLimit);
        cp.setCountlimit(cp.countLimit);
        cp.setTimeLimit(900L);
        Vector<String> argV = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-matchlimit")) {
                cp.setMatchLimit(Double.parseDouble(args[++i]));
                continue;
            }
            if (arg.equals("-mc")) {
                cp.setMaxNumberOfConformations(Integer.parseInt(args[++i]));
                continue;
            }
            if (arg.equals("-v")) {
                ++cp.verboseLevel;
                continue;
            }
            if (arg.equals("-dc")) {
                cp.setCoolinternals(false);
                continue;
            }
            if (arg.equals("-ric")) {
                cp.setNaturals(false);
                continue;
            }
            if (arg.equals("-help")) {
                System.err.println(usage);
                System.exit(0);
                continue;
            }
            if (arg.equals("-auto")) {
                cp.setAutomatic(true);
                continue;
            }
            if (arg.equals("-countlimit")) {
                cp.setCountlimit(Integer.parseInt(args[++i]));
                continue;
            }
            if (arg.equals("-T")) {
                cp.setTemperature(Double.parseDouble(args[++i]));
                continue;
            }
            if (arg.equals("-dt")) {
                cp.setTimestep(Double.parseDouble(args[++i]));
                continue;
            }
            if (arg.equals("-energywindow")) {
                cp.setEnergyWindow(Double.parseDouble(args[++i]));
                continue;
            }
            if (arg.equals("-opt")) {
                if (cp.isRaw()) {
                    System.err.println("Ambigous options -raw and -opt.");
                    throw new PluginException("Ambigous options.");
                }
                cp.setOpt(true);
                continue;
            }
            if (arg.equals("-raw")) {
                if (cp.isOpt()) {
                    System.err.println("Ambigous options -raw and -opt.");
                    throw new PluginException("Ambigous options.");
                }
                cp.setRaw(true);
                continue;
            }
            if (arg.equals("-o")) {
                outname = args[++i];
                continue;
            }
            if (arg.equals("-ci")) {
                cp.conformationInput = args[++i];
                cp.hasConformations = true;
                continue;
            }
            if (arg.equals("-timelimit")) {
                long timeLimit = Long.parseLong(args[++i]);
                cp.setTimeLimit(timeLimit);
                continue;
            }
            if (arg.equals("-speed")) {
                speedLevel = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-ff")) {
                String ff;
                if ((ff = args[++i]).equalsIgnoreCase("mmff94")) {
                    cp.ffNAme = "mmff94";
                }
                System.err.println("FF is: " + cp.ffNAme);
                continue;
            }
            argV.addElement(args[i]);
        }
        args = new String[argV.size()];
        if ((args = argV.toArray(args)).length == 0 && !cp.hasConformations()) {
            System.err.println(usage);
            return;
        }
        ConformationStream css = null;
        if (cp.getConformationInput() != null) {
            css = new ConformationStream(new MoleculeLoader(cp.getConformationInput()));
            try {
                ForceField ff = cp.ffNAme.equals("mmff94") ? new MMFF94() : new Dreiding();
                cp.setFf(ff);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        MoleculeLoader ml = null;
        if (args != null && args.length > 0) {
            ml = new MoleculeLoader(args);
        }
        int count = 0;
        while (count == 0 || ml != null && ml.hasNext()) {
            Molecule[] confs;
            ++count;
            Molecule mol = null;
            if (ml != null) {
                mol = ml.next();
                cp.setInputMolecule(mol);
            }
            try {
                if (cp.getFf() == null) {
                    if (cp.ffNAme == "mmff94") {
                        cp.setFf(new MMFF94());
                    } else {
                        cp.setFf(new Dreiding());
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (css != null) {
                cp.setStructureStream(css);
            }
            cp.setMatchLimit(cp.matchLimit);
            if (cp.getVerboseLevel() > 0) {
                System.err.println("Set match limit to " + cp.matchLimit);
                System.err.println("Set count limit to " + cp.countLimit);
                System.err.println("Set speed level to " + speedLevel);
                System.err.println("Forcefield class is:" + cp.getFf().getClass().getName());
            }
            Thread cpThread = new Thread(new RunClass(cp));
            cpThread.start();
            System.err.println("ConformationPlugin thread has been started.");
            MolExporter me = null;
            if (outname == null) {
                try {
                    me = new MolExporter(System.out, "sdf");
                }
                catch (MolExportException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    me = new MolExporter(new FileOutputStream(outname + "_" + count + ".sdf"), "sdf");
                }
                catch (MolExportException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (cp.getVerboseLevel() > 0) {
                if (outname == null) {
                    System.err.println("Output results to standard output.");
                } else {
                    System.err.println("Output results to " + outname + "_" + count + ".sdf");
                }
            }
            while (!cpThread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!cpThread.isAlive()) {
                    throw new UnsupportedOperationException("Unconditional deadlock. Thread exit.");
                }
                System.exit(-1);
            }
            System.err.println("Entering main \"getRemainingConformations\" loop.");
            while (cp.cm == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (cp.cm != null) {
                System.err.println("Call cp.cm.setSpeedLevel(" + speedLevel + ").");
                cp.cm.setSpeedLevel(speedLevel);
            }
            System.err.println("Entering main \"getRemainingConformations\" loop.");
            while (cpThread.isAlive()) {
                System.err.println("We are in main \"getRemainingConformations\" loop.");
                if (cp.cm != null) {
                    System.err.println("Call getRemainingConformations()");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    confs = cp.cm.getRemainingConformations();
                    if (confs.length > 0) {
                        System.err.println("Number of new conformations is " + confs.length);
                    }
                    for (int i = 0; i < confs.length; ++i) {
                        System.err.print(".");
                        try {
                            Molecule m = confs[i];
                            me.write(m);
                            continue;
                        }
                        catch (MolExportException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.err.print("cm is null!");
                }
                System.err.print("!");
                try {
                    Thread.sleep(990L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.err.println("Conformation plugin thread is dead.");
            confs = cp.cm.getRemainingConformations();
            try {
                String mName = "Null";
                if (mol != null) {
                    mName = mol.getName();
                }
                System.err.println("# " + count + "\tConformations: " + cp.getConformationCount() + "\t Name: " + mName);
                for (int i = 0; i < confs.length; ++i) {
                    Molecule m = confs[i];
                    me.write(m);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (MolExportException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Molecule[] getConformations() throws PluginException {
        if (this.conformations == null) {
            this.run();
        }
        return this.conformations;
    }

    public int getConformationCount() throws PluginException {
        this.conformationCount = this.getConformations().length;
        return this.conformationCount;
    }

    public void setMatchLimit(double matchLimit) {
        this.matchLimit = matchLimit;
    }

    public double getMatchLimit() {
        return this.matchLimit;
    }

    @Override
    public Molecule[] getResultMolecules() throws PluginException {
        return this.getConformations();
    }

    public Object call() throws Exception {
        return this.run();
    }

    public void setOpt(boolean opt) {
        this.opt = opt;
    }

    public boolean isOpt() {
        return this.opt;
    }

    public void setHasconformations(boolean hasconformations) {
        this.hasConformations = hasconformations;
    }

    public boolean hasConformations() {
        return this.hasConformations;
    }

    public void setConformationInput(String conformationInput) {
        this.conformationInput = conformationInput;
    }

    public String getConformationInput() {
        return this.conformationInput;
    }

    public void setCanceller(Canceller canceller) {
        this.canceller = canceller;
    }

    public Canceller getCanceller() {
        return this.canceller;
    }

    public void setMaxNumberOfConformations(int maxNumberOfConformations) {
        this.maxNumberOfConformations = maxNumberOfConformations;
        if (this.cm != null) {
            this.cm.setMaxNumberOfConformations(maxNumberOfConformations);
        }
    }

    public int getMaxNumberOfConformations() {
        return this.maxNumberOfConformations;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit * 1000L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public boolean isCoolinternals() {
        return this.coolinternals;
    }

    public void setCoolinternals(boolean coolinternals) {
        this.coolinternals = coolinternals;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int verboseLevel) {
        this.verboseLevel = verboseLevel;
    }

    public boolean isNaturals() {
        return this.naturals;
    }

    public void setNaturals(boolean naturals) {
        this.naturals = naturals;
    }

    public int getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(int countLimit) {
        this.countLimit = countLimit;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTimestep() {
        return this.timestep;
    }

    public void setTimestep(double timestep) {
        this.timestep = timestep;
    }

    public int getTermostat() {
        return this.termostat;
    }

    public void setTermostat(int termostat) {
        this.termostat = termostat;
    }
}

