/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Geometry;
import chemaxon.calculations.HBondViewer;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class GeometryPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"dreidingenergy", "mmff94energy", "distance", "angle", "dihedral", "hindrance", "minimalprojectionarea", "maximalprojectionarea", "minimalprojectionradius", "maximalprojectionradius", "volume", "minz", "maxz"};
    private Object[] types = new Object[]{"dreidingenergy", "hindrance", "minimalprojectionarea", "maximalprojectionarea", "minimalprojectionradius", "maximalprojectionradius", "minz", "maxz"};
    private static final double CALORIE_TO_JOULE = 4.184;
    private static final String NO_TYPE_SELECTED_REMARK = "No calculation type selected in the options dialog.";
    private static String warningmsg = "";
    private Geometry geometry = new Geometry();
    private String calculateForLEConformer = "if2D";
    private boolean calculateEnergy = false;
    private boolean calculateMMFF94Energy = false;
    private boolean mmff94Optimization = false;
    private boolean calculateMoleculeProjection = false;
    private int[] atoms;
    private HBondViewer hbondViewer = null;
    private boolean hbondCalculationSelected = false;
    private int numberOfHBonds = 0;
    private int[][] hbondDAAtomIndexes = null;
    private boolean molHasHBonds = false;
    private boolean isDefaultEnergyUnit = true;
    private boolean calculateVolume = false;
    private boolean preparedMol = true;

    @Override
    public String getProductName() {
        return "Geometry Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toLowerCase();
                token = GeometryPlugin.removeWhitespace(token);
                this.checkType(token, TYPE_RANGE);
                if (token.equals("volume")) {
                    this.setCalculateVolume(true);
                }
                if (token.equals("dreidingenergy")) {
                    this.setCalculateEnergy(true);
                }
                if (token.equalsIgnoreCase("mmff94energy")) {
                    this.setCalculateMMFF94Energy(true);
                }
                if (token.equals("hbondcount")) {
                    this.setHBondCalculation(true);
                }
                if (token.equals("minimalprojectionarea") || token.equals("maximalprojectionarea") || token.equals("minimalprojectionradius") || token.equals("maximalprojectionradius") || token.equals("minz") || token.equals("maxz")) {
                    this.setCalculateMoleculeProjections(true);
                }
                this.types[i++] = token;
            }
        }
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        this.calculateForLEConformer = params.getProperty("calcforleconformer", "if2D");
        this.setOptimization(Integer.parseInt(params.getProperty("optimization", "1")));
        this.isDefaultEnergyUnit = params.getProperty("energyunit", "kcal/mol").equalsIgnoreCase("kcal/mol");
        this.setOptimizeProjection(params.getProperty("optimizeprojection", "false").equalsIgnoreCase("true"));
        this.setMMFF94Optimization(params.getProperty("mmff94optimization", "false").equalsIgnoreCase("true"));
        String atomsString = params.getProperty("atoms");
        if (atomsString != null) {
            try {
                int[] atomsArray = StringUtil.parseInts(atomsString);
                this.setAtoms(atomsArray);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Atoms are not set properly.");
            }
        }
    }

    private void setAtoms(int[] atoms) throws PluginException {
        int i = 0;
        while (i < atoms.length) {
            int n = i++;
            atoms[n] = atoms[n] - 1;
            if (atoms[n] >= 0) continue;
            throw new PluginException("Atoms are not set properly.");
        }
        this.atoms = atoms;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.geometry.setProgressMonitor(pmon);
    }

    public void setCalculateVolume(boolean calculateVolume) {
        this.calculateVolume = calculateVolume;
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return false;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (GeometryPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
        if (mol.getFragCount() > 1) {
            throw new PluginException("Calculation result is not defined for molecules with multiple fragments.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.geometry.setMolecule(mol);
    }

    public void setCalculateEnergy(boolean e) {
        this.calculateEnergy = e;
    }

    public void setCalculateMMFF94Energy(boolean mmffe) {
        this.calculateMMFF94Energy = mmffe;
    }

    public void setMMFF94Optimization(boolean opt) {
        this.mmff94Optimization = opt;
    }

    public void setCalculateForLEConformer(String condition) {
        this.calculateForLEConformer = condition;
    }

    public void setOptimization(int opt) {
        this.geometry.setOptimization(opt);
    }

    private boolean calculateLowestEnergyConformer() {
        return this.geometry.calculateLowestEnergyConformer();
    }

    public Molecule getLowestEnergyConformer() {
        return this.geometry.getLowestEnergyConformer();
    }

    @Override
    public void setLicenseEnvironment(String env) {
        super.setLicenseEnvironment(env);
        this.geometry.setLicenseEnvironment(env);
    }

    private void calculateDreidingEnergy() {
        this.geometry.calculateDreidingEnergy();
    }

    public double getDreidingEnergy() {
        return this.geometry.dreidingEnergy();
    }

    private boolean calculateMMFF94Energy() throws PluginException {
        try {
            return this.geometry.calculateMMFF94Energy(this.mmff94Optimization);
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    public double getMMFF94Energy() {
        return this.geometry.getMMFF94Energy();
    }

    public double getDistance(int atom1, int atom2) {
        return this.geometry.distance(atom1, atom2);
    }

    public double getDistance(int[] atoms) throws PluginException {
        if (atoms == null || atoms.length != 2) {
            throw new PluginException("Atoms are not set properly for distance calculation.");
        }
        return this.geometry.distance(atoms[0], atoms[1]);
    }

    public double getAngle(int atom1, int atom2, int atom3) {
        return this.geometry.angle(atom1, atom2, atom3);
    }

    public double getAngle(int[] atoms) throws PluginException {
        if (atoms == null || atoms.length != 3) {
            throw new PluginException("Atoms are not set properly for angle calculation.");
        }
        return this.geometry.angle(atoms[0], atoms[1], atoms[2]);
    }

    public double getDihedral(int atom1, int atom2, int atom3, int atom4) {
        return this.geometry.dihedral(atom1, atom2, atom3, atom4);
    }

    public double getDihedral(int[] atoms) throws PluginException {
        if (atoms == null || atoms.length != 4) {
            throw new PluginException("Atoms are not properly set for dihedral calculaton.");
        }
        return this.geometry.dihedral(atoms[0], atoms[1], atoms[2], atoms[3]);
    }

    public double getStericHindrance(int atom) {
        return this.geometry.stericHindrance(atom);
    }

    public void setCalculateMoleculeProjections(boolean c) {
        this.calculateMoleculeProjection = c;
    }

    public double getMinimalProjectionArea() {
        return this.geometry.getMinimalArea();
    }

    public double getMaximalProjectionArea() {
        return this.geometry.getMaximalArea();
    }

    public double getMinimalProjectionRadius() {
        return this.geometry.getMinimalRadius();
    }

    public double getMaximalProjectionRadius() {
        return this.geometry.getMaximalRadius();
    }

    public double getVolume() {
        return this.geometry.getVolume();
    }

    public void setOptimizeProjection(boolean optimize) {
        this.geometry.setAccurateMode(optimize);
    }

    private boolean calculateHBonds(Molecule mol) {
        boolean foundHBond = false;
        this.numberOfHBonds = 0;
        this.hbondViewer.setTakeConformers(false);
        this.hbondViewer.setMolecule(mol);
        this.hbondViewer.calcDACouples();
        if (this.hbondViewer.getConformerCount() == 0) {
            this.numberOfHBonds = 0;
        } else {
            foundHBond = true;
            this.numberOfHBonds = this.hbondViewer.getHBondCountOfConformer(0);
            this.hbondDAAtomIndexes = new int[this.numberOfHBonds][];
            for (int bi = 0; bi < this.numberOfHBonds; ++bi) {
                this.hbondDAAtomIndexes[bi] = new int[2];
                this.hbondDAAtomIndexes[bi][0] = this.hbondViewer.getADCoupleOfConformer(0, bi)[0];
                this.hbondDAAtomIndexes[bi][1] = this.hbondViewer.getADCoupleOfConformer(0, bi)[1];
            }
        }
        return foundHBond;
    }

    boolean hasHBonds() {
        return this.numberOfHBonds != 0;
    }

    int getHBondCount() {
        return this.numberOfHBonds;
    }

    int[] getHBond(int bondIndex) {
        return this.hbondDAAtomIndexes[bondIndex];
    }

    void setHBondCalculation(boolean hb) {
        this.hbondCalculationSelected = hb;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.calculateForLEConformer.equals("if2D") && this.geometry.getInputMolDim() <= 2 || this.calculateForLEConformer.equals("always")) {
            if (!this.calculateLowestEnergyConformer()) {
                warningmsg = "Calculation failed.";
                return false;
            }
        } else {
            if (this.geometry.getInputMolDim() == 0) {
                throw new PluginException("Geometry calculation with molecule in 0 dimension format.");
            }
            if (this.calculateEnergy) {
                this.calculateDreidingEnergy();
            }
        }
        if (this.calculateMoleculeProjection) {
            this.geometry.calculateMoleculeProjection();
            if (this.preparedMol) {
                this.geometry.getMoleculeWithCirclesAndVectors();
            }
        }
        if (this.calculateMMFF94Energy && !this.calculateMMFF94Energy()) {
            warningmsg = "MMFF94 energy calculation failed.";
            return false;
        }
        if (this.hbondCalculationSelected) {
            this.molHasHBonds = this.calculateHBonds(this.geometry.get3DMolecule());
        }
        if (this.calculateVolume) {
            this.geometry.volume();
        }
        return true;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("dreidingenergy")) {
            return new Double(this.getDreidingEnergy());
        }
        if (typestr.equalsIgnoreCase("mmff94energy")) {
            return new Double(this.getMMFF94Energy());
        }
        if (typestr.equalsIgnoreCase("hbondcount")) {
            return new Integer(this.getHBondCount());
        }
        if (typestr.equalsIgnoreCase("distance")) {
            return new Double(this.getDistance(this.atoms));
        }
        if (typestr.equalsIgnoreCase("angle")) {
            return new Double(this.getAngle(this.atoms));
        }
        if (typestr.equalsIgnoreCase("dihedral")) {
            return new Double(this.getDihedral(this.atoms));
        }
        if (typestr.equalsIgnoreCase("hindrance")) {
            return new Double(this.getStericHindrance(index));
        }
        if (typestr.equalsIgnoreCase("minimalprojectionarea")) {
            return new Double(this.getMinimalProjectionArea());
        }
        if (typestr.equalsIgnoreCase("maximalprojectionarea")) {
            return new Double(this.getMaximalProjectionArea());
        }
        if (typestr.equalsIgnoreCase("minimalprojectionradius")) {
            return new Double(this.getMinimalProjectionRadius());
        }
        if (typestr.equalsIgnoreCase("maximalprojectionradius")) {
            return new Double(this.getMaximalProjectionRadius());
        }
        if (typestr.equalsIgnoreCase("volume")) {
            return new Double(this.getVolume());
        }
        if (typestr.equalsIgnoreCase("minz")) {
            return new Double(this.getMinZ());
        }
        if (typestr.equalsIgnoreCase("maxz")) {
            return new Double(this.getMaxZ());
        }
        throw new PluginException("Unknown type: " + type);
    }

    public double getMaxZ() {
        return this.geometry.getMaxZ();
    }

    public double getMinZ() {
        return this.geometry.getMinZ();
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        if (arg != null) {
            try {
                int[] atomsArray = StringUtil.parseInts(arg);
                this.setAtoms(atomsArray);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Atoms are not set properly.");
            }
        }
        return this.getResult(type, 0);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Double) {
            double x = (Double)result;
            return this.format(x);
        }
        if (result instanceof Integer) {
            return String.valueOf((Integer)result);
        }
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("sdf:-a");
        }
        throw new PluginException("Result should be a double, integer \n or molecule object instead of: " + result);
    }

    @Override
    public int getResultCount(Object type) {
        return this.getResultDomain(type) == 1 ? this.getAtomCount() : 1;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("hindrance")) {
            return 1;
        }
        return 2;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("dreidingenergy")) {
            return "Dreiding energy";
        }
        if (typestr.equalsIgnoreCase("mmff94energy")) {
            return "MMFF94 energy";
        }
        if (typestr.equals("hbondcount")) {
            return "Intramolecular H bond count";
        }
        if (typestr.equals("distance")) {
            return "Distance";
        }
        if (typestr.equals("angle")) {
            return "Angle";
        }
        if (typestr.equals("dihedral")) {
            return "Dihedral";
        }
        if (typestr.equals("hindrance")) {
            return "Steric hindrance";
        }
        if (typestr.equals("minimalprojectionarea")) {
            return "Minimal projection area";
        }
        if (typestr.equals("maximalprojectionarea")) {
            return "Maximal projection area";
        }
        if (typestr.equals("minimalprojectionradius")) {
            return "Minimal projection radius";
        }
        if (typestr.equals("maximalprojectionradius")) {
            return "Maximal projection radius";
        }
        if (typestr.equals("maxz")) {
            return "Length perpendicular to the max area";
        }
        if (typestr.equals("minz")) {
            return "Length perpendicular to the min area";
        }
        if (typestr.equals("volume")) {
            return "van der Waals volume";
        }
        return type.toString();
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule displayMol = this.geometry.get3DMolecule();
        if (displayMol == null) {
            return null;
        }
        displayMol.clearProperties();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) != 2) continue;
            Object result = this.getResult(type, 0);
            if (type.toString().toLowerCase().equals("dreidingenergy")) {
                if (!this.isDefaultEnergyUnit) {
                    displayMol.setProperty(type.toString(), this.format(this.getDreidingEnergy() * 4.184) + " kJ/mol");
                    continue;
                }
                displayMol.setProperty(type.toString(), this.getResultAsString(type, 0, result) + " kcal/mol");
                continue;
            }
            if (type.toString().toLowerCase().equals("mmff94energy")) {
                if (!this.isDefaultEnergyUnit) {
                    displayMol.setProperty(type.toString(), this.format(this.getMMFF94Energy() * 4.184) + " kJ/mol");
                    continue;
                }
                displayMol.setProperty(type.toString(), this.getResultAsString(type, 0, result) + " kcal/mol");
                continue;
            }
            displayMol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return displayMol.getPropertyCount() > 0 ? displayMol : null;
    }

    @Override
    public Molecule[] getResultMolecules() throws PluginException {
        ArrayList<Molecule> list = new ArrayList<Molecule>();
        Molecule mol = this.getResultMolecule();
        if (mol != null) {
            list.add(mol);
        }
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) != 1) continue;
            mol = this.getDisplayMolecule();
            mol.clearProperties();
            mol.setProperty(type.toString(), "");
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                Object result = this.getResult(type, i);
                String label = this.getResultAsString(type, i, result);
                mol.getAtom(i).setExtraLabel(label);
            }
            list.add(mol);
        }
        if (list.size() == 0) {
            return null;
        }
        Molecule[] mols = new Molecule[list.size()];
        list.toArray(mols);
        return mols;
    }

    @Override
    public String getRemark() {
        return this.types == null || this.types.length == 0 ? NO_TYPE_SELECTED_REMARK : null;
    }

    @Override
    public String getWarningMessage() {
        return this.geometry.get3DMolecule() == null ? warningmsg : "";
    }

    @Override
    public boolean isMultiThreadedRunEnabled() {
        return false;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
    }
}

