/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.calculations.GeometryPlugin;
import chemaxon.marvin.calculations.MultipleDataDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MPolyline;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;

public class GeometryPluginDisplay
extends MultipleDataDisplay {
    private static final Color HBOND_COLOR = Color.cyan.darker();

    public GeometryPluginDisplay() {
        this.setCellSize(400, 400);
    }

    @Override
    public void store() throws PluginException {
        Molecule mol0;
        GeometryPlugin plugin = (GeometryPlugin)this.getPlugin();
        Molecule[] mols = this.getPlugin().getResultMolecules();
        if (this.resultMolList == null) {
            this.resultMolList = new ArrayList();
        }
        if ((mol0 = mols[0]).getProperty("hbondcount") != null) {
            MDocument doc = mol0.getDocument();
            if (doc == null) {
                doc = new MDocument(mol0);
            }
            for (int j = 0; j < plugin.getHBondCount(); ++j) {
                int[] hb = plugin.getHBond(j);
                MolAtom atom1 = mol0.getAtom(hb[0]);
                MolAtom atom2 = mol0.getAtom(hb[1]);
                MPolyline line = new MPolyline(new MAtomSetPoint(new MolAtom[]{atom1}), (MPoint)new MAtomSetPoint(new MolAtom[]{atom2}));
                line.setColor(HBOND_COLOR);
                line.setThickness(0.04);
                doc.addObject(line);
            }
            mols[0] = mol0;
        }
        this.resultMolList.add(mols);
    }

    @Override
    public MProgressMonitor getProgressMonitor(Component parent) {
        MDialogProgressMonitor pm = new MDialogProgressMonitor(parent, this.getTitle());
        pm.setMillisToDecideToPopup(5);
        pm.setMillisToPopup(5);
        return pm;
    }
}

