/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Interaction;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class HBDAPlugin
extends MajorMicrospeciesAccessorPlugin {
    private static final String WARNING = "No H bond donor/acceptor atoms found.";
    public static final double EPSILON = 0.1;
    private static final double DEF_LOWER = 0.0;
    private static final double DEF_UPPER = 14.0;
    private static final double DEF_STEP = 0.5;
    public static final String ACCEPTOR_SIGN = "A";
    public static final String DONOR_SIGN = "D";
    private static String[] TYPE_RANGE = new String[]{"don", "acc", "donsitecount", "accsitecount", "donorcount", "acceptorcount", "msdon", "msacc"};
    private Object[] types = new Object[]{"don", "acc", "donsitecount", "accsitecount", "donorcount", "acceptorcount"};
    private Object[] guitypes = null;
    private double lower = 0.0;
    private double upper = 14.0;
    private double step = 0.5;
    private boolean guimode = false;
    private boolean mscalc = false;
    private double[] mspHs = null;
    private double[] msacceptors = null;
    private double[] msdonors = null;
    private Interaction interaction = new Interaction();

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "HBDA Plugin";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.mscalc = "true".equalsIgnoreCase(params.getProperty("mscalc"));
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toLowerCase();
                if (token.equalsIgnoreCase("acceptor")) {
                    token = "acc";
                } else if (token.equalsIgnoreCase("donor")) {
                    token = "don";
                }
                this.checkType(token, TYPE_RANGE);
                if (token.startsWith("ms")) {
                    this.mscalc = true;
                }
                this.types[i++] = token;
            }
        }
        this.guitypes = null;
        if (this.guimode) {
            this.types = this.getGUIResultTypes();
        }
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        if (this.mscalc) {
            String sstr;
            String lstr = params.getProperty("lower");
            this.lower = lstr != null && lstr.length() > 0 ? Double.valueOf(lstr) : 0.0;
            String ustr = params.getProperty("upper");
            this.upper = ustr != null && ustr.length() > 0 ? Double.valueOf(ustr) : 14.0;
            if (this.upper < this.lower) {
                double tmp = this.lower;
                this.lower = this.upper;
                this.upper = tmp;
            }
            if ((sstr = params.getProperty("step")) != null && sstr.length() > 0) {
                this.step = Double.valueOf(sstr);
                if (this.step < 0.0) {
                    this.step = -this.step;
                } else if (this.step == 0.0 && this.lower != this.upper) {
                    throw new PluginException("Step size is zero.");
                }
            } else {
                this.step = 0.5;
            }
        }
        this.setExcludeSulfur("true".equalsIgnoreCase(params.getProperty("excludesulfur", "true")));
        this.setExcludeHalogens("true".equalsIgnoreCase(params.getProperty("excludehalogens", "true")));
    }

    public void setpHLower(double lower) {
        this.lower = lower;
        this.setMsCalc(true);
    }

    public void setpHUpper(double upper) {
        this.upper = upper;
        this.setMsCalc(true);
    }

    public void setpHStep(double step) {
        this.step = step;
        this.setMsCalc(true);
    }

    public void setMsCalc(boolean mscalc) {
        this.mscalc = mscalc;
        this.types = mscalc ? new Object[]{"don", "acc", "donsitecount", "accsitecount", "donorcount", "acceptorcount", "msdon", "msacc"} : new Object[]{"don", "acc", "donsitecount", "accsitecount", "donorcount", "acceptorcount"};
    }

    @Override
    protected boolean isMsCalc() {
        return this.mscalc;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (HBDAPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.interaction.setMolecule(mol);
    }

    public void setExcludeSulfur(boolean e) {
        this.interaction.setExcludeSulfur(e);
    }

    public void setExcludeHalogens(boolean e) {
        this.interaction.setExcludeHalogens(e);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.mscalc) {
            int count = (int)Math.floor((this.upper - this.lower) / this.step) + 1;
            if (this.mspHs == null || this.mspHs.length != count) {
                this.mspHs = new double[count];
                this.msacceptors = new double[count];
                this.msdonors = new double[count];
            }
            double pH = this.lower;
            for (int i = 0; i < this.msacceptors.length; ++i) {
                this.interaction.calcAcceptorDonorCount(pH);
                this.mspHs[i] = pH;
                this.msacceptors[i] = this.interaction.getAcceptorSiteCountOfMacroState();
                this.msdonors[i] = this.interaction.getDonorSiteCountOfMacroState();
                pH += this.step;
            }
        }
        this.interaction.calcAcceptorDonorCount();
        return !this.interaction.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.interaction.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    @Override
    public String getWarningMessage() {
        int count = 0;
        for (int i = 0; i < this.types.length; ++i) {
            String typestr = this.types[i].toString().toLowerCase();
            if (typestr.indexOf("acc") != -1) {
                count += this.getAcceptorAtomCount();
            }
            if (typestr.indexOf("don") == -1) continue;
            count += this.getDonorAtomCount();
        }
        return count == 0 ? WARNING : "";
    }

    public double[] getpHs() {
        double[] r = new double[this.mspHs.length];
        for (int i = 0; i < this.mspHs.length; ++i) {
            r[i] = this.mspHs[i];
        }
        return r;
    }

    public double[] getMsAcceptorCounts() {
        double[] r = new double[this.msacceptors.length];
        for (int i = 0; i < this.msacceptors.length; ++i) {
            r[i] = this.msacceptors[i];
        }
        return r;
    }

    public double[] getMsDonorCounts() {
        double[] r = new double[this.msdonors.length];
        for (int i = 0; i < this.msdonors.length; ++i) {
            r[i] = this.msdonors[i];
        }
        return r;
    }

    public int getAcceptorCount(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.interaction.getAcceptorSiteCountListOfMicrospecies()[index];
    }

    public int getDonorCount(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.interaction.getDonorSiteCountListOfMicrospecies()[index];
    }

    public int getAcceptorCount() {
        return this.interaction.getAcceptorSiteCountOfMicrospecies();
    }

    public int getDonorCount() {
        return this.interaction.getDonorSiteCountOfMicrospecies();
    }

    public int getAcceptorAtomCount() {
        return this.interaction.getAcceptorAtomCountOfMicrospecies();
    }

    public int getDonorAtomCount() {
        return this.interaction.getDonorAtomCountOfMicrospecies();
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    protected void setGUIMode(boolean guimode) {
        this.guimode = guimode;
    }

    private Object[] getGUIResultTypes() {
        if (this.guitypes == null) {
            Object[] t = this.getResultTypes();
            int a = -1;
            int d = -1;
            for (int i = 0; i < t.length; ++i) {
                if (t[i].toString().equalsIgnoreCase("acc")) {
                    a = i;
                    continue;
                }
                if (!t[i].toString().equalsIgnoreCase("don")) continue;
                d = i;
            }
            if (a == -1 && d == -1) {
                this.guitypes = t;
            } else if (a == -1) {
                Object[] objectArray;
                if (this.mscalc) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = "don";
                    objectArray2[1] = "donsitecount";
                    objectArray2[2] = "donorcount";
                    objectArray = objectArray2;
                    objectArray2[3] = "msdon";
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = "don";
                    objectArray3[1] = "donsitecount";
                    objectArray = objectArray3;
                    objectArray3[2] = "donorcount";
                }
                this.guitypes = objectArray;
            } else if (d == -1) {
                Object[] objectArray;
                if (this.mscalc) {
                    Object[] objectArray4 = new Object[4];
                    objectArray4[0] = "acc";
                    objectArray4[1] = "accsitecount";
                    objectArray4[2] = "acceptorcount";
                    objectArray = objectArray4;
                    objectArray4[3] = "msacc";
                } else {
                    Object[] objectArray5 = new Object[3];
                    objectArray5[0] = "acc";
                    objectArray5[1] = "accsitecount";
                    objectArray = objectArray5;
                    objectArray5[2] = "acceptorcount";
                }
                this.guitypes = objectArray;
            } else {
                Object[] objectArray;
                if (this.mscalc) {
                    Object[] objectArray6 = new Object[7];
                    objectArray6[0] = "accdon";
                    objectArray6[1] = "donsitecount";
                    objectArray6[2] = "donorcount";
                    objectArray6[3] = "msdon";
                    objectArray6[4] = "accsitecount";
                    objectArray6[5] = "acceptorcount";
                    objectArray = objectArray6;
                    objectArray6[6] = "msacc";
                } else {
                    Object[] objectArray7 = new Object[5];
                    objectArray7[0] = "accdon";
                    objectArray7[1] = "donsitecount";
                    objectArray7[2] = "donorcount";
                    objectArray7[3] = "accsitecount";
                    objectArray = objectArray7;
                    objectArray7[4] = "acceptorcount";
                }
                this.guitypes = objectArray;
            }
        }
        return this.guitypes;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.startsWith("ms") || typestr.endsWith("count")) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("acc") || typestr.equals("don") || typestr.equals("accdon")) {
            return this.getAtomCount();
        }
        return 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("msacc")) {
            return new double[][]{this.getpHs(), this.getMsAcceptorCounts()};
        }
        if (typestr.equals("msdon")) {
            return new double[][]{this.getpHs(), this.getMsDonorCounts()};
        }
        if (typestr.equals("accsitecount")) {
            return new Integer(this.getAcceptorCount());
        }
        if (typestr.equals("donsitecount")) {
            return new Integer(this.getDonorCount());
        }
        if (typestr.equals("acceptorcount")) {
            return new Integer(this.getAcceptorAtomCount());
        }
        if (typestr.equals("donorcount")) {
            return new Integer(this.getDonorAtomCount());
        }
        if (typestr.equals("acc")) {
            int a = this.getAcceptorCount(index);
            if (a == -1) {
                return NAN;
            }
            return new Integer(a);
        }
        if (typestr.equals("don")) {
            int d = this.getDonorCount(index);
            if (d == -1) {
                return NAN;
            }
            return new Integer(d);
        }
        if (typestr.equals("accdon")) {
            int a = this.getAcceptorCount(index);
            int d = this.getDonorCount(index);
            if (a == -1 && d == -1) {
                return NAN;
            }
            return new Integer(Math.max(a, d));
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Double) {
            return this.format((Double)result);
        }
        if (result instanceof Integer) {
            return String.valueOf((Integer)result);
        }
        if (result instanceof double[][]) {
            return this.format((double[][])result, 3);
        }
        throw new PluginException("Result is not a double[][] or a numerical object: " + result);
    }

    @Override
    public int getResultAsRGB(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.indexOf("acc") != -1) {
            return 0xFF0000;
        }
        return 255;
    }

    @Override
    public long getResultsAsRGB(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("accdon")) {
            if ((index = this.getAtomIndex(index)) == -1) {
                return 0L;
            }
            int acceptor = this.getAcceptorCount(index);
            int donor = this.getDonorCount(index);
            if (acceptor == 0 && donor == 0) {
                return 0L;
            }
            if (acceptor != 0 && donor != 0) {
                return acceptor > donor ? 0xFF00FF0000L : 0xFF0000000000FFL;
            }
            return acceptor != 0 ? 0xFF0000L : 255L;
        }
        return this.getResultAsRGB(type, index, result);
    }

    @Override
    public String getResultsAsString(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("accdon")) {
            if ((index = this.getAtomIndex(index)) == -1) {
                return "";
            }
            int acceptor = this.getAcceptorCount(index);
            int donor = this.getDonorCount(index);
            if (acceptor == 0 && donor == 0) {
                return "";
            }
            if (acceptor != 0 && donor != 0) {
                return acceptor > donor ? "A|D" : "D|A";
            }
            return acceptor != 0 ? ACCEPTOR_SIGN : DONOR_SIGN;
        }
        if (typestr.equals("acc") && result instanceof Integer) {
            int value = (Integer)result;
            return value == 0 ? "" : ACCEPTOR_SIGN;
        }
        if (typestr.equals("don") && result instanceof Integer) {
            int value = (Integer)result;
            return value == 0 ? "" : DONOR_SIGN;
        }
        return this.getResultAsString(type, index, result);
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("accsitecount")) {
            return "Acceptor sites";
        }
        if (typestr.equals("acceptorcount")) {
            return "Acceptor count";
        }
        if (typestr.equals("msacc")) {
            return "Acc";
        }
        if (typestr.equals("donsitecount")) {
            return "Donor sites";
        }
        if (typestr.equals("donorcount")) {
            return "Donor count";
        }
        if (typestr.equals("msdon")) {
            return "Don";
        }
        return "H bond donor/acceptor sites";
    }

    @Override
    public boolean isNegligibleResult(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (!typestr.startsWith("ms")) {
            return false;
        }
        if (!(result instanceof double[][])) {
            throw new PluginException("Result is not a double[][] object: " + result);
        }
        double[] c = ((double[][])result)[1];
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] >= 0.1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object result;
            Object type = this.types[t];
            if (this.getResultDomain(type) == 1) {
                for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                    result = this.getResult(type, i);
                    String label = this.getResultsAsString(type, i, result);
                    long rgbs = this.getResultsAsRGB(type, i, result);
                    mol.getAtom(i).setExtraLabel(label);
                    mol.getAtom(i).setExtraLabelColor(rgbs);
                }
                continue;
            }
            String typestr = type.toString().toLowerCase();
            if (typestr.startsWith("ms")) continue;
            result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol;
    }
}

