/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.HBDAPlugin;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.ResultView;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;

public class HBDAPluginDisplay
extends CalculatorPluginDisplay {
    @Override
    public synchronized void setPlugin(CalculatorPlugin plugin) {
        super.setPlugin(plugin);
        ((HBDAPlugin)plugin).setGUIMode(true);
    }

    @Override
    public boolean isMultipleDisplay() {
        return !((HBDAPlugin)this.getPlugin()).isMsCalc();
    }

    @Override
    public Component getResultComponent() throws PluginException {
        HBDAPlugin plugin = (HBDAPlugin)this.getPlugin();
        if (!plugin.isMsCalc()) {
            return super.getResultComponent();
        }
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        if (this.resultMolList.size() > 1) {
            throw new PluginException("HBDA cannot display microspecies data for more molecules.");
        }
        MolPanel mpan = this.parent instanceof MolPanel ? (MolPanel)this.parent : null;
        ResultView view = this.createResultView("H Bond Donor/Acceptor", mpan);
        Molecule mol = (Molecule)this.resultMolList.get(0);
        String text = this.appendpHText(this.getPropertyText(mol));
        view.setTopMolViewer(mol, text);
        view.setMenu();
        MarvinModule chart = (MarvinModule)MarvinModule.load("MChart", null);
        if (chart != null) {
            int mstypes = 0;
            Object[] types = plugin.getResultTypes();
            for (int i = 0; i < types.length; ++i) {
                if ("msacc".equalsIgnoreCase(types[i].toString())) {
                    mstypes |= 1;
                    continue;
                }
                if (!"msdon".equalsIgnoreCase(types[i].toString())) continue;
                mstypes |= 2;
            }
            String[] labels = this.getLabels(plugin.getpHs());
            Object values = null;
            String[] legendlabels = null;
            Color[] colors = null;
            String header = null;
            switch (mstypes) {
                case 3: {
                    values = new double[2][];
                    values[0] = plugin.getMsDonorCounts();
                    values[1] = plugin.getMsAcceptorCounts();
                    colors = new Color[]{Color.blue, Color.red};
                    legendlabels = new String[]{"Don", "Acc"};
                    header = "| pH| Don| Acc";
                    break;
                }
                case 2: {
                    values = new double[1][];
                    values[0] = plugin.getMsDonorCounts();
                    colors = new Color[]{Color.blue};
                    legendlabels = new String[]{"Don"};
                    header = "| pH| Don";
                    break;
                }
                case 1: {
                    values = new double[1][];
                    values[0] = plugin.getMsAcceptorCounts();
                    colors = new Color[]{Color.red};
                    legendlabels = new String[]{"Acc"};
                    header = "| pH| Acc";
                }
            }
            chart.modfunc(new Object[]{"setSeriesColors", colors});
            chart.modfunc(new Object[]{"setTitle", "H bond donor/acceptor sites"});
            chart.modfunc(new Object[]{"setSampleLabels", labels});
            chart.modfunc(new Object[]{"setSampleValues", values});
            chart.modfunc(new Object[]{"setRange", new double[]{0.0, Double.NEGATIVE_INFINITY}});
            chart.modfunc(new Object[]{"setLegendLabels", legendlabels});
            chart.modfunc(new Object[]{"setSampleHighlightOn", new Boolean(true)});
            view.setChart(chart);
            view.setBottomTextArea(this.getTableText(header, labels, (double[][])values));
        } else {
            System.err.println("Could not load chart.jar.");
        }
        view.build();
        return view;
    }
}

