/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;

public class HBDAPluginOutput
extends CalculatorPluginOutput {
    @Override
    public String getHeader() {
        Object[] types = this.plugin.getResultTypes();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            String typestr;
            if (i > 0) {
                s.append(this.separator);
            }
            if ((typestr = types[i].toString().toLowerCase()).startsWith("ms")) {
                double step = Double.parseDouble(this.params.getProperty("step"));
                double lower = Double.parseDouble(this.params.getProperty("lower"));
                double upper = Double.parseDouble(this.params.getProperty("upper"));
                int count = (int)Math.round((upper - lower) / step);
                double pH = lower;
                for (int j = 0; j <= count; ++j) {
                    if (j > 0) {
                        s.append(this.separator);
                    }
                    s.append("pH=" + this.plugin.format(pH));
                    pH += step;
                }
                continue;
            }
            s.append(typestr);
        }
        return new String(s);
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        Object[] types = this.plugin.getResultTypes();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            Object type;
            String typestr;
            if (i > 0) {
                s.append(this.separator);
            }
            if ((typestr = (type = types[i]).toString().toLowerCase()).startsWith("ms")) {
                double[] result = ((double[][])this.plugin.getResult(type, 0))[1];
                for (int j = 0; j < result.length; ++j) {
                    if (j > 0) {
                        s.append(this.separator);
                    }
                    s.append(this.plugin.format(result[j]));
                }
                continue;
            }
            s.append(this.getResults(type));
        }
        return new String(s);
    }
}

