/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Charge;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class IonChargePlugin
extends CalculatorPlugin {
    private static final int ACCUMULATED = 0;
    private static final int SINGLE = 1;
    private static final int DEF_MAXIONS = 8;
    private static final double DEF_PH = 7.0;
    private double pH = 7.0;
    private double distribution = -1.0;
    private Ionizer ionizer = null;
    private Charge charge = null;
    private int chgtype = 1;
    private Object[] types = new Object[]{"charge"};
    private double[][] ioncharges = null;

    public IonChargePlugin() {
        this.ionizer = new Ionizer();
        this.charge = new Charge();
    }

    @Override
    public String getProductName() {
        return "Charge Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String pHstr = params.getProperty("pH");
        if (pHstr == null || pHstr.length() == 0) {
            pHstr = params.getProperty("ph");
        }
        this.pH = pHstr != null && pHstr.length() > 0 ? Double.valueOf(pHstr) : 7.0;
        int maxions = 8;
        String maxionsStr = params.getProperty("max-ions");
        if (maxionsStr != null && maxionsStr.length() > 0 && (maxions = Integer.valueOf(maxionsStr).intValue()) < 0) {
            maxions = 0;
        }
        this.ionizer.setMaxIons(maxions);
        String distributionStr = params.getProperty("min-percent");
        if (distributionStr != null && distributionStr.length() > 0) {
            this.distribution = Double.valueOf(distributionStr);
            this.types[0] = "charges";
        } else {
            this.distribution = -1.0;
            this.types[0] = "charge";
        }
        String chgtypeStr = params.getProperty("charge-type");
        this.chgtype = chgtypeStr != null && chgtypeStr.toUpperCase().startsWith("ACC") ? 0 : 1;
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (IonChargePlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.ionizer.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.ionizer.calcMicroSpecies();
        this.ionizer.calcMsDistribution(this.pH);
        if (this.distribution >= 0.0) {
            int chargeCount;
            int count = this.ionizer.getMicroSpeciesCount();
            for (chargeCount = 0; chargeCount < count && !(this.ionizer.getSortedMsDistribution(chargeCount) < this.distribution); ++chargeCount) {
            }
            int atomCount = this.ionizer.getMolecule().getAtomCount();
            this.ioncharges = new double[atomCount][chargeCount];
            for (int i = 0; i < chargeCount; ++i) {
                this.charge.setMolecule(this.ionizer.getSortedMicroSpecies(i));
                this.charge.calcCharges();
                for (int j = 0; j < atomCount; ++j) {
                    this.ioncharges[j][i] = this.chgtype == 0 ? this.charge.getAccumulatedCharge(j) : this.charge.getTotalCharge(j);
                }
            }
        } else {
            this.charge.setMolecule(this.ionizer.getMainMicroSpecies());
            this.charge.calcCharges();
        }
        return !this.ionizer.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        String msg = "";
        if (this.ionizer.getIonOverflowStatus()) {
            msg = msg + "The number of ionizable atoms (" + this.ionizer.getMaxIonsCounter() + ") exceeds the specified limit (" + this.ionizer.getMaxIons() + ").";
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            if (msg.length() > 0) {
                msg = msg + "\n";
            }
            msg = msg + "Inconsistent molecular structure.";
        }
        return msg;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        return this.getAtomCount();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        index = this.getAtomIndex(index);
        if (this.distribution >= 0.0) {
            if (index != -1) {
                return this.ioncharges[index];
            }
            return new double[0];
        }
        if (index != -1) {
            if (this.chgtype == 0) {
                return new Double(this.charge.getAccumulatedCharge(index));
            }
            return new Double(this.charge.getTotalCharge(index));
        }
        return NAN;
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Double) {
            double x = (Double)result;
            return Double.isNaN(x) ? "" : this.format(x);
        }
        if (result instanceof double[]) {
            String str = "";
            double[] a = (double[])result;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    str = str + ",";
                }
                str = str + (Double.isNaN(a[i]) ? "" : this.format(a[i]));
            }
            return str;
        }
        throw new PluginException("Result is not a Double object or double array: " + result);
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        super.standardize(mol);
    }
}

