/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.calculations.IsoelectricPointPlugin;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.ResultView;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.util.ArrayList;

public class IsoelectricPointPluginDisplay
extends CalculatorPluginDisplay {
    private ArrayList chargeList = null;

    @Override
    public MProgressMonitor getProgressMonitor(Component parent) {
        return new MDialogProgressMonitor(parent, "Isoelectric point");
    }

    @Override
    public void pop() {
        super.pop();
        if (this.chargeList != null && this.chargeList.size() > 0) {
            this.chargeList.remove(this.chargeList.size() - 1);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.chargeList != null) {
            this.chargeList.clear();
        }
    }

    @Override
    public void store() throws PluginException {
        IsoelectricPointPlugin plugin = (IsoelectricPointPlugin)this.getPlugin();
        Molecule mol = plugin.getResultMolecule();
        if (mol != null) {
            if (this.resultMolList == null) {
                this.resultMolList = new ArrayList();
            }
            this.resultMolList.add(mol);
            if (this.chargeList == null) {
                this.chargeList = new ArrayList();
            }
            this.chargeList.add(plugin.getChargeDistribution());
        }
    }

    @Override
    public Component getResultComponent() throws PluginException {
        IsoelectricPointPlugin plugin = (IsoelectricPointPlugin)this.getPlugin();
        if (!plugin.isChargeCalc()) {
            return super.getResultComponent();
        }
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        MolPanel mpan = this.parent instanceof MolPanel ? (MolPanel)this.parent : null;
        ResultView view = this.createResultView("Isoelectric Point", mpan);
        int count = this.resultMolList.size();
        String header = "| pH";
        if (count == 1) {
            header = header + "| chg";
        } else {
            for (int i = 1; i <= count; ++i) {
                header = header + "|chg" + i;
            }
        }
        double[][] charges = new double[this.chargeList.size()][];
        this.chargeList.toArray((T[])charges);
        double[] pHs = plugin.getpHs();
        String[] pHlabels = this.getLabels(pHs);
        Molecule mol = (Molecule)this.resultMolList.get(0);
        String text = this.getPropertyText(mol);
        view.setTopMolViewer(mol, text);
        view.setBottomTextArea(this.getTableText(header, pHlabels, charges));
        view.setMenu();
        MarvinModule chart = (MarvinModule)MarvinModule.load("MChart", null);
        if (chart != null) {
            chart.modfunc(new Object[]{"setTitle", "Charge"});
            chart.modfunc(new Object[]{"setSampleLabels", pHlabels});
            chart.modfunc(new Object[]{"setSampleValues", charges});
            chart.modfunc(new Object[]{"setRange", new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}});
            if (count > 1) {
                Molecule[] legendmols = new Molecule[count];
                this.resultMolList.toArray(legendmols);
                chart.modfunc(new Object[]{"setLegendImages", legendmols});
                String[] legendtexts = new String[count];
                legendtexts[0] = text;
                for (int i = 1; i < count; ++i) {
                    legendtexts[i] = this.getPropertyText(legendmols[i]);
                }
                chart.modfunc(new Object[]{"setLegendTexts", legendtexts});
                chart.modfunc(new Object[]{"setSampleHighlightOn", new Boolean(false)});
            }
            view.setChart(chart);
        } else {
            System.err.println("Could not load chart.jar.");
        }
        view.build();
        return view;
    }
}

