/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public abstract class MajorMicrospeciesAccessorPlugin
extends CalculatorPlugin {
    private static final String[] LICENSE_NAMES = new String[]{"Protonation Plugin Group", "Charge Plugin Group", "HBDA Plugin", "Huckel Analysis Plugin", "Geometry Plugin Group"};
    private double pH = Double.NaN;
    protected Ionizer ionizer = new Ionizer();
    private PKaLargeModel proteinIonization = null;

    @Override
    public boolean isLicensed() {
        for (int i = 0; i < LICENSE_NAMES.length; ++i) {
            if (!LicenseHandler.getInstance().isLicensed(LICENSE_NAMES[i], this.licenseEnvironment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        boolean microspecies;
        this.pH = Double.NaN;
        boolean bl = microspecies = !"false".equalsIgnoreCase(params.getProperty("microspecies"));
        if (microspecies) {
            String pHstr = params.getProperty("pH");
            if (pHstr == null || pHstr.length() == 0) {
                pHstr = params.getProperty("ph");
            }
            if (pHstr != null && pHstr.length() > 0) {
                this.pH = Double.valueOf(pHstr);
            }
        }
    }

    public void setpH(double pH) {
        this.pH = pH;
    }

    @Override
    public double getpH() {
        return this.pH;
    }

    @Override
    protected final Molecule createModifiedInputMolecule(Molecule mol) {
        return this.getMajorMicroSpecies(mol);
    }

    private Molecule getMajorMicroSpecies(Molecule mol) {
        if (!Double.isNaN(this.pH)) {
            mol = this.ionizer.getMajorMicroSpecies(this.pH, mol);
            if (this.ionizer.getIonOverflowStatus()) {
                if (this.proteinIonization == null) {
                    this.proteinIonization = new PKaLargeModel();
                }
                mol = this.proteinIonization.getMajorMicroSpecies(this.pH, mol);
            }
        }
        return mol;
    }

    @Override
    public String getErrorMessage() {
        return this.ionizer.getCriticalErrorFlag() ? "Inconsistent molecular structure." : "";
    }

    public String getIonizerErrorMessage() {
        String msg = "";
        if (this.ionizer.getIonOverflowStatus()) {
            msg = msg + "The number of ionizable atoms (" + this.ionizer.getMaxIonsCounter() + ") exceeds the specified limit (" + this.ionizer.getMaxIons() + ").";
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            if (msg.length() > 0) {
                msg = msg + "\n";
            }
            msg = msg + "Inconsistent molecular structure.";
        }
        return msg;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (MajorMicrospeciesAccessorPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        if (!Double.isNaN(this.pH)) {
            mol.implicitizeHydrogens(2047);
        }
        MajorMicrospeciesAccessorPlugin.standardizeIonicGroups(mol);
        mol.dearomatize();
        mol.aromatize(1);
    }
}

