/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.MolFilter;
import chemaxon.util.StringUtil;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkushEnumerationPlugin
extends CalculatorPlugin {
    private static final String WARNING = "The number of enumerated structures >=  2^63\n(arithmetical overflow, only 100 000 will be generated)";
    private static final int COUNT = 0;
    private static final int ENUMERATE = 1;
    private static final int RANDOM = 2;
    private static final int SMALL = 0;
    private static final int LARGE = 1;
    private static final int MAGNITUDE = 2;
    private static final int STRING = 3;
    public static final MolFilter FILTER_VALENCE = MarkushEnumeratorFactory.FILTER_VALENCE;
    public static final int COLORING_NONE = 0;
    public static final int COLORING_SCAFFOLD = 1;
    public static final int COLORING_RGROUPS = 2;
    public static final int COLORING_ALL = 3;
    private MarkushEnumeratorFactory factory = new MarkushEnumeratorFactory();
    private ExpansionCounter counter = new ExpansionCounter();
    private MolEnumerator molEnum = null;
    private MolFilter filter = null;
    private int[] enumIndexes = null;
    private long maxStructureCount = -1L;
    private long structureCount = 0L;
    private int limitedStructureCount = 0;
    private int countMode = 0;
    private int calctype = 1;
    private boolean enumHomology = true;
    private Molecule[] structures = null;
    private boolean hasSelectedAtoms = false;
    private boolean enumCodeNeeded = false;
    private String structureID = null;
    private boolean alignScaffold = false;
    private int coloring = 0;
    private static String[] TYPE_RANGE = new String[]{"structures", "count", "allcount"};
    private Object[] types = new Object[]{"structures"};
    private int currentCount = 0;

    @Override
    public boolean isLicensed() {
        return this.counter.isLicensed() && (this.molEnum == null || this.molEnum.isLicensed());
    }

    @Override
    public void setLicenseEnvironment(String env) {
        super.setLicenseEnvironment(env);
        this.counter.setLicenseEnvironment(env);
        if (this.molEnum != null) {
            this.molEnum.setLicenseEnvironment(env);
        }
    }

    @Override
    public String getProductName() {
        return "Markush Enumeration Plugin";
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        this.types = new Object[]{"structures"};
        if ("countonly".equals(params.getProperty("calctype"))) {
            this.calctype = 0;
            this.types[0] = "count";
            String mode = params.getProperty("mode");
            this.countMode = 0;
            if ("large".equalsIgnoreCase(mode)) {
                this.countMode = 1;
            } else if ("magnitude".equalsIgnoreCase(mode)) {
                this.countMode = 2;
            } else if ("string".equalsIgnoreCase(mode)) {
                this.countMode = 3;
            }
        } else {
            String coloringStr;
            String chtypes = params.getProperty("type");
            if (chtypes != null) {
                StringTokenizer st = new StringTokenizer(chtypes, ",");
                this.types = new Object[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    this.checkType(token, TYPE_RANGE);
                    this.types[i++] = token;
                }
            }
            this.calctype = "random".equals(params.getProperty("calctype")) || "true".equalsIgnoreCase(params.getProperty("random")) ? 2 : 1;
            long max = -1L;
            switch (this.calctype) {
                case 1: {
                    max = Long.parseLong(params.getProperty("max", "-1"));
                    break;
                }
                case 2: {
                    max = Long.parseLong(params.getProperty("num", "-1"));
                    if (max != -1L) break;
                    max = Long.parseLong(params.getProperty("max", "1"));
                }
            }
            this.setMaxStructureCount(max);
            this.setEnumCodeNeeded("true".equalsIgnoreCase(params.getProperty("code")));
            String structureID = params.getProperty("structureid");
            if (structureID == null) {
                structureID = params.getProperty("structureID");
            }
            this.setStructureID(structureID);
            int coloring = 0;
            if ("true".equalsIgnoreCase(params.getProperty("scaffold"))) {
                coloring |= 1;
            }
            if ("true".equalsIgnoreCase(params.getProperty("rgroups"))) {
                coloring |= 2;
            }
            if ((coloringStr = params.getProperty("coloring")) != null) {
                if ("none".equals(coloringStr = coloringStr.toLowerCase())) {
                    coloring = 0;
                } else if ("all".equals(coloringStr)) {
                    coloring = 3;
                } else {
                    if (coloringStr.indexOf("scaffold") >= 0) {
                        coloring |= 1;
                    }
                    if (coloringStr.indexOf("rgroups") >= 0) {
                        coloring |= 2;
                    }
                }
            }
            this.setColoring(coloring);
            this.setAlignScaffold("true".equalsIgnoreCase(params.getProperty("alignscaffold")));
        }
        this.setEnumerateHomology("true".equalsIgnoreCase(params.getProperty("enumhomology")));
        boolean valenceCheck = "true".equalsIgnoreCase(params.getProperty("valencecheck"));
        this.setFilter(valenceCheck ? FILTER_VALENCE : null);
        this.setAtomIndexes(params.getProperty("atoms"));
    }

    public void setRandomEnumeration() {
        this.calctype = 2;
    }

    public boolean isRandomEnumeration() {
        return this.calctype == 2;
    }

    public void setEnumerateHomology(boolean enumerate) {
        this.enumHomology = enumerate;
    }

    public boolean isHomologyEnumerated() {
        return this.enumHomology;
    }

    public void setEnumCodeNeeded(boolean value) {
        this.enumCodeNeeded = value;
    }

    public boolean getEnumCodeNeeded() {
        return this.enumCodeNeeded;
    }

    public void setStructureID(String id) {
        this.structureID = id;
        if (id != null) {
            this.setEnumCodeNeeded(true);
        }
    }

    public String getStructureID() {
        return this.structureID;
    }

    public void setFilter(MolFilter filter) {
        this.filter = filter;
    }

    protected boolean isFiltered() {
        return this.filter != null;
    }

    public boolean isApproximateCount() {
        return this.counter.isApproximateCount();
    }

    private void setAtomIndexes(String atoms) throws PluginException {
        if (atoms == null) {
            this.enumIndexes = null;
            return;
        }
        try {
            this.enumIndexes = StringUtil.parseInts(atoms);
            int i = 0;
            while (i < this.enumIndexes.length) {
                int n = i++;
                this.enumIndexes[n] = this.enumIndexes[n] - 1;
                if (this.enumIndexes[n] >= 0) continue;
                throw new PluginException("Atoms are not set properly.");
            }
        }
        catch (NumberFormatException e) {
            throw new PluginException("Atoms are not set properly.");
        }
    }

    public void setMaxStructureCount(long max) {
        this.maxStructureCount = max;
    }

    public void setAlignScaffold(boolean value) {
        this.alignScaffold = value;
    }

    public boolean getAlignScaffold() {
        return this.alignScaffold;
    }

    public void setColoring(int coloring) {
        this.coloring = coloring;
    }

    public int getColoring() {
        return this.coloring;
    }

    protected boolean isCleanNeeded() {
        return !this.alignScaffold && this.coloring == 0;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        int[] indexes;
        this.hasSelectedAtoms = false;
        int[] nArray = indexes = this.enumIndexes == null ? this.getSelectedUnionAtomIndexes(mol) : this.enumIndexes;
        if (this.calctype != 0) {
            this.factory.setFilter(this.filter);
            this.factory.setRandom(this.calctype == 2);
            this.factory.setAlignScaffold(this.alignScaffold);
            this.factory.setColoring(this.coloring);
            this.factory.setEnumCodeNeeded(this.enumCodeNeeded);
            this.factory.setStructureID(this.structureID);
            this.factory.setEnumerateHomology(this.enumHomology);
            try {
                this.molEnum = this.factory.createEnumerator(mol, indexes);
            }
            catch (IllegalArgumentException e) {
                throw new PluginException(e);
            }
            this.molEnum.setLicenseEnvironment(this.licenseEnvironment);
        }
        this.counter.setEnumerateHomology(this.enumHomology);
        this.counter.setMolecule(mol, indexes);
    }

    private int[] getSelectedUnionAtomIndexes(Molecule mol) {
        int count = 0;
        MoleculeGraph union = mol.getGraphUnion();
        int n = union.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!union.getAtom(i).isSelected()) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        this.hasSelectedAtoms = true;
        int[] indexes = new int[count];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (!union.getAtom(i).isSelected()) continue;
            if (this.calctype != 0) {
                union.getAtom(i).setSelected(false);
            }
            indexes[k++] = i;
        }
        return indexes;
    }

    @Override
    public boolean run() throws PluginException {
        this.structures = null;
        try {
            this.structureCount = this.counter.countExpansions();
        }
        catch (ExpansionCounter.ArithmeticOverflowException e) {
            this.structureCount = -1L;
        }
        catch (IllegalArgumentException e) {
            throw new PluginException(e);
        }
        catch (ExpansionException e) {
            throw new PluginException(e);
        }
        if (this.calctype == 2) {
            if (this.maxStructureCount == -1L) {
                this.maxStructureCount = 1L;
            }
            this.structureCount = this.maxStructureCount;
        }
        this.setLimitedStructureCount();
        this.currentCount = 0;
        return true;
    }

    public BigInteger countEnumerations() throws PluginException {
        try {
            return this.counter.countExpansionsLarge();
        }
        catch (ExpansionException e) {
            throw new PluginException(e);
        }
    }

    public int countEnumerationsMagnitude() throws PluginException {
        try {
            return this.counter.countExpansionsMagnitude();
        }
        catch (ExpansionException e) {
            throw new PluginException(e);
        }
    }

    public long getStructureCount() {
        return this.structureCount;
    }

    public int getLimitedStructureCount() {
        return this.limitedStructureCount;
    }

    private void setLimitedStructureCount() {
        long count = this.structureCount == -1L || this.maxStructureCount != -1L && this.structureCount > this.maxStructureCount ? this.maxStructureCount : this.structureCount;
        int n = this.limitedStructureCount = count < Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
        if (this.molEnum != null) {
            this.molEnum.setNumberOfRandomEnumeratesToGenerate(this.getEnumStructureCount());
        }
    }

    private int getEnumStructureCount() {
        return this.limitedStructureCount != -1 ? this.limitedStructureCount : Integer.MAX_VALUE;
    }

    public boolean hasMoreStructures() {
        return this.currentCount < this.getEnumStructureCount() && this.molEnum.hasMoreElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Molecule getNextStructure() {
        if (this.hasMoreStructures()) {
            try {
                Molecule molecule = this.molEnum.nextElement();
                return molecule;
            }
            finally {
                if (!this.isRandomEnumeration() && this.limitedStructureCount != -1) {
                    ++this.currentCount;
                }
            }
        }
        return null;
    }

    public Molecule getNextAromatizedStructure() {
        Molecule mol = this.getNextStructure();
        if (mol != null) {
            mol.aromatize();
        }
        return mol;
    }

    public Molecule[] getStructures() throws PluginException {
        int count;
        if (this.maxStructureCount == -1L && (this.structureCount == -1L || this.structureCount > Integer.MAX_VALUE)) {
            throw new PluginException("Too many structures: call setMaxStructureCount(long) to set the number of strucutres to be returned");
        }
        int n = count = this.maxStructureCount == -1L ? (int)this.structureCount : this.limitedStructureCount;
        if (this.structures == null) {
            this.structures = new Molecule[count];
            for (int i = 0; i < this.structures.length; ++i) {
                this.structures[i] = this.getNextStructure();
            }
        }
        return this.structures;
    }

    public Molecule[] getAromatizedStructures() throws PluginException {
        Molecule[] mols = this.getStructures();
        Molecule[] amols = new Molecule[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            amols[i] = mols[i].cloneMolecule();
            amols[i].aromatize();
        }
        return amols;
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new ResultSource(new ResultIterator(this.molEnum), this.limitedStructureCount, this.enumCodeNeeded);
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structures") ? this.getLimitedStructureCount() : 1;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("count")) {
            return "Markush library size";
        }
        return type.toString();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            switch (this.countMode) {
                default: {
                    return new Long(this.getStructureCount());
                }
                case 1: {
                    return this.countEnumerations();
                }
                case 2: {
                    return new Integer(this.countEnumerationsMagnitude());
                }
                case 3: 
            }
            return this.getLibrarySizeString();
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        this.setAtomIndexes(arg);
        this.setMolecule(this.getCalcMolecule());
        this.run();
        return this.getResult(type, 0);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("smarts");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("smarts"));
            }
            return new String(buffer);
        }
        if (result instanceof Number) {
            return result.toString();
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new PluginException("Result should be a molecule or integer object\ninstead of: " + result);
    }

    @Override
    public String getRemark() {
        if (this.calctype == 0) {
            return null;
        }
        return this.getStructureCount() == -1L && this.getLimitedStructureCount() == -1 ? WARNING : null;
    }

    public String getLibrarySizeString() throws PluginException {
        if (this.calctype == 2) {
            return null;
        }
        long count = this.getStructureCount();
        int m = this.countEnumerationsMagnitude();
        String approx = "~ 10^" + m;
        return count == -1L ? approx : String.valueOf(count) + (m > 5 ? " (" + approx + ")" : "");
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        String libSize = (this.isApproximateCount() ? "~ " : "") + this.getLibrarySizeString();
        if (this.hasSelectedAtoms) {
            mol.setProperty("Markush library size for selected generic features", libSize);
        } else {
            mol.setProperty("Markush library size", libSize);
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
    }

    private class ResultSource
    extends PluginMDocSource {
        private boolean codeNeeded;

        public ResultSource(Iterator iterator, int maxCount, boolean codeNeeded) {
            super(iterator, maxCount);
            this.codeNeeded = false;
            this.codeNeeded = codeNeeded;
        }

        @Override
        public String getDocLabel(int k, MDocument doc) {
            String label = super.getDocLabel(k, doc);
            if (this.codeNeeded) {
                label = label + "    " + ((Molecule)doc.getMainMoleculeGraph()).getProperty("Markush code");
            }
            return label;
        }
    }

    private class ResultIterator
    implements Iterator {
        private MolEnumerator enumerator = null;

        public ResultIterator(MolEnumerator enumerator) {
            this.enumerator = enumerator;
        }

        @Override
        public boolean hasNext() {
            return this.enumerator.hasMoreElements();
        }

        public Object next() {
            return this.hasNext() ? CalculatorPlugin.getDocument(this.enumerator.nextElement()) : null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

