/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.MarkushEnumerationPlugin;
import chemaxon.marvin.calculations.MultipleMoleculeDisplay;
import chemaxon.marvin.plugin.PluginException;
import java.util.Properties;

public class MarkushEnumerationPluginDisplay
extends MultipleMoleculeDisplay {
    private boolean fusedMultipleMoleculeDisplay;

    @Override
    public void setParameters(Properties params) {
        this.fusedMultipleMoleculeDisplay = "true".equalsIgnoreCase(params.getProperty("fusedmultiplemoleculedisplay"));
    }

    @Override
    protected boolean isDefaultDisplay() {
        return "count".equals(this.getPlugin().getResultTypes()[0]);
    }

    @Override
    protected boolean isFusedMultipleMoleculeDisplay() {
        return this.fusedMultipleMoleculeDisplay;
    }

    @Override
    protected boolean isCleanNeeded() {
        return ((MarkushEnumerationPlugin)this.getPlugin()).isCleanNeeded();
    }

    @Override
    protected String getCleaningOptions() {
        return "t2000";
    }

    @Override
    public String getTitle() {
        if (this.isDefaultDisplay()) {
            return super.getTitle();
        }
        try {
            MarkushEnumerationPlugin plugin = (MarkushEnumerationPlugin)this.getPlugin();
            String librarySize = plugin.getLibrarySizeString();
            if (librarySize != null) {
                long count = plugin.getStructureCount();
                long countMax = this.getLimitedResultSource().getRecordCountMax();
                if (count != -1L && count < countMax) {
                    countMax = count;
                }
                return super.getTitle() + ": " + (plugin.isFiltered() ? "max. " : (plugin.isApproximateCount() ? "~" : "")) + countMax + " out of " + (plugin.isApproximateCount() ? "~" : "") + librarySize + " structures";
            }
            return super.getTitle() + ": " + this.getLimitedResultSource().getRecordCountMax() + " random structures";
        }
        catch (PluginException e) {
            return super.getTitle();
        }
    }

    @Override
    protected long getMaxCount() throws PluginException {
        return ((MarkushEnumerationPlugin)this.getPlugin()).getLimitedStructureCount();
    }
}

