/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MolecularDynamics;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class MolecularDynamicsPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"structure", "structures", "count"};
    private Object[] types = new Object[]{"structure"};
    private MolecularDynamics md = new MolecularDynamics();
    private ArrayList framesList = null;
    private boolean firstStep = true;
    private int currentFrameNumber = 0;
    private int totalFrameNumber = 0;
    private double samplingStartTime = 0.0;
    private double samplingInterval = 10.0;
    private int stepNumber = 1000;
    private MProgressMonitor progressMonitor = null;

    public void setForceField(String forcefield) {
        this.md.setForceField(forcefield);
    }

    public void setIntegrator(String integrator) {
        this.md.setIntegrator(integrator);
    }

    public void setStepNumber(int stepno) {
        this.stepNumber = stepno;
        this.md.setStepNo(stepno);
    }

    public void setStepTime(double timestep) {
        this.md.setTimeStep(Double.toString(timestep));
    }

    public void setInitialTemperature(double temperature) {
        this.md.setTemperature(temperature);
    }

    public void setSamplingStart(double sampstart) {
        this.samplingStartTime = sampstart;
    }

    public void setSamplingInterval(double sampinterval) {
        this.samplingInterval = sampinterval;
    }

    public void setCenterMolecule(boolean centerMolecule) {
        this.md.setCenterMolecule(centerMolecule);
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    @Override
    public String getProductName() {
        return "Conformation Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        this.setCenterMolecule(true);
        this.setForceField(params.getProperty("forcefield", "dreiding"));
        this.setIntegrator(params.getProperty("integrator", "velocityverlet"));
        this.setStepNumber(Integer.valueOf(params.getProperty("stepno", "1000")));
        this.setStepTime(Double.valueOf(params.getProperty("steptime", "0.1")));
        this.setSamplingStart(Double.valueOf(params.getProperty("savestart", "0")));
        this.setSamplingInterval(Double.valueOf(params.getProperty("samplinginterval", "10")));
        this.setInitialTemperature(Double.valueOf(params.getProperty("temperature", "300")));
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return false;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (MolecularDynamicsPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        if (mol.getDim() < 3) {
            mol.clean(3, "c3[prehydrogenize]");
        }
        try {
            this.md.setInputMolecule(mol);
        }
        catch (MDException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        try {
            this.md.InitMD();
            this.firstStep = true;
            this.currentFrameNumber = 0;
            this.framesList = null;
            this.totalFrameNumber = (int)Math.ceil(((double)this.stepNumber * this.md.getTimeStep() - this.samplingStartTime) / this.samplingInterval);
            if (this.progressMonitor != null) {
                this.progressMonitor.initProgressMonitor("Calculating trajectories", 0, this.totalFrameNumber);
            }
            this.framesList = new ArrayList();
            Molecule nextStepMol = null;
            while (this.md.getElapsedTime() <= this.samplingStartTime) {
                nextStepMol = this.md.NextStep();
            }
            this.framesList.add(nextStepMol.cloneMolecule());
            ++this.currentFrameNumber;
            return true;
        }
        catch (MDException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new ResultSource(new ResultIterator(), this.getStructureCount());
    }

    public int getStructureCount() {
        return this.totalFrameNumber;
    }

    private Molecule getNextStructure() throws PluginException {
        try {
            if (this.firstStep && this.framesList != null) {
                this.firstStep = false;
                return (Molecule)this.framesList.get(0);
            }
            Molecule nextStepMol = null;
            while (this.md.getCurrentStepNo() < (double)this.stepNumber && this.md.getElapsedTime() < (double)this.currentFrameNumber * this.samplingInterval) {
                nextStepMol = this.md.NextStep();
            }
            if (nextStepMol == null) {
                nextStepMol = this.md.NextStep();
            }
            nextStepMol = nextStepMol.cloneMolecule();
            this.framesList.add(nextStepMol);
            ++this.currentFrameNumber;
            if (this.progressMonitor != null) {
                this.progressMonitor.setProgressValue(this.currentFrameNumber);
            }
            return nextStepMol;
        }
        catch (MDException e) {
            throw new PluginException(e);
        }
    }

    private boolean hasNextStructure() {
        return this.currentFrameNumber < this.totalFrameNumber;
    }

    private int getCurrentFrameNumber() {
        return this.currentFrameNumber;
    }

    public Molecule getStructure(int index) throws PluginException {
        while (this.getCurrentFrameNumber() <= index) {
            this.getNextStructure();
        }
        return (Molecule)this.framesList.get(index);
    }

    public Molecule[] getStructures() throws PluginException {
        while (this.getCurrentFrameNumber() < this.getStructureCount()) {
            this.getNextStructure();
        }
        Molecule[] frames = new Molecule[this.getStructureCount()];
        this.framesList.toArray(frames);
        return frames;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structure") ? this.getStructureCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structure")) {
            return this.getStructure(index);
        }
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            return new Integer(this.getStructureCount());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("sdf:-a");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("sdf:-a"));
            }
            return new String(buffer);
        }
        if (result instanceof Integer) {
            return result.toString();
        }
        throw new PluginException("Unknown result: " + result);
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
    }

    private static class ResultSource
    extends PluginMDocSource {
        public ResultSource(Iterator iterator, int maxCount) {
            super(iterator, maxCount);
        }

        @Override
        public String getDocLabel(int k, MDocument doc) {
            Molecule mol = (Molecule)doc.getMainMoleculeGraph();
            return "Frame: " + String.valueOf(k + 1) + "  Energy: " + Math.rint(Double.parseDouble(mol.getProperty("Energy")) * 100.0) / 100.0 + " kcal/mol " + mol.getComment();
        }
    }

    private class ResultIterator
    implements Iterator {
        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return MolecularDynamicsPlugin.this.hasNextStructure();
        }

        public Object next() {
            try {
                return this.hasNext() ? CalculatorPlugin.getDocument(MolecularDynamicsPlugin.this.getNextStructure()) : null;
            }
            catch (PluginException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

