/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.io.CleanedMDocSource;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolFragLoader;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.IntRange;
import java.awt.Component;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class MultipleMoleculeDisplay
extends CalculatorPluginDisplay {
    private static final int LIMIT = 100000;
    private static final int FUSED_LIMIT = 100;
    private static final int CELLSIZE = 200;
    private static final int FUSED_CELLSIZE = 400;
    private static final String NO_RESULT_MOLECULES_REMARK = "No result molecules were generated.";
    private boolean noResultMolecules = false;
    private PluginMDocSource docSource = null;
    private long maxCount = -1L;

    protected String getWarning() throws PluginException {
        long n = this.getMaxCount();
        if (n > (long)this.getLimit()) {
            return "The number of structures (" + n + ") exceeds " + this.getLimit() + "." + "\nThe display will show the first " + this.getLimit() + " structures only." + "\nUse batch processing to generate all structures.";
        }
        return null;
    }

    protected long getMaxCount() throws PluginException {
        return this.maxCount != -1L ? this.maxCount : (long)this.getPlugin().getResultSource().getRecordCountMax();
    }

    @Override
    public String getRemark() throws PluginException {
        String remark = this.noResultMolecules ? NO_RESULT_MOLECULES_REMARK : null;
        remark = MultipleMoleculeDisplay.concatMessages(remark, super.getRemark(), "\n\n");
        if (this.isDefaultDisplay()) {
            return remark;
        }
        remark = MultipleMoleculeDisplay.concatMessages(remark, this.getWarning(), "\n\n");
        return remark;
    }

    private static String concatMessages(String m1, String m2, String separator) {
        if (m1 != null && m2 != null) {
            return m1.concat(separator).concat(m2);
        }
        if (m1 != null) {
            return m1;
        }
        if (m2 != null) {
            return m2;
        }
        return null;
    }

    private static Molecule[] getMols(MDocSource ds) throws PluginException {
        ArrayList<MoleculeGraph> list = new ArrayList<MoleculeGraph>();
        MDocument doc = null;
        try {
            while ((doc = ds.nextDoc()) != null) {
                list.add(doc.getMainMoleculeGraph());
            }
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        Molecule[] mols = new Molecule[list.size()];
        list.toArray(mols);
        return mols;
    }

    @Override
    public boolean isMultipleDisplay() {
        return false;
    }

    protected boolean isDefaultDisplay() {
        return false;
    }

    protected boolean isFusedMultipleMoleculeDisplay() {
        return false;
    }

    protected MolFragLoader getMolFragLoader() {
        return new MolFragLoader();
    }

    protected boolean isCleanNeeded() {
        return false;
    }

    protected String getCleaningOptions() {
        return null;
    }

    protected boolean isAnimated() {
        return false;
    }

    protected int getViewDim() {
        return this.getPlugin().getInputMolDim();
    }

    protected boolean isSelectable() {
        return !this.isAnimated();
    }

    protected int getLimit() {
        return this.isFusedMultipleMoleculeDisplay() ? 100 : 100000;
    }

    protected int getCellSize() {
        return this.isFusedMultipleMoleculeDisplay() ? 400 : 200;
    }

    @Override
    public void store() throws PluginException {
        if (this.isDefaultDisplay()) {
            super.store();
        }
        this.docSource = null;
        this.maxCount = -1L;
    }

    @Override
    public void pop() {
        if (this.isDefaultDisplay()) {
            super.pop();
        }
    }

    @Override
    public void clear() {
        if (this.isDefaultDisplay()) {
            super.clear();
        }
    }

    protected PluginMDocSource getLimitedResultSource() throws PluginException {
        if (this.docSource != null) {
            return this.docSource;
        }
        this.docSource = this.getPlugin().getResultSource();
        this.maxCount = this.docSource.getRecordCountMax();
        this.docSource.limitRecordCount(this.getLimit());
        return this.docSource;
    }

    @Override
    public Component getResultComponent() throws PluginException {
        if (this.isDefaultDisplay()) {
            return super.getResultComponent();
        }
        MDocSource ds = this.getLimitedResultSource();
        if (this.isCleanNeeded() && !this.isFusedMultipleMoleculeDisplay()) {
            ds = new CleanedMDocSource(ds, this.getViewDim(), this.getCleaningOptions());
        } else if (this.isFusedMultipleMoleculeDisplay()) {
            ds = new FusedMDocSource(ds, this.getMolFragLoader());
        }
        MolPanel mpan = this.parent instanceof MolPanel ? (MolPanel)this.parent : null;
        try {
            CallbackIface view = (CallbackIface)MarvinModule.load("view.swing.MolsView", mpan);
            view.callback("setSize", new Integer(this.getCellSize()));
            view.callback("setVisibleRows", new Integer(2));
            view.callback("setCols", new Integer(2));
            view.callback("setDim", new Integer(this.getViewDim()));
            if (this.isAnimated()) {
                view.callback("setM", MultipleMoleculeDisplay.getMols(ds));
                view.callback("setCols", new Integer(1));
            } else {
                view.callback("setCells", ds.getRecordCountMax());
            }
            ViewPanel vpan = (ViewPanel)view.callback("createViewPanel", null);
            vpan.setDebug(mpan.getDebug());
            boolean bl = this.noResultMolecules = vpan == null;
            if (mpan != null) {
                CallbackIface frame = this.createMolsFrame();
                frame.callback("setParent", mpan);
                frame.callback("setTitle", this.getTitle());
                frame.callback("setSize", new Integer(this.getCellSize()));
                if (this.isSelectable()) {
                    frame.callback("setSelectButton", "Select");
                }
                frame.callback("setSourceCell", new Integer(this.icell));
                frame.callback("setViewPanel", vpan);
                frame.callback("setDocSource", ds);
                frame.callback("build", null);
                return (Component)((Object)frame);
            }
            return vpan;
        }
        catch (SecurityException sex) {
            if (mpan != null) {
                mpan.getErrorDisplay().firewallError(sex, null);
                return null;
            }
            throw new PluginException(sex);
        }
    }

    private static class FusedMDocSource
    extends MDocSource {
        private MolFragLoader mfl;
        private MDocument nextDoc;

        public FusedMDocSource(MDocSource mds, MolFragLoader mfl) {
            this.mfl = mfl;
            mfl.setRange(new IntRange("-" + Integer.toString(100)));
            mfl.setIterator(mds.getMoleculeIterator());
        }

        @Override
        public int estimateNumRecords() {
            return 1;
        }

        @Override
        public int getRecordCount() {
            return this.nextDoc == null ? 0 : 1;
        }

        @Override
        public int getRecordCountMax() {
            return 1;
        }

        @Override
        public boolean isEndReached() {
            return this.nextDoc != null;
        }

        @Override
        public boolean isRewindable() {
            return false;
        }

        @Override
        public MDocument nextDoc() throws IOException {
            if (this.nextDoc == null) {
                this.nextDoc = new MDocument(this.mfl.loadFrags());
            }
            return this.nextDoc;
        }

        @Override
        public void seekRecord(int k, MProgressMonitor pmon) throws EOFException, IOException {
        }

        @Override
        protected void seekVisitedRecord(int k) throws IOException {
        }

        @Override
        public boolean skipRecord() throws IOException {
            return this.nextDoc == null;
        }
    }
}

