/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Charge;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class OrbitalElectronegativityPlugin
extends MajorMicrospeciesAccessorPlugin {
    private static String[] TYPE_RANGE = new String[]{"sigma", "pi"};
    private Charge oen = null;
    private Object[] types = new Object[]{"sigma"};
    private boolean resonance = false;

    public OrbitalElectronegativityPlugin() {
        this.oen = new Charge();
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Charge Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                token = OrbitalElectronegativityPlugin.removeWhitespace(token);
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        this.resonance = "true".equalsIgnoreCase(params.getProperty("resonance"));
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    public void setTakeResonantStructures(boolean resonance) {
        this.resonance = resonance;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.oen.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.resonance) {
            this.oen.calcMajorResonanceCharge();
        } else {
            this.oen.calcCharges();
        }
        return !this.oen.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.oen.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public double getSigmaOEN(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.oen.getSigmaOEN(index);
    }

    public double getPiOEN(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.oen.getPiOEN(index);
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        return this.getAtomCount();
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("sigma")) {
            return "Sigma orbital electronegativity";
        }
        if (typestr.equals("pi")) {
            return "Pi orbital electronegativity";
        }
        return type.toString();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("sigma")) {
            return new Double(this.getSigmaOEN(index));
        }
        if (typestr.equals("pi")) {
            return new Double(this.getPiOEN(index));
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        String str = Double.isNaN(x) ? "" : this.format(x);
        index = this.getAtomIndex(index);
        return str;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        Object type = this.types[0];
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            Object result = this.getResult(type, i);
            String label = this.getResultAsString(type, i, result);
            mol.getAtom(i).setExtraLabel(label);
        }
        return mol;
    }
}

