/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.AtomPolarizability;
import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.MolPolarizability;
import chemaxon.calculations.TholePolarizability;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class PolarizabilityPlugin
extends MajorMicrospeciesAccessorPlugin {
    private TholePolarizability tpol = null;
    private AtomPolarizability atomPolarizability = null;
    private boolean geom3D = false;
    private static String[] TYPE_RANGE = new String[]{"molecular", "atomic", "a(xx)", "a(yy)", "a(zz)"};
    private Object[] types = new Object[]{"atomic", "molecular"};
    private boolean criticalError = false;

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Charge Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.geom3D = "true".equalsIgnoreCase(params.getProperty("geom3D")) || "true".equalsIgnoreCase(params.getProperty("geom3d"));
        String chtypes = params.getProperty("type");
        if (params.getProperty("thole") != null && params.getProperty("thole").equalsIgnoreCase("true")) {
            chtypes = "molecular,a(xx),a(yy),a(zz)";
            this.geom3D = true;
        }
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toLowerCase();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    public void setGeom3D(boolean geom3D) {
        this.geom3D = geom3D;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (PolarizabilityPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        if (this.geom3D) {
            if (this.tpol == null) {
                this.tpol = new TholePolarizability();
            }
            this.tpol.setMolecule(mol);
        } else {
            this.atomPolarizability = new AtomPolarizability(mol);
        }
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.geom3D) {
            this.tpol.calcPolTensor();
            return !this.tpol.getCriticalErrorFlag();
        }
        this.criticalError = CriticalErrorCalculation.calculate(this.atomPolarizability.getMolecule());
        return !this.criticalError;
    }

    @Override
    public String getErrorMessage() {
        if (this.geom3D ? this.tpol.getCriticalErrorFlag() : this.criticalError) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public double getPolarizability(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.atomPolarizability.calculate(index);
    }

    public double getHPolarizability(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        Molecule mol = this.atomPolarizability.getMolecule();
        int hcount = mol.getAtom(index).getImplicitHcount();
        if (hcount == 0) {
            return 0.0;
        }
        return (double)hcount * this.atomPolarizability.calculate(mol.getAtomCount());
    }

    public double getMolPolarizability() {
        return this.geom3D ? this.tpol.getAveragePolComp() : MolPolarizability.calculate(this.atomPolarizability).doubleValue();
    }

    public double getAveragePolarizabilityComponent() {
        return this.tpol.getAveragePolComp();
    }

    public double[] getPrincipalPolarizabilityComponents() {
        return this.tpol.getPrincipalPolComp();
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString().toLowerCase();
        return typestr.equals("atomic") ? 1 : 2;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString().toLowerCase();
        return typestr.equals("atomic") ? this.getAtomCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("atomic")) {
            return new Double(this.getPolarizability(index));
        }
        if (typestr.equals("implh")) {
            return new Double(this.getHPolarizability(index));
        }
        if (typestr.equals("molecular")) {
            return new Double(this.getMolPolarizability());
        }
        if (typestr.equals("a(xx)")) {
            return new Double(this.getPrincipalPolarizabilityComponents()[0]);
        }
        if (typestr.equals("a(yy)")) {
            return new Double(this.getPrincipalPolarizabilityComponents()[1]);
        }
        if (typestr.equals("a(zz)")) {
            return new Double(this.getPrincipalPolarizabilityComponents()[2]);
        }
        throw new PluginException("Invalid type: " + typestr);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        return this.format(x);
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) == 1) {
                for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                    Object result = this.getResult(type, i);
                    String label = this.getResultAsString(type, i, result);
                    mol.getAtom(i).setExtraLabel(label);
                }
                continue;
            }
            Object result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol;
    }
}

