/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.training.AtomicContributionBasedPredictor;
import chemaxon.calculations.training.TrainerUtils;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class PredictorPlugin
extends CalculatorPlugin {
    private static final String GENERAL_TRAINING_ID_PREFIX = "general:";
    private static final String TRAINING_NOT_FOUND_ERROR_MSG = "Training not found. Predictions have to be trained before use.";
    private AtomicContributionBasedPredictor predictor = null;
    private Molecule mol = null;
    private String trainingId = null;
    private double[] result = new double[]{Double.NaN, Double.NaN};
    private boolean predictionNotFoundError = false;
    private boolean needError = false;

    public PredictorPlugin() {
        this.predictor = new AtomicContributionBasedPredictor();
    }

    @Override
    public String getProductName() {
        return "Predictor Plugin";
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        this.predictionNotFoundError = false;
        this.setDoublePrecision(params.getProperty("precision", "2"));
        String trainingId = params.getProperty("trainingid");
        if (trainingId == null) {
            trainingId = params.getProperty("type");
        }
        try {
            if (trainingId != null) {
                this.setTraining(trainingId);
            }
        }
        catch (PluginException e) {
            this.predictionNotFoundError = true;
        }
        String errorParam = params.getProperty("error");
        if (errorParam != null) {
            this.needError = errorParam.equalsIgnoreCase("true");
        }
    }

    public static String[] getTrainingIds() {
        List<String> allTrainingIds = Arrays.asList(TrainerUtils.getTrainingIds());
        ArrayList<String> trainingIds = new ArrayList<String>();
        for (String trainingId : allTrainingIds) {
            if (!trainingId.startsWith(GENERAL_TRAINING_ID_PREFIX)) continue;
            trainingIds.add(trainingId.substring(GENERAL_TRAINING_ID_PREFIX.length()));
        }
        String[] trainingIdsArray = new String[trainingIds.size()];
        trainingIds.toArray(trainingIdsArray);
        return trainingIdsArray;
    }

    public void setTraining(String trainingId) throws PluginException {
        if (trainingId == null || trainingId.length() == 0) {
            throw new PluginException("Training ID is not set.");
        }
        this.trainingId = trainingId;
        String trainingIdWithPrefix = trainingId;
        if (!trainingId.startsWith(GENERAL_TRAINING_ID_PREFIX)) {
            trainingIdWithPrefix = GENERAL_TRAINING_ID_PREFIX + trainingId;
        }
        try {
            this.predictor.setTrainingResults(TrainerUtils.loadParameters(trainingIdWithPrefix));
        }
        catch (IOException e) {
            throw new PluginException("Cannot load parameter file for training '" + trainingId + "'.", e);
        }
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.predictionNotFoundError) {
            return false;
        }
        this.result = this.predictor.predictWithError(this.mol);
        return true;
    }

    public double getPredictedValue() {
        return this.result[0];
    }

    public double getStandardError() {
        return this.result[1];
    }

    @Override
    public Object[] getResultTypes() {
        return new Object[]{this.trainingId != null ? this.trainingId : "prediciton"};
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        return this.result[0];
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        return this.getResult(type, 0);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double r = (Double)result;
        if (Double.isNaN(r)) {
            return "";
        }
        return this.format(r);
    }

    @Override
    public Molecule getResultMolecule() {
        double error = this.getStandardError();
        String errorString = Double.isNaN(error) ? "" : " \u00b1 " + this.format(error);
        this.mol.setProperty(this.trainingId, this.format(this.result[0]) + errorString);
        return this.mol;
    }

    @Override
    public String getErrorMessage() {
        if (this.predictionNotFoundError) {
            return TRAINING_NOT_FOUND_ERROR_MSG;
        }
        return "";
    }

    @Override
    public void standardize(Molecule mol) {
        mol.aromatize();
    }

    public boolean needError() {
        return this.needError;
    }
}

