/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.PredictorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.LabelItem;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.marvin.plugin.gui.ParameterPanel;
import chemaxon.marvin.plugin.gui.ParameterTab;
import chemaxon.marvin.plugin.gui.PrecisionItem;
import chemaxon.marvin.plugin.gui.SeparatorItem;
import chemaxon.marvin.plugin.gui.SingleSelectionItem;
import java.util.ArrayList;

public class PredictorPluginDisplay
extends CalculatorPluginDisplay {
    private static final String PREDICTOR_PLUGIN_NAME = "Predictor";
    private static final String HELP_TEXT = "<html> <body> You can run your own trained predictions here.<br> To learn how to train a new prediction see the <br> <a href=https://www.chemaxon.com/marvin/help/calculations/predictor.html>documentation</a>.</body> </html>";

    @Override
    protected ParameterPanelHandler createParameterPanel() throws PluginException {
        return new PredictionPluginParameterPanel();
    }

    private class PredictionPluginParameterPanel
    extends ParameterPanel {
        public PredictionPluginParameterPanel() {
            ParameterItem[] parameterItemArray;
            ParameterTab parameterTab = new ParameterTab(PredictorPluginDisplay.PREDICTOR_PLUGIN_NAME, null);
            if (PredictorPlugin.getTrainingIds().length > 0) {
                ParameterItem[] parameterItemArray2 = new ParameterItem[2];
                parameterItemArray2[0] = new PrecisionItem("precision", "Decimal places", null, "2", "2");
                parameterItemArray = parameterItemArray2;
                parameterItemArray2[1] = new PredictionSelectorItem();
            } else {
                ParameterItem[] parameterItemArray3 = new ParameterItem[4];
                parameterItemArray3[0] = new LabelItem(PredictorPluginDisplay.HELP_TEXT, null);
                parameterItemArray3[1] = new SeparatorItem();
                parameterItemArray3[2] = new PrecisionItem("precision", "Decimal places", null, "2", "2");
                parameterItemArray = parameterItemArray3;
                parameterItemArray3[3] = new PredictionSelectorItem();
            }
            super(parameterTab, null, parameterItemArray);
        }

        @Override
        public boolean isOkActionEnabled() {
            return PredictorPlugin.getTrainingIds().length > 0;
        }
    }

    private class PredictionSelectorItem
    extends SingleSelectionItem {
        private static final String EMPTY_CHOICE = "-----";

        public PredictionSelectorItem() {
            super("trainingid", "Training", null);
            ArrayList<Choice> choiceList = new ArrayList<Choice>();
            String[] traningIds = PredictorPlugin.getTrainingIds();
            for (int i = 0; i < traningIds.length; ++i) {
                Choice choice = new Choice(traningIds[i], traningIds[i], null, i == 0, i == 0);
                choiceList.add(choice);
                this.setChoices(choiceList.toArray(new Choice[choiceList.size()]));
            }
            if (choiceList.isEmpty()) {
                this.setChoices(new Choice[]{new Choice("", EMPTY_CHOICE, null, true, true)});
                this.setEnabled(false);
            }
        }
    }
}

