/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.calculations.GraphInvariants;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.BitPattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class StereoisomerPlugin
extends CalculatorPlugin {
    private String warningmsg = "";
    private static String[] TYPE_RANGE = new String[]{"structure", "structures", "count"};
    private Object[] types = new Object[]{"structure"};
    public static final int TETRAHEDRAL = 1;
    public static final int DOUBLE_BOND = 2;
    public static final int BOTH = 3;
    private Molecule mol = null;
    private Molecule[] stereoisomers = null;
    private int maxNumberOfStereoisomers = -1;
    private boolean check3DStereo = false;
    private boolean in3D = false;
    private int stereoisomerism;
    private boolean protectTetrahedralStereo = false;
    private boolean protectDoubleBondStereo = false;
    private MProgressMonitor pm = null;
    private int progressValue = 0;
    private int maxProgressValue;

    @Override
    public String getProductName() {
        return "Isomers Plugin Group";
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return false;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.pm = pmon;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String stereoisomerismType;
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        if ((stereoisomerismType = params.getProperty("stereoisomerism", "both")).equalsIgnoreCase("tetrahedral")) {
            this.setStereoisomerismType(1);
        } else if (stereoisomerismType.equalsIgnoreCase("doublebond")) {
            this.setStereoisomerismType(2);
        } else if (stereoisomerismType.equalsIgnoreCase("both")) {
            this.setStereoisomerismType(3);
        }
        this.setProtectTetrahedralStereo("true".equalsIgnoreCase(params.getProperty("protecttetrahedralstereo", "false")));
        this.setProtectDoubleBondStereo("true".equalsIgnoreCase(params.getProperty("protectdoublebondstereo", "false")));
        this.maxNumberOfStereoisomers = "true".equalsIgnoreCase(params.getProperty("generateall")) ? -1 : Integer.valueOf(params.getProperty("maxstereoisomers", "1000"));
        this.check3DStereo = "true".equalsIgnoreCase(params.getProperty("verify3d")) || "true".equalsIgnoreCase(params.getProperty("verify3D"));
        this.in3D = "true".equalsIgnoreCase(params.getProperty("in3d")) || "true".equalsIgnoreCase(params.getProperty("in3D"));
    }

    public boolean isIn3D() {
        return this.in3D;
    }

    public void setProtectTetrahedralStereo(boolean protect) {
        this.protectTetrahedralStereo = protect;
    }

    public void setProtectDoubleBondStereo(boolean protect) {
        this.protectDoubleBondStereo = protect;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (StereoisomerPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
    }

    private Molecule[] calculateTetrahedralStereoisomers(Molecule mol) throws PluginException {
        Molecule[] tempTetrahedralStereoisomers2;
        int atomIdx;
        ArrayList<Molecule> tetrahedralStereoisomersList = new ArrayList<Molecule>();
        int atomCount = mol.getAtomCount();
        int[] parityCenters = new int[atomCount];
        int[] atomParities = new int[atomCount];
        for (int i = 0; i < atomParities.length; ++i) {
            atomParities[i] = 0;
        }
        int parityCenterCount = 0;
        Molecule prevTetrahedralStereoisomer = mol.cloneMolecule();
        Molecule tetrahedralStereoisomer = prevTetrahedralStereoisomer.cloneMolecule();
        int[] parityCentersWithEitherParity = new int[atomCount];
        int eitherParityCenterCount = 0;
        int parity = 0;
        for (atomIdx = 0; atomIdx < atomCount; ++atomIdx) {
            parity = tetrahedralStereoisomer.getParity(atomIdx);
            if (parity == 3) {
                parityCentersWithEitherParity[eitherParityCenterCount++] = atomIdx;
                continue;
            }
            if (!this.protectTetrahedralStereo || parity == 0) continue;
            atomParities[atomIdx] = parity;
        }
        for (atomIdx = 0; atomIdx < atomCount; ++atomIdx) {
            MolAtom atom = mol.getAtom(atomIdx);
            if (atom.getImplicitHcount() > 1 || atom.getBondCount() + atom.getImplicitHcount() != 4) continue;
            tetrahedralStereoisomer.setParity(atomIdx, 1);
        }
        int[] allParityCenters = new int[atomCount];
        int allParityCenterCount = 0;
        for (int atomIdx2 = 0; atomIdx2 < atomCount; ++atomIdx2) {
            parity = tetrahedralStereoisomer.getParity(atomIdx2);
            if (parity == 0) continue;
            allParityCenters[allParityCenterCount++] = atomIdx2;
        }
        parityCenters = this.protectTetrahedralStereo ? parityCentersWithEitherParity : allParityCenters;
        parityCenterCount = this.protectTetrahedralStereo ? eitherParityCenterCount : allParityCenterCount;
        tetrahedralStereoisomer.clean(2, null);
        int maxTetrahedralStereoisomerCount = (int)Math.pow(2.0, parityCenterCount);
        BitPattern bitp = new BitPattern(parityCenterCount);
        BitPattern diffbitp = new BitPattern(parityCenterCount);
        for (int i = 0; i < parityCenterCount; ++i) {
            diffbitp.set(i);
        }
        HashSet<String> smilesSet = new HashSet<String>();
        try {
            for (int tetrahedralStereoisomerIdx = 0; tetrahedralStereoisomerIdx < maxTetrahedralStereoisomerCount && (this.maxNumberOfStereoisomers == -1 || smilesSet.size() < this.maxNumberOfStereoisomers) && this.controlProgress(); ++tetrahedralStereoisomerIdx) {
                tetrahedralStereoisomer = prevTetrahedralStereoisomer.cloneMolecule();
                for (int parityCenter = 0; parityCenter < parityCenterCount; ++parityCenter) {
                    if (!diffbitp.get(parityCenter)) continue;
                    atomParities[parityCenters[parityCenter]] = bitp.get(parityCenter) ? 1 : 2;
                }
                tetrahedralStereoisomer.setParity(atomParities, true);
                prevTetrahedralStereoisomer = tetrahedralStereoisomer.cloneMolecule();
                int sizeBeforeAdd = smilesSet.size();
                try {
                    StereoisomerPlugin.clearAtomMaps(tetrahedralStereoisomer);
                    smilesSet.add(tetrahedralStereoisomer.toFormat("smiles:u"));
                }
                catch (IllegalArgumentException e) {
                    smilesSet.add(tetrahedralStereoisomer.toFormat("cxsmarts:u"));
                }
                if (smilesSet.size() > sizeBeforeAdd) {
                    tetrahedralStereoisomer.clearCachedInfo(0);
                    tetrahedralStereoisomersList.add(tetrahedralStereoisomer);
                }
                diffbitp = (BitPattern)bitp.clone();
                bitp.next();
                diffbitp.xor(bitp);
            }
            tempTetrahedralStereoisomers2 = new Molecule[tetrahedralStereoisomersList.size()];
            tetrahedralStereoisomersList.toArray(tempTetrahedralStereoisomers2);
        }
        catch (OutOfMemoryError er) {
            tetrahedralStereoisomersList = null;
            Object tempTetrahedralStereoisomers2 = null;
            this.endProgress();
            throw new PluginException("Out of memory. Allocate more memory to JVM or lower the maximum number of stereoisomers to be generated.\n");
        }
        return tempTetrahedralStereoisomers2;
    }

    private Molecule[] calculateDoubleBondStereoisomers(Molecule mol) throws PluginException {
        Molecule[] tempCTIsomers2;
        ArrayList<Molecule> ctIsomersList = new ArrayList<Molecule>();
        int bondCount = mol.getBondCount();
        int[] ctBonds = new int[bondCount];
        int ctBondCount = 0;
        int[] unspecOrEitherCTBonds = new int[bondCount];
        int unspecOrEitherCTBondCount = 0;
        CleanUtil.setCTCrossedBond(mol);
        Molecule prevCTIsomer = mol.cloneMolecule();
        Molecule ctIsomer = prevCTIsomer.cloneMolecule();
        ctIsomer.setDim(0);
        int[] smallestRingSize = GraphInvariants.generateSmallestRingToIdx(ctIsomer);
        for (int bondIdx = 0; bondIdx < bondCount; ++bondIdx) {
            int stereo;
            MolBond molBond = ctIsomer.getBond(bondIdx);
            if (molBond.getType() != 2) continue;
            int atom1Idx = ctIsomer.indexOf(molBond.getAtom1());
            int atom2Idx = ctIsomer.indexOf(molBond.getAtom2());
            boolean canBeCT = false;
            canBeCT = ctIsomer.canBeCT(atom1Idx, atom2Idx);
            if (canBeCT && (smallestRingSize[atom1Idx] == 0 || smallestRingSize[atom2Idx] == 0 || smallestRingSize[atom1Idx] >= 8 && smallestRingSize[atom2Idx] >= 8)) {
                ctBonds[ctBondCount++] = bondIdx;
            }
            if (!canBeCT) continue;
            MolAtom ctAtom1 = molBond.getCTAtom1();
            MolAtom ctAtom4 = molBond.getCTAtom4();
            if (ctAtom1 == null || ctAtom4 == null || (stereo = ctIsomer.getStereo2(molBond, ctAtom1, ctAtom4, true)) == 128 || stereo == 64) continue;
            unspecOrEitherCTBonds[unspecOrEitherCTBondCount++] = bondIdx;
        }
        ctBonds = this.protectDoubleBondStereo ? unspecOrEitherCTBonds : ctBonds;
        ctBondCount = this.protectDoubleBondStereo ? unspecOrEitherCTBondCount : ctBondCount;
        int maxCTIsomerCount = (int)Math.pow(2.0, ctBondCount);
        BitPattern bitp = new BitPattern(ctBondCount);
        BitPattern diffbitp = new BitPattern(ctBondCount);
        for (int i = 0; i < ctBondCount; ++i) {
            diffbitp.set(i);
        }
        HashSet<String> smilesSet = new HashSet<String>();
        try {
            for (int ctIsomerIdx = 0; ctIsomerIdx < maxCTIsomerCount && (this.maxNumberOfStereoisomers == -1 || smilesSet.size() < this.maxNumberOfStereoisomers) && this.controlProgress(); ++ctIsomerIdx) {
                for (int ctBondIdx = 0; ctBondIdx < ctBondCount; ++ctBondIdx) {
                    MolAtom ctAtom1 = ctIsomer.getBond(ctBonds[ctBondIdx]).getCTAtom1();
                    MolAtom ctAtom4 = ctIsomer.getBond(ctBonds[ctBondIdx]).getCTAtom4();
                    if (!diffbitp.get(ctBondIdx)) continue;
                    if (bitp.get(ctBondIdx)) {
                        ctIsomer.getBond(ctBonds[ctBondIdx]).setStereo2Flags(ctAtom1, ctAtom4, 128);
                        continue;
                    }
                    ctIsomer.getBond(ctBonds[ctBondIdx]).setStereo2Flags(ctAtom1, ctAtom4, 64);
                }
                prevCTIsomer = ctIsomer.cloneMolecule();
                int sizeBeforeAdd = smilesSet.size();
                try {
                    StereoisomerPlugin.clearAtomMaps(ctIsomer);
                    smilesSet.add(ctIsomer.toFormat("smiles:u"));
                }
                catch (IllegalArgumentException e) {
                    smilesSet.add(ctIsomer.toFormat("cxsmarts:u"));
                }
                if (smilesSet.size() > sizeBeforeAdd) {
                    ctIsomer.clean(2, null);
                    ctIsomer.clearCachedInfo(0);
                    ctIsomersList.add(ctIsomer);
                    ctIsomer = prevCTIsomer.cloneMolecule();
                }
                diffbitp = (BitPattern)bitp.clone();
                bitp.next();
                diffbitp.xor(bitp);
            }
            tempCTIsomers2 = new Molecule[ctIsomersList.size()];
            ctIsomersList.toArray(tempCTIsomers2);
        }
        catch (OutOfMemoryError er) {
            ctIsomersList = null;
            Object tempCTIsomers2 = null;
            this.endProgress();
            throw new PluginException("Out of memory. Allocate more memory to JVM or lower the maximum number of stereoisomers to be generated.\n");
        }
        return tempCTIsomers2;
    }

    private Molecule[] calculateBothStereoisomers(Molecule mol) throws PluginException {
        Molecule[] doubleBondStereoisomers = this.calculateDoubleBondStereoisomers(mol);
        Molecule[] tetrahedralStereoisomers = null;
        ArrayList<Molecule> molsList = new ArrayList<Molecule>();
        for (int doublebIdx = 0; doublebIdx < doubleBondStereoisomers.length; ++doublebIdx) {
            tetrahedralStereoisomers = this.calculateTetrahedralStereoisomers(doubleBondStereoisomers[doublebIdx]);
            for (int tetraIdx = 0; tetraIdx < tetrahedralStereoisomers.length; ++tetraIdx) {
                molsList.add(tetrahedralStereoisomers[tetraIdx]);
            }
        }
        Molecule[] rmols = new Molecule[molsList.size()];
        molsList.toArray(rmols);
        return rmols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Molecule[] check3DStructures(Molecule[] mols, boolean in3D) throws PluginException {
        int n = mols.length;
        ArrayList<Molecule> molsList = new ArrayList<Molecule>();
        Molecule molClone = null;
        if (n > 1 && this.pm != null) {
            this.pm = new MDialogProgressMonitor(null, "Checking 3D structures...", 2);
            this.pm.initProgressMonitor(String.valueOf(n) + " molecules to check", 0, n);
        }
        try {
            boolean canceled = false;
            for (int i = 0; i < n && !canceled; ++i) {
                molClone = mols[i].cloneMolecule();
                if (this.pm != null) {
                    this.pm.setProgressValue(i);
                    if (this.pm.isCanceled()) {
                        canceled = true;
                    }
                }
                boolean bl = canceled = !molClone.clean(3, "S{fine}E", this.pm != null ? this.pm.getChild() : null);
                if (molClone.getProperty("Energy").equals("CLEAN3D_FAILED")) continue;
                if (in3D) {
                    molsList.add(molClone);
                    continue;
                }
                molsList.add(mols[i]);
            }
        }
        finally {
            if (this.pm != null) {
                this.pm.setProgressValue(n);
            }
        }
        Molecule[] rmols = new Molecule[molsList.size()];
        molsList.toArray(rmols);
        return rmols;
    }

    private void initProgressMonitor(int n) {
        if (this.pm != null) {
            this.pm = new MDialogProgressMonitor(null, "Stereoisomers");
            this.maxProgressValue = n;
            this.pm.initProgressMonitor("Generating stereoisomers...", 0, n);
        }
    }

    private boolean controlProgress() {
        if (this.pm != null) {
            if (this.pm.isCanceled()) {
                return false;
            }
            this.pm.setProgressValue(this.progressValue++);
        }
        return true;
    }

    private boolean endProgress() {
        if (this.pm != null) {
            this.pm.setProgressValue(this.maxProgressValue);
        }
        this.progressValue = 0;
        return true;
    }

    private void resetProgressValue() {
        this.progressValue = 0;
    }

    private static void clearAtomMaps(Molecule mol) {
        for (MolAtom atom : mol.getAtomArray()) {
            atom.setAtomMap(0);
        }
    }

    public boolean isChiralCenter(int a) {
        return this.mol.getParity(a) != 0;
    }

    public int chiralCenterCount() {
        int p = 0;
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.mol.getParity(i) == 0) continue;
            ++p;
        }
        return p;
    }

    private int canBeCTDoubleBondCount() {
        int count = 0;
        int[] smallestRingSize = GraphInvariants.generateSmallestRingToIdx(this.mol);
        for (int bondIdx = 0; bondIdx < this.mol.getBondCount(); ++bondIdx) {
            int atom2Idx;
            MolBond molBond = this.mol.getBond(bondIdx);
            int atom1Idx = this.mol.indexOf(molBond.getAtom1());
            if (!this.mol.canBeCT(atom1Idx, atom2Idx = this.mol.indexOf(molBond.getAtom2())) || smallestRingSize[atom1Idx] != 0 && smallestRingSize[atom2Idx] != 0 && (smallestRingSize[atom1Idx] < 8 || smallestRingSize[atom2Idx] < 8)) continue;
            ++count;
        }
        return count;
    }

    public void setMaxNumberOfStereoisomers(int n) {
        this.maxNumberOfStereoisomers = n;
    }

    public void setStereoisomerismType(int itype) {
        this.stereoisomerism = itype;
    }

    public void setCheck3DStereo(boolean c) {
        this.check3DStereo = c;
    }

    public void setIn3D(boolean b) {
        this.in3D = b;
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new PluginMDocSource(new ResultIterator(), this.getStructureCount());
    }

    int getStructureCount() {
        return this.getStereoisomerCount();
    }

    public int getStereoisomerCount() {
        return this.stereoisomers.length;
    }

    Molecule getStructure(int index) {
        return this.getStereoisomer(index);
    }

    public Molecule getStereoisomer(int index) {
        return this.stereoisomers[index];
    }

    Molecule[] getStructures() {
        return this.getStereoisomers();
    }

    public Molecule[] getStereoisomers() {
        return this.stereoisomers;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.resetProgressValue();
        if (this.stereoisomerism == 2) {
            int maxPredictedStereoisomers = (int)Math.pow(2.0, this.canBeCTDoubleBondCount());
            int maxProgress = this.maxNumberOfStereoisomers == -1 || maxPredictedStereoisomers < this.maxNumberOfStereoisomers ? maxPredictedStereoisomers : this.maxNumberOfStereoisomers;
            this.initProgressMonitor(maxProgress);
            this.stereoisomers = this.calculateDoubleBondStereoisomers(this.mol);
            this.endProgress();
        } else if (this.stereoisomerism == 1) {
            int maxPredictedStereoisomers = (int)Math.pow(2.0, this.chiralCenterCount());
            int maxProgress = this.maxNumberOfStereoisomers == -1 || maxPredictedStereoisomers < this.maxNumberOfStereoisomers ? maxPredictedStereoisomers : this.maxNumberOfStereoisomers;
            this.initProgressMonitor(maxProgress);
            this.stereoisomers = this.calculateTetrahedralStereoisomers(this.mol);
            this.endProgress();
        } else if (this.stereoisomerism == 3) {
            int maxPredictedStereoisomers = (int)(Math.pow(2.0, this.canBeCTDoubleBondCount()) * Math.pow(2.0, this.chiralCenterCount()));
            int maxProgress = this.maxNumberOfStereoisomers == -1 || maxPredictedStereoisomers < this.maxNumberOfStereoisomers ? maxPredictedStereoisomers : this.maxNumberOfStereoisomers;
            this.initProgressMonitor(maxProgress);
            this.stereoisomers = this.calculateBothStereoisomers(this.mol);
            this.endProgress();
        }
        if (this.check3DStereo || this.in3D) {
            this.stereoisomers = this.check3DStructures(this.stereoisomers, this.in3D);
        }
        return true;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("structure")) {
            return "Stereoisomer";
        }
        if (typestr.equals("structures")) {
            return "Stereoisomers";
        }
        if (typestr.equals("count")) {
            return "Stereoisomer count";
        }
        return type.toString();
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structure") ? this.getStereoisomerCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structure")) {
            return this.getStructure(index);
        }
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            return new Integer(this.getStructureCount());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("sdf:-a");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("sdf:-a"));
            }
            return new String(buffer);
        }
        if (result instanceof Integer) {
            return result.toString();
        }
        throw new PluginException("Result should be a molecule or integer object\ninstead of: " + result);
    }

    @Override
    public String getWarningMessage() {
        return this.getStereoisomerCount() == 0 ? this.warningmsg : "";
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setStereoGroupType(0);
        }
    }

    private class ResultIterator
    implements Iterator {
        private int currentCount = 0;

        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentCount < StereoisomerPlugin.this.getStructureCount();
        }

        public Object next() {
            return this.hasNext() ? CalculatorPlugin.getDocument(StereoisomerPlugin.this.getStructure(this.currentCount++)) : null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

