/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.util.SSS;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Properties;
import java.util.Vector;

public class StructuralFrameworksPlugin
extends CalculatorPlugin {
    private FrameworkTypes ft = FrameworkTypes.bemismurcko;
    private Object[] types = new Object[]{"structure"};
    private OperationHostImpl host = null;
    private boolean keepSingleForAcyclic = true;
    private boolean lfin = false;
    private boolean lfout = false;
    private boolean prunein = false;
    private boolean pruneout = false;
    private boolean oeqcheck = false;
    private boolean hydrogenize = false;
    private boolean dehydrogenize = false;
    private String format = "sdf";
    private VerbosePrinter verb = null;

    public void setVerbosePrinter(VerbosePrinter verb) {
        this.verb = verb;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        switch (this.ft) {
            case mcs: {
                int fc = mol.getFragCount();
                if (fc >= 2) break;
                throw new PluginException("MCS requires at least two fragments.");
            }
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        if (this.verb != null) {
            this.verb.verbose("Set input molecule");
            this.verb.verbose(mol);
        }
        this.getHost(false).setInputMolecule(mol);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void standardize(Molecule mol) {
        super.standardize(mol);
        mol.ungroupSgroups();
    }

    @Override
    public boolean run() throws PluginException {
        if (this.verb != null) {
            this.verb.verbose("run()");
        }
        this.checkLicense();
        try {
            return this.getHost(true).run();
        }
        catch (PluginException e) {
            this.host = null;
            throw e;
        }
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        if (this.verb != null) {
            this.verb.verbose("Return result molecule");
        }
        return this.getHost(false).getInputMolecule();
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    private void newParameterSet() {
        if (this.host != null) {
            try {
                this.host.clearOpChain();
            }
            catch (PluginException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                this.host = null;
            }
        }
    }

    private OperationHostImpl getHost(boolean param) {
        if (this.host == null) {
            this.host = new OperationHostImpl();
        }
        if (param && this.host.opChainSize() == 0) {
            if (this.lfin && this.ft != FrameworkTypes.mcs) {
                this.host.addOp(new KeepLargestFragmentOperation());
            }
            if (this.dehydrogenize || this.prunein || this.ft == FrameworkTypes.bemismurcko || this.ft == FrameworkTypes.bemismurckoloose) {
                this.host.addOp(new HydrogenizeOperation(false));
            } else if (this.hydrogenize) {
                this.host.addOp(new HydrogenizeOperation(true));
            }
            if ((this.prunein || this.ft == FrameworkTypes.bemismurcko) && this.ft != FrameworkTypes.bemismurckoloose) {
                this.host.addOp(new PruneTypesOperation());
            }
            switch (this.ft) {
                case allringsystems: {
                    this.host.addOp(new AllRingSystemOperation());
                    break;
                }
                case bemismurcko: {
                    this.host.addOp(new BemisMurckoOperation(this.keepSingleForAcyclic));
                    break;
                }
                case bemismurckoloose: {
                    this.host.addOp(new BemisMurckoLooseOperation(this.keepSingleForAcyclic));
                    break;
                }
                case cssr: {
                    this.host.addOp(new CSSROperation());
                    break;
                }
                case sssr: {
                    this.host.addOp(new SSSROperation());
                    break;
                }
                case largestring: {
                    this.host.addOp(new LargestRingOperation());
                    break;
                }
                case largestringsystem: {
                    this.host.addOp(new LargestRingSystemOperation());
                    break;
                }
                case mcs: {
                    this.host.addOp(new MCSOperation());
                    break;
                }
            }
            if (this.pruneout) {
                this.host.addOp(new PruneTypesOperation());
            }
            if (this.lfout) {
                this.host.addOp(new KeepLargestFragmentOperation());
            }
            if (this.oeqcheck) {
                this.host.addOp(new RemoveEQOperation());
            }
        }
        return this.host;
    }

    public void setKeepSingleAtom(boolean b) {
        this.newParameterSet();
        this.keepSingleForAcyclic = b;
    }

    public void setFormat(String f) {
        this.newParameterSet();
        this.format = f;
    }

    public void setLfin(boolean b) {
        this.newParameterSet();
        this.lfin = b;
    }

    public void setLfout(boolean b) {
        this.newParameterSet();
        this.lfout = b;
    }

    public void setType(FrameworkTypes ft) {
        this.newParameterSet();
        this.ft = ft;
    }

    public void setPruneIn(boolean b) {
        this.newParameterSet();
        this.prunein = b;
    }

    public void setPruneOut(boolean b) {
        this.newParameterSet();
        this.pruneout = b;
    }

    public void setHydrogenize(boolean b) {
        this.newParameterSet();
        this.hydrogenize = b;
    }

    public void setDehydrogenize(boolean b) {
        this.newParameterSet();
        this.dehydrogenize = b;
    }

    public void setOeqcheck(boolean b) {
        this.newParameterSet();
        this.oeqcheck = b;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String f;
        if (this.verb != null) {
            this.verb.verbose("Set parameters");
            this.verb.verbose(params);
        }
        super.setParameters(params);
        String s = params.getProperty("keepsingleatom");
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                this.keepSingleForAcyclic = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.keepSingleForAcyclic = false;
            } else {
                throw new PluginException("Parameter value for --keepsingleatom \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("lfin")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.lfin = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.lfin = false;
            } else {
                throw new PluginException("Parameter value for --lfin \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("lfout")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.lfout = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.lfout = false;
            } else {
                throw new PluginException("Parameter value for --lfout \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("prunein")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.prunein = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.prunein = false;
            } else {
                throw new PluginException("Parameter value for --prunein \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("pruneout")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.pruneout = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.pruneout = false;
            } else {
                throw new PluginException("Parameter value for --pruneout \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("hydrogenize")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.hydrogenize = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.hydrogenize = false;
            } else {
                throw new PluginException("Parameter value for --hydrogenize \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("dehydrogenize")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.dehydrogenize = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.dehydrogenize = false;
            } else {
                throw new PluginException("Parameter value for --dehydrogenize \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((s = params.getProperty("oeqcheck")) != null) {
            if (s.equalsIgnoreCase("true")) {
                this.oeqcheck = true;
            } else if (s.equalsIgnoreCase("false")) {
                this.oeqcheck = false;
            } else {
                throw new PluginException("Parameter value for --oeqcheck \"" + s + "\" invalid. Use \"true\" or \"false\".");
            }
        }
        if ((f = params.getProperty("format")) != null) {
            this.format = f;
        }
        if ((s = params.getProperty("type")) != null) {
            if (s.startsWith("bmfl") || s.startsWith("bemismurckoloose")) {
                this.setType(FrameworkTypes.bemismurckoloose);
            } else if (s.startsWith("bmf") || s.startsWith("bemismurcko")) {
                this.setType(FrameworkTypes.bemismurcko);
            } else if (s.startsWith("mcs")) {
                this.setType(FrameworkTypes.mcs);
            } else if (s.startsWith("largestringsystem")) {
                this.setType(FrameworkTypes.largestringsystem);
            } else if (s.startsWith("largestring")) {
                this.setType(FrameworkTypes.largestring);
            } else if (s.startsWith("allringsystems")) {
                this.setType(FrameworkTypes.allringsystems);
            } else if (s.startsWith("sssr")) {
                this.setType(FrameworkTypes.sssr);
            } else if (s.startsWith("cssr")) {
                this.setType(FrameworkTypes.cssr);
            } else if (s.startsWith("keep")) {
                this.setType(FrameworkTypes.keep);
            }
        }
    }

    @Override
    public String getProductName() {
        return "Structural Frameworks Plugin";
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultCount() {
        return 1;
    }

    public Molecule getResult() throws PluginException {
        return this.getHost(false).getInputMolecule();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        return this.getResult();
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            Molecule mol = (Molecule)result;
            return mol.toFormat(this.format);
        }
        throw new PluginException("Cannot convert result to String: " + result);
    }

    @Override
    public String getTypeString(Object type) {
        return type.toString().toLowerCase();
    }

    private static int[][] findRingSystems(Molecule m) {
        int i;
        Vector<int[]> ret = new Vector<int[]>();
        BitSet procs = new BitSet();
        int[][] sssr = m.getSSSR();
        boolean found = true;
        while (found) {
            found = false;
            BitSet rs = new BitSet();
            for (i = 0; i < sssr.length; ++i) {
                if (procs.get(i)) continue;
                procs.set(i);
                found = true;
                for (int j = 0; j < sssr[i].length; ++j) {
                    rs.set(sssr[i][j]);
                }
                break;
            }
            boolean found2 = true;
            block3: while (found2) {
                found2 = false;
                for (int i2 = 0; i2 < sssr.length; ++i2) {
                    int j;
                    if (procs.get(i2)) continue;
                    for (j = 0; j < sssr[i2].length; ++j) {
                        if (!rs.get(sssr[i2][j])) continue;
                        found2 = true;
                        break;
                    }
                    if (!found2) continue;
                    procs.set(i2);
                    for (j = 0; j < sssr[i2].length; ++j) {
                        rs.set(sssr[i2][j]);
                    }
                    continue block3;
                }
            }
            ret.add(U.collectSets(rs));
        }
        int[][] r = new int[ret.size()][];
        for (i = 0; i < r.length; ++i) {
            r[i] = (int[])ret.get(i);
        }
        return r;
    }

    private static Molecule select(Molecule m, int[][] sel) {
        Molecule res = new Molecule();
        int[][] mct = m.getCtab();
        BondTable mbt = m.getBondTable();
        for (int i = 0; i < sel.length; ++i) {
            int j;
            int[] ns = new int[sel[i].length];
            for (j = 0; j < sel[i].length; ++j) {
                MolAtom aj = m.getAtom(sel[i][j]);
                MolAtom na = new MolAtom(aj.getAtno());
                if (m.getDim() == 2) {
                    na.setXY(aj.getX(), aj.getY());
                } else if (m.getDim() == 3) {
                    na.setXYZ(aj.getX(), aj.getY(), aj.getZ());
                }
                res.add(na);
                ns[j] = res.indexOf(na);
            }
            for (j = 0; j < sel[i].length; ++j) {
                int aj = sel[i][j];
                int naj = ns[j];
                for (int k = 0; k < mct[aj].length; ++k) {
                    int idx;
                    int ak = mct[aj][k];
                    if (ak > aj || (idx = U.indexOf(sel[i], ak)) < 0) continue;
                    int nak = ns[idx];
                    MolBond mb = m.getBond(mbt.getBondIndex(aj, ak));
                    MolBond nb = new MolBond(res.getAtom(naj), res.getAtom(nak), mb.getType());
                    res.add(nb);
                }
            }
        }
        res.setDim(m.getDim());
        if (m.getDim() != 0) {
            res.clean(2, null);
        }
        return res;
    }

    private static class OperationHostImpl
    implements OperationHost {
        private outerStates ostate = outerStates.noinput;
        Molecule molecule = null;
        boolean mget = false;
        boolean rset = false;
        private Vector<Operation> opchain = null;

        private OperationHostImpl() {
        }

        public void setInputMolecule(Molecule m) throws PluginException {
            if (this.ostate == outerStates.running) {
                throw new PluginException("Internal error");
            }
            this.ostate = outerStates.finished;
            this.molecule = m;
        }

        public void clearOpChain() throws PluginException {
            if (this.ostate == outerStates.running) {
                throw new PluginException("Internal error");
            }
            if (this.opchain != null) {
                this.opchain.clear();
            }
        }

        public int opChainSize() {
            if (this.opchain == null) {
                return 0;
            }
            return this.opchain.size();
        }

        public void addOp(Operation o) {
            if (this.opchain == null) {
                this.opchain = new Vector();
            }
            this.opchain.add(o);
        }

        public boolean run() throws PluginException {
            if (this.ostate != outerStates.finished) {
                throw new PluginException("Internal error");
            }
            this.ostate = outerStates.running;
            if (this.opchain != null) {
                for (int i = 0; i < this.opchain.size(); ++i) {
                    this.mget = false;
                    this.rset = false;
                    Operation o = this.opchain.get(i);
                    o.run(this);
                }
            }
            this.ostate = outerStates.finished;
            return true;
        }

        @Override
        public Molecule getInputMolecule() throws PluginException {
            return this.getInputMolecule(false);
        }

        @Override
        public int getInputFragmentCount() throws PluginException {
            throw new PluginException("Internal error");
        }

        @Override
        public void setResultMolecule(Molecule m) throws PluginException {
            if (this.ostate != outerStates.running || !this.mget || this.rset) {
                throw new PluginException("Internal error");
            }
            this.rset = true;
            this.molecule = m;
        }

        @Override
        public void addResultFragment(Molecule m) throws PluginException {
            throw new PluginException("Internal error");
        }

        @Override
        public Molecule getInputMolecule(boolean cloneRequested) throws PluginException {
            if (this.ostate != outerStates.finished && this.ostate != outerStates.running) {
                throw new PluginException("Internal error");
            }
            if (this.mget && this.ostate == outerStates.running) {
                throw new PluginException("Internal error");
            }
            if (cloneRequested) {
                throw new PluginException("Internal error");
            }
            this.mget = true;
            return this.molecule;
        }

        @Override
        public Molecule[] getInputMoleculeFragments(boolean cloneRequested) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Molecule getInputFragment(int f, boolean cloneRequested) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static enum outerStates {
            noinput,
            running,
            finished;

        }
    }

    private static class LargestRingOperation
    implements Operation {
        private LargestRingOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            int[][] rr = m.getSSSR();
            if (rr == null || rr.length == 0) {
                host.setResultMolecule(new Molecule());
                return;
            }
            int ms = -1;
            int mi = -1;
            for (int i = 0; i < rr.length; ++i) {
                if (rr[i].length <= ms) continue;
                ms = rr[i].length;
                mi = i;
            }
            host.setResultMolecule(StructuralFrameworksPlugin.select(m, new int[][]{rr[mi]}));
        }
    }

    private static class LargestRingSystemOperation
    implements Operation {
        private LargestRingSystemOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            int[][] rs = StructuralFrameworksPlugin.findRingSystems(m);
            if (rs == null || rs.length == 0) {
                host.setResultMolecule(new Molecule());
                return;
            }
            int ms = -1;
            int mi = -1;
            for (int i = 0; i < rs.length; ++i) {
                if (rs[i].length <= ms) continue;
                ms = rs[i].length;
                mi = i;
            }
            host.setResultMolecule(StructuralFrameworksPlugin.select(m, new int[][]{rs[mi]}));
        }
    }

    private static class AllRingSystemOperation
    implements Operation {
        private AllRingSystemOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            int[][] rs = StructuralFrameworksPlugin.findRingSystems(m);
            host.setResultMolecule(StructuralFrameworksPlugin.select(m, rs));
        }
    }

    private static class CSSROperation
    implements Operation {
        private CSSROperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            host.setResultMolecule(StructuralFrameworksPlugin.select(m, m.getCSSR()));
        }
    }

    private static class SSSROperation
    implements Operation {
        private SSSROperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            host.setResultMolecule(StructuralFrameworksPlugin.select(m, m.getSSSR()));
        }
    }

    private static interface Operation {
        public boolean handleMultiFragmentMolecule();

        public void run(OperationHost var1) throws PluginException;
    }

    private static interface OperationHost {
        public Molecule getInputMolecule() throws PluginException;

        public Molecule getInputMolecule(boolean var1) throws PluginException;

        public Molecule[] getInputMoleculeFragments(boolean var1);

        public int getInputFragmentCount() throws PluginException;

        public Molecule getInputFragment(int var1, boolean var2);

        public void setResultMolecule(Molecule var1) throws PluginException;

        public void addResultFragment(Molecule var1) throws PluginException;
    }

    private static class KeepLargestFragmentOperation
    implements Operation {
        private KeepLargestFragmentOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule[] frags = host.getInputMolecule().convertToFrags();
            int ms = 0;
            int msi = -1;
            for (int i = 0; i < frags.length; ++i) {
                int si = frags[i].getAtomCount();
                if (si <= ms) continue;
                ms = si;
                msi = i;
            }
            host.setResultMolecule(frags[msi]);
        }
    }

    private static class HydrogenizeOperation
    implements Operation {
        private boolean b = false;

        public HydrogenizeOperation(boolean b) {
            this.b = b;
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            host.getInputMolecule().hydrogenize(this.b);
        }
    }

    private static class PruneTypesOperation
    implements Operation {
        private PruneTypesOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        public static void prune(Molecule m) {
            int i;
            for (i = 0; i < m.getAtomCount(); ++i) {
                MolAtom ai = m.getAtom(i);
                ai.setAtno(6);
                ai.setFlags(0);
            }
            for (i = 0; i < m.getBondCount(); ++i) {
                MolBond bi = m.getBond(i);
                bi.setFlags(0);
                bi.setType(1);
            }
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            PruneTypesOperation.prune(host.getInputMolecule());
        }
    }

    private static class BemisMurckoOperation
    implements Operation {
        boolean keepSingle = false;

        public BemisMurckoOperation(boolean keepSingle) {
            this.keepSingle = keepSingle;
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule m = host.getInputMolecule();
            boolean found = true;
            while (found) {
                found = false;
                for (int i = 0; !found && i < m.getAtomCount(); ++i) {
                    int bci = m.getAtom(i).getBondCount();
                    if (bci == 1) {
                        m.removeAtom(i);
                        found = true;
                        continue;
                    }
                    if (this.keepSingle || bci != 0) continue;
                    m.removeAtom(i);
                    found = true;
                }
            }
        }
    }

    private static class BemisMurckoLooseOperation
    implements Operation {
        boolean keepSingle = false;
        boolean oxo1 = true;

        public BemisMurckoLooseOperation(boolean keepSingle) {
            this.keepSingle = keepSingle;
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            int i;
            int i2;
            Molecule m = host.getInputMolecule();
            BondClassifier bc = new BondClassifier();
            BitSet remove = new BitSet(m.getAtomCount());
            BitSet keep = new BitSet(m.getAtomCount());
            bc.classify(m);
            if (this.oxo1) {
                for (i2 = 0; i2 < m.getBondCount(); ++i2) {
                    MolBond bi = m.getBond(i2);
                    if (bi.getType() == 1) continue;
                    int a1 = m.indexOf(bi.getAtom1());
                    int a2 = m.indexOf(bi.getAtom2());
                    if (bc.isRingAtom(a1) == bc.isRingAtom(a2)) continue;
                    keep.set(a1);
                    keep.set(a2);
                }
            }
            for (i2 = 0; i2 < m.getAtomCount(); ++i2) {
                if (!bc.isRingAtom(i2)) continue;
                keep.set(i2);
            }
            int[][] ctab = m.getCtab();
            boolean found = true;
            while (found) {
                found = false;
                for (i = 0; i < ctab.length; ++i) {
                    if (keep.get(i) || remove.get(i)) continue;
                    int nc = 0;
                    for (int j = 0; j < ctab[i].length; ++j) {
                        int nj = ctab[i][j];
                        if (remove.get(nj)) continue;
                        ++nc;
                    }
                    if (nc != true) continue;
                    remove.set(i);
                    found = true;
                }
            }
            for (i = m.getAtomCount() - 1; i >= 0; --i) {
                if (!remove.get(i)) continue;
                m.removeAtom(i);
            }
            if (!this.keepSingle) {
                for (i = m.getAtomCount() - 1; i >= 0; --i) {
                    if (m.getAtom(i).getBondCount() != 0) continue;
                    m.removeAtom(i);
                }
            } else {
                for (i = m.getAtomCount() - 1; i >= 0; --i) {
                    if (m.getAtom(i).getBondCount() != 0) continue;
                    m.getAtom(i).setAtno(6);
                }
            }
        }
    }

    private static class MCSOperation
    implements Operation {
        private MCSOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            Molecule in = host.getInputMolecule();
            Molecule[] frags = in.convertToFrags();
            if (frags.length == 0 || frags.length == 1) {
                throw new PluginException("MCS needs two fragments");
            }
            Molecule res = new Molecule();
            SSS sss = new SSS();
            sss.setMCSMode(true);
            for (int i = 0; i < frags.length - 1; ++i) {
                sss.setQuery(frags[i]);
                for (int j = i + 1; j < frags.length; ++j) {
                    int k;
                    sss.setTarget(frags[j]);
                    if (!sss.findFirst()) continue;
                    Molecule m = sss.getResultAsMolecule();
                    for (k = 0; k < m.getAtomCount(); ++k) {
                        res.add(m.getAtom(k));
                    }
                    for (k = 0; k < m.getBondCount(); ++k) {
                        res.add(m.getBond(k));
                    }
                }
            }
            if (in.getDim() == 2 || in.getDim() == 3) {
                res.clean(2, "");
            }
            host.setResultMolecule(res);
        }
    }

    private static class RemoveEQOperation
    implements Operation {
        private RemoveEQOperation() {
        }

        @Override
        public boolean handleMultiFragmentMolecule() {
            return true;
        }

        @Override
        public void run(OperationHost host) throws PluginException {
            int i;
            Molecule in = host.getInputMolecule();
            Molecule[] frags = in.convertToFrags();
            Molecule res = new Molecule();
            SSS sss = new SSS();
            sss.setSSSMode(true);
            for (i = 0; i < frags.length - 1; ++i) {
                if (frags[i] == null) continue;
                sss.setQuery(frags[i]);
                for (int j = i + 1; j < frags.length; ++j) {
                    if (frags[j] == null || frags[i].getAtomCount() != frags[j].getAtomCount() || frags[i].getBondCount() != frags[j].getBondCount()) continue;
                    sss.setTarget(frags[j]);
                    if (!sss.findFirst()) continue;
                    frags[j] = null;
                }
            }
            for (i = 0; i < frags.length; ++i) {
                int k;
                if (frags[i] == null) continue;
                for (k = 0; k < frags[i].getAtomCount(); ++k) {
                    res.add(frags[i].getAtom(k));
                }
                for (k = 0; k < frags[i].getBondCount(); ++k) {
                    res.add(frags[i].getBond(k));
                }
            }
            if (in.getDim() == 2 || in.getDim() == 3) {
                res.clean(2, "");
            }
            host.setResultMolecule(res);
        }
    }

    public static interface VerbosePrinter {
        public void verbose(Object var1);
    }

    public static enum FrameworkTypes {
        bemismurcko,
        bemismurckoloose,
        allringsystems,
        largestringsystem,
        sssr,
        cssr,
        largestring,
        mcs,
        keep;

    }
}

