/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.TPSA;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class TPSAPlugin
extends MajorMicrospeciesAccessorPlugin {
    private static String[] TYPE_RANGE = new String[]{"psa"};
    private Object[] types = new Object[]{"psa"};
    private TPSA tpsa = new TPSA();

    @Override
    public String getProductName() {
        return "Free Plugin";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        this.setExcludeSulfur("true".equalsIgnoreCase(params.getProperty("excludesulfur", "true")));
        this.setExcludePhosphorus("true".equalsIgnoreCase(params.getProperty("excludephosphorus", "true")));
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation is not defined for reactions.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.tpsa.setMolecule(mol);
    }

    public void setExcludeSulfur(boolean s) {
        this.tpsa.excludeSulfur(s);
    }

    public void setExcludePhosphorus(boolean p) {
        this.tpsa.excludePhosphorus(p);
    }

    @Override
    public boolean run() throws PluginException {
        this.tpsa.calcTPSA();
        return !this.tpsa.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.tpsa.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public int getResultCount(Object type) {
        return 1;
    }

    public double getTPSA() {
        return this.getSurfaceArea();
    }

    public double getSurfaceArea() {
        return this.tpsa.getTPSA();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        return new Double(this.getSurfaceArea());
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        return this.format(x);
    }

    @Override
    public String getTypeString(Object type) {
        return "Polar surface area";
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        mol.setProperty("psa", this.format(this.getSurfaceArea()));
        return mol;
    }
}

