/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Tautomerization;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class TautomerizationPlugin
extends CalculatorPlugin {
    private Tautomerization tautomerization = null;
    private Molecule inputMol = null;
    private Molecule canonicTautomer = null;
    private Molecule standardTautomer = null;
    private boolean canonicTautomerCalculation = false;
    private boolean standardTautomerCalculation = false;
    private Molecule genericTautomer = null;
    private boolean genericTautomerCalculation = false;
    private Molecule majorTautomer = null;
    private boolean majorTautomerCalculation = false;
    private boolean dominantTautomerDistributionCalculation = false;
    private boolean modifyInputStructure = false;
    private static final String WARNING = "No multiple structures.";
    private static String[] TYPE_RANGE = new String[]{"structure", "structures", "count"};
    private Object[] types = new Object[]{"structure"};
    private boolean single = false;
    private boolean criticalError = false;
    private String dominantTautomerDistributionTag;
    private boolean cleanResultStructures;
    private boolean partialNeutralization = false;

    public TautomerizationPlugin() {
        this.tautomerization = new Tautomerization();
        this.tautomerization.setResonantCalc(false);
    }

    @Override
    public String getProductName() {
        return "Isomers Plugin Group";
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return !this.single;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.tautomerization.setProgressMonitor(pmon);
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        boolean considerpH;
        this.single = "true".equalsIgnoreCase(params.getProperty("single"));
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        this.setDoublePrecision(params.getProperty("precision"));
        boolean symfilter = !"false".equalsIgnoreCase(params.getProperty("symfilter", "true"));
        this.setSymmetryFiltering(symfilter);
        double pH = Double.NaN;
        boolean bl = considerpH = !"false".equalsIgnoreCase(params.getProperty("considerpH")) && !"false".equalsIgnoreCase(params.getProperty("considerph"));
        if (considerpH) {
            String pHstr = params.getProperty("pH");
            if (pHstr == null || pHstr.length() == 0) {
                pHstr = params.getProperty("ph");
            }
            if (pHstr != null && pHstr.length() > 0) {
                pH = Double.valueOf(pHstr);
            }
        }
        this.setpH(pH);
        this.setMaxStructureCount(Integer.parseInt(params.getProperty("max", "1000")));
        String calctype = params.getProperty("calctype", "alltautomers");
        boolean canonical = "true".equalsIgnoreCase(params.getProperty("canonical")) || calctype.equalsIgnoreCase("canonical");
        this.setTakeCanonicalForm(canonical);
        boolean generic = "true".equalsIgnoreCase(params.getProperty("generic")) || calctype.equalsIgnoreCase("generic");
        this.setTakeGenericTautomer(generic);
        boolean moststable = "true".equalsIgnoreCase(params.getProperty("moststable")) || calctype.equalsIgnoreCase("moststable");
        boolean major = "true".equalsIgnoreCase(params.getProperty("major")) || calctype.equalsIgnoreCase("major");
        this.setTakeMajorTautomer(major || moststable);
        boolean takeDominantTautomers = "true".equalsIgnoreCase(params.getProperty("dominants")) || calctype.equalsIgnoreCase("dominants");
        this.setTakeDominantTautomers(takeDominantTautomers);
        boolean takeStandardTautomers = "true".equalsIgnoreCase(params.getProperty("standard")) || calctype.equalsIgnoreCase("standard");
        this.setTakeStandardForm(takeStandardTautomers);
        boolean claculateDominantTautomerDistribution = "true".equalsIgnoreCase(params.getProperty("distribution")) || calctype.equalsIgnoreCase("distribution");
        this.setDominantTautomerDistributionCalculation(claculateDominantTautomerDistribution);
        this.dominantTautomerDistributionTag = params.getProperty("tag", "TAUTOMER_DISTRIBUTION");
        this.setMaximumTautomerizationPathLength(Integer.parseInt(params.getProperty("pathlength", "4")));
        this.setProtectAromaticity("true".equalsIgnoreCase(params.getProperty("protectaromaticity", "true")));
        this.setProtectCharge("true".equalsIgnoreCase(params.getProperty("protectcharge", "true")));
        this.setExcludeAntiAromaticCompounds("true".equalsIgnoreCase(params.getProperty("excludeantiaroma", "true")));
        this.setProtectDoubleBondStereo("true".equalsIgnoreCase(params.getProperty("protectdoublebondstereo", "false")));
        this.setProtectAllTetrahedralStereoCenters("true".equalsIgnoreCase(params.getProperty("protectalltetrahedralcenters", "false")));
        this.setProtectLabeledTetrahedralStereoCenters("true".equalsIgnoreCase(params.getProperty("protectlabeledtetrahedralcenters", "false")));
        this.setProtectEsterGroups("true".equalsIgnoreCase(params.getProperty("protectestergroups", "true")));
        String ringProp = params.getProperty("ring", "false");
        this.setRingChainTautomerizationAllowed("true".equalsIgnoreCase(ringProp));
    }

    public void setCleanResultStructures(boolean clean) {
        this.cleanResultStructures = clean;
    }

    public void setSymmetryFiltering(boolean filtering) {
        this.tautomerization.setSymmetryFiltering(filtering);
    }

    public void setMaxStructureCount(int max) {
        this.tautomerization.setMaxSpeciesCount(max);
    }

    public void setpH(double pH) {
        this.tautomerization.setpH(pH);
    }

    public void setMaximumTautomerizationPathLength(int length) {
        this.tautomerization.setTautomerPathLengthCriteria(length);
    }

    public void setProtectAromaticity(boolean pa) {
        this.tautomerization.protectAromaticity(pa);
    }

    public void setProtectCharge(boolean pc) {
        this.tautomerization.protectCharge(pc);
    }

    public void setExcludeAntiAromaticCompounds(boolean aa) {
        this.tautomerization.excludeAntiAroma(aa);
    }

    public void setProtectDoubleBondStereo(boolean protect) {
        this.tautomerization.setProtectDoubleBondStereo(protect);
    }

    public void setProtectAllTetrahedralStereoCenters(boolean protect) {
        this.tautomerization.setProtectAllTetrahedralStereoCenters(protect);
    }

    public void setProtectLabeledTetrahedralStereoCenters(boolean protect) {
        this.tautomerization.setProtectLabeledTetrahedralStereoCenters(protect);
    }

    public void setProtectEsterGroups(boolean protect) {
        this.tautomerization.setProtectEsterGroups(protect);
    }

    public void setRingChainTautomerizationAllowed(boolean allowed) {
        this.tautomerization.setRingChainTautomerizationAllowed(allowed);
    }

    public void setInputMoleculeModified(boolean inputMoleculeModified) {
        this.modifyInputStructure = inputMoleculeModified;
    }

    private boolean isInputMoleculeModified() {
        return this.modifyInputStructure;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (TautomerizationPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected Molecule createStandardizedMolecule(Molecule mol, boolean om) throws PluginException {
        return this.createStandardizedMolecule(mol);
    }

    @Override
    protected Molecule createStandardizedMolecule(Molecule mol) throws PluginException {
        this.inputMol = mol;
        boolean modify = this.isInputMoleculeModified();
        if (!modify) {
            mol = mol.cloneMoleculeWithDocument();
        }
        if (!this.handlesMultiFragmentMolecules() && mol.getFragCount() > 1) {
            MoleculeGraph[] frags = mol.findFrags(mol.getClass());
            MoleculeGraph frag = frags[0];
            int m = frag.getAtomCount();
            for (int i = 1; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= m) continue;
                frag = frags[i];
                m = frag.getAtomCount();
            }
            if (modify) {
                mol.clear();
                mol.fuse(frag);
            } else {
                mol = (Molecule)frag;
            }
        }
        this.standardize(mol);
        return mol;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.tautomerization.setMolecule(mol);
        this.tautomerization.setRowInputMolecule(this.inputMol);
    }

    void setTakePartialNeutralization(boolean pn) {
        this.partialNeutralization = pn;
    }

    public void setWigglyBondVisibility(boolean vis) {
        this.tautomerization.setWigglyBondVisibility(vis);
    }

    public void setTakeCanonicalForm(boolean canonical) {
        this.canonicTautomerCalculation = canonical;
    }

    public void setTakeStandardForm(boolean s) {
        this.standardTautomerCalculation = s;
    }

    public void setTakeGenericTautomer(boolean generic) {
        this.genericTautomerCalculation = generic;
    }

    public void setTakeMostStableTautomer(boolean mostStable) {
        this.setTakeMajorTautomer(mostStable);
    }

    public void setTakeMajorTautomer(boolean major) {
        this.majorTautomerCalculation = major;
    }

    public void setTakeDominantTautomers(boolean dominants) {
        this.tautomerization.setTakeDominantTautomers(dominants);
    }

    public void setDominantTautomerDistributionCalculation(boolean distrib) {
        this.dominantTautomerDistributionCalculation = distrib;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.canonicTautomerCalculation) {
            this.tautomerization.setParentOfCanonicalStructureConserved(this.isInputMoleculeModified());
            this.tautomerization.setPartialNeutralization(this.partialNeutralization);
            this.canonicTautomer = this.tautomerization.createCanonicTautomer();
            this.tautomerization.setParentOfCanonicalStructureConserved(false);
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        } else if (this.standardTautomerCalculation) {
            this.tautomerization.setParentOfCanonicalStructureConserved(this.isInputMoleculeModified());
            this.tautomerization.setPartialNeutralization(this.partialNeutralization);
            this.standardTautomer = this.tautomerization.createStandardTautomer();
            this.tautomerization.setParentOfCanonicalStructureConserved(false);
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        } else if (this.genericTautomerCalculation) {
            this.genericTautomer = this.tautomerization.createGenericTautomer();
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        } else if (this.majorTautomerCalculation || this.dominantTautomerDistributionCalculation) {
            this.tautomerization.calcDominantTautomerDistribution();
            this.majorTautomer = this.tautomerization.getTMolecule(0);
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        } else {
            this.tautomerization.createDACouples();
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        }
        return !this.criticalError;
    }

    public double getDominantTautomerDistribution(int index) {
        return this.tautomerization.getTauDistribution(index);
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new ResultSource(new ResultIterator(), this.getStructureCount());
    }

    public int getStructureCount() {
        return this.canonicTautomerCalculation || this.standardTautomerCalculation || this.genericTautomerCalculation || this.majorTautomerCalculation ? 1 : this.tautomerization.getTCount();
    }

    public Molecule getStructure(int index) {
        Molecule struc = null;
        struc = this.criticalError ? this.inputMol : (this.canonicTautomerCalculation ? this.canonicTautomer : (this.standardTautomerCalculation ? this.standardTautomer : (this.genericTautomerCalculation ? this.genericTautomer : (this.majorTautomerCalculation ? this.majorTautomer : this.tautomerization.getTMolecule(index)))));
        if (this.cleanResultStructures) {
            if (struc.getDim() == 0) {
                struc.clean(2, null);
            } else if (this.tautomerization.isRingChainTauotmerizationAllowed()) {
                if (struc.getDim() == 3) {
                    struc.clean(3, null);
                } else {
                    struc.clean(2, null);
                }
            } else if (this.tautomerization.getFixedAtomIndexesForPartialClean() != null) {
                if (struc.getDim() == 3) {
                    struc.partialClean(3, this.tautomerization.getFixedAtomIndexesForPartialClean(), null);
                } else {
                    struc.partialClean(2, this.tautomerization.getFixedAtomIndexesForPartialClean(), null);
                }
            }
        }
        return struc;
    }

    @Deprecated
    public Molecule[] getStructures() {
        Molecule[] mols = new Molecule[this.getStructureCount()];
        for (int i = 0; i < mols.length; ++i) {
            mols[i] = this.getStructure(i);
        }
        return mols;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structure") ? this.getStructureCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structure")) {
            return this.getStructure(index);
        }
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            return new Integer(this.getStructureCount());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("smiles");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("smiles"));
            }
            return new String(buffer);
        }
        if (result instanceof Integer) {
            return result.toString();
        }
        throw new PluginException("Result should be a molecule or integer object\ninstead of: " + result);
    }

    @Override
    public String getRemark() {
        return this.getStructureCount() == 0 ? WARNING : null;
    }

    @Override
    public String getErrorMessage() {
        return this.criticalError ? "Inconsistent molecular structure." : "";
    }

    protected String getTitle() {
        if (this.criticalError) {
            return "Input molecule";
        }
        if (this.canonicTautomerCalculation) {
            return "Canonical tautomer";
        }
        if (this.genericTautomerCalculation) {
            return "Generic tautomer";
        }
        if (this.majorTautomerCalculation) {
            return "Major tautomer";
        }
        return "Tautomers";
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups(0);
        TautomerizationPlugin.standardizeIonicGroups(mol);
        mol.aromatize(2);
    }

    @Override
    public boolean isMultiThreadedRunEnabled() {
        return false;
    }

    private class ResultSource
    extends PluginMDocSource {
        public ResultSource(Iterator iterator, int maxCount) {
            super(iterator, maxCount);
        }

        @Override
        public String getDocLabel(int k, MDocument doc) {
            if (!TautomerizationPlugin.this.dominantTautomerDistributionCalculation) {
                return String.valueOf(k + 1);
            }
            return "Tautomer: " + String.valueOf(k + 1) + "  Distribution: " + TautomerizationPlugin.this.format(TautomerizationPlugin.this.getDominantTautomerDistribution(k)) + " %";
        }
    }

    private class ResultIterator
    implements Iterator {
        private int currentCount = 0;

        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentCount < TautomerizationPlugin.this.getStructureCount();
        }

        public Object next() {
            if (this.hasNext()) {
                Molecule structure = TautomerizationPlugin.this.getStructure(this.currentCount);
                MDocument doc = CalculatorPlugin.getDocument(structure);
                if (TautomerizationPlugin.this.dominantTautomerDistributionCalculation) {
                    structure.setProperty(TautomerizationPlugin.this.dominantTautomerDistributionTag, TautomerizationPlugin.this.format(TautomerizationPlugin.this.getDominantTautomerDistribution(this.currentCount)));
                }
                ++this.currentCount;
                return doc;
            }
            return null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

