/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class TopologyAnalyserPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"aliphaticAtom", "aliphaticAtomCount", "aliphaticBondCount", "aliphaticRingCount", "aliphaticRingCountOfSize", "aliphaticRings", "aliphaticRingsOfSize", "aromaticAtom", "aromaticAtomCount", "aromaticBondCount", "aromaticRingCount", "aromaticRingCountOfSize", "aromaticRings", "aromaticRingsOfSize", "asymmetricAtom", "asymmetricAtomCount", "asymmetricAtoms", "atomCount", "balabanIndex", "bondCount", "bondType", "carboAliphaticRingCount", "carboAromaticRingCount", "carboRingCount", "carboRingCountOfSize", "carboRings", "carboRingsOfSize", "chainAtom", "chainAtomCount", "chainBond", "chainBondCount", "chiralCenter", "chiralCenterCount", "chiralCenters", "connected", "connectedGraph", "cyclomaticNumber", "distanceCount", "distanceDegree", "eccentricity", "fragmentCount", "fusedAliphaticRingCount", "fusedAliphaticRingCountOfSize", "fusedAliphaticRings", "fusedAliphaticRingsOfSize", "fusedAromaticRingCount", "fusedAromaticRingCountOfSize", "fusedAromaticRings", "fusedAromaticRingsOfSize", "fusedRingCount", "hararyIndex", "heteroaliphaticRingCount", "heteroaliphaticRingCountOfSize", "heteroaliphaticRings", "heteroaliphaticRingsOfSize", "heteroaromaticRingCount", "heteroaromaticRingCountOfSize", "heteroaromaticRings", "heteroaromaticRingsOfSize", "heteroRingCount", "heteroRingCountOfSize", "heteroRings", "heteroRingsOfSize", "hyperWienerIndex", "largestAtomRingSize", "largestRing", "largestRingSize", "largestRingSystem", "largestRingSystemSize", "plattIndex", "randicIndex", "ringAtom", "ringAtomCount", "ringBond", "ringBondCount", "ringCount", "ringCountOfAtom", "ringCountOfSize", "rings", "ringsOfSize", "ringSystemCount", "ringSystemCountOfSize", "ringSystems", "ringSystemsOfSize", "rotatableBond", "rotatableBondCount", "shortestpath", "smallestAtomRingSize", "smallestRing", "smallestRingSize", "smallestRingSystem", "smallestRingSystemSize", "stereoDoubleBondCount", "stericEffectIndex", "szegedIndex", "wienerIndex", "wienerPolarity"};
    private Object[] types = new Object[]{"atomcount", "aliphaticatomcount", "aromaticatomcount", "bondcount", "aliphaticbondcount", "aromaticbondcount", "rotatablebondcount", "fragmentcount", "ringcount", "aliphaticringcount", "aromaticringcount", "heteroringcount", "heteroaromaticringcount", "carboringcount", "carboaliphaticringcount", "carboaromaticringcount", "ringatomcount", "ringbondcount", "chainatomcount", "chainbondcount", "smallestringsize", "largestringsize", "fusedringcount", "fusedaliphaticringcount", "fusedaromaticringcount", "ringsystemcount", "largestringsystemsize", "smallestringsystemsize", "asymmetricatomcount", "chiralcentercount", "cyclomaticNumber", "plattIndex", "randicIndex", "balabanIndex", "distanceDegree", "eccentricity", "hararyIndex", "hyperWienerIndex", "szegedIndex", "wienerIndex", "wienerPolarity", "stericEffectIndex"};
    private static final String NO_TYPE_SELECTED_REMARK = "No calculation type selected in the options dialog.";
    private TopologyAnalyser topanal = new TopologyAnalyser();
    private boolean single = false;
    private int atom1 = -1;
    private int atom2 = -1;
    private int size;

    @Override
    public void setLicenseEnvironment(String env) {
        super.setLicenseEnvironment(env);
        this.topanal.setLicenseEnvironment(this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Geometry Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String atoms;
        this.single = "true".equalsIgnoreCase(params.getProperty("single"));
        String chtypes = params.getProperty("type");
        String chtypesK = params.getProperty("type1");
        int k = 1;
        while (chtypesK != null) {
            chtypes = chtypes == null ? chtypesK : chtypes + "," + chtypesK;
            chtypesK = params.getProperty("type" + ++k);
        }
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toLowerCase();
                token = TopologyAnalyserPlugin.removeWhitespace(token);
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        if ((atoms = params.getProperty("atoms")) != null) {
            this.setAtoms(atoms);
        }
        this.setSize(Integer.parseInt(params.getProperty("size", "0")));
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    private void setAtoms(String atoms) throws PluginException {
        int[] a = StringUtil.parseInts(atoms);
        if (a.length != 2) {
            throw new PluginException("Invalid atoms format: " + atoms + "\nUse format: <atom1-atom2>, e.g. 2-4");
        }
        this.atom1 = a[0] - 1;
        this.atom2 = a[1] - 1;
    }

    private void setSize(int size) {
        this.size = size;
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return !this.single;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (TopologyAnalyserPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.topanal.setMolecule(mol);
    }

    public int getAllAtomCount() {
        return this.topanal.atomCount();
    }

    public int getAliphaticAtomCount() {
        return this.topanal.aliphaticAtomCount();
    }

    public int getAromaticAtomCount() {
        return this.topanal.aromaticAtomCount();
    }

    public int getBondCount() {
        return this.topanal.bondCount();
    }

    public int getAliphaticBondCount() {
        return this.topanal.aliphaticBondCount();
    }

    public int getAromaticBondCount() {
        return this.topanal.aromaticBondCount();
    }

    public int getFragmentCount() {
        return this.topanal.fragmentCount();
    }

    public int getRingCount() {
        return this.topanal.ringCount();
    }

    public int getAliphaticRingCount() {
        return this.topanal.aliphaticRingCount();
    }

    public int getAliphaticRingCount(int size) {
        return this.topanal.aliphaticRingCount(size);
    }

    public int getAliphaticRingCountOfSize(int size) {
        return this.topanal.aliphaticRingCount(size);
    }

    public int[][] getAliphaticRings() {
        return this.topanal.aliphaticRings();
    }

    public int[][] getAliphaticRings(int size) {
        return this.topanal.aliphaticRings(size);
    }

    public int getAromaticRingCount() {
        return this.topanal.aromaticRingCount();
    }

    public int getAromaticRingCount(int size) {
        return this.topanal.aromaticRingCount(size);
    }

    public int getAromaticRingCountOfSize(int size) {
        return this.topanal.aromaticRingCount(size);
    }

    public int[][] getAromaticRings() {
        return this.topanal.aromaticRings();
    }

    public int[][] getAromaticRings(int size) {
        return this.topanal.aromaticRings(size);
    }

    public int getHeteroRingCount() {
        return this.topanal.heteroRingCount();
    }

    public int getHeteroRingCount(int size) {
        return this.topanal.heteroRingCount(size);
    }

    public int[][] getHeteroRings() {
        return this.topanal.heteroRings();
    }

    public int[][] getHeteroRings(int size) {
        return this.topanal.heteroRings(size);
    }

    public int getHeteroaliphaticRingCount() {
        return this.topanal.heteroaliphaticRingCount();
    }

    public int getHeteroaliphaticRingCount(int size) {
        return this.topanal.heteroaliphaticRingCount(size);
    }

    public int[][] getHeteroaliphaticRings() {
        return this.topanal.heteroaliphaticRings();
    }

    public int[][] getHeteroaliphaticRings(int size) {
        return this.topanal.heteroaliphaticRings(size);
    }

    public int getHeteroaromaticRingCount() {
        return this.topanal.heteroaromaticRingCount();
    }

    public int getHeteroaromaticRingCount(int size) {
        return this.topanal.heteroaromaticRingCount(size);
    }

    public int[][] getHeteroaromaticRings() {
        return this.topanal.heteroaromaticRings();
    }

    public int[][] getHeteroaromaticRings(int size) {
        return this.topanal.heteroaromaticRings(size);
    }

    public int getCarboRingCount() {
        return this.topanal.carboRingCount();
    }

    public int getCarboRingCount(int size) {
        return this.topanal.carboRingCount(size);
    }

    public int[][] getCarboRings() {
        return this.topanal.carboRings();
    }

    public int[][] getCarboRings(int size) {
        return this.topanal.carboRings(size);
    }

    public int getCarboaliphaticRingCount() {
        return this.topanal.carboaliphaticRingCount();
    }

    public int getCarboaromaticRingCount() {
        return this.topanal.carboaromaticRingCount();
    }

    public int getRingAtomCount() {
        return this.topanal.ringAtomCount();
    }

    public int getRingBondCount() {
        return this.topanal.ringBondCount();
    }

    public int getChainAtomCount() {
        return this.topanal.chainAtomCount();
    }

    public int getChainBondCount() {
        return this.topanal.chainBondCount();
    }

    public int getRotatableBondCount() {
        return this.topanal.rotatableBondCount();
    }

    public int getSmallestRingSize() {
        return this.topanal.smallestRingSize();
    }

    public int getLargestRingSize() {
        return this.topanal.largestRingSize();
    }

    public int getFusedRingCount() {
        return this.topanal.fusedRingCount();
    }

    public int getFusedAliphaticRingCount() {
        return this.topanal.fusedAliphaticRingCount();
    }

    public int getFusedAliphaticRingCount(int size) {
        return this.topanal.fusedAliphaticRingCount(size);
    }

    public int[][] getFusedAliphaticRings() {
        return this.topanal.fusedAliphaticRings();
    }

    public int[][] getFusedAliphaticRings(int size) {
        return this.topanal.fusedAliphaticRings(size);
    }

    public int getFusedAromaticRingCount() {
        return this.topanal.fusedAromaticRingCount();
    }

    public int getFusedAromaticRingCount(int size) {
        return this.topanal.fusedAromaticRingCount(size);
    }

    public int[][] getFusedAromaticRings() {
        return this.topanal.fusedAromaticRings();
    }

    public int[][] getFusedAromaticRings(int size) {
        return this.topanal.fusedAromaticRings(size);
    }

    public int getRingSystemCount() {
        return this.topanal.ringSystemCount();
    }

    public int getRingSystemCount(int size) {
        return this.topanal.ringSystemCount(size);
    }

    public int getRingSystemCountOfSize(int size) {
        return this.topanal.ringSystemCount(size);
    }

    public int[] getLargestRing() {
        return this.topanal.largestRing();
    }

    public int[] getLargestRingSystem() {
        return this.topanal.largestRingSystem();
    }

    public int getLargestRingSystemSize() {
        return this.topanal.largestRingSystemSize();
    }

    public int getSmallestRingSystemSize() {
        return this.topanal.smallestRingSystemSize();
    }

    public boolean isAromaticAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isAromaticAtom(index);
    }

    public boolean isAliphaticAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isAliphaticAtom(index);
    }

    public boolean isChainAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isChainAtom(index);
    }

    public boolean isRingAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isRingAtom(index);
    }

    public int getSmallestRingSizeOfAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return 0;
        }
        return this.topanal.smallestRingSizeOfAtom(index);
    }

    public int getLargestRingSizeOfAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return 0;
        }
        return this.topanal.largestRingSizeOfAtom(index);
    }

    public int getCyclomaticNumber() {
        return this.topanal.cyclomaticNumber();
    }

    public int getAsymmetricAtomCount() {
        return this.topanal.asymmetricAtomCount();
    }

    public int[] getAsymmetricAtoms() {
        return this.topanal.asymmetricAtoms();
    }

    public boolean isAsymmetricAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isAsymmetricAtom(index);
    }

    public int getChiralCenterCount() {
        return this.topanal.chiralCenterCount();
    }

    public int[] getChiralCenters() {
        return this.topanal.chiralCenters();
    }

    public boolean isChiralCenter(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return false;
        }
        return this.topanal.isChiralCenter(index);
    }

    public String getStereo(int a) {
        return this.topanal.stereo(a);
    }

    public String getStereo(int a1, int a2) {
        return this.topanal.stereo(a1, a2);
    }

    public int getStereoDoubleBondCount() {
        return this.topanal.stereoDoubleBondCount();
    }

    public int getShortestPath(int index1, int index2) {
        index1 = this.getAtomIndex(index1);
        index2 = this.getAtomIndex(index2);
        return this.topanal.shortestPath(index1, index2);
    }

    public boolean isConnected(int index1, int index2) {
        index1 = this.getAtomIndex(index1);
        index2 = this.getAtomIndex(index2);
        return this.topanal.isConnected(index1, index2);
    }

    public int getPlattIndex() {
        return this.topanal.plattIndex();
    }

    public double getRandicIndex() {
        return this.topanal.randicIndex();
    }

    public double getBalabanIndex() {
        return this.topanal.balabanIndex();
    }

    public int getDistanceDegree(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.topanal.distanceDegree(index);
    }

    public int getEccentricity(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.topanal.eccentricity(index);
    }

    public double getHararyIndex() {
        return this.topanal.hararyIndex();
    }

    public int getHyperWienerIndex() {
        return this.topanal.hyperWienerIndex();
    }

    public int getSzegedIndex() {
        return this.topanal.szegedIndex();
    }

    public int getWienerIndex() {
        return this.topanal.wienerIndex();
    }

    public int getWienerPolarity() {
        return this.topanal.wienerPolarity();
    }

    public double getStericEffectIndex(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.topanal.stericEffectIndex(index);
    }

    public int getBondType(int index) {
        return this.topanal.bondType(index);
    }

    public int getDistanceCount(int index, int distance) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.topanal.distanceCount(index, distance);
    }

    public boolean isRingBond(int index) {
        return this.topanal.isRingBond(index);
    }

    public boolean isChainBond(int index) {
        return this.topanal.isChainBond(index);
    }

    public boolean isConnectedGraph() {
        return this.topanal.isConnected();
    }

    public boolean isRotatableBond(int index) {
        return this.topanal.isRotatableBond(index);
    }

    public int getRingCountOfAtom(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return -1;
        }
        return this.topanal.ringCountOfAtom(index);
    }

    public int getRingCount(int size) {
        return this.topanal.ringCount(size);
    }

    public int getRingCountOfSize(int size) {
        return this.topanal.ringCount(size);
    }

    public int[][] getRings() {
        return this.topanal.rings();
    }

    public int[][] getRings(int size) {
        return this.topanal.rings(size);
    }

    public int[][] getRingSystems() {
        return this.topanal.ringSystems();
    }

    public int[][] getRingSystems(int size) {
        return this.topanal.ringSystems(size);
    }

    public int[] getSmallestRing() {
        return this.topanal.smallestRing();
    }

    public int[] getSmallestRingSystem() {
        return this.topanal.smallestRingSystem();
    }

    public int getBondIndex(int i1, int i2) {
        BondTable btab = this.topanal.getMolecule().getBondTable();
        return btab.getBondIndex(i1, i2);
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("aliphaticAtom")) {
            return new Boolean(this.isAliphaticAtom(index));
        }
        if (typestr.equalsIgnoreCase("aliphaticAtomCount")) {
            return new Integer(this.getAliphaticAtomCount());
        }
        if (typestr.equalsIgnoreCase("aliphaticBondCount")) {
            return new Integer(this.getAliphaticBondCount());
        }
        if (typestr.equalsIgnoreCase("aliphaticRingCount")) {
            return new Integer(this.getAliphaticRingCount());
        }
        if (typestr.equalsIgnoreCase("aliphaticRingCountOfSize")) {
            return new Integer(this.getAliphaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("aliphaticRings")) {
            return this.getAliphaticRings();
        }
        if (typestr.equalsIgnoreCase("aliphaticRingsOfSize")) {
            return this.getAliphaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("aromaticAtom")) {
            return new Boolean(this.isAromaticAtom(index));
        }
        if (typestr.equalsIgnoreCase("aromaticAtomCount")) {
            return new Integer(this.getAromaticAtomCount());
        }
        if (typestr.equalsIgnoreCase("aromaticBondCount")) {
            return new Integer(this.getAromaticBondCount());
        }
        if (typestr.equalsIgnoreCase("aromaticRingCount")) {
            return new Integer(this.getAromaticRingCount());
        }
        if (typestr.equalsIgnoreCase("aromaticRingCountOfSize")) {
            return new Integer(this.getAromaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("aromaticRings")) {
            return this.getAromaticRings();
        }
        if (typestr.equalsIgnoreCase("aromaticRingsOfSize")) {
            return this.getAromaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("asymmetricAtom")) {
            return new Boolean(this.isAsymmetricAtom(index));
        }
        if (typestr.equalsIgnoreCase("asymmetricAtomCount")) {
            return new Integer(this.getAsymmetricAtomCount());
        }
        if (typestr.equalsIgnoreCase("asymmetricAtoms")) {
            return this.getAsymmetricAtoms();
        }
        if (typestr.equalsIgnoreCase("atomCount")) {
            return new Integer(this.getAllAtomCount());
        }
        if (typestr.equalsIgnoreCase("balabanIndex")) {
            return new Double(this.getBalabanIndex());
        }
        if (typestr.equalsIgnoreCase("bondCount")) {
            return new Integer(this.getBondCount());
        }
        if (typestr.equalsIgnoreCase("bondType")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Bond atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            index = this.getBondIndex(this.atom1, this.atom2);
            if (index == -1) {
                return new Integer(-1);
            }
            return new Integer(this.getBondType(index));
        }
        if (typestr.equalsIgnoreCase("carboAliphaticRingCount")) {
            return new Integer(this.getCarboaliphaticRingCount());
        }
        if (typestr.equalsIgnoreCase("carboAromaticRingCount")) {
            return new Integer(this.getCarboaromaticRingCount());
        }
        if (typestr.equalsIgnoreCase("carboRingCount")) {
            return new Integer(this.getCarboRingCount());
        }
        if (typestr.equalsIgnoreCase("carboRingCountOfSize")) {
            return new Integer(this.getCarboRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("carboRings")) {
            return this.getCarboRings();
        }
        if (typestr.equalsIgnoreCase("carboRingsOfSize")) {
            return this.getCarboRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("chainAtom")) {
            return new Boolean(this.isChainAtom(index));
        }
        if (typestr.equalsIgnoreCase("chainAtomCount")) {
            return new Integer(this.getChainAtomCount());
        }
        if (typestr.equalsIgnoreCase("chainBond")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Bond atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            index = this.getBondIndex(this.atom1, this.atom2);
            if (index == -1) {
                return Boolean.FALSE;
            }
            return new Boolean(this.isChainBond(index));
        }
        if (typestr.equalsIgnoreCase("chainBondCount")) {
            return new Integer(this.getChainBondCount());
        }
        if (typestr.equalsIgnoreCase("chiralCenter")) {
            return new Boolean(this.isChiralCenter(index));
        }
        if (typestr.equalsIgnoreCase("chiralCenterCount")) {
            return new Integer(this.getChiralCenterCount());
        }
        if (typestr.equalsIgnoreCase("chiralCenters")) {
            return this.getChiralCenters();
        }
        if (typestr.equalsIgnoreCase("connected")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            return new Boolean(this.isConnected(this.atom1, this.atom2));
        }
        if (typestr.equalsIgnoreCase("connectedGraph")) {
            return new Boolean(this.isConnectedGraph());
        }
        if (typestr.equalsIgnoreCase("cyclomaticNumber")) {
            return new Integer(this.getCyclomaticNumber());
        }
        if (typestr.equalsIgnoreCase("distanceDegree")) {
            return new Integer(this.getDistanceDegree(index));
        }
        if (typestr.equalsIgnoreCase("eccentricity")) {
            return new Integer(this.getEccentricity(index));
        }
        if (typestr.equalsIgnoreCase("fragmentCount")) {
            return new Integer(this.getFragmentCount());
        }
        if (typestr.equalsIgnoreCase("fusedAliphaticRingCount")) {
            return new Integer(this.getFusedAliphaticRingCount());
        }
        if (typestr.equalsIgnoreCase("fusedAliphaticRingCountOfSize")) {
            return new Integer(this.getFusedAliphaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("fusedAliphaticRings")) {
            return this.getFusedAliphaticRings();
        }
        if (typestr.equalsIgnoreCase("fusedAliphaticRingsOfSize")) {
            return this.getFusedAliphaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("fusedAromaticRingCount")) {
            return new Integer(this.getFusedAromaticRingCount());
        }
        if (typestr.equalsIgnoreCase("fusedAromaticRingCountOfSize")) {
            return new Integer(this.getFusedAromaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("fusedAromaticRings")) {
            return this.getFusedAromaticRings();
        }
        if (typestr.equalsIgnoreCase("fusedAromaticRingsOfSize")) {
            return this.getFusedAromaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("fusedRingCount")) {
            return new Integer(this.getFusedRingCount());
        }
        if (typestr.equalsIgnoreCase("hararyIndex")) {
            return new Double(this.getHararyIndex());
        }
        if (typestr.equalsIgnoreCase("heteroaliphaticRingCount")) {
            return new Integer(this.getHeteroaliphaticRingCount());
        }
        if (typestr.equalsIgnoreCase("heteroaliphaticRingCountOfSize")) {
            return new Integer(this.getHeteroaliphaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("heteroaliphaticRings")) {
            return this.getHeteroaliphaticRings();
        }
        if (typestr.equalsIgnoreCase("heteroaliphaticRingsOfSize")) {
            return this.getHeteroaliphaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("heteroaromaticRingCount")) {
            return new Integer(this.getHeteroaromaticRingCount());
        }
        if (typestr.equalsIgnoreCase("heteroaromaticRingCountOfSize")) {
            return new Integer(this.getHeteroaromaticRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("heteroaromaticRings")) {
            return this.getHeteroaromaticRings();
        }
        if (typestr.equalsIgnoreCase("heteroaromaticRingsOfSize")) {
            return this.getHeteroaromaticRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("heteroRingCount")) {
            return new Integer(this.getHeteroRingCount());
        }
        if (typestr.equalsIgnoreCase("heteroRingCountOfSize")) {
            return new Integer(this.getHeteroRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("heteroRings")) {
            return this.getHeteroRings();
        }
        if (typestr.equalsIgnoreCase("heteroRingsOfSize")) {
            return this.getHeteroRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("hyperWienerIndex")) {
            return new Integer(this.getHyperWienerIndex());
        }
        if (typestr.equalsIgnoreCase("largestAtomRingSize")) {
            return new Integer(this.getLargestRingSizeOfAtom(index));
        }
        if (typestr.equalsIgnoreCase("largestRing")) {
            return this.getLargestRing();
        }
        if (typestr.equalsIgnoreCase("largestRingSize")) {
            return new Integer(this.getLargestRingSize());
        }
        if (typestr.equalsIgnoreCase("largestRingSystem")) {
            return this.getLargestRingSystem();
        }
        if (typestr.equalsIgnoreCase("largestRingSystemSize")) {
            return new Integer(this.getLargestRingSystemSize());
        }
        if (typestr.equalsIgnoreCase("plattIndex")) {
            return new Integer(this.getPlattIndex());
        }
        if (typestr.equalsIgnoreCase("randicIndex")) {
            return new Double(this.getRandicIndex());
        }
        if (typestr.equalsIgnoreCase("ringAtom")) {
            return new Boolean(this.isRingAtom(index));
        }
        if (typestr.equalsIgnoreCase("ringAtomCount")) {
            return new Integer(this.getRingAtomCount());
        }
        if (typestr.equalsIgnoreCase("ringBond")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Bond atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            index = this.getBondIndex(this.atom1, this.atom2);
            if (index == -1) {
                return Boolean.FALSE;
            }
            return new Boolean(this.isRingBond(index));
        }
        if (typestr.equalsIgnoreCase("ringBondCount")) {
            return new Integer(this.getRingBondCount());
        }
        if (typestr.equalsIgnoreCase("ringCount")) {
            return new Integer(this.getRingCount());
        }
        if (typestr.equalsIgnoreCase("ringCountOfAtom")) {
            return new Integer(this.getRingCountOfAtom(index));
        }
        if (typestr.equalsIgnoreCase("ringCountOfSize")) {
            return new Integer(this.getRingCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("rings")) {
            return this.getRings();
        }
        if (typestr.equalsIgnoreCase("ringsOfSize")) {
            return this.getRings(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("ringSystemCount")) {
            return new Integer(this.getRingSystemCount());
        }
        if (typestr.equalsIgnoreCase("ringSystemCountOfSize")) {
            return new Integer(this.getRingSystemCount(this.size(index, this.size)));
        }
        if (typestr.equalsIgnoreCase("ringSystems")) {
            return this.getRingSystems();
        }
        if (typestr.equalsIgnoreCase("ringSystemsOfSize")) {
            return this.getRingSystems(this.size(index, this.size));
        }
        if (typestr.equalsIgnoreCase("rotatableBond")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Bond atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            index = this.getBondIndex(this.atom1, this.atom2);
            if (index == -1) {
                return Boolean.FALSE;
            }
            return new Boolean(this.isRotatableBond(index));
        }
        if (typestr.equalsIgnoreCase("rotatableBondCount")) {
            return new Integer(this.getRotatableBondCount());
        }
        if (typestr.equalsIgnoreCase("shortestpath")) {
            if (this.atom1 < 0 || this.atom2 < 0) {
                throw new PluginException("Atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
            }
            return new Integer(this.getShortestPath(this.atom1, this.atom2));
        }
        if (typestr.equalsIgnoreCase("smallestAtomRingSize")) {
            return new Integer(this.getSmallestRingSizeOfAtom(index));
        }
        if (typestr.equalsIgnoreCase("smallestRing")) {
            return this.getSmallestRing();
        }
        if (typestr.equalsIgnoreCase("smallestRingSize")) {
            return new Integer(this.getSmallestRingSize());
        }
        if (typestr.equalsIgnoreCase("smallestRingSystem")) {
            return this.getSmallestRingSystem();
        }
        if (typestr.equalsIgnoreCase("smallestringsystemsize")) {
            return new Integer(this.getSmallestRingSystemSize());
        }
        if (typestr.equalsIgnoreCase("stereoDoubleBondCount")) {
            return new Integer(this.getStereoDoubleBondCount());
        }
        if (typestr.equalsIgnoreCase("stericEffectIndex")) {
            return new Double(this.getStericEffectIndex(index));
        }
        if (typestr.equalsIgnoreCase("szegedIndex")) {
            return new Integer(this.getSzegedIndex());
        }
        if (typestr.equalsIgnoreCase("wienerIndex")) {
            return new Integer(this.getWienerIndex());
        }
        if (typestr.equalsIgnoreCase("wienerPolarity")) {
            return new Integer(this.getWienerPolarity());
        }
        throw new PluginException("Unknown type: " + type);
    }

    private int size(int index, int size) throws PluginException {
        if (index != 0 && size == 0) {
            size = index;
        }
        if (size < 0) {
            throw new PluginException("Invalid ring size: " + size);
        }
        return size;
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        this.setAtoms(arg);
        if (this.atom1 < 0 || this.atom2 < 0) {
            throw new PluginException("Atoms are not set:\natom1=" + this.atom1 + ", atom2=" + this.atom2);
        }
        return this.getResult(type, 0);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result == null) {
            return "";
        }
        if (result instanceof Integer) {
            if ((Integer)result == Integer.MAX_VALUE) {
                return this.format(Double.POSITIVE_INFINITY);
            }
        } else {
            if (result instanceof Double) {
                double x = (Double)result;
                return this.format(x);
            }
            if (result instanceof int[]) {
                StringBuffer s = new StringBuffer();
                int[] a = (int[])result;
                for (int i = 0; i < a.length; ++i) {
                    if (i > 0) {
                        s.append(";");
                    }
                    s.append(a[i]);
                }
                return new String(s);
            }
        }
        return result.toString();
    }

    @Override
    public int getResultCount(Object type) {
        return this.getResultDomain(type) == 1 ? this.getAtomCount() : 1;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("aromaticAtom") || typestr.equalsIgnoreCase("aliphaticAtom") || typestr.equalsIgnoreCase("chainAtom") || typestr.equalsIgnoreCase("ringAtom") || typestr.equalsIgnoreCase("asymmetricAtom") || typestr.equalsIgnoreCase("chiralCenter") || typestr.equalsIgnoreCase("largestAtomRingSize") || typestr.equalsIgnoreCase("smallestAtomRingSize") || typestr.equalsIgnoreCase("distanceDegree") || typestr.equalsIgnoreCase("eccentricity") || typestr.equalsIgnoreCase("stericEffectIndex")) {
            return 1;
        }
        return 2;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("atomcount")) {
            return "Atom count";
        }
        if (typestr.equals("aliphaticatomcount")) {
            return "Aliphatic atom count";
        }
        if (typestr.equals("aromaticatomcount")) {
            return "Aromatic atom count";
        }
        if (typestr.equals("bondcount")) {
            return "Bond count";
        }
        if (typestr.equals("aliphaticbondcount")) {
            return "Aliphatic bond count";
        }
        if (typestr.equals("aromaticbondcount")) {
            return "Aromatic bond count";
        }
        if (typestr.equals("rotatablebondcount")) {
            return "Rotatable bond count";
        }
        if (typestr.equals("fragmentcount")) {
            return "Fragment count";
        }
        if (typestr.equals("ringcount")) {
            return "Ring count";
        }
        if (typestr.equals("aliphaticringcount")) {
            return "Aliphatic ring count";
        }
        if (typestr.equals("aliphaticringcountofsize")) {
            return "Aliphatic ring count of size";
        }
        if (typestr.equals("aromaticringcount")) {
            return "Aromatic ring count";
        }
        if (typestr.equals("aromaticringcountofsize")) {
            return "Aromatic ring count of size";
        }
        if (typestr.equals("heteroringcount")) {
            return "Hetero ring count";
        }
        if (typestr.equals("heteroaliphaticringcount")) {
            return "Heteroaliphatic ring count";
        }
        if (typestr.equals("heteroaromaticringcount")) {
            return "Heteroaromatic ring count";
        }
        if (typestr.equals("carboringcount")) {
            return "Carbo ring count";
        }
        if (typestr.equals("carboaliphaticringcount")) {
            return "Carboaliphatic ring count";
        }
        if (typestr.equals("carboaromaticringcount")) {
            return "Carboaromatic ring count";
        }
        if (typestr.equals("ringatomcount")) {
            return "Ring atom count";
        }
        if (typestr.equals("ringbondcount")) {
            return "Ring bond count";
        }
        if (typestr.equals("chainatomcount")) {
            return "Chain atom count";
        }
        if (typestr.equals("chainbondcount")) {
            return "Chain bond count";
        }
        if (typestr.equals("smallestringsize")) {
            return "Smallest ring size";
        }
        if (typestr.equals("largestringsize")) {
            return "Largest ring size";
        }
        if (typestr.equals("fusedringcount")) {
            return "Fused ring count";
        }
        if (typestr.equals("fusedaliphaticringcount")) {
            return "Fused aliphatic ring count";
        }
        if (typestr.equals("fusedaromaticringcount")) {
            return "Fused aromatic ring count";
        }
        if (typestr.equals("ringsystemcount")) {
            return "Ring system count";
        }
        if (typestr.equals("ringsystemcountofsize")) {
            return "Ring system count of size";
        }
        if (typestr.equals("largestringsystemsize")) {
            return "Largest ring system size";
        }
        if (typestr.equals("smallestringsystemsize")) {
            return "Smallest ring system size";
        }
        if (typestr.equals("asymmetricatomcount")) {
            return "Asymmetric atom count";
        }
        if (typestr.equals("asymmetricatoms")) {
            return "Asymmetric atoms";
        }
        if (typestr.equals("chiralcentercount")) {
            return "Chiral center count";
        }
        if (typestr.equals("chiralcenters")) {
            return "Chiral centers";
        }
        if (typestr.equals("stereodoublebondcount")) {
            return "Stereo double bond count";
        }
        if (typestr.equals("cyclomaticnumber")) {
            return "Cyclomatic number";
        }
        if (typestr.equals("aromaticatom")) {
            return "Aromatic atom";
        }
        if (typestr.equals("chainatom")) {
            return "Chain atom";
        }
        if (typestr.equals("ringatom")) {
            return "Ring atom";
        }
        if (typestr.equals("asymmetricatom")) {
            return "Asymmetric atom";
        }
        if (typestr.equals("chiralcenter")) {
            return "Chiral center";
        }
        if (typestr.equals("plattindex")) {
            return "Platt index";
        }
        if (typestr.equals("randicindex")) {
            return "Randic index";
        }
        if (typestr.equals("balabanindex")) {
            return "Balaban index";
        }
        if (typestr.equals("distancedegree")) {
            return "Distance degree";
        }
        if (typestr.equals("eccentricity")) {
            return "Eccentricity";
        }
        if (typestr.equals("hararyindex")) {
            return "Harary index";
        }
        if (typestr.equals("hyperwienerindex")) {
            return "Hyper wiener index";
        }
        if (typestr.equals("szegedindex")) {
            return "Szeged index";
        }
        if (typestr.equals("wienerindex")) {
            return "Wiener index";
        }
        if (typestr.equals("wienerpolarity")) {
            return "Wiener polarity";
        }
        if (typestr.equals("stericeffectindex")) {
            return "Steric effect index";
        }
        if (typestr.equals("smallestatomringsize")) {
            return "Smallest ring size of atom";
        }
        if (typestr.equals("largestatomringsize")) {
            return "Largest ring size of atom";
        }
        if (typestr.equals("shortestpath")) {
            return "Shortest path";
        }
        if (typestr.equals("connected")) {
            return "Connected";
        }
        if (typestr.equals("aliphaticatom")) {
            return "Aliphatic atom";
        }
        if (typestr.equals("connectedgraph")) {
            return "Connected graph";
        }
        if (typestr.equals("bondtype")) {
            return "Bond type";
        }
        if (typestr.equals("distancecount")) {
            return "Distance count";
        }
        if (typestr.equals("chainbond")) {
            return "Chain bond";
        }
        if (typestr.equals("ringbond")) {
            return "Ring bond";
        }
        if (typestr.equals("rotatablebond")) {
            return "Rotatable bond";
        }
        if (typestr.equals("ringcountofsize")) {
            return "Ring count of size";
        }
        if (typestr.equals("ringcountofatom")) {
            return "Ring count of atom";
        }
        return type.toString();
    }

    @Override
    public boolean run() throws PluginException {
        return true;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) != 2) continue;
            Object result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol.getPropertyCount() > 0 ? mol : null;
    }

    @Override
    public Molecule[] getResultMolecules() throws PluginException {
        ArrayList<Molecule> list = new ArrayList<Molecule>();
        Molecule mol = this.getResultMolecule();
        if (mol != null) {
            list.add(mol);
        }
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) != 1) continue;
            mol = this.getDisplayMolecule();
            mol.setProperty(type.toString(), "");
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                Object result = this.getResult(type, i);
                String label = this.getResultAsString(type, i, result);
                mol.getAtom(i).setExtraLabel(label);
            }
            list.add(mol);
        }
        if (list.size() == 0) {
            return null;
        }
        Molecule[] mols = new Molecule[list.size()];
        list.toArray(mols);
        return mols;
    }

    @Override
    public String getRemark() {
        return this.types == null || this.types.length == 0 ? NO_TYPE_SELECTED_REMARK : null;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
    }
}

