/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.logDPlugin;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.ResultView;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.util.ArrayList;

public class logDPluginDisplay
extends CalculatorPluginDisplay {
    private ArrayList reflogDList = null;
    private ArrayList logDList = null;

    @Override
    public void pop() {
        super.pop();
        if (this.reflogDList != null && this.reflogDList.size() > 0) {
            this.reflogDList.remove(this.reflogDList.size() - 1);
        }
        if (this.logDList != null && this.logDList.size() > 0) {
            this.logDList.remove(this.logDList.size() - 1);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.reflogDList != null) {
            this.reflogDList.clear();
        }
        if (this.logDList != null) {
            this.logDList.clear();
        }
    }

    @Override
    public void store() throws PluginException {
        logDPlugin plugin = (logDPlugin)this.getPlugin();
        Molecule mol = plugin.getImageMolecule();
        if (mol != null) {
            if (this.resultMolList == null) {
                this.resultMolList = new ArrayList();
            }
            this.resultMolList.add(mol);
            if (this.reflogDList == null) {
                this.reflogDList = new ArrayList();
            }
            this.reflogDList.add(plugin.getReflogDs());
            if (this.logDList == null) {
                this.logDList = new ArrayList();
            }
            this.logDList.add(plugin.getlogDs());
        }
    }

    @Override
    public Component getResultComponent() throws PluginException {
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        logDPlugin plugin = (logDPlugin)this.getPlugin();
        MolPanel mpan = this.parent instanceof MolPanel ? (MolPanel)this.parent : null;
        ResultView view = this.createResultView("logD", mpan);
        int count = this.resultMolList.size();
        String header = "| pH";
        if (count == 1) {
            header = header + "|logD";
        } else {
            for (int i = 1; i <= count; ++i) {
                header = header + "|logD" + i;
            }
        }
        double[][] reflogDs = new double[this.reflogDList.size()][];
        this.reflogDList.toArray((T[])reflogDs);
        double[][] logDs = new double[this.logDList.size()][];
        this.logDList.toArray((T[])logDs);
        double[] refpHs = plugin.getRefpHs();
        double[] pHs = plugin.getpHs();
        String[] refpHlabels = this.getLabels(refpHs);
        String[] pHlabels = this.getLabels(pHs);
        view.setTopTextArea(this.getTableText(header, refpHlabels, reflogDs));
        view.setBottomTextArea(this.getTableText(header, pHlabels, logDs));
        view.setMenu(new String[]{"logD at reference pH's", "Open Viewer"});
        MarvinModule chart = (MarvinModule)MarvinModule.load("MChart", null);
        if (chart != null) {
            chart.modfunc(new Object[]{"setTitle", "logD"});
            chart.modfunc(new Object[]{"setSampleLabels", pHlabels});
            chart.modfunc(new Object[]{"setSampleValues", logDs});
            chart.modfunc(new Object[]{"setRange", new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}});
            Molecule[] legendmols = new Molecule[count];
            this.resultMolList.toArray(legendmols);
            chart.modfunc(new Object[]{"setLegendImages", legendmols});
            chart.modfunc(new Object[]{"setSampleHighlightOn", new Boolean(false)});
            view.setChart(chart);
        } else {
            System.err.println("Could not load chart.jar.");
        }
        view.build();
        return view;
    }
}

