/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.Calculator;
import chemaxon.marvin.calculations.logPPlugin;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class logPPluginOutput
extends CalculatorPluginOutput {
    @Override
    public Properties getPluginParameters() throws PluginException {
        Properties pluginParams = (Properties)this.params.clone();
        if ("true".equalsIgnoreCase(this.params.getProperty("increments"))) {
            String type = this.params.getProperty("type");
            if (type.indexOf("logPMicro") != -1 && type.indexOf("logPTrue") != -1) {
                throw new PluginException("Atomic values are defined for single type only.", 3);
            }
            if (type.indexOf("increments") == -1) {
                type = type + ",increments";
                pluginParams.put("type", type);
            }
        }
        return pluginParams;
    }

    @Override
    public String getHeader() {
        StringBuffer s = new StringBuffer();
        Object[] types = ((logPPlugin)this.plugin).getUserTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            s.append(this.plugin.getTypeString(types[i]));
            if (!this.needError()) continue;
            s.append(this.separator);
            s.append("error");
        }
        return new String(s);
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        StringBuffer s = new StringBuffer();
        Object[] types = ((logPPlugin)this.plugin).getUserTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            Object type = types[i];
            int r = this.plugin.getResultCount(type);
            for (int j = 0; j < r; ++j) {
                if (j > 0) {
                    s.append(";");
                }
                Object result = this.plugin.getResult(type, j);
                String rtext = this.plugin.getResultAsString(type, j, result);
                s.append(rtext);
                if (!this.needError()) continue;
                s.append(this.separator);
                double error = ((logPPlugin)this.plugin).getStandardError(type, j);
                s.append(Double.isNaN(error) ? "" : this.plugin.format(error));
            }
        }
        return new String(s);
    }

    @Override
    public double getSpecResult(Molecule target, String arg) throws PluginException {
        Calculator.runPlugin(this.plugin, target);
        return ((logPPlugin)this.plugin).getlogPTrue();
    }

    private boolean needError() {
        return ((logPPlugin)this.plugin).needError();
    }
}

