/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.Calculator;
import chemaxon.marvin.calculations.pKaPlugin;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;

public class pKaPluginOutput
extends CalculatorPluginOutput {
    private static int DEF_NA = 2;
    private static int DEF_NB = 2;
    private int na = DEF_NA;
    private int nb = DEF_NB;

    @Override
    public void setOutputParameters(Object[] types) throws PluginException {
        boolean acidic = false;
        boolean basic = false;
        for (int i = 0; i < types.length; ++i) {
            String typestr = types[i].toString();
            if (typestr.equalsIgnoreCase("acidic")) {
                acidic = true;
            }
            if (typestr.equalsIgnoreCase("basic")) {
                basic = true;
            }
            if (!typestr.equalsIgnoreCase("pKa")) continue;
            acidic = true;
            basic = true;
        }
        if (acidic) {
            String nastr = this.params.getProperty("na");
            if (nastr != null) {
                this.na = Integer.parseInt(nastr);
            }
        } else {
            this.na = 0;
        }
        if (basic) {
            String nbstr = this.params.getProperty("nb");
            if (nbstr != null) {
                this.nb = Integer.parseInt(nbstr);
            }
        } else {
            this.nb = 0;
        }
    }

    @Override
    public String getHeader() {
        int i;
        StringBuffer s = new StringBuffer();
        for (i = 1; i <= this.na; ++i) {
            if (i > 1) {
                s.append(this.separator);
            }
            s.append("apKa" + i);
        }
        for (i = 1; i <= this.nb; ++i) {
            s.append(this.separator);
            s.append("bpKa" + i);
        }
        s.append(this.separator);
        s.append("atoms");
        return new String(s);
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        double[] a = new double[this.na];
        int[] ai = new int[this.na];
        double[] b = new double[this.nb];
        int[] bi = new int[this.nb];
        ((pKaPlugin)this.plugin).getMacropKaValues(-1, a, ai);
        ((pKaPlugin)this.plugin).getMacropKaValues(1, b, bi);
        StringBuffer s = new StringBuffer();
        StringBuffer si = new StringBuffer();
        int n = this.na + this.nb;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            if (i < this.na) {
                if (Double.isNaN(a[i])) continue;
                s.append(this.plugin.format(a[i]));
                si.append(ai[i] + 1);
                si.append(",");
                continue;
            }
            if (Double.isNaN(b[i - this.na])) continue;
            s.append(this.plugin.format(b[i - this.na]));
            si.append(bi[i - this.na] + 1);
            si.append(",");
        }
        String sistr = new String(si);
        if (sistr.length() > 0) {
            sistr = sistr.substring(0, sistr.length() - 1);
        }
        s.append(this.separator);
        s.append(sistr);
        return new String(s);
    }

    @Override
    public double getSpecResult(Molecule target, String arg) throws PluginException {
        Calculator.runPlugin(this.plugin, target);
        String type = "acidic";
        int k = arg.indexOf(":");
        if (k != -1) {
            type = arg.substring(0, k);
        }
        String index = arg.substring(k + 1);
        Object result = this.plugin.getResult((Object)type, index);
        return (Double)result;
    }
}

