/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common;

import chemaxon.common.util.ColorParser;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.swing.templates.TemplateHandler;
import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class UserSettings {
    public static final String PROPERTY_TYPE_TRANSIENT = "transient";
    public static final String PROPERTY_TYPE_PERSISTENT = "persistent";
    public static final String PROPERTY_TYPE_DEFAULT = "default";
    public static final String PROPERTY_TYPE_ALL = "all";
    public static final int MAX_RECENT_FILE_LIST_SIZE = 50;
    public static final int MIN_RECENT_FILE_LIST_SIZE = 1;
    public static final String MARVIN_CONFIG_DEFAULT_PATH = "marvin.properties";
    private static Collection<String> TRANSIENT_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("customizationEnabled", "serializedMenuconfig", "menuconfig", "shortcuts", "lazyMenus", "transferSelection", "confirmTransfer", "transferButtonVisible", "useComponentActions", "imageScale", "setColorScheme", "customizationDirectory", "viewonly", "moreEnabled", "menubar", "noAntialias", "atomMappingVisible", "atomNumbersVisible", "atomPropertiesVisible", "valencePropertyVisible", "lonePairsVisible", "noAtomSymbols3D", "dimension", "isSketcher", "maxScale", "buttonmenubar", "toolbarFloatable", "ligandErrorVisible", "defaultTool", "symbols")));
    private static ResourceBundle resources = ResourceBundle.getBundle(UserSettings.class.getName(), Locale.getDefault());
    private static Properties defaultProperties = UserSettings.loadDefaults();
    private long timeStamp;
    private PropertyChangeSupport propChangeSup = new PropertyChangeSupport(this);
    private int ownerCount = 0;
    private String configFileName = "marvin.properties";
    private Properties persistentProperties;
    private Properties transientProperties;
    @Deprecated
    public static final double DEFAULT_SKETCH_ARROW_HEAD_LENGTH = 0.8;
    @Deprecated
    public static final double DEFAULT_SKETCH_ARROW_HEAD_WIDTH = 0.5;
    @Deprecated
    public static final int MYTEMPLATES_GROUP_INDEX = 128;
    @Deprecated
    public static final String CLEAN_H_OPTION = "cleanHOption";
    @Deprecated
    public static final int MAX_VIEW_RECENT_FILE_LIST_SIZE = 10;
    @Deprecated
    public static final int MIN_VIEW_RECENT_FILE_LIST_SIZE = 1;
    @Deprecated
    public static final int DEFAULT_VIEW_RECENT_FILE_LIST_SIZE = 4;
    @Deprecated
    public static final int MAX_SKETCH_RECENT_FILE_LIST_SIZE = 10;
    @Deprecated
    public static final int MIN_SKETCH_RECENT_FILE_LIST_SIZE = 1;
    @Deprecated
    public static final int DEFAULT_SKETCH_RECENT_FILE_LIST_SIZE = 4;
    @Deprecated
    public static final boolean DEFAULT_LONE_PAIR_AUTOCALC = true;
    @Deprecated
    public static final boolean DEFAULT_BOND_IN_HAND = true;

    public static String getDescription(String key, String val) {
        String s = null;
        if (val != null) {
            try {
                s = resources.getString(key + "." + val);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if (s == null) {
            try {
                s = resources.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return s != null ? s : key;
    }

    public UserSettings() {
        this(MARVIN_CONFIG_DEFAULT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSettings(String configFileName) {
        InputStream is = null;
        try {
            is = this.loadProperties(configFileName);
            this.loadFromStream(is);
        }
        finally {
            UserSettings.close(is);
        }
    }

    UserSettings(InputStream input) {
        this.loadFromStream(input);
    }

    private void loadFromStream(InputStream inputStream) {
        Properties props = UserSettings.loadProperties(inputStream);
        UserSettings.removeTransientProperties(props);
        this.init(props);
    }

    private static Properties loadProperties(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            Properties result = new Properties();
            result.load(inputStream);
            return result;
        }
        catch (IOException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private InputStream loadProperties(String fileName) {
        if (Environment.APPLET || Environment.UNTRUSTED) {
            return null;
        }
        this.configFileName = fileName;
        this.timeStamp = DotfileUtil.lastModified(fileName);
        try {
            return DotfileUtil.open(fileName);
        }
        catch (IOException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private static void removeTransientProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (String id : TRANSIENT_IDS) {
            props.remove(id);
        }
    }

    public UserSettings(UserSettings settings) {
        this.configFileName = settings.configFileName;
        this.timeStamp = settings.timeStamp;
        this.init(null);
        this.persistentProperties.putAll((Map<?, ?>)settings.persistentProperties);
        this.transientProperties.putAll((Map<?, ?>)settings.transientProperties);
    }

    public Map<String, String> getPropertyMap() {
        return this.getPropertyMap(PROPERTY_TYPE_ALL);
    }

    public Map<String, String> getPropertyMap(String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (type.equals(PROPERTY_TYPE_DEFAULT) || type.equals(PROPERTY_TYPE_ALL)) {
            for (Object s : defaultProperties.keySet()) {
                map.put(s.toString(), this.getProperty(s.toString()));
            }
        }
        if (type.equals(PROPERTY_TYPE_PERSISTENT) || type.equals(PROPERTY_TYPE_ALL)) {
            for (Object s : this.persistentProperties.keySet()) {
                map.put(s.toString(), this.persistentProperties.getProperty(s.toString()));
            }
        }
        if (type.equals(PROPERTY_TYPE_TRANSIENT) || type.equals(PROPERTY_TYPE_ALL)) {
            for (Object s : this.transientProperties.keySet()) {
                map.put(s.toString(), this.transientProperties.getProperty(s.toString()));
            }
        }
        return map;
    }

    public void save(String comment) throws IOException {
        this.save(this.configFileName, comment);
    }

    public void save(String fileName, String comment) throws IOException {
        this.saveImpl(fileName, comment);
    }

    private void saveImpl(String fileName, String comment) throws IOException {
        UserSettings.removeTransientProperties(this.persistentProperties);
        OutputStream os = DotfileUtil.create(fileName);
        this.persistentProperties.store(os, comment);
        os.close();
    }

    public Vector<String> getPropertiesDescriptionChangedByOtherApp() {
        Vector<String> retval = new Vector<String>();
        UserSettings settings = new UserSettings(this.configFileName);
        if (settings.timeStamp > this.timeStamp) {
            for (Object s : settings.persistentProperties.keySet()) {
                String propInFile = settings.getProperty(s.toString());
                String propInThis = this.getProperty(s.toString());
                if (propInThis != null && propInFile.equals(propInThis)) continue;
                retval.add(UserSettings.getDescription(s.toString(), propInThis));
            }
        }
        return retval;
    }

    public synchronized void addOwner(PropertyChangeListener o) {
        ++this.ownerCount;
        this.propChangeSup.addPropertyChangeListener(o);
    }

    public synchronized void removeOwner(PropertyChangeListener o) {
        --this.ownerCount;
        this.propChangeSup.removePropertyChangeListener(o);
    }

    public synchronized int getOwnerCount() {
        return this.ownerCount;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propChangeSup.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propChangeSup.removePropertyChangeListener(l);
    }

    public String getDefaultProperty(String key) {
        return defaultProperties.getProperty(key);
    }

    public String getProperty(String key) {
        String s = null;
        s = this.persistentProperties.getProperty(key);
        if (s != null) {
            return s;
        }
        return this.transientProperties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, true);
    }

    public void setProperty(String key, String value, boolean isPersistent) {
        String oldValue = this.getProperty(key);
        this.storeProperty(key, value, isPersistent);
        this.propChangeSup.firePropertyChange(key, oldValue, value);
    }

    private boolean getBoolProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    private Font getFontProperty(String key) {
        return new Font(this.getProperty(key), 0, 12);
    }

    private void setProperty(String key, Font value) {
        Font oldValue = this.getFontProperty(key);
        this.storeProperty(key, value.getFontName(), true);
        this.propChangeSup.firePropertyChange(key, oldValue, value);
    }

    private double getDoubleProperty(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    private void setProperty(String key, double value) {
        Double oldValue = this.getProperty(key) != null ? Double.valueOf(this.getProperty(key)) : null;
        this.storeProperty(key, Double.toString(value), true);
        this.propChangeSup.firePropertyChange(key, oldValue, value);
    }

    private int getIntProperty(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    private void setProperty(String key, int value) {
        Integer oldValue = this.getProperty(key) != null ? Integer.valueOf(this.getIntProperty(key)) : null;
        this.storeProperty(key, Integer.toString(value), true);
        this.propChangeSup.firePropertyChange(key, oldValue, (Object)value);
    }

    private void setProperty(String key, Color value) {
        this.setProperty(key, value, true);
    }

    private void setProperty(String key, Color value, boolean isPersistent) {
        Color oldValue = this.getColorProperty(key);
        this.storeProperty(key, ColorParser.toString(value), isPersistent);
        this.propChangeSup.firePropertyChange(key, oldValue, value);
    }

    private Color getColorProperty(String key) {
        return ColorParser.parseColor(this.getProperty(key));
    }

    private void setProperty(String key, boolean value) {
        boolean oldValue = this.getBoolProperty(key);
        this.storeProperty(key, Boolean.toString(value), true);
        this.propChangeSup.firePropertyChange(key, oldValue, value);
    }

    private void storeProperty(String key, String valueString, boolean isPersistent) {
        boolean p = isPersistent;
        if (!p && this.persistentProperties.getProperty(key) != null) {
            p = true;
        }
        if (p) {
            this.setPropertyOn(this.persistentProperties, key, valueString);
        } else {
            this.setPropertyOn(this.transientProperties, key, valueString);
        }
    }

    public void removeAllProperty() {
        this.persistentProperties.clear();
        this.transientProperties.clear();
    }

    public void setTerminalBondDeletionStyle(String style) {
        this.setProperty("terminalBondDeletionStyle", style);
    }

    public String getTerminalBondDeletionStyle() {
        return this.getProperty("terminalBondDeletionStyle");
    }

    public void setAutoCheckStructure(boolean b) {
        this.setProperty("autoCheckStructure", b);
    }

    public boolean isAutoCheckStructure() {
        return this.getBoolProperty("autoCheckStructure");
    }

    public String getViewColorScheme() {
        return this.getProperty("viewColorScheme");
    }

    public void setViewColorScheme(String c) {
        this.setProperty("viewColorScheme", c);
    }

    public String getSketchColorScheme() {
        return this.getProperty("sketchColorScheme");
    }

    public void setSketchColorScheme(String c) {
        this.setProperty("sketchColorScheme", c);
    }

    public Color getSketchMolbg2d() {
        return this.getColorProperty("sketchMolbg2d");
    }

    public void setSketchMolbg2d(Color c) {
        this.setProperty("sketchMolbg2d", c);
    }

    public Color getSketchMolbg3d() {
        return this.getColorProperty("sketchMolbg3d");
    }

    public void setSketchMolbg3d(Color c) {
        this.setProperty("sketchMolbg3d", c);
    }

    public Color getViewMolbg2d() {
        return this.getColorProperty("viewMolbg2d");
    }

    public void setViewMolbg2d(Color c) {
        this.setProperty("viewMolbg2d", c);
    }

    public Color getViewMolbg3d() {
        return this.getColorProperty("viewMolbg3d");
    }

    public void setViewMolbg3d(Color c) {
        this.setProperty("viewMolbg3d", c);
    }

    public String getSketchImplicitH() {
        return this.getProperty("implicitH");
    }

    public void setSketchImplicitH(String s) {
        MolPainterCommon.getImplicitHFlagsOf(s);
        this.setProperty("implicitH", s);
    }

    public String getViewImplicitH() {
        return this.getProperty("viewImplicitH");
    }

    public void setViewImplicitH(String s) {
        MolPainterCommon.getImplicitHFlagsOf(s);
        this.setProperty("viewImplicitH", s);
    }

    public String getViewAnyBond() {
        return this.getProperty("viewAnyBond");
    }

    public void setViewAnyBond(String v) {
        int i = MolPainterCommon.getAnyBondFlagsOf(v) >> 21;
        String s = DispOptConsts.ANYBOND_STYLES[i];
        this.setProperty("viewAnyBond", s);
    }

    public String getSketchAnyBond() {
        return this.getProperty("sketchAnyBond");
    }

    public void setSketchAnyBond(String v) {
        int i = MolPainterCommon.getAnyBondFlagsOf(v) >> 21;
        String s = DispOptConsts.ANYBOND_STYLES[i];
        this.setProperty("sketchAnyBond", s);
    }

    public String getDownWedge() {
        return this.getProperty("downWedge");
    }

    public void setDownWedge(String s) {
        this.setProperty("downWedge", s);
    }

    public String getCoordinateBondStyle() {
        return this.getProperty("coordinateBondStyle");
    }

    public void setCoordinateBondStyle(String s) {
        this.setProperty("coordinateBondStyle", s);
    }

    public String getCoordinateBondStyleAtMulticenter() {
        return this.getProperty("coordinateBondStyleAtMulticenter");
    }

    public void setCoordinateBondStyleAtMulticenter(String s) {
        this.setProperty("coordinateBondStyleAtMulticenter", s);
    }

    public boolean isBondDraggedAlong() {
        return this.getBoolProperty("bondDraggedAlong");
    }

    public void setBondDraggedAlong(boolean v) {
        this.setProperty("bondDraggedAlong", v);
    }

    public String getCopyAsFormat() {
        String ret = this.getProperty("copyAsFormat");
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void setCopyAsFormat(String fmt) {
        this.setProperty("copyAsFormat", fmt);
    }

    public String getDefaultSaveFormat() {
        return this.getProperty("defaultSaveFormat");
    }

    public void setDefaultSaveFormat(String s) {
        this.setProperty("defaultSaveFormat", s);
    }

    public boolean isValenceErrorVisibleInView() {
        return this.getBoolProperty("valenceErrorVisibleInView");
    }

    public void setValenceErrorVisibleInView(boolean v) {
        this.setProperty("valenceErrorVisibleInView", v);
    }

    public boolean isvalidateSgroupsAtCreation() {
        return this.getBoolProperty("validateSgroupsAtCreation");
    }

    public void setvalidateSgroupsAtCreation(boolean b) {
        this.setProperty("validateSgroupsAtCreation", b);
    }

    public boolean isValenceErrorVisible() {
        return this.getBoolProperty("valenceErrorVisible");
    }

    public synchronized void setValenceErrorVisible(boolean v) {
        this.setProperty("valenceErrorVisible", v);
    }

    public boolean isEZVisible() {
        return this.getBoolProperty("EZVisible");
    }

    public void setEZVisible(boolean v) {
        this.setProperty("EZVisible", v);
    }

    public String getChiralitySupport() {
        return this.getProperty("chiralitySupport");
    }

    public void setChiralitySupport(String v) {
        this.setProperty("chiralitySupport", v);
    }

    public String getAbsoluteLabelVisible() {
        return this.getProperty("absLabelVisible");
    }

    public void setAbsoluteLabelVisible(String v) {
        this.setProperty("absLabelVisible", v);
    }

    public boolean isLonePairAutoCalc() {
        return this.getBoolProperty("lonePairsAutoCalc");
    }

    public void setLonePairAutoCalc(boolean v) {
        this.setProperty("lonePairsAutoCalc", v);
    }

    public String getSketchRendering2d() {
        return this.getProperty("sketchRendering2d");
    }

    public void setSketchRendering2d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.setProperty("sketchRendering2d", s);
    }

    public String getSketchRendering3d() {
        return this.getProperty("sketchRendering3d");
    }

    public void setSketchRendering3d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.setProperty("sketchRendering3d", s);
    }

    public String getViewRendering2d() {
        return this.getProperty("viewRendering2d");
    }

    public void setViewRendering2d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.setProperty("viewRendering2d", s);
    }

    public String getViewRendering3d() {
        return this.getProperty("viewRendering3d");
    }

    public void setViewRendering3d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.setProperty("viewRendering3d", s);
    }

    public String getViewNavmode2d() {
        return this.getProperty("viewNavmode2d");
    }

    public void setViewNavmode2d(String s) {
        this.setProperty("viewNavmode2d", s);
    }

    public String getViewNavmode3d() {
        return this.getProperty("viewNavmode3d");
    }

    public void setViewNavmode3d(String s) {
        this.setProperty("viewNavmode3d", s);
    }

    public String getClean2dOpts() {
        String ret = this.getProperty("clean2dOpts");
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public synchronized void setClean2dOpts(String s) {
        this.setProperty("clean2dOpts", s);
    }

    public boolean isCleanHOptionEnabled() {
        return this.getBoolProperty(CLEAN_H_OPTION);
    }

    public void setCleanHOptionEnabled(boolean b) {
        this.setProperty(CLEAN_H_OPTION, b);
    }

    public boolean isViewAtomMarkEnabled() {
        return this.getBoolProperty("viewAtomMarkEnabled");
    }

    public void setViewAtomMarkEnabled(boolean b) {
        this.setProperty("viewAtomMarkEnabled", b);
    }

    @Deprecated
    public void setCleanHOption(boolean b) {
        this.setProperty(CLEAN_H_OPTION, b);
    }

    public String getClean3dOpts() {
        return this.getProperty("clean3dOpts");
    }

    public synchronized void setClean3dOpts(String s) {
        String opt = s;
        if (s != null && s.equals("O0")) {
            opt = "S{fast}";
        } else if (s != null && s.equals("OD")) {
            opt = "S{fine}";
        }
        this.setProperty("clean3dOpts", opt);
    }

    public int getAromatizeMethod() {
        return this.getIntProperty("aromatizeMethod");
    }

    public void setAromatizeMethod(int method) {
        this.setProperty("aromatizeMethod", method);
    }

    public int getAtomMappingMethod() {
        return this.getIntProperty("atomMappingMethod");
    }

    public void setAtomMappingMethod(int method) {
        this.setProperty("atomMappingMethod", method);
    }

    public Font getAtomFont() {
        return new Font(this.getProperty("atomFont"), 0, 12);
    }

    public void setAtomFont(Font f) {
        this.setProperty("atomFont", f);
    }

    public double getAtomSize() {
        return this.getDoubleProperty("atomsize");
    }

    public void setAtomSize(double r) {
        this.setProperty("atomsize", r);
    }

    public double getBondSpacing() {
        return this.getDoubleProperty("bondSpacing");
    }

    public void setBondSpacing(double w) {
        this.setProperty("bondSpacing", w);
    }

    public int getFogFactor() {
        return this.getIntProperty("fogFactor");
    }

    public void setFogFactor(int w) {
        this.setProperty("fogFactor", w);
    }

    public boolean isAutomaticFogEnabled() {
        return this.getBoolProperty("automaticFogEnabled");
    }

    public void setAutomaticFogEnabled(boolean enable) {
        this.setProperty("automaticFogEnabled", enable);
    }

    public double getWireThickness() {
        return this.getDoubleProperty("wireThickness");
    }

    public void setWireThickness(double d) {
        this.setProperty("wireThickness", d);
    }

    public double getStickThickness() {
        return this.getDoubleProperty("stickThickness");
    }

    public void setStickThickness(double d) {
        this.setProperty("stickThickness", d);
    }

    public double getBallRadius() {
        return this.getDoubleProperty("ballRadius");
    }

    public void setBallRadius(double r) {
        this.setProperty("ballRadius", r);
    }

    public double getSketchArrowHeadLength() {
        return this.getDoubleProperty("sketchArrowHeadLength");
    }

    public void setSketchArrowHeadLength(double d) {
        this.setProperty("sketchArrowHeadLength", d);
    }

    public double getSketchArrowHeadWidth() {
        return this.getDoubleProperty("sketchArrowHeadWidth");
    }

    public void setSketchArrowHeadWidth(double d) {
        this.setProperty("sketchArrowHeadWidth", d);
    }

    public double getSketchArrowTailLength() {
        return this.getDoubleProperty("sketchArrowTailLength");
    }

    public void setSketchArrowTailLength(double d) {
        this.setProperty("sketchArrowTailLength", d);
    }

    public double getSketchArrowTailWidth() {
        return this.getDoubleProperty("sketchArrowTailWidth");
    }

    public void setSketchArrowTailWidth(double d) {
        this.setProperty("sketchArrowTailWidth", d);
    }

    public List<String> getViewRecentFileList() {
        return Collections.unmodifiableList(this.initRecentFileList("viewRecentFileList"));
    }

    public void addToViewRecentFileList(File f) {
        List<String> viewRecentFileList = this.initRecentFileList("viewRecentFileList");
        if (!viewRecentFileList.contains(f.getAbsolutePath())) {
            if (viewRecentFileList.size() >= this.getRecentFileListSize("viewRecentFileList")) {
                viewRecentFileList.remove(viewRecentFileList.size() - 1);
            }
            viewRecentFileList.add(0, f.getAbsolutePath());
        } else {
            int index = viewRecentFileList.indexOf(f.getAbsolutePath());
            if (index != 0) {
                viewRecentFileList.add(0, viewRecentFileList.remove(index));
            }
        }
        this.setProperty("viewRecentFileList", this.getRecentFileListAsString(viewRecentFileList));
    }

    public int getViewRecentFileListSize() {
        return this.getRecentFileListSize("viewRecentFileList");
    }

    public void setViewRecentFileListSize(int size) {
        this.setProperty("viewRecentFileListSize", this.getValidRecentFileListSizeBasedOn(size));
    }

    public List<String> getSketchRecentFileList() {
        return Collections.unmodifiableList(this.initRecentFileList("sketchRecentFileList"));
    }

    public void addToSketchRecentFileList(File f) {
        List<String> sketchRecentFileList = this.initRecentFileList("sketchRecentFileList");
        if (!sketchRecentFileList.contains(f.getAbsolutePath())) {
            if (sketchRecentFileList.size() >= this.getRecentFileListSize("sketchRecentFileList")) {
                sketchRecentFileList.remove(sketchRecentFileList.size() - 1);
            }
            sketchRecentFileList.add(0, f.getAbsolutePath());
        } else {
            int index = sketchRecentFileList.indexOf(f.getAbsolutePath());
            sketchRecentFileList.add(0, sketchRecentFileList.remove(index));
        }
        this.setProperty("sketchRecentFileList", this.getRecentFileListAsString(sketchRecentFileList));
    }

    public int getSketchRecentFileListSize() {
        return this.getRecentFileListSize("sketchRecentFileList");
    }

    public void setSketchRecentFileListSize(int size) {
        this.setProperty("sketchRecentFileListSize", this.getValidRecentFileListSizeBasedOn(size));
    }

    public String getLoadSaveLocation() {
        return this.getProperty("loadSaveLocation");
    }

    public void setLoadSaveLocation(String s) {
        this.setProperty("loadSaveLocation", s);
    }

    public File getLoadWorkingDir() {
        if ("saveCustomLocation".equals(this.getLoadSaveLocation())) {
            return new File(this.getProperty("loadWorkingDir"));
        }
        return null;
    }

    public void setLoadWorkingDir(String s) {
        if ("saveCustomLocation".equals(this.getLoadSaveLocation())) {
            this.setProperty("loadWorkingDir", s);
        }
    }

    public File getViewLoadWorkingDir() {
        return this.getWorkingDirFor("viewLoadWorkingDir");
    }

    public void setViewLoadWorkingDir(String s) {
        this.setProperty("viewLoadWorkingDir", s);
    }

    public File getViewSaveWorkingDir() {
        return this.getWorkingDirFor("viewSaveWorkingDir");
    }

    public void setViewSaveWorkingDir(String s) {
        this.setProperty("viewSaveWorkingDir", s);
    }

    public File getSketchLoadWorkingDir() {
        return this.getWorkingDirFor("sketchLoadWorkingDir");
    }

    public void setSketchLoadWorkingDir(String s) {
        this.setProperty("sketchLoadWorkingDir", s);
    }

    public File getSketchSaveWorkingDir() {
        return this.getWorkingDirFor("sketchSaveWorkingDir");
    }

    public void setSketchSaveWorkingDir(String s) {
        this.setProperty("sketchSaveWorkingDir", s);
    }

    public void setSaveLoadZoomFactorToMRV(boolean b) {
        this.setProperty("saveLoadZoomFactorToMRV", b);
    }

    public boolean getSaveLoadZoomFactorToMRV() {
        return this.getBoolProperty("saveLoadZoomFactorToMRV");
    }

    public void setSaveGUIPropertiesInMRV(boolean flag) {
        this.setProperty("saveGUIProperties", flag);
    }

    public boolean getSaveGUIPropertiesInMRV() {
        return this.getBoolProperty("saveGUIProperties") || this.getBoolProperty("readGUIProperties");
    }

    public String getViewCarbonVisibility() {
        return this.getProperty("viewCarbonVisibility");
    }

    public void setViewCarbonVisibility(String v) {
        this.setProperty("viewCarbonVisibility", v);
    }

    public String getViewLigandOrderVisibility() {
        return this.getProperty("viewLigandOrderVisibility");
    }

    public void setViewLigandOrderVisibility(String v) {
        this.setProperty("viewLigandOrderVisibility", v);
    }

    public String getSketchCarbonVisibility() {
        return this.getProperty("sketchCarbonVisibility");
    }

    public void setSketchCarbonVisibility(String v) {
        int i = MolPainterCommon.getCarbonVisibilityFlagsOf(v) >> 28;
        this.setProperty("sketchCarbonVisibility", DispOptConsts.CARBON_VIS_STYLES[i]);
    }

    public String getSketchLigandOrderVisibility() {
        return this.getProperty("sketchLigandOrderVisibility");
    }

    public void setSketchLigandOrderVisibility(String v) {
        this.setProperty("sketchLigandOrderVisibility", v);
    }

    public boolean isTransformationEnabled() {
        if (this.getProperty("transformationEnabled").equals("on")) {
            this.persistentProperties.put("transformationEnabled", "true");
        }
        return this.getBoolProperty("transformationEnabled");
    }

    public void setTransformationEnabled(boolean v) {
        this.setProperty("transformationEnabled", v);
    }

    public int getViewLayout() {
        return this.getIntProperty("viewLayout");
    }

    public void setViewLayout(int v) {
        int value = v;
        if (v != 0 && v != 1 && v != 2) {
            value = 0;
        }
        this.setProperty("viewLayout", value);
    }

    public String getRLogicVisible() {
        return this.getProperty("rLogicVisible");
    }

    public void setRLogicVisible(String v) {
        this.setProperty("rLogicVisible", v);
    }

    public boolean isAtomPropertiesVisible() {
        return this.getBoolProperty("atomPropertiesVisible");
    }

    public void setAtomPropertiesVisible(boolean v) {
        this.setProperty("atomPropertiesVisible", v);
    }

    public String getCheckerConfigFileName() {
        return this.getProperty("checkerConfigFileName");
    }

    public void setCheckerConfigFileName(String checkerConfigFileName) {
        this.setProperty("checkerConfigFileName", checkerConfigFileName);
    }

    public String getServicesConfigURL() {
        return this.getProperty("servicesConfigURL");
    }

    public void setServicesConfigURL(String servicesConfigURL) {
        this.setProperty("servicesConfigURL", servicesConfigURL);
    }

    public boolean isValencePropertyVisible() {
        return this.getBoolProperty("valencePropertyVisible");
    }

    public void setValencePropertyVisible(boolean v) {
        this.setProperty("valencePropertyVisible", v);
    }

    public boolean isLigandErrorVisible() {
        return this.getBoolProperty("ligandErrorVisible");
    }

    public synchronized void setLigandErrorVisible(boolean v) {
        this.setProperty("ligandErrorVisible", v);
    }

    private static Properties loadDefaults() {
        Properties def = new Properties();
        try {
            def.load(UserSettings.class.getResourceAsStream("UserSettings_defaultProps.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return def;
    }

    private void init(Properties props) {
        Properties p = new Properties(defaultProperties);
        if (props != null) {
            p.putAll((Map<?, ?>)props);
        }
        this.persistentProperties = p;
        this.transientProperties = new Properties();
        String molbg = this.persistentProperties.getProperty("molbg");
        String sketch2dmolbg = this.persistentProperties.getProperty("sketchMolbg2d");
        if (molbg != null && sketch2dmolbg == null) {
            this.persistentProperties.setProperty("sketchMolbg2d", molbg);
        }
        this.persistentProperties.remove("molbg");
    }

    private void setPropertyOn(Properties props, String key, String value) {
        String oldValue = props.getProperty(key);
        if (!value.equals(oldValue)) {
            if (!value.equals(defaultProperties.getProperty(key))) {
                props.setProperty(key, value);
            } else {
                props.remove(key);
            }
        }
    }

    private List<String> initRecentFileList(String propertyKey) {
        LinkedList<String> fileList = new LinkedList<String>();
        String s = this.getProperty(propertyKey);
        if (s != null) {
            String[] st = s.length() - 1 > 1 ? s.substring(1, s.length() - 1).split("(?<!\\Q" + File.separator + "\\E),") : new String[]{};
            for (int i = 0; i < st.length && i < this.getRecentFileListSize(propertyKey); ++i) {
                st[i] = st[i].replaceAll(File.separator + ",", ",");
                fileList.add(st[i].trim());
            }
        }
        return fileList;
    }

    private int getRecentFileListSize(String propertyKey) {
        return this.getIntProperty(propertyKey + "Size");
    }

    private int getValidRecentFileListSizeBasedOn(int size) {
        if (size < 1) {
            return 1;
        }
        if (size > 50) {
            return 50;
        }
        return size;
    }

    private String quoteFileNameForRecentFileList(String s) {
        return s.replace(",", File.separator + ",");
    }

    private String getRecentFileListAsString(List<String> l) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator<String> i = l.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            sb.append(this.quoteFileNameForRecentFileList(i.next()));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private File getWorkingDirFor(String propertyKey) {
        if (Environment.LIKELY_COMMAND_LINE || "saveStartupLocation".equals(this.getLoadSaveLocation())) {
            return new File(System.getProperty("user.dir"));
        }
        if ("saveCustomLocation".equals(this.getLoadSaveLocation())) {
            return this.getLoadWorkingDir();
        }
        String s = this.getProperty(propertyKey);
        if (s != null) {
            return new File(s);
        }
        try {
            if ("saveLastLocation".equals(this.getLoadSaveLocation())) {
                return new File(System.getProperty("user.home"));
            }
            if ("saveStartupLocation".equals(this.getLoadSaveLocation())) {
                return new File(System.getProperty("user.dir"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public synchronized void put(String key, String v) {
        if (this.persistentProperties.containsKey(key)) {
            this.setProperty(key, v);
        } else {
            this.setProperty(key, v, !TRANSIENT_IDS.contains(key));
        }
    }

    @Deprecated
    public synchronized String get(String key) {
        return this.getProperty(key);
    }

    @Deprecated
    public Enumeration<Object> keys() {
        Hashtable<String, String> table = new Hashtable<String, String>(this.getPropertyMap(PROPERTY_TYPE_ALL));
        return table.keys();
    }

    @Deprecated
    public void addTo(Properties p) {
        p.putAll((Map<?, ?>)this.persistentProperties);
    }

    @Deprecated
    public synchronized void addWithLCKeysTo(Properties p) {
        Set<Object> e = this.persistentProperties.keySet();
        for (Object key : e) {
            p.put(key.toString().toLowerCase(), this.getProperty(key.toString()));
        }
    }

    @Deprecated
    public boolean tryToLoad() {
        return true;
    }

    @Deprecated
    public boolean tryToLoad(Properties props) {
        props.putAll((Map<?, ?>)this.persistentProperties);
        return true;
    }

    @Deprecated
    public boolean tryToLoadTemplates() {
        return false;
    }

    @Deprecated
    public static String getMyTemplatesKey() {
        return TemplateHandler.MYTEMPLATES_KEY;
    }

    @Deprecated
    public static String getMyTemplatesValue(Properties props) {
        return null;
    }

    @Deprecated
    public String getMyTemplatesValue() {
        return UserSettings.getMyTemplatesValue(null);
    }

    @Deprecated
    public static String getDefaultMyTemplatesValue() {
        return "*My Templates*";
    }

    @Deprecated
    public void save(String comment, boolean templatesOnly) throws IOException {
        this.save(comment);
    }

    @Deprecated
    public boolean getViewExplicitH() {
        return false;
    }

    @Deprecated
    public void setViewExplicitH(boolean v) {
    }

    @Deprecated
    public boolean isReactionErrorVisible() {
        return false;
    }

    @Deprecated
    public void setReactionErrorVisible(boolean v) {
    }

    @Deprecated
    public boolean checkBeforeSave(Properties p, Vector<String> changed) {
        Vector<String> v = this.getPropertiesDescriptionChangedByOtherApp();
        changed.addAll(v);
        return !v.isEmpty();
    }

    @Deprecated
    public boolean getReadGUIPropertiesFromMRV() {
        return this.getSaveGUIPropertiesInMRV();
    }

    @Deprecated
    public void setReadGUIPropertiesFromMRV(boolean flag) {
        this.setSaveGUIPropertiesInMRV(this.getSaveGUIPropertiesInMRV() || flag);
    }

    private static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

