/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

public class DnD
implements Serializable,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final long serialVersionUID = -5098079184957405432L;
    public static final int DRAG = 1;
    public static final int DROP = 2;
    private Component theComponent = null;
    private HourglassHandler theHourglass = null;
    private MolPanel theMolPanel = null;
    private String dndModuleName = null;
    private int dndFlags = 0;
    private String dragOptString = null;
    private int debugLevel = 0;
    private transient CallbackIface dndModule = null;
    private transient DropTarget dropTarget;
    private transient DragSource dragSource;

    public DnD(String modname, Component component, HourglassHandler hourglass, MolPanel molPanel, int flags, String dragOpts, int debug) {
        this.dndModuleName = modname;
        this.theComponent = component;
        this.theHourglass = hourglass;
        this.theMolPanel = molPanel;
        this.dndFlags = flags;
        if ((flags & 1) != 0) {
            this.dragOptString = dragOpts;
            this.initDrag();
        }
        if ((flags & 2) != 0) {
            this.initDrop();
        }
        this.debugLevel = debug;
    }

    public Component getComponent() {
        return this.theComponent;
    }

    public HourglassHandler getHourglass() {
        return this.theHourglass;
    }

    public MolPanel getMolPanel() {
        return this.theMolPanel;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public int getDebug() {
        return this.debugLevel;
    }

    public void setDebug(int debug) {
        this.debugLevel = debug;
    }

    public void log(String s) {
        if (this.debugLevel > 0) {
            System.err.println("dnd." + this.dndModuleName + ": " + s);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent ev) {
        this.log("[Source] dragGestureRecognized");
        CallbackIface c = this.getDnDModule();
        if (c != null) {
            c.callback("dragGestureRecognized", ev);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent ev) {
        this.log("[Source] dragEnter");
    }

    @Override
    public void dragEnter(DropTargetDragEvent ev) {
        this.log("[Target] dragEnter");
        ev.acceptDrag(3);
    }

    @Override
    public void dragOver(DragSourceDragEvent ev) {
        this.log("[Source] dragOver");
    }

    @Override
    public void dragOver(DropTargetDragEvent ev) {
        CallbackIface c = this.getDnDModule();
        if (c != null) {
            c.callback("dragOver", ev);
        }
        this.log("[Target] dragOver");
    }

    @Override
    public void dragExit(DragSourceEvent ev) {
        this.log("[Source] dragExit");
    }

    @Override
    public void dragExit(DropTargetEvent ev) {
        this.log("[Target] dragExit");
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent ev) {
        CallbackIface c = this.getDnDModule();
        if (c != null) {
            c.callback("dragDropEnd", ev);
        }
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        CallbackIface c = this.getDnDModule();
        if (c != null) {
            this.log("DROP");
            c.callback("drop", ev);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent ev) {
        this.log("[Source] dragActionChanged");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent ev) {
        this.log("[Target] dropActionChanged");
    }

    private void initDrag() {
        int opts = 0;
        StringTokenizer st = new StringTokenizer(this.dragOptString, " \t\n\r");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        st = new StringTokenizer(sb.toString(), "|");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("ACTION_COPY")) {
                opts |= 1;
                continue;
            }
            if (!s.equals("ACTION_MOVE")) continue;
            opts |= 2;
        }
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.theComponent, opts, this);
    }

    private void initDrop() {
        this.dropTarget = new DropTarget(this.theComponent, this);
        this.theComponent.setDropTarget(this.dropTarget);
    }

    private CallbackIface getDnDModule() {
        if (this.dndModule == null) {
            this.dndModule = (CallbackIface)MarvinModule.load(this.dndModuleName, null);
            if (this.dndModule != null) {
                this.dndModule.callback("init", this);
            }
        }
        return this.dndModule;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if ((this.dndFlags & 1) != 0) {
            this.initDrag();
        }
        if ((this.dndFlags & 2) != 0) {
            this.initDrop();
        }
    }
}

