/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class MolCanvas
extends JComponent {
    private static final long serialVersionUID = -5462802359996287421L;
    protected int draggedPointerX;
    protected int draggedPointerY;
    protected double dragPhi;
    protected double dragPhiX;
    protected double dragPhiY;
    private long dragWhen;

    public abstract MolPainter getPainter();

    public abstract DPoint3 calcTransformCenter();

    protected void initDrag(MouseEvent ev) {
        this.draggedPointerX = ev.getX();
        this.draggedPointerY = ev.getY();
        this.dragWhen = ev.getWhen();
        this.dragPhi = 0.0;
        this.dragPhiX = 0.0;
        this.dragPhiY = 0.0;
    }

    protected int getNavMode() {
        return this.getPainter().getCommon().getDispopts() & 0x38;
    }

    protected long getDragTime(MouseEvent ev) {
        return ev.getWhen() - this.dragWhen;
    }

    protected void zoomRotate(MouseEvent ev, CTransform3D u, boolean enablerot) {
        Dimension d = this.getSize();
        double dx = ev.getX() - this.draggedPointerX;
        double dy = ev.getY() - this.draggedPointerY;
        if (Math.abs(dx) <= Math.abs(dy) || !enablerot) {
            double c = dy / (double)d.height;
            if (c > 0.1) {
                c = 0.1;
            }
            if (c < -0.1) {
                c = -0.1;
            }
            u.setScale(1.0 + c);
        } else {
            double mag = this.getPainter().getScale();
            double phi = 0.5 * dx / mag;
            u.setRotation(0.0, 0.0, 1.0, phi);
        }
    }

    protected void rotZ(MouseEvent ev, CTransform3D u) {
        double ry;
        Dimension d = this.getSize();
        double mag = this.getPainter().getScale();
        double rx = ev.getX() - d.width / 2;
        double r = Math.sqrt(rx * rx + (ry = (double)(d.height / 2 - ev.getY())) * ry);
        if (r >= 1.0) {
            rx /= r;
            ry /= r;
        }
        double dx = 0.5 * (double)(ev.getX() - this.draggedPointerX);
        double dy = 0.5 * (double)(this.draggedPointerY - ev.getY());
        double phi = (rx * dy - ry * dx) / mag;
        u.setRotation(0.0, 0.0, 1.0, phi);
    }

    protected void rot3D(MouseEvent ev, CTransform3D u) {
        double mag = this.getPainter().getScale();
        double xphi = 0.5 * (double)(ev.getY() - this.draggedPointerY) / mag;
        double yphi = 0.5 * (double)(ev.getX() - this.draggedPointerX) / mag;
        double phi = Math.sqrt(xphi * xphi + yphi * yphi);
        this.dragPhi += phi;
        this.dragPhiX += xphi;
        this.dragPhiY += yphi;
        u.setRotation(xphi, yphi, 0.0, phi);
    }

    protected DPoint3 calcTransformCenter(int nav) {
        DPoint3 o = this.calcTransformCenter();
        MolPainter painter = this.getPainter();
        if (nav != 24) {
            o.x = this.getSize().width / 2;
            o.y = this.getSize().height / 2;
            o.z *= painter.getScale() / 1.54;
            CTransform3D t = painter.getTransformMatrix();
            CTransform3D tinv = new CTransform3D(t);
            tinv.invert();
            tinv.transform(o);
            painter.getRTransformRef().transform(o);
        }
        return o;
    }
}

