/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.common.swing.MoleculeViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class MoleculeViewAccessory
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -5123713451624419144L;
    private MoleculeViewer molViewer;
    private String lastFileName = new String("");

    public MoleculeViewAccessory(JFileChooser chooser) {
        chooser.addPropertyChangeListener(this);
        this.molViewer = new MoleculeViewer();
        this.molViewer.setChkPreview(true);
        this.molViewer.addPropertyChangeListener("molPosition", this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.molViewer, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("SelectedFileChangedProperty".equals(propertyName)) {
            String moleculeFilePath;
            File selection = (File)evt.getNewValue();
            if (selection != null && !(moleculeFilePath = selection.getAbsolutePath()).equalsIgnoreCase(this.lastFileName)) {
                this.lastFileName = moleculeFilePath;
                this.molViewer.setMoleculeFilePath(moleculeFilePath, 0);
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(propertyName)) {
            this.molViewer.clear();
        }
        if (propertyName.equals("molPosition")) {
            this.firePropertyChange("molPosition", Integer.parseInt(evt.getOldValue().toString()), Integer.parseInt(evt.getNewValue().toString()));
        }
    }

    public void forceMoleculeReload() {
        this.lastFileName = "";
    }
}

