/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.MolPrinter;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MoleculeViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkPreview = null;
    private JPanel mainPanel = null;
    private MoleculeView view = null;
    private Component viewComponent = null;
    private MolImporter molImporter;
    private Future<?> lastTask = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private JPanel containerPanel = null;
    private JLabel statusLabel = null;
    private JPanel controlPanel = null;
    private JLabel prevLabel = null;
    private JLabel nextLabel = null;
    private JLabel firstLabel = null;
    private JLabel lastLabel = null;
    private JLabel countLabel = null;
    private int molPos = -1;
    private int maxMolecules = 0;
    private String moleculeFilePath = null;
    private boolean molFileChanged = false;
    private boolean needChkPreview = false;
    private static final int AUTO_CHANGE_DISABLED = 0;
    private static final int AUTO_CHANGE_BACKWARD = -1;
    private static final int AUTO_CHANGE_FORWARD = 1;
    private int autoChangeMode;
    private boolean notClick;
    private int delayCount;
    private static final int MOLECULE_AUTO_CHANGE_STARTDELAY = 800;
    private int MOLECULE_AUTO_CHANGE_DELAY_MOD = 600;
    private static String loading = "Loading";
    private static String cantShow = "<html>No preview<br>available";
    private Timer autoChangeTimer = new Timer(800, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeViewer.this.autoChangeTimer.stop();
            MoleculeViewer.this.notClick = true;
            MoleculeViewer.this.delayCount++;
            int i = MoleculeViewer.this.delayCount * 30 > MoleculeViewer.this.MOLECULE_AUTO_CHANGE_DELAY_MOD ? 800 - MoleculeViewer.this.MOLECULE_AUTO_CHANGE_DELAY_MOD : 800 - MoleculeViewer.this.delayCount * 30;
            MoleculeViewer.this.autoChangeTimer.setInitialDelay(i);
            if (MoleculeViewer.this.autoChangeMode != 0) {
                if (MoleculeViewer.this.autoChangeMode == 1) {
                    MoleculeViewer.this.nextMolecule();
                }
                if (MoleculeViewer.this.autoChangeMode == -1) {
                    MoleculeViewer.this.prevMolecule();
                }
                MoleculeViewer.this.autoChangeTimer.restart();
            } else {
                MoleculeViewer.this.delayCount = 0;
            }
        }
    });

    public MoleculeViewer(String molFilePath) {
        this(molFilePath, 0);
    }

    public MoleculeViewer(String molFilePath, int molPosition) {
        this(new DefaultMoleucleView());
        this.moleculeFilePath = molFilePath;
        this.firePropertyChange("molPosition", this.molPos, molPosition);
        this.molPos = molPosition;
        this.runNewThread();
    }

    public MoleculeViewer() {
        this(new DefaultMoleucleView());
    }

    public MoleculeViewer(MoleculeView view) {
        this.view = view;
        this.initialize();
    }

    public void setMoleculeFilePath(String molFilePath) {
        this.setMoleculeFilePath(molFilePath, 0);
    }

    public void setMoleculeFilePath(String molFilePath, int molPosition) {
        this.firePropertyChange("molPosition", this.molPos, molPosition);
        this.molPos = molPosition;
        if (molFilePath != null && !molFilePath.equals(this.moleculeFilePath)) {
            this.moleculeFilePath = molFilePath;
            this.molFileChanged = true;
            this.runNewThread();
        }
    }

    public void setChkPreview(boolean needPrev) {
        this.needChkPreview = needPrev;
        if (this.needChkPreview) {
            this.initialize();
        } else if (this.chkPreview != null) {
            this.mainPanel.remove(this.chkPreview);
            this.chkPreview = null;
        }
    }

    private void runNewThread() {
        if (this.lastTask != null) {
            this.lastTask.cancel(true);
        }
        this.viewComponent.setVisible(false);
        this.view.setMolecule(null);
        this.statusLabel.setVisible(true);
        this.controlPanel.setVisible(false);
        if (this.chkPreview == null || this.chkPreview.isSelected()) {
            this.statusLabel.setText(loading);
            if (this.moleculeFilePath != null) {
                this.lastTask = this.executor.submit(new Worker(this, this.moleculeFilePath));
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(120, 160));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMaximumSize(new Dimension(110, 130));
        this.setMinimumSize(new Dimension(110, 130));
        this.setPreferredSize(new Dimension(120, 160));
        this.add((Component)this.getPnlMain(), null);
    }

    private JCheckBox getChkPreview() {
        if (this.chkPreview == null) {
            this.chkPreview = new JCheckBox();
            this.chkPreview.setText("Show preview");
            this.chkPreview.setMinimumSize(new Dimension(100, 20));
            this.chkPreview.setPreferredSize(new Dimension(100, 20));
            this.chkPreview.setSelected(true);
            this.chkPreview.setMaximumSize(new Dimension(120, 20));
            this.chkPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!MoleculeViewer.this.chkPreview.isSelected()) {
                        MoleculeViewer.this.viewComponent.setVisible(false);
                        MoleculeViewer.this.statusLabel.setVisible(false);
                        MoleculeViewer.this.controlPanel.setVisible(false);
                    } else if (MoleculeViewer.this.molFileChanged) {
                        MoleculeViewer.this.runNewThread();
                    } else {
                        MoleculeViewer.this.viewComponent.setVisible(true);
                        MoleculeViewer.this.statusLabel.setVisible(true);
                        MoleculeViewer.this.controlPanel.setVisible(true);
                        MoleculeViewer.this.showView();
                        MoleculeViewer.this.repaint();
                    }
                }
            });
        }
        return this.chkPreview;
    }

    private JPanel getPnlMain() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setMaximumSize(new Dimension(110, 150));
            this.mainPanel.setMinimumSize(new Dimension(110, 150));
            this.mainPanel.setPreferredSize(new Dimension(110, 150));
            if (this.needChkPreview) {
                this.mainPanel.add((Component)this.getChkPreview(), "South");
            }
            this.mainPanel.setAlignmentY(1.0f);
            this.mainPanel.setAlignmentX(1.0f);
            this.mainPanel.add((Component)this.getPnlContainer(), "Center");
        } else if (this.needChkPreview) {
            this.mainPanel.add((Component)this.getChkPreview(), "South");
        }
        return this.mainPanel;
    }

    private void showView() {
        try {
            this.viewComponent.setVisible(true);
            this.statusLabel.setVisible(false);
            this.controlPanel.setVisible(true);
            this.molImporter.seekRecord(this.molPos, null);
            this.view.setMolecule(this.molImporter.nextDoc().getPrimaryMolecule());
            this.prevLabel.setEnabled(this.molPos != 0);
            this.nextLabel.setEnabled(this.molPos != this.maxMolecules - 1);
            this.firstLabel.setEnabled(this.prevLabel.isEnabled());
            this.lastLabel.setEnabled(this.nextLabel.isEnabled());
            this.countLabel.setText(this.molPos + 1 + "/" + this.maxMolecules);
            this.containerPanel.updateUI();
        }
        catch (Exception e) {
            this.error();
        }
    }

    private JPanel getPnlContainer() {
        if (this.containerPanel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(cantShow);
            this.statusLabel.setHorizontalTextPosition(0);
            this.statusLabel.setHorizontalAlignment(0);
            this.statusLabel.setFont(new Font("SansSerif", 1, 11));
            this.statusLabel.setOpaque(false);
            this.statusLabel.setVisible(false);
            this.containerPanel = new JPanel();
            this.containerPanel.setLayout(new BorderLayout());
            this.containerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.containerPanel.setBackground(Color.white);
            this.containerPanel.setPreferredSize(new Dimension(106, 126));
            this.viewComponent = this.view.getViewComponent();
            this.containerPanel.add(this.viewComponent, "Center");
            this.containerPanel.add((Component)this.statusLabel, "North");
            this.containerPanel.add((Component)this.getPnlButtons(), "South");
        }
        return this.containerPanel;
    }

    private JPanel getPnlButtons() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
            this.controlPanel.setOpaque(false);
            this.controlPanel.setVisible(false);
            this.controlPanel.add(Box.createHorizontalGlue());
            this.controlPanel.add(this.getFirstLabel());
            this.controlPanel.add(this.getPrevLabel());
            this.controlPanel.add(this.getCountLabel());
            this.controlPanel.add(this.getNextLabel());
            this.controlPanel.add(this.getLastLabel());
            this.controlPanel.add(Box.createHorizontalGlue());
        }
        return this.controlPanel;
    }

    private JLabel getFirstLabel() {
        if (this.firstLabel == null) {
            this.firstLabel = new JLabel();
            this.firstLabel.setIcon(new ImageIcon(this.getClass().getResource("first.gif")));
            this.firstLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("first_disabled.gif")));
            this.firstLabel.setOpaque(false);
            this.firstLabel.setAlignmentX(0.5f);
            this.firstLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MoleculeViewer.this.firstLabel.isEnabled()) {
                        int mp = MoleculeViewer.this.molPos;
                        MoleculeViewer.this.molPos = 0;
                        MoleculeViewer.this.firePropertyChange("molPosition", mp, MoleculeViewer.this.molPos);
                        MoleculeViewer.this.showView();
                    }
                }
            });
        }
        return this.firstLabel;
    }

    private JLabel getPrevLabel() {
        if (this.prevLabel == null) {
            this.prevLabel = new JLabel();
            this.prevLabel.setIcon(new ImageIcon(this.getClass().getResource("prev.gif")));
            this.prevLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("prev_disabled.gif")));
            this.prevLabel.setOpaque(false);
            this.prevLabel.setAlignmentX(0.5f);
            this.prevLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MoleculeViewer.this.autoChangeMode = -1;
                    MoleculeViewer.this.autoChangeTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    MoleculeViewer.this.autoChangeMode = 0;
                    MoleculeViewer.this.autoChangeTimer.stop();
                    MoleculeViewer.this.delayCount = 0;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!MoleculeViewer.this.notClick) {
                        MoleculeViewer.this.prevMolecule();
                    }
                    MoleculeViewer.this.notClick = false;
                }
            });
        }
        return this.prevLabel;
    }

    private JLabel getNextLabel() {
        if (this.nextLabel == null) {
            this.nextLabel = new JLabel();
            this.nextLabel.setIcon(new ImageIcon(this.getClass().getResource("next.gif")));
            this.nextLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("next_disabled.gif")));
            this.nextLabel.setOpaque(false);
            this.nextLabel.setAlignmentX(0.5f);
            this.nextLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MoleculeViewer.this.autoChangeMode = 1;
                    MoleculeViewer.this.autoChangeTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    MoleculeViewer.this.autoChangeMode = 0;
                    MoleculeViewer.this.autoChangeTimer.stop();
                    MoleculeViewer.this.delayCount = 0;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!MoleculeViewer.this.notClick) {
                        MoleculeViewer.this.nextMolecule();
                    }
                    MoleculeViewer.this.notClick = false;
                }
            });
        }
        return this.nextLabel;
    }

    private void nextMolecule() {
        if (this.nextLabel.isEnabled()) {
            ++this.molPos;
            this.firePropertyChange("molPosition", this.molPos - 1, this.molPos);
            this.showView();
        }
    }

    private void prevMolecule() {
        if (this.prevLabel.isEnabled()) {
            --this.molPos;
            this.firePropertyChange("molPosition", this.molPos + 1, this.molPos);
            this.showView();
        }
    }

    private JLabel getLastLabel() {
        if (this.lastLabel == null) {
            this.lastLabel = new JLabel();
            this.lastLabel.setIcon(new ImageIcon(this.getClass().getResource("last.gif")));
            this.lastLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("last_disabled.gif")));
            this.lastLabel.setOpaque(false);
            this.lastLabel.setAlignmentX(0.5f);
            this.lastLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MoleculeViewer.this.lastLabel.isEnabled()) {
                        int mp = MoleculeViewer.this.molPos;
                        MoleculeViewer.this.molPos = MoleculeViewer.this.maxMolecules - 1;
                        MoleculeViewer.this.firePropertyChange("molPosition", mp, MoleculeViewer.this.molPos);
                        MoleculeViewer.this.showView();
                    }
                }
            });
        }
        return this.lastLabel;
    }

    private JLabel getCountLabel() {
        if (this.countLabel == null) {
            this.countLabel = new JLabel("0/0");
            this.countLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }
        return this.countLabel;
    }

    public void clear() {
        this.executor.shutdownNow();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MoleculeViewer.this.view.setMolecule(null);
                MoleculeViewer.this.viewComponent.setVisible(false);
                MoleculeViewer.this.statusLabel.setVisible(false);
                MoleculeViewer.this.controlPanel.setVisible(false);
                MoleculeViewer.this.close();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void setMolImporter(MolImporter m) {
        this.close();
        this.molImporter = m;
    }

    public void close() {
        try {
            if (this.molImporter != null) {
                this.molImporter.close();
                this.molImporter = null;
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException ie) {
    }

    private void workerFinished(int maxCount, String path) {
        if (this.moleculeFilePath != path) {
            return;
        }
        this.maxMolecules = maxCount;
        if (this.maxMolecules > 0 && this.maxMolecules > this.molPos) {
            MolImporter importer = null;
            try {
                importer = new MolImporter(path);
            }
            catch (IOException e) {
                this.error();
                MoleculeViewer.close(importer);
                return;
            }
            this.setMolImporter(importer);
            this.statusLabel.setVisible(false);
            this.showView();
            this.repaint();
        } else {
            this.error();
        }
    }

    private static void close(MolImporter anImporter) {
        if (anImporter != null) {
            try {
                anImporter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void error() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoleculeViewer.this.view.setMolecule(null);
                MoleculeViewer.this.viewComponent.setVisible(false);
                MoleculeViewer.this.statusLabel.setText(cantShow);
                MoleculeViewer.this.statusLabel.setVisible(true);
                MoleculeViewer.this.controlPanel.setVisible(false);
                MoleculeViewer.this.repaint();
                MoleculeViewer.this.close();
            }
        });
    }

    private static class DefaultMoleucleView
    extends JPanel
    implements MoleculeView {
        private static final long serialVersionUID = 1L;
        private MolPrinter printer = new MolPrinter();

        public DefaultMoleucleView() {
            this.printer.setDispopts((this.printer.getDispopts() | 0x1000) & 0xFFFFFFFC | 1);
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        @Override
        public void setMolecule(Molecule molecule) {
            Molecule mol = molecule;
            if (mol != null && mol.getDim() == 0) {
                mol = mol.cloneMolecule();
                mol.clean(2, null);
            }
            this.printer.setMol(mol);
        }

        @Override
        public Component getViewComponent() {
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            this.printer.setScale(this.printer.maxScale(this.getSize()));
            this.printer.paint(g2, this.getSize());
        }
    }

    public static interface MoleculeView {
        public void setMolecule(Molecule var1);

        public Component getViewComponent();
    }

    private static class Worker
    implements Runnable {
        private MoleculeViewer viewer;
        private final String path;
        private MolImporter importer;
        private int moleculeCount;

        public Worker(MoleculeViewer viewer, String path) {
            this.path = path;
            this.viewer = viewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.importer = new MolImporter(this.path);
                this.moleculeCount = this.getMolCount(this.importer);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Worker.this.viewer.workerFinished(Worker.this.moleculeCount, Worker.this.path);
                    }
                });
            }
            catch (IOException e) {
                this.viewer.error();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                MoleculeViewer.close(this.importer);
            }
        }

        private int getMolCount(MolImporter imp) throws MolFormatException, IOException, InterruptedException {
            int count = 0;
            while (imp.skipRecord()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ++count;
            }
            return count;
        }
    }
}

