/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.marvin.common.swing.AboutDialog;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.version.VersionInfo;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class AboutDialogImpl
implements AboutDialog {
    private static final String ICON_RESOURCE = "/chemaxon/icons/marvin/";
    private JDialog dialog;
    private JButton closeButton;
    private String programName;
    private String version;
    private Window parent;
    private String iconURL;
    String[] dataRows = new String[]{"Product Version:", "Build Date:", "Operating System:", "Java:", "Memory:", "Environment:", "Browser:", "Internal build id:"};
    String graphicData = null;

    @Override
    public void setParent(Window parent) {
        this.parent = parent;
    }

    @Override
    public void setIconURL(String url) {
        this.iconURL = url;
    }

    @Override
    public void setProgramName(String name) {
        this.programName = name;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setGraphicsData(String data) {
        this.graphicData = data;
    }

    @Override
    public void show() {
        if (this.parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)this.parent);
        }
        if (this.parent instanceof Frame) {
            this.dialog = new JDialog((Frame)this.parent);
        }
        this.initComponents();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
    }

    private ImageIcon getIcon() {
        if (this.iconURL != null) {
            return new ImageIcon(AboutDialogImpl.class.getResource(this.iconURL));
        }
        return AboutDialogImpl.getIcon(this.programName.toLowerCase());
    }

    private static ImageIcon getIcon(String progname) {
        Class<AboutDialogImpl> cl = AboutDialogImpl.class;
        if (progname.indexOf("sketch") != -1) {
            return new ImageIcon(cl.getResource("/chemaxon/icons/marvin/msketch64.png"));
        }
        if (progname.indexOf("view") != -1) {
            return new ImageIcon(cl.getResource("/chemaxon/icons/marvin/mview64.png"));
        }
        if (progname.indexOf("space") != -1) {
            return new ImageIcon(cl.getResource("/chemaxon/icons/marvin/mspace64.png"));
        }
        return new ImageIcon();
    }

    private String getMemoryInformation() {
        StringBuffer sb = new StringBuffer();
        Runtime rt = Runtime.getRuntime();
        DecimalFormat fmt = new DecimalFormat("0.0");
        long maxmem = rt.maxMemory();
        if (Long.MAX_VALUE != maxmem) {
            sb.append(fmt.format((double)maxmem / 1048576.0));
            sb.append("M maximum, ");
        }
        long freemem = rt.freeMemory();
        long totalmem = rt.totalMemory();
        sb.append(fmt.format((double)totalmem / 1048576.0));
        sb.append("M total, ");
        sb.append(fmt.format((double)freemem / 1048576.0));
        sb.append("M free");
        return sb.toString();
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel label1 = new JLabel();
        JLabel label2 = new JLabel();
        label2.setPreferredSize(new Dimension(330, 50));
        JLabel title1 = compFactory.createTitle("Copyright \u00a9 1998-2012 ChemAxon Ltd.");
        JEditorPane editorPane1 = new JEditorPane();
        this.closeButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.dialog.setTitle("About " + this.programName);
        this.dialog.setResizable(false);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        label1.setIcon(this.getIcon());
        contentPanel.add((Component)label1, cc.xy(1, 1));
        label2.setText(this.programName);
        label2.setFont(title1.getFont().deriveFont(1, 18.0f));
        contentPanel.add((Component)label2, cc.xy(3, 1));
        JEditorPane pane = this.createEditorPane();
        pane.setFont(title1.getFont());
        contentPanel.add((Component)pane, cc.xy(3, 3));
        contentPanel.add((Component)title1, cc.xy(3, 7));
        editorPane1.setEditorKit(new HTMLEditorKit());
        editorPane1.setOpaque(false);
        editorPane1.setEditable(false);
        editorPane1.setText("<html> <body> <a href=\"http://www.chemaxon.com\">http://www.chemaxon.com</a></body> </html>");
        editorPane1.setBackground(SystemColor.window);
        AboutDialogImpl.addHyperlinkListener(editorPane1);
        contentPanel.add((Component)editorPane1, cc.xy(3, 9));
        dialogPane.add((Component)contentPanel, "Center");
        dialogPane.add((Component)this.createButtonBar(), "South");
        contentPane.add((Component)dialogPane, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
    }

    private static void addHyperlinkListener(JEditorPane editorPane) {
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private JPanel createButtonBar() {
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.closeButton.setText("Close");
        this.closeButton.setFocusCycleRoot(true);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialogImpl.this.dialog.setVisible(false);
                AboutDialogImpl.this.dialog.dispose();
            }
        });
        buttonBar.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return buttonBar;
    }

    private JEditorPane createEditorPane() {
        String additionalData;
        String env;
        String browser;
        JEditorPane pane = new JEditorPane();
        pane.setEditorKit(new HTMLEditorKit());
        String product = this.programName + " " + this.version;
        String jvendor = System.getProperty("java.vendor");
        String jver = System.getProperty("java.version");
        String java = jvendor + " Java " + jver;
        String os = System.getProperty("os.arch");
        os = os + " " + System.getProperty("os.name");
        os = os + " " + System.getProperty("os.version");
        try {
            browser = System.getProperty("browser");
            browser = browser == null ? "-" : browser + " " + System.getProperty("browser.version");
        }
        catch (SecurityException sex) {
            browser = "";
        }
        String string = Environment.APPLET ? (Environment.UNTRUSTED ? "Untrusted Applet" : "Trusted Applet") : (env = Environment.JAVAWEBSTART ? "Java Web Start" : "Application");
        if (Environment.isAdmin()) {
            env = env + " (with administrator rights)";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><table>");
        this.insertData(builder, this.dataRows[0], product);
        this.insertData(builder, this.dataRows[1], VersionInfo.buildDate());
        this.insertData(builder, this.dataRows[7], VersionInfo.getInternalVersionId());
        this.insertData(builder, this.dataRows[2], os);
        this.insertData(builder, this.dataRows[3], java);
        this.insertData(builder, this.dataRows[4], this.getMemoryInformation());
        this.insertData(builder, this.dataRows[5], env);
        if (browser != null) {
            this.insertData(builder, this.dataRows[6], browser);
        }
        if (this.graphicData != null) {
            this.insertGraphicData(builder);
        }
        if ((additionalData = System.getProperty("AboutDialogData")) != null) {
            this.insertAdditionalData(builder, additionalData);
        }
        builder.append("</table></body></html>");
        pane.setText(builder.toString());
        pane.setEditable(false);
        pane.setOpaque(false);
        return pane;
    }

    private void insertGraphicData(StringBuilder builder) {
        String[] rows = this.graphicData.split("\n");
        for (int i = 0; i < rows.length; ++i) {
            String[] s = rows[i].split(" = ");
            if (s == null || s.length != 2) continue;
            this.insertData(builder, s[0], s[1]);
        }
    }

    private void insertAdditionalData(StringBuilder builder, String data) {
        String[] dataElements = data.split("\t");
        for (int i = 0; i < dataElements.length; i += 2) {
            this.insertData(builder, dataElements[i], dataElements[i + 1]);
        }
    }

    private void insertData(StringBuilder builder, String name, String value) {
        builder.append("<tr><td><b>");
        builder.append(name);
        builder.append("</b></td><td>");
        builder.append(value);
        builder.append("</td></tr>");
    }
}

