/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseException;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.ImportDialog;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.marvin.uif.builder.DefaultConfigurationProvider;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MolLoader;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class EditMolfileFrame
implements CallbackIface,
WindowListener,
ComponentListener,
CaretListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CONFIG = "default";
    private static final String NAMING_CONFIG = "IUPAC";
    private static final String DEFAULT_FORMAT = "mrv:P";
    private static final ResourceBundle RESOURCES;
    private static final String PROPERTY_EXPORT_FORMAT = "exportFormat";
    private static final String PROPERTY_JAVASTRING = "javaString";
    private static final String PROPERTY_JAVASTRING_ENABLED = "javaStringEnabled";
    private static final String PROPERTY_DOCUMENT = "document";
    private static final int MAXROWS = 40;
    private MolPanel molPanel;
    private JDialog dialog = null;
    private JButton importButton;
    private FormatHolder exportFormat;
    private boolean naming;
    private Dimension prevDialogSize = null;
    private boolean autoSizingDialog = false;
    private boolean dialogResizedByUser = false;
    private int index = 0;
    private JTextArea txt;
    private MDocument document;
    private boolean importEnabled = true;
    private PropertyChangeSupport propertySupport;
    private boolean javaString;
    private GUIModule module;
    private Map<String, FormatHolder> exportFormats;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(property, listener);
    }

    public void copy() {
        ClipboardHandler.putStringToClipboard(this.txt.getSelectedText());
    }

    public void cut() {
        this.copy();
        this.txt.replaceSelection("");
    }

    public void paste() {
        this.txt.replaceSelection(ClipboardHandler.getStringFromClipboard());
    }

    public void selectAll() {
        this.txt.setSelectionStart(0);
        this.txt.setSelectionEnd(this.txt.getText().length());
    }

    public void close() {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setVisible(false);
        this.windowClosing(new WindowEvent(this.dialog, 0));
    }

    public void doImport() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EditMolfileFrame.this.doImport(EditMolfileFrame.this.getExportFormat() != null ? EditMolfileFrame.this.getExportFormat().getFormat() : null);
            }
        }).run();
    }

    public void importAs() {
        if (this.naming) {
            this.doImport();
            return;
        }
        MFileFormat defaultFormat = this.getExportFormat() != null ? this.getExportFormat().getFormat() : null;
        ImportDialog importDialog = new ImportDialog((Dialog)this.dialog, this, this.getRecognizedFormat(), defaultFormat);
        importDialog.open();
    }

    public void writeToConsole() {
        System.out.println(this.txt.getText());
    }

    public void doNew() {
        this.setJavaString(false);
        this.txt.setText("");
    }

    public void convertToJavaString() {
        this.setJavaString(!this.isJavaString());
        this.updateText();
    }

    public boolean isJavaStringEnabled() {
        return this.getExportFormat() != null;
    }

    public boolean isImportEnabled() {
        return this.importEnabled;
    }

    @Override
    public Object callback(String method, Object o) {
        if (method.equals("setNaming")) {
            String configName;
            this.naming = (Boolean)o;
            String string = configName = this.naming ? NAMING_CONFIG : DEFAULT_CONFIG;
            if (!this.module.getActive().equalsIgnoreCase(configName)) {
                this.module.setActive(configName);
                this.updateMenus();
            }
        } else if (method.equals("setMolPanel")) {
            this.molPanel = (MolPanel)o;
            this.init();
        } else if (method.equals("show")) {
            String exportFormatStr;
            String s;
            this.setDocument((MDocument)o);
            String string = s = this.naming ? "name" : this.molPanel.getFormat();
            if ((s == null || s.equals("DEFAULT") || s.equals("")) && (s = this.getDocument().getInputFormat()) == null) {
                s = DEFAULT_FORMAT;
            }
            if (s.length() != 0 && s.charAt(s.length() - 1) == ':') {
                s = s.substring(0, s.length() - 1);
            }
            s = EditMolfileFrame.convertToHumanReadable(s);
            this.setExportFormat(this.findFormat(s));
            this.updateMenus();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.molPanel);
            String string2 = exportFormatStr = this.getExportFormat() != null ? this.getExportFormat().getName() : DEFAULT_FORMAT;
            if (this.setText(this.getDocument(), exportFormatStr)) {
                this.molPanel.showWindow(this.dialog);
            }
        } else if (method.equals("setIndex")) {
            this.index = (Integer)o;
        }
        return null;
    }

    private static String convertToHumanReadable(String format2) {
        if ("mrv".equals(format2)) {
            return DEFAULT_FORMAT;
        }
        if ("cml".equals(format2)) {
            return "cml:A";
        }
        return format2;
    }

    private void updateMenus() {
        this.dialog.setJMenuBar(this.module.getMenuBar());
        if (this.importButton != null) {
            this.dialog.getContentPane().remove(this.importButton);
        }
        if (this.naming) {
            this.dialog.getContentPane().add(this.importButton);
        }
    }

    private FormatHolder findFormat(String fmt) {
        String[] options;
        FormatHolder result = this.exportFormats.get(fmt);
        if (result == null && (options = MFileFormatUtil.splitFormatAndOptions(fmt))[0] != null) {
            result = this.exportFormats.get(options[0]);
        }
        return result;
    }

    private void init() {
        this.propertySupport = new PropertyChangeSupport(this);
        this.dialog = this.molPanel.isParentWindowDialog() ? new JDialog(this.molPanel.getParentDialog()) : new JDialog(this.molPanel.getParentFrame());
        Boolean b = (Boolean)this.molPanel.callback("isImportEnabled", null);
        if (b != null) {
            this.importEnabled = b;
        }
        try {
            this.module = new GUIModule(new DefaultConfigurationProvider().getConfiguration(EditMolfileFrame.class, "EditMolfileFrame.xml", null));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.registerFormats();
        this.registerActions();
        this.module.bindComponent(this.dialog.getRootPane());
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.txt = new JTextArea(40, 80);
        this.txt.addCaretListener(this);
        this.txt.setAlignmentX(0.5f);
        this.txt.setEditable(true);
        this.importButton = new JButton(this.module.getActions().getAction("import"));
        this.importButton.setAlignmentX(0.5f);
        JScrollPane scrollPane = new JScrollPane(this.txt);
        contentPane.add(scrollPane);
        this.txt.setFont(new Font("Courier", 0, 12));
        this.dialog.addWindowListener(this);
    }

    private void registerFormats() {
        this.exportFormats = Utils.newMap();
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, 1L, 393L);
        for (int i = 0; i < formats.length; ++i) {
            this.registerFormat(formats[i]);
        }
        this.registerFormat(MFileFormat.CML, null, "P");
        this.registerFormat(MFileFormat.CML, "A");
        this.registerFormat(MFileFormat.CML, "A", "P");
        this.registerFormat(MFileFormat.SMILES, "u");
        this.registerFormat(MFileFormat.SMILES, "0");
        this.registerFormat(MFileFormat.MRV, null, "P");
    }

    private void registerFormat(MFileFormat format2, String primaryOption) {
        this.registerFormat(format2, primaryOption, new String[]{null});
    }

    private void registerFormat(MFileFormat format2, String primaryOption, String ... extraOptions) {
        OptionDescriptor primaryDescriptor = this.findDescriptor(format2, primaryOption);
        OptionDescriptor[] extraDescriptors = this.findDescriptors(format2, extraOptions);
        if (primaryDescriptor == null && extraDescriptors.length == 0) {
            return;
        }
        FormatHolder holder = new FormatHolder(format2, format2.getName(), primaryDescriptor, extraDescriptors);
        this.exportFormats.put(holder.getName(), holder);
    }

    private OptionDescriptor findDescriptor(MFileFormat format2, String option) {
        OptionDescriptor[] result = this.findDescriptors(format2, option);
        return result.length > 0 ? result[0] : null;
    }

    private OptionDescriptor[] findDescriptors(MFileFormat format2, String ... options) {
        if (options == null) {
            return new OptionDescriptor[0];
        }
        Map<String, OptionDescriptor> descriptors = EditMolfileFrame.collectDescriptors(format2);
        ArrayList<OptionDescriptor> result = new ArrayList<OptionDescriptor>();
        for (String option : options) {
            if (!descriptors.containsKey(option)) continue;
            result.add(descriptors.get(option));
        }
        return result.toArray(new OptionDescriptor[result.size()]);
    }

    private static Map<String, OptionDescriptor> collectDescriptors(MFileFormat format2) {
        OptionDescriptor[] descriptors;
        HashMap<String, OptionDescriptor> result = new HashMap<String, OptionDescriptor>();
        try {
            descriptors = format2.createExportModule().getOptionDescriptors(format2.getName());
        }
        catch (MolExportException ignore) {
            return Collections.emptyMap();
        }
        for (OptionDescriptor descriptor : descriptors) {
            result.put(descriptor.getName(), descriptor);
        }
        return result;
    }

    private void registerFormat(MFileFormat format2) {
        if (MFileFormat.INCHI.equals(format2) && Environment.UNTRUSTED) {
            return;
        }
        String[] names = format2.getNames();
        for (int i = 0; i < names.length; ++i) {
            FormatHolder holder = new FormatHolder(format2, names[i]);
            this.exportFormats.put(holder.getName(), holder);
        }
    }

    private void registerActions() {
        this.registerExportFormatActions();
        this.registerCommonActions();
    }

    private void registerExportFormatActions() {
        for (FormatHolder element : this.exportFormats.values()) {
            this.module.getActions().register("format." + element.getName(), new ExportFormatAction(element));
        }
    }

    private void registerCommonActions() {
        this.module.getActions().register("cut", new DelegatingAction());
        this.module.getActions().register("copy", new DelegatingAction());
        this.module.getActions().register("paste", new DelegatingAction());
        this.module.getActions().register("selectAll", new DelegatingAction());
        this.module.getActions().register("close", new DelegatingAction());
        this.module.getActions().register("new", new DelegatingAction());
        this.module.getActions().register("writeToConsole", new DelegatingAction());
        this.module.getActions().register("convertToJavaString", new ConvertToJavaStringAction());
        if (this.importEnabled) {
            this.module.getActions().register("import", new DelegatingAction());
            this.module.getActions().register("importAs", new DelegatingAction());
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.prevDialogSize == null) {
            this.prevDialogSize = new Dimension(this.dialog.getSize());
            this.dialog.addComponentListener(this);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.molPanel.closeEditSource(this.dialog);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (SwingUtilities.getWindowAncestor(this.molPanel) != this.dialog.getOwner()) {
            this.molPanel.closeEditSource(this.dialog);
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension size = this.dialog.getSize();
        if (this.prevDialogSize.width != 0 && this.prevDialogSize.height != 0 && !size.equals(this.prevDialogSize)) {
            int dw = Math.abs(size.width - this.prevDialogSize.width);
            int dh = Math.abs(size.height - this.prevDialogSize.height);
            Dimension scrsz = this.dialog.getToolkit().getScreenSize();
            if (!this.autoSizingDialog && dw < scrsz.width / 10 && dh < scrsz.height / 10) {
                this.dialogResizedByUser = true;
            }
            this.prevDialogSize = new Dimension(size);
        }
        this.autoSizingDialog = false;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setText(MDocument doc, String fmt) {
        Object gpc;
        String str = null;
        if (fmt.equals("mrv")) {
            gpc = this.molPanel.getGlobalGUIProperties();
            doc.setGUIPropertyContainer((MPropertyContainer)gpc);
        }
        try {
            gpc = doc.getMainMoleculeGraph().getLock();
            synchronized (gpc) {
                if (fmt.equals(MFileFormat.NAME.getName())) {
                    try {
                        str = ((Molecule)doc.getMainMoleculeGraph()).toFormat(MFileFormat.NAME.getName());
                    }
                    catch (IllegalArgumentException e) {
                        str = "";
                    }
                } else {
                    str = doc.exportToFormat(fmt);
                }
            }
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.molPanel.getErrorDisplay().error("Cannot convert molecule to '" + fmt + "' format", ex);
            str = "";
        }
        if (str != null) {
            int rows;
            if (this.isJavaString()) {
                int off = 0;
                int eol = str.indexOf(10);
                if (eol < 0) {
                    str = "\"" + EditMolfileFrame.quote(str) + "\"";
                } else {
                    int lcount = 0;
                    StringBuffer fbuf = new StringBuffer();
                    StringBuffer lbuf = new StringBuffer();
                    while (true) {
                        String s = str.substring(off, eol);
                        if (lbuf.length() + s.length() > 74 && lcount > 0) {
                            fbuf.append("\"");
                            fbuf.append(lbuf.toString());
                            fbuf.append("\"+\n");
                            lbuf.setLength(0);
                            lcount = 0;
                        }
                        lbuf.append(EditMolfileFrame.quote(s));
                        lbuf.append("\\n");
                        ++lcount;
                        off = eol + 1;
                        if (off >= str.length()) break;
                        eol = str.indexOf(10, off);
                        if (eol >= 0) continue;
                        eol = str.length();
                    }
                    fbuf.append("\"" + lbuf.toString() + "\"\n");
                    str = fbuf.toString();
                }
            }
            this.txt.setText(str);
            if (this.naming) {
                this.txt.selectAll();
            }
            if ((rows = this.txt.getLineCount() + 2) > 40) {
                rows = 40;
            }
            if (rows != this.txt.getRows()) {
                this.txt.setRows(rows);
                if (!this.dialogResizedByUser) {
                    this.autoSizingDialog = true;
                    this.dialog.pack();
                }
            }
            return true;
        }
        return false;
    }

    private static String quote(String line) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void caretUpdate(CaretEvent ev) {
        this.module.getActions().getAction("copy").setEnabled(ev.getDot() != ev.getMark());
        this.module.getActions().getAction("cut").setEnabled(ev.getDot() != ev.getMark());
    }

    void doImport(MFileFormat format2) {
        String fmtopts = format2.getName();
        String s = this.txt.getText();
        String[] a = MFileFormatUtil.splitFileAndOptions(s);
        s = a[0];
        String fmt = null;
        String opts = null;
        if (a[1] != null) {
            a = MFileFormatUtil.splitFormatAndOptions(a[1]);
            fmt = a[0];
            opts = a[1];
        }
        if (fmtopts.indexOf(58) < 0) {
            fmtopts = fmtopts + ":";
        }
        String[] b = MFileFormatUtil.splitFormatAndOptions(fmtopts);
        if (fmt == null) {
            fmt = b[0];
            if (opts == null) {
                opts = b[1];
            }
        }
        if (fmt != null) {
            fmtopts = fmt + ":";
            if (opts != null) {
                fmtopts = fmtopts + opts;
            }
        } else {
            fmtopts = opts;
        }
        MDocument doc = null;
        PositionedInputStream mis = null;
        try {
            String text = EncodingUtil.escape(this.txt.getText(), 0);
            byte[] txtbytes = text.contains("\\u") ? this.txt.getText().getBytes("utf8") : EncodingUtil.getBytes(this.txt.getText());
            ByteArrayInputStream is = new ByteArrayInputStream(txtbytes);
            mis = new MolInputStream((InputStream)is, fmt);
            MRecordImporter mii = MolLoader.createImporter((MolInputStream)mis, opts);
            doc = mii.readDoc();
            MPropertyContainer guiprops = mii.getGlobalProperties();
            if (guiprops != null && this.molPanel.getSaveGlobalGUIProperties()) {
                this.molPanel.setGlobalGUIProperties(guiprops);
            }
        }
        catch (LicenseException lex) {
            this.molPanel.getErrorDisplay().error(lex.getMessage(), lex);
            return;
        }
        catch (Throwable ex) {
            System.err.println(ex);
            ex.printStackTrace();
            int line = mis != null ? mis.getLineCount() : 0;
            StringBuffer sb = new StringBuffer("Cannot import molecule.");
            if (line > 0) {
                sb.append("\nError in line ");
                sb.append(line);
                sb.append('.');
            }
            this.molPanel.getErrorDisplay().error(sb.toString(), ex);
            return;
        }
        if (doc != null) {
            Molecule[] m = new Molecule[]{(Molecule)doc.getMainMoleculeGraph()};
            this.molPanel.molLoaded(m, this.index);
            this.molPanel.firePropertyChangeEvent("windowClosing", null, "EditMolfileFrame-import" + this.index);
            this.windowClosing(null);
        } else {
            JOptionPane.showMessageDialog(this.dialog, "No molecule found.", "Error", 0);
        }
    }

    public FormatHolder getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(FormatHolder exportFormat) {
        if (exportFormat == null) {
            this.setJavaString(false);
        }
        boolean oldJSEnabled = this.isJavaStringEnabled();
        FormatHolder oldValue = this.getExportFormat();
        this.exportFormat = exportFormat;
        this.propertySupport.firePropertyChange(PROPERTY_EXPORT_FORMAT, oldValue, this.getExportFormat());
        this.propertySupport.firePropertyChange(PROPERTY_JAVASTRING_ENABLED, oldJSEnabled, this.isJavaStringEnabled());
        this.setTextFormat(exportFormat != null ? exportFormat.getName() : null);
    }

    private void setTextFormat(String formatStr) {
        Cursor old = this.dialog.getCursor();
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        if (formatStr != null && this.setText(this.getDocument(), formatStr)) {
            if (!this.naming) {
                this.molPanel.setFormat(formatStr);
            }
        } else if (formatStr == null) {
            this.txt.setText("");
        }
        this.dialog.setCursor(old);
        String s = RESOURCES.getString("editSourceTitle");
        this.dialog.setTitle(this.getExportFormat() == null ? s : s + " - " + this.getExportFormat().getDescription());
    }

    public boolean isJavaString() {
        return this.javaString;
    }

    public void setJavaString(boolean javaString) {
        boolean oldValue = this.isJavaString();
        this.javaString = javaString;
        this.propertySupport.firePropertyChange(PROPERTY_JAVASTRING, oldValue, this.isJavaString());
    }

    private void updateText() {
        if (this.getExportFormat() != null) {
            this.setText(this.getDocument(), this.getExportFormat().getName());
        } else {
            this.setText(this.getDocument(), "");
        }
    }

    private void setDocument(MDocument document) {
        MDocument oldDocument = this.getDocument();
        this.document = document;
        this.propertySupport.firePropertyChange(PROPERTY_DOCUMENT, oldDocument, this.getDocument());
    }

    private MDocument getDocument() {
        return this.document;
    }

    /*
     * Exception decompiling
     */
    private MFileFormat getRecognizedFormat() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void handleActionPerformed(String command) {
        if ("copy".equals(command)) {
            this.copy();
        } else if ("cut".equals(command)) {
            this.cut();
        } else if ("paste".equals(command)) {
            this.paste();
        } else if ("selectAll".equals(command)) {
            this.selectAll();
        } else if ("close".equals(command)) {
            this.close();
        } else if ("writeToConsole".equals(command)) {
            this.writeToConsole();
        } else if ("new".equals(command)) {
            this.doNew();
        } else if ("import".equals(command)) {
            this.doImport();
        } else if ("importAs".equals(command)) {
            this.importAs();
        }
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(EditMolfileFrame.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("EditMolfileFrame.properties not found");
        }
        RESOURCES = rc;
    }

    private static class FormatHolder {
        private final MFileFormat format;
        private final String name;
        private final String description;

        public FormatHolder(MFileFormat format2, String name) {
            this(format2, name, null, null);
        }

        public FormatHolder(MFileFormat format2, String name, OptionDescriptor primaryOption, OptionDescriptor[] extraOptions) {
            this.format = format2;
            this.description = primaryOption != null ? format2.getDescription() + "(" + primaryOption.getDescription() + ")" : format2.getDescription();
            this.name = this.generateName(name, primaryOption, extraOptions);
        }

        private String generateName(String defaultName, OptionDescriptor primaryOption, OptionDescriptor ... extraOptions) {
            if (primaryOption == null && extraOptions == null) {
                return defaultName;
            }
            StringBuilder b = new StringBuilder(defaultName);
            b.append(":");
            FormatHolder.append(b, primaryOption);
            FormatHolder.append(b, extraOptions);
            return b.toString();
        }

        private static void append(StringBuilder b, OptionDescriptor ... options) {
            for (OptionDescriptor option : options) {
                if (option == null) continue;
                b.append(option.getName());
            }
        }

        public MFileFormat getFormat() {
            return this.format;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ExportFormatAction
    extends AbstractStateAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private FormatHolder format;

        public ExportFormatAction(FormatHolder format2) {
            super(format2.getDescription(), false, true);
            this.format = format2;
            this.update();
            EditMolfileFrame.this.addPropertyChangeListener(EditMolfileFrame.PROPERTY_EXPORT_FORMAT, this);
            EditMolfileFrame.this.addPropertyChangeListener(EditMolfileFrame.PROPERTY_DOCUMENT, this);
        }

        @Override
        public void actionPerformed(ActionEvent ignored) {
            EditMolfileFrame.this.setExportFormat(this.format);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ignored) {
            this.update();
        }

        private void update() {
            this.setSelected(this.format.equals(EditMolfileFrame.this.getExportFormat()));
            RxnMolecule rxmol = EditMolfileFrame.this.getDocument() != null ? RxnMolecule.getReaction(EditMolfileFrame.this.getDocument().getMainMoleculeGraph()) : null;
            this.setEnabled(rxmol == null || (this.format.getFormat().getFlags() & 0x40L) != 0L);
        }
    }

    private class ConvertToJavaStringAction
    extends AbstractStateAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;

        public ConvertToJavaStringAction() {
            super(EditMolfileFrame.this.isJavaString(), false);
            this.propertyChange(null);
            EditMolfileFrame.this.addPropertyChangeListener(EditMolfileFrame.PROPERTY_JAVASTRING, this);
            EditMolfileFrame.this.addPropertyChangeListener(EditMolfileFrame.PROPERTY_JAVASTRING_ENABLED, this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditMolfileFrame.this.convertToJavaString();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setSelected(EditMolfileFrame.this.isJavaString());
            this.setEnabled(EditMolfileFrame.this.isJavaStringEnabled());
        }
    }

    private class DelegatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EditMolfileFrame.this.handleActionPerformed(e.getActionCommand());
        }
    }
}

