/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.swing.ActionButton;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Fit
implements CallbackIface,
ActionListener,
ListSelectionListener,
MouseListener {
    private JDialog dialog = null;
    private SketchPanel sketchPanel = null;
    private MAction applyAction;
    private MAction closeAction;
    private String timerTask = null;
    private JRadioButton selectionButton;
    private JRadioButton scaffoldButton;
    private JRadioButton rgroupDefinitionButton;
    private JList list;
    private DefaultListModel listModel = new DefaultListModel();
    private ViewPanel viewPanel = null;
    private ViewCanvas viewCanvas = null;
    private static final ResourceBundle RESOURCES;
    public static final LookAndFeel DEFAULT_LOANDFEEL;

    public Fit() {
        this.applyAction = new MAction("apply", RESOURCES.getString("apply"));
        this.applyAction.addActionListener(this);
        this.closeAction = new MAction("close", RESOURCES.getString("close"));
        this.closeAction.addActionListener(this);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("show")) {
            this.init();
            this.dialog.pack();
            this.timerTask = "show";
            Timer tmr = new Timer(20, this);
            tmr.setRepeats(false);
            tmr.start();
        } else if (!method.equals("setMol") && !method.equals("setDocument")) {
            if (method.equals("setViewPanel")) {
                this.viewPanel = (ViewPanel)arg;
            } else if (method.equals("setViewCanvas")) {
                this.viewCanvas = (ViewCanvas)arg;
            }
        }
        return null;
    }

    private void init() {
        Container parent;
        for (parent = this.sketchPanel != null ? this.sketchPanel : this.viewPanel; parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        if (parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)parent, true);
        } else if (parent instanceof Frame) {
            this.dialog = new JDialog((Frame)parent, true);
        }
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("marvinSketch") + ": " + rc.getString("fit"));
        this.addMainPanel();
        this.dialog.setModal(false);
        this.dialog.addMouseListener(this);
    }

    private Component addMainPanel() {
        JPanel panel = new JPanel();
        this.dialog.getContentPane().add(panel);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        JLabel label = new JLabel(RESOURCES.getString("zoomTo"));
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(12, 12, 6, 6);
        panel.add((Component)label, gbc);
        this.selectionButton = new JRadioButton(RESOURCES.getString("selection"));
        this.selectionButton.setActionCommand("selection");
        this.selectionButton.addActionListener(this);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 5, 4, 6);
        gbc.gridwidth = 3;
        panel.add((Component)this.selectionButton, gbc);
        this.scaffoldButton = new JRadioButton(RESOURCES.getString("scaffold"));
        this.scaffoldButton.setActionCommand("scaffold");
        this.scaffoldButton.addActionListener(this);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 5, 4, 6);
        panel.add((Component)this.scaffoldButton, gbc);
        this.rgroupDefinitionButton = new JRadioButton(RESOURCES.getString("rgroupDefinition"));
        this.rgroupDefinitionButton.setActionCommand("rgroupDefinition");
        this.rgroupDefinitionButton.addActionListener(this);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 5, 4, 6);
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        panel.add((Component)this.rgroupDefinitionButton, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectionButton);
        group.add(this.scaffoldButton);
        group.add(this.rgroupDefinitionButton);
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(5);
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(80, 80));
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = new Insets(6, 6, 0, 11);
        gbc.anchor = 14;
        gbc.gridwidth = 1;
        panel.add((Component)listScroller, gbc);
        ActionButton applyButton = new ActionButton(this.applyAction);
        int height = applyButton.getPreferredSize().height;
        applyButton.setPreferredSize(new Dimension(80, height));
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.insets = new Insets(17, 5, 11, 0);
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.anchor = 14;
        panel.add((Component)applyButton, gbc);
        ActionButton closeButton = new ActionButton(this.closeAction);
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.insets = new Insets(17, 5, 11, 11);
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        closeButton.setPreferredSize(new Dimension(80, height));
        panel.add((Component)closeButton, gbc);
        return panel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        Object t = ev.getSource();
        if (t instanceof Timer) {
            if (!this.timerTask.equals("show")) return;
            if (this.sketchPanel != null) {
                MolEditor editor = this.sketchPanel.getEditor();
                if (editor != null) {
                    this.rgroupList(editor.getDocument());
                }
            } else if (this.viewCanvas != null) {
                this.rgroupList(this.viewCanvas.getDocument());
            }
            this.dialog.setVisible(true);
            this.selectionButton.setSelected(true);
            this.list.setEnabled(false);
            return;
        }
        if (t instanceof MAction) {
            String cmd = ev.getActionCommand();
            if (!cmd.equals("apply")) {
                if (!cmd.equals("close")) return;
                this.dialog.setVisible(false);
                return;
            }
            MoleculeGraph molg = null;
            if (this.sketchPanel != null) {
                MolEditor editor = this.sketchPanel.getEditor();
                molg = editor.getDocument().getMainMoleculeGraph();
            } else if (this.viewCanvas != null && this.viewCanvas.getDocument() != null) {
                molg = this.viewCanvas.getDocument().getMainMoleculeGraph();
            }
            if (this.selectionButton.isSelected() && this.sketchPanel != null) {
                this.sketchPanel.fitFragment(true, null, 0);
            }
            if (this.scaffoldButton.isSelected()) {
                if (molg == null) return;
                if (!(molg instanceof RgMoleculeGraphIface)) return;
                MoleculeGraph[] mg = new MoleculeGraph[1];
                RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)molg);
                mg[0] = rgmol.getRootG();
                if (this.sketchPanel != null) {
                    this.sketchPanel.fitFragment(false, mg, 0);
                    return;
                }
                if (this.viewCanvas == null) return;
                return;
            } else {
                if (!this.rgroupDefinitionButton.isSelected()) return;
                if (molg == null) return;
                if (!(molg instanceof RgMoleculeGraphIface)) return;
                RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)molg);
                if (this.listModel.isEmpty()) return;
                String rs = (String)this.listModel.get(this.list.getSelectedIndex());
                rs = rs.substring(1);
                long id = Long.parseLong(rs);
                int index = this.getRgroupIndex(rgmol, id);
                int m = rgmol.getRgroupMemberCount(index);
                MoleculeGraph[] mg = new MoleculeGraph[m];
                for (int j = 0; j < m; ++j) {
                    mg[j] = rgmol.getRgroupMemberG(index, j);
                }
                if (this.sketchPanel != null) {
                    this.sketchPanel.fitFragment(false, mg, (int)id);
                    return;
                }
                if (this.viewCanvas == null) return;
            }
            return;
        }
        if (!(t instanceof JRadioButton)) return;
        String cmd = ev.getActionCommand();
        if (cmd.equals("selection")) {
            this.list.setEnabled(false);
            return;
        }
        if (cmd.equals("scaffold")) {
            this.list.setEnabled(false);
            return;
        }
        if (!cmd.equals("rgroupDefinition")) return;
        this.list.setEnabled(true);
    }

    private int getRgroupIndex(RgMoleculeGraphIface rgmol, long id) {
        int k = rgmol.getRgroupCount();
        for (int i = 0; i < k; ++i) {
            if ((long)rgmol.getRgroupId(i) != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void rgroupList(MDocument document) {
        int selection = this.list.getSelectedIndex();
        MoleculeGraph molg = null;
        if (document != null) {
            molg = document.getMainMoleculeGraph();
        }
        if (molg == null) {
            return;
        }
        if (molg instanceof RgMoleculeGraphIface) {
            RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)molg);
            int rgNumber = rgmol.getRgroupCount();
            if (!this.listModel.isEmpty()) {
                this.listModel.clear();
            }
            for (int i = 0; i < rgNumber; ++i) {
                int rgid = rgmol.getRgroupId(i);
                this.listModel.addElement(new String("R" + rgid));
            }
            if (!this.listModel.isEmpty()) {
                if (selection == -1 || selection >= this.listModel.getSize()) {
                    this.list.setSelectedIndex(0);
                } else if (selection >= 0 && selection < this.listModel.getSize()) {
                    this.list.setSelectedIndex(selection);
                }
            }
        }
    }

    private void refreshRGroupDefinitionList() {
        if (this.sketchPanel != null) {
            MolEditor editor = this.sketchPanel.getEditor();
            if (editor != null) {
                this.rgroupList(editor.getDocument());
            }
        } else if (this.viewCanvas != null) {
            this.rgroupList(this.viewCanvas.getDocument());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.refreshRGroupDefinitionList();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static {
        DEFAULT_LOANDFEEL = UIManager.getLookAndFeel();
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(Fit.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("Fit.properties not found");
        }
        RESOURCES = rc;
    }
}

