/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.PagesActions;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.swing.ActionButton;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.MViewFrame;
import chemaxon.struc.MDocument;
import chemaxon.struc.PageSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class IntegerDialog
implements CallbackIface,
ActionListener,
FocusListener {
    private JDialog dialog = null;
    private MAction okAction = new MAction("ok", MolPanel.GRESOURCES.getString("ok"));
    private MAction cancelAction;
    private String timerTask = null;
    private boolean isValueProper = true;
    private PageSettings pageSettings = null;
    private SketchCanvas sketchCanvas = null;
    private SketchPanel sketchPanel = null;
    private MDocument document;
    private JTextField textField;
    private MViewFrame viewFrame = null;
    private ViewPanel viewPanel = null;
    private ViewCanvas viewCanvas = null;
    private static final ResourceBundle RESOURCES;

    public IntegerDialog() {
        this.okAction.addActionListener(this);
        this.cancelAction = new MAction("cancel", MolPanel.GRESOURCES.getString("cancel"));
        this.cancelAction.addActionListener(this);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("setViewFrame")) {
            this.viewFrame = (MViewFrame)arg;
        } else if (method.equals("setViewPanel")) {
            this.viewPanel = (ViewPanel)arg;
        } else if (method.equals("show")) {
            this.init();
            this.dialog.pack();
            this.timerTask = "show";
            Timer tmr = new Timer(20, this);
            tmr.setRepeats(false);
            tmr.start();
        } else if (method.equals("setDocument")) {
            this.document = (MDocument)arg;
            this.pageSettings = (PageSettings)this.document.getPageSettings().clone();
        } else if (method.equals("setSketchCanvas")) {
            this.sketchCanvas = (SketchCanvas)arg;
        } else if (method.equals("setViewCanvas")) {
            this.viewCanvas = (ViewCanvas)arg;
        }
        return null;
    }

    private void init() {
        Container parent = null;
        if (this.sketchPanel != null) {
            parent = this.sketchPanel;
        } else if (this.viewFrame != null) {
            parent = this.viewFrame;
        } else if (this.viewPanel != null) {
            parent = this.viewPanel;
        }
        while (parent != null && !(parent instanceof Frame) && !(parent instanceof Dialog)) {
            parent = parent.getParent();
        }
        if (parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)parent, true);
        } else if (parent instanceof Frame) {
            this.dialog = new JDialog((Frame)parent, true);
        }
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("goToPage"));
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 0;
        ++gbc.gridy;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbl.setConstraints(this.addEditorPanel(), gbc);
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets.top = 2;
        gbc.insets.bottom = 1;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbl.setConstraints(this.addOkCancelPanel(), gbc);
    }

    private Component addEditorPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        gbc.insets.left = 10;
        gbl.setConstraints(panel.add(new JLabel(RESOURCES.getString("enterPageNumber") + "(" + 1 + "..." + this.pageSettings.getColumnCount() * this.pageSettings.getRowCount() + ")" + ":")), gbc);
        ++gbc.gridx;
        this.textField = new JTextField(5);
        panel.add(this.textField);
        this.textField.setText(String.valueOf(this.pageSettings.getSelectedPage() + 1));
        this.textField.addFocusListener(this);
        gbl.setConstraints(this.textField, gbc);
        this.dialog.getContentPane().add(panel);
        return panel;
    }

    private Component addOkCancelPanel() {
        JPanel panel = new JPanel();
        this.dialog.getContentPane().add(panel);
        panel.add(new ActionButton(this.okAction));
        panel.add(new ActionButton(this.cancelAction));
        return panel;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object src = event.getSource();
        this.isValueProper = true;
        if (src instanceof JTextField) {
            JTextField t = (JTextField)src;
            int x = 0;
            try {
                x = Integer.valueOf(t.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (t == this.textField) {
                if (x > 0 && x <= this.pageSettings.getColumnCount() * this.pageSettings.getRowCount()) {
                    this.pageSettings.setSelectedPage(x - 1);
                    this.textField.setText(String.valueOf(x));
                } else {
                    this.isValueProper = false;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object t = ev.getSource();
        if (t instanceof Timer) {
            if (this.timerTask.equals("show")) {
                this.dialog.setVisible(true);
            }
        } else if (t instanceof MAction) {
            String cmd = ev.getActionCommand();
            if (cmd.equals("ok")) {
                if (this.isValueProper) {
                    this.document.setPageSettings(this.pageSettings);
                    this.dialog.setVisible(false);
                    if (this.sketchPanel != null) {
                        this.sketchPanel.centraliseSelectedPage(this.pageSettings);
                        this.sketchCanvas.repaint();
                        this.sketchPanel.updateStatusBar();
                    }
                    if (this.viewCanvas != null) {
                        this.viewCanvas.centralize(this.pageSettings);
                        if (this.viewCanvas.isInWin()) {
                            this.viewFrame.updateStatusBarSettings();
                        }
                        this.viewCanvas.repaint();
                    }
                } else {
                    PagesActions.showErrorMessageDialog(this.dialog);
                }
            } else if (cmd.equals("cancel")) {
                this.dialog.setVisible(false);
            }
            this.isValueProper = false;
        }
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(IntegerDialog.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("IntegerDialog.properties not found");
        }
        RESOURCES = rc;
    }
}

