/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.help.HelpResource;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.util.FindCodeBase;
import java.awt.Component;
import java.net.URL;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.MainWindow;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JavaHelp
implements CallbackIface {
    MolPanel molPanel = null;
    HelpSet helpSet = null;
    HelpBroker helpBroker = null;
    MainWindow mainWindow = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setMolPanel")) {
            this.molPanel = (MolPanel)arg;
        } else if (method.equals("doJavaHelp")) {
            if (this.helpBroker == null) {
                this.initJavaHelp();
            }
        } else if (method.equals("setDisplayed")) {
            this.updateActivationWindow();
            this.helpBroker.setDisplayed(Boolean.TRUE.equals(arg));
        } else if (method.equals("setHelpID")) {
            this.helpBroker.setCurrentID(arg.toString());
        } else {
            if (method.equals("getHelpBroker")) {
                return this.helpBroker;
            }
            if (method.equals("enableHelpOnButton")) {
                JComponent component = (JComponent)((Object[])arg)[0];
                String helpID = ((Object[])arg)[1].toString();
                this.helpBroker.enableHelpOnButton((Component)component, helpID, this.helpSet);
            }
        }
        return null;
    }

    protected void initJavaHelp() {
        try {
            ClassLoader cl = JavaHelp.class.getClassLoader();
            URL url = null;
            url = Environment.JAVAWEBSTART ? FindCodeBase.getResource(HelpResource.class, "/" + this.molPanel.getHelpSetLocation()) : HelpSet.findHelpSet((ClassLoader)cl, (String)this.molPanel.getHelpSetLocation());
            this.helpSet = new HelpSet(null, url);
            this.helpBroker = this.helpSet.createHelpBroker();
            this.helpBroker.enableHelpKey((Component)this.molPanel, "Sketch", this.helpSet);
        }
        catch (Exception e) {
            System.err.println("API Help Set not found");
        }
    }

    private void updateActivationWindow() {
        if (this.helpBroker instanceof DefaultHelpBroker) {
            ((DefaultHelpBroker)this.helpBroker).setActivationWindow(SwingUtilities.getWindowAncestor(this.molPanel));
        }
    }
}

