/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.common.util.IntVector;
import chemaxon.common.util.LongVector;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.MoleculeViewAccessory;
import chemaxon.marvin.common.swing.MoleculeViewer;
import chemaxon.marvin.common.swing.modules.FreeLoadSave;
import chemaxon.marvin.common.swing.modules.LoadSaveBase;
import chemaxon.marvin.common.swing.modules.MessagePanel;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.MHeaderReader;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MolFragLoader;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ImageExportUtil;
import chemaxon.util.IntRange;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class LoadSave
extends LoadSaveBase
implements CallbackIface,
ActionListener,
Runnable {
    private static final int SAVE_CANCEL = 0;
    private static final int SAVE_NO = 1;
    private static final int SAVE_OVERWRITE = 2;
    private static final int SAVE_RECREATE = 3;
    private static final int SAVE_APPEND = 4;
    private static final int SAVE_SAMERECORD = 5;
    private static final String SYSTEM_EOL = System.getProperty("line.separator");
    protected static final int I_FILE = 0;
    protected static final int I_FMT = 1;
    protected static final int I_CMD = 2;
    protected static final int I_MOL = 3;
    protected static final int I_MOLCOUNT = 4;
    protected Object[] command;
    private LoadSave parent = null;
    private boolean secondRun = false;
    private int importedMoleculeIndex = -1;
    private File moleculeFile = null;
    private File cwd = null;
    private String format = null;
    private Molecule molecule = null;
    private boolean moleculeIsReaction = false;
    private boolean saveMoreMols = false;
    private boolean inNewThread = true;
    private String moleculeHeaderStr = null;
    private String moleculeStr = null;
    private String moleculeFooterStr = null;
    private byte[] moleculeHeaderData = null;
    private byte[] moleculeData = null;
    private byte[] moleculeFooterData = null;
    private int saveMode = 0;
    private int debug = 0;
    private int[] icells = null;
    private int molPosition = -1;
    private boolean silentMode = false;

    public LoadSave() {
        this.cwd = LoadSave.getDefaultDirectory();
    }

    private LoadSave(LoadSave p, File f, int position) {
        this.parent = p;
        this.molPanel = p.molPanel;
        this.debug = p.debug;
        this.moleculeFile = f;
        this.cwd = LoadSave.getDefaultDirectory();
        this.setCwd(f);
        this.format = p.format;
        this.command = p.command;
        this.molecule = p.molecule;
        this.moleculeIsReaction = p.moleculeIsReaction;
        this.saveMoreMols = p.saveMoreMols;
        this.icells = p.icells;
        this.moleculeHeaderStr = p.moleculeHeaderStr;
        this.moleculeStr = p.moleculeStr;
        this.moleculeFooterStr = p.moleculeFooterStr;
        this.moleculeHeaderData = p.moleculeHeaderData;
        this.moleculeData = p.moleculeData;
        this.moleculeFooterData = p.moleculeFooterData;
        this.importedMoleculeIndex = p.importedMoleculeIndex;
        this.saveMode = p.saveMode;
        this.molPosition = position;
        new Thread(this).start();
    }

    static File getDefaultDirectory() {
        try {
            String s = Environment.MACOS && Environment.getCodeBase() != null ? System.getProperty("user.home") : System.getProperty("user.dir");
            return new File(s);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public Object callback(String cmd, Object arg) {
        if (cmd.equals("setMolPanel")) {
            this.molPanel = (MolPanel)arg;
            this.debug = this.molPanel != null ? (Integer)this.molPanel.callback("getDebug", null) : 0;
        } else if (cmd.equals("setFile")) {
            File f = (File)arg;
            this.moleculeFile = f != null && f.isDirectory() ? null : f;
            this.setCwd(f);
        } else if (cmd.equals("setInNewThread")) {
            Boolean b = (Boolean)arg;
            this.inNewThread = b;
        } else {
            if (cmd.equals("getFile")) {
                return this.moleculeFile;
            }
            if (cmd.equals("getCwd")) {
                return this.cwd;
            }
            if (cmd.equals("setCwd")) {
                File f = (File)arg;
                this.cwd = f != null && f.isDirectory() ? null : f;
                this.setCwd(f);
            } else {
                if (cmd.equals("getMol")) {
                    return this.molecule;
                }
                if (cmd.equals("setCommand")) {
                    this.command = (Object[])arg;
                    if (this.inNewThread) {
                        Timer t = new Timer(20, this);
                        t.setRepeats(false);
                        t.start();
                    } else if (this.command[2].equals("saveAs")) {
                        this.saveAsPerformed(this.command);
                    } else if (this.command[2].equals("save")) {
                        this.savePerformed(this.command);
                    }
                } else if (cmd.equals("silentMode")) {
                    this.silentMode = Boolean.TRUE.equals(arg);
                } else if (cmd.equals("simpleWrite")) {
                    Object[] args = (Object[])arg;
                    File f = (File)args[0];
                    String molstr = null;
                    byte[] moldata = null;
                    if (args[1] instanceof String) {
                        molstr = (String)args[1];
                    } else if (args[1] instanceof byte[]) {
                        moldata = (byte[])args[1];
                    }
                    boolean append = (Boolean)args[2];
                    if (molstr != null) {
                        this.simpleWrite(f, molstr, append);
                    } else {
                        this.simpleWrite(f, moldata, append);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected JFileChooser makeChooser(PropertyChangeListener pcl, int molcount) {
        boolean out = pcl == null;
        File cwd = this.cwd;
        JFileChooser w = new JFileChooser(cwd);
        w.putClientProperty("FileChooser.readOnly", Boolean.TRUE);
        File selfile = this.initFilters(w, out, molcount);
        if (selfile != null && out) {
            w.setSelectedFile(selfile);
        }
        if (!out) {
            MoleculeViewAccessory mwa = new MoleculeViewAccessory(w);
            mwa.addPropertyChangeListener("molPosition", pcl);
            w.setAccessory(mwa);
        }
        if (out) {
            w.addPropertyChangeListener(new ExtensionHandler());
        }
        return w;
    }

    private File initFilters(JFileChooser w, boolean out, int molcount) {
        String newfmt;
        long flags = 0L;
        if (out) {
            flags = this.moleculeIsReaction ? (flags |= 0x40L) : (flags |= 0x20L);
            flags |= 1L;
            if (molcount > 1) {
                flags |= 0x800L;
            }
        } else {
            flags |= 2L;
        }
        FileFilter ff = w.getAcceptAllFileFilter();
        String fmt = this.format;
        String deffmt = this.molPanel.getUserSettings().getDefaultSaveFormat();
        File selfile = this.moleculeFile;
        if (fmt != null && !(newfmt = LoadSave.changeFormat(fmt, this.moleculeIsReaction)).equals(fmt)) {
            String s = selfile.getPath();
            if (s.endsWith("." + fmt)) {
                selfile = new File(s.substring(0, s.length() - fmt.length()) + newfmt);
            }
            fmt = newfmt;
        }
        String molfmt = this.molecule != null ? this.molecule.getInputFormat() : null;
        w.resetChoosableFileFilters();
        if (!out) {
            w.addChoosableFileFilter(new MolFileFilter("ALL_STRUCTURE_FILES"));
        }
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, flags, flags | 0x80L | 0x100L);
        boolean defselected = false;
        for (int i = 0; i < formats.length; ++i) {
            MolFileFilter mff = new MolFileFilter(formats[i]);
            String s = mff.getFormat();
            if (s.equals("inchi") && Environment.UNTRUSTED) continue;
            w.addChoosableFileFilter(mff);
            if (defselected && !s.equals(fmt) || !(fmt != null && MFileFormatUtil.isSubFormatOf(fmt, s) || out && fmt == null && s.equals(deffmt) || !out && fmt == null && s.equals("ALL_STRUCTURE_FILES")) && (!out || !MFileFormatUtil.isSubFormatOf(s, fmt) || !MFileFormatUtil.isSubFormatOf(s, molfmt))) continue;
            ff = mff;
            defselected = true;
        }
        if (!out) {
            w.addChoosableFileFilter(new MolFileFilter(MFileFormat.GZIP));
        }
        w.setFileFilter(ff);
        if (out) {
            try {
                w.setAcceptAllFileFilterUsed(false);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return selfile;
    }

    private static String changeFormat(String fmt, boolean rxn) {
        if (rxn) {
            if (fmt.equals("mol") || fmt.equals("rgf")) {
                return "rxn";
            }
            if (fmt.equals("sdf")) {
                return "rdf";
            }
            if (fmt.equals("csmol")) {
                return "csrxn";
            }
            if (fmt.equals("cssdf")) {
                return "csrdf";
            }
        } else {
            if (fmt.equals("rxn") || fmt.equals("rgf")) {
                return "mol";
            }
            if (fmt.equals("rdf")) {
                return "sdf";
            }
            if (fmt.equals("rxn")) {
                return "csmol";
            }
            if (fmt.equals("csrdf")) {
                return "cssdf";
            }
        }
        return fmt;
    }

    private void setCwd(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                this.cwd = f;
            } else {
                String s = f.getParent();
                if (s != null) {
                    this.cwd = new File(s);
                }
            }
        }
    }

    private void saveAsPerformed(Object[] v) {
        Molecule m = (Molecule)v[3];
        if (m == null) {
            m = new Molecule();
        }
        this.molecule = m;
        this.moleculeIsReaction = m.isReaction();
        JFileChooser w = this.makeChooser(null, 1);
        do {
            this.saveAs(w);
        } while (this.saveMode == 1);
    }

    private void savePerformed(Object[] v) {
        Molecule m = (Molecule)v[3];
        if (m == null) {
            m = new Molecule();
        }
        this.molecule = m;
        this.moleculeIsReaction = m.isReaction();
        if (this.moleculeFile != null) {
            this.saveMode = this.prepareSaving(this.moleculeFile);
            if (this.saveMode == 1) {
                this.command[2] = "saveAs";
                JFileChooser w = this.makeChooser(null, 1);
                do {
                    this.saveAs(w);
                } while (this.saveMode == 1);
                return;
            }
            if (this.saveMode == 0) {
                return;
            }
            if (this.inNewThread) {
                new LoadSave(this, this.moleculeFile, -1);
                this.molecule = null;
            } else {
                this.run();
            }
        } else {
            v[2] = "saveAs";
            this.callback("setCommand", v);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object t = e.getSource();
        if (t instanceof Timer) {
            Object[] v = this.command;
            this.icells = null;
            this.saveMoreMols = false;
            if (v[2].equals("open")) {
                MolPositionListener mpl = new MolPositionListener();
                File f = null;
                if (v[0] != null && v[0] instanceof File) {
                    f = (File)v[0];
                } else {
                    String prevformat = this.format;
                    this.format = null;
                    JFileChooser chooser = this.makeChooser(mpl, 1);
                    int r = chooser.showOpenDialog(this.molPanel);
                    if (r == 0) {
                        String sfmt;
                        f = chooser.getSelectedFile();
                        FileFilter sfilter = chooser.getFileFilter();
                        if (sfilter instanceof MolFileFilter && (sfmt = ((MolFileFilter)sfilter).getFormat()) != null && !sfmt.equals("ALL_STRUCTURE_FILES")) {
                            this.format = sfmt;
                        }
                    } else {
                        this.format = prevformat;
                    }
                }
                if (f != null) {
                    if (this.command.length == 4) {
                        new LoadSave(this, f, mpl.getMolPosition());
                    } else {
                        this.moleculeFile = f;
                        this.molPanel.callback("setFileFromLoadSave", this);
                    }
                }
            } else if (v[2].equals("saveAs")) {
                this.saveAsPerformed(v);
            } else if (v[2].equals("save")) {
                this.savePerformed(v);
            } else if (v[2].equals("saveAll") || v[2].equals("saveMore")) {
                this.saveMoreMols = true;
                int nmols = (Integer)v[4];
                if (v[2].equals("saveMore")) {
                    while (!this.enterMoreMolIndex(nmols)) {
                    }
                    if (this.icells == null) {
                        return;
                    }
                    nmols = this.icells.length;
                }
                if (nmols == 1 && v[3] != null) {
                    this.moleculeIsReaction = ((Molecule)v[3]).isReaction();
                }
                JFileChooser w = this.makeChooser(null, nmols);
                do {
                    this.saveAs(w);
                } while (this.saveMode == 1);
            }
        }
    }

    private String guessExtension(File[] newfile, MolFileFilter mff) {
        String fmt = this.format;
        String ext = MFileFormatUtil.getFileExtensionLC(newfile[0]);
        if (mff != null) {
            fmt = mff.getFormat();
            if (ext == null || MFileFormatUtil.getMostLikelyMolFormat("." + ext) == null) {
                ext = mff.getExtension();
                newfile[0] = new File(newfile[0].getPath() + "." + ext);
            }
        }
        if (ext == null && fmt != null) {
            ext = fmt;
            newfile[0] = new File(newfile[0].getPath() + "." + ext);
        }
        return ext;
    }

    private String guessFormat(String ext, File newfile, MolFileFilter mff) {
        String fmt = this.format;
        if (mff != null) {
            fmt = mff.getFormat();
        }
        if (!(ext == null || mff != null && mff.accept(newfile) || fmt != null && fmt.equals("sybyl") && ext.equals("mol"))) {
            fmt = MFileFormatUtil.getMostLikelyMolFormat("." + ext);
            MFileFormat mffmt = null;
            if (fmt != null) {
                mffmt = MFileFormatUtil.getFormat(fmt);
            }
            if (mffmt != null && (mffmt.getFlags() & 0x80L) != 0L) {
                File newf2 = new File(newfile.getPath().substring(0, newfile.getPath().length() - 1 - ext.length()));
                String ext2 = MFileFormatUtil.getFileExtensionLC(newf2);
                String fmt2 = MFileFormatUtil.getMostLikelyMolFormat("." + ext2);
                if (fmt2 != null) {
                    fmt = fmt + ":" + fmt2;
                }
            }
        }
        return fmt;
    }

    private void saveAs(JFileChooser w) {
        int r = w.showSaveDialog(this.molPanel);
        this.saveMode = 0;
        if (r == 0) {
            File[] newfile = new File[1];
            newfile[0] = w.getSelectedFile();
            if (newfile[0] != null) {
                String ext;
                String fmt;
                this.setCwd(newfile[0]);
                FileFilter ff = w.getFileFilter();
                MolFileFilter mff = null;
                if (ff instanceof MolFileFilter) {
                    mff = (MolFileFilter)ff;
                }
                if ((fmt = this.guessFormat(ext = this.guessExtension(newfile, mff), newfile[0], mff)) == null) {
                    JOptionPane.showMessageDialog(null, "Cannot determine output format from extension for file " + newfile[0].getName(), "Unknown output file format", 0);
                    this.saveMode = 1;
                    return;
                }
                this.format = fmt;
                this.format = this.handleSilentMode(this.format);
                this.saveMode = this.saveMoreMols ? this.confirmOverwrite(newfile[0]) : this.prepareSaving(newfile[0]);
                if (this.saveMode != 0 && this.saveMode != 1) {
                    if (this.inNewThread) {
                        new LoadSave(this, newfile[0], -1);
                    } else {
                        this.moleculeFile = newfile[0];
                        this.run();
                    }
                }
                this.moleculeFooterStr = null;
                this.moleculeStr = null;
                this.moleculeHeaderStr = null;
                this.moleculeFooterData = null;
                this.moleculeData = null;
                this.moleculeHeaderData = null;
            }
        }
    }

    private String handleSilentMode(String aFormat) {
        return this.silentMode && "name".equals(aFormat) ? "name:ignoreErrors" : aFormat;
    }

    @Override
    public void run() {
        if (this.secondRun) {
            this.parent.moleculeFile = this.moleculeFile;
            this.parent.format = this.format;
            this.parent.cwd = this.cwd;
            this.parent.command = this.command;
            this.parent.molecule = this.molecule;
            this.parent.moleculeIsReaction = this.moleculeIsReaction;
            this.parent.importedMoleculeIndex = this.importedMoleculeIndex;
            this.molPanel.callback("setFileFromLoadSave", this);
            return;
        }
        String cmd = (String)this.command[2];
        if (cmd.equals("open")) {
            if (this.open(this.moleculeFile)) {
                this.secondRun = true;
                SwingUtilities.invokeLater(this);
            }
        } else if (cmd.startsWith("save")) {
            if (this.saveMoreMols) {
                Object[] args = new Object[]{this.moleculeFile, this.format, this, this.molecule, this.icells};
                this.molPanel.callback((String)this.command[2], args);
                return;
            }
            boolean success = this.save(this.moleculeFile);
            this.molecule = null;
            this.molPanel.callback("savePerformed", this);
            if (this.inNewThread && success && !cmd.equals("save") && this.molPanel.getMolCount() <= 1) {
                this.secondRun = true;
                SwingUtilities.invokeLater(this);
            }
        }
    }

    private boolean open(File f) {
        IntVector linenums;
        LongVector positions;
        MolInputStream mis;
        FileInputStream fis;
        RandomAccessFile raf;
        String[] fmtopts;
        String filename;
        MRecordImporter imp;
        Molecule mol;
        block25: {
            this.importedMoleculeIndex = -1;
            this.setCwd(f);
            mol = new RgMolecule();
            imp = null;
            filename = f.getPath();
            String[] fileopts = MFileFormatUtil.splitFileAndOptions(filename);
            if (fileopts[1] != null) {
                fmtopts = MFileFormatUtil.splitFormatAndOptions(fileopts[1]);
                f = new File(fileopts[0]);
            } else {
                fmtopts = new String[2];
            }
            if (fmtopts[0] == null) {
                fmtopts[0] = MFileFormatUtil.getUnguessableFormat(fileopts[0]);
            }
            try {
                raf = new RandomAccessFile(f.getPath(), "r");
                fis = new FileInputStream(raf.getFD());
                ProgressMonitorInputStream pis = new ProgressMonitorInputStream(this.molPanel, "Examining " + f.getPath(), fis);
                mis = new MolInputStream((InputStream)new BufferedInputStream(pis), fmtopts[0], null, f.getPath());
                this.format = mis.getFormat();
                String[] fmtopts2 = this.format.indexOf(58) < 0 ? new String[]{this.format, null} : MFileFormatUtil.splitFormatAndOptions(this.format);
                if (fmtopts[0] == null) {
                    fmtopts[0] = fmtopts2[0];
                }
                if (fmtopts[1] == null) {
                    fmtopts[1] = fmtopts2[1];
                }
                try {
                    imp = MolLoader.createImporter(mis, fmtopts[1], this.debug);
                }
                catch (SecurityException sex) {
                    this.molPanel.getErrorDisplay().firewallError(sex, "file");
                }
                catch (IncompatibleClassChangeError ex) {
                    this.molPanel.getErrorDisplay().error(ex);
                }
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.molPanel, "File " + f.getName() + " not found", "File not found", 0);
                this.molecule = null;
                this.moleculeFile = null;
                return true;
            }
            catch (IOException ex) {
                this.molPanel.getErrorDisplay().error("Cannot import file " + f.getName(), ex);
                this.molecule = null;
                this.moleculeFile = null;
                return true;
            }
            positions = new LongVector();
            linenums = new IntVector();
            try {
                positions = this.examine(imp, linenums, true);
            }
            catch (IOException ex) {
                int nmols = positions.size() / 2;
                String msg = nmols == 0 ? "Cannot read file " + f.getName() : "Read error after molecule " + nmols;
                this.molPanel.getErrorDisplay().error(msg, ex);
                if (nmols != 0) break block25;
                this.moleculeFile = null;
                return true;
            }
        }
        int nmols = positions.size() / 2;
        String molindexes = null;
        if (nmols == 0) {
            JOptionPane.showMessageDialog(this.molPanel, "Cannot read molecule from empty file", "Empty file", 2);
            this.moleculeFile = f;
            this.molPanel.setFile(f);
            return true;
        }
        if (nmols > 1 && (molindexes = this.enterMolIndexesForOpen("The file contains " + nmols + " molecules.\n\n" + "Please enter molecule record numbers\nand/or ranges to load.\n" + "(eg.: 5, -3, 4-7, 2-)\n\n" + "Leave it empty to load all molecules.\n\n" + "Maximum number of records to load: 100", "Molecule records to load", nmols, this.molPosition < 0 ? 0 : this.molPosition)) == null) {
            return false;
        }
        long pos = 0L;
        int lnum = 0;
        if (this.importedMoleculeIndex != -1) {
            pos = positions.size() > 0 ? positions.get(2 * this.importedMoleculeIndex) : 0L;
            lnum = linenums.size() > 0 ? linenums.get(this.importedMoleculeIndex) : 0;
        }
        try {
            MDocument doc;
            FreeLoadSave freeLoadSave;
            String title;
            String msg;
            int r;
            MPropertyContainer gbc;
            raf.seek(0L);
            FileInputStream is = fis = new FileInputStream(raf.getFD());
            String misformat = fmtopts[0] != null && fmtopts[1] != null ? fmtopts[0] + ":" + fmtopts[1] : fmtopts[0];
            mis = new MolInputStream((InputStream)is, misformat, null, f.getPath());
            if (this.molPanel.getUserSettings().getSaveGUIPropertiesInMRV() && (gbc = imp.getGlobalProperties()) != null && gbc.size() > 0 && (r = JOptionPane.showConfirmDialog(this.molPanel, msg = "The input file includes GUI settings for Marvin.\nAre you sure to overwrite current settings with the input file stored ones?", title = "Overwrite GUI settings", 0)) == 0) {
                this.molPanel.setGlobalGUIProperties(gbc);
            }
            if (nmols > 1) {
                if (this.importedMoleculeIndex != -1) {
                    imp = MolLoader.createImporter(mis, fmtopts[1], this.debug);
                    imp.getRecordReader().seek(pos, lnum, this.importedMoleculeIndex);
                    freeLoadSave = new FreeLoadSave();
                    doc = freeLoadSave.readDocument(imp);
                    if (doc != null) {
                        mol = (Molecule)doc.getMainMoleculeGraph();
                    }
                    this.moleculeFile = f;
                    this.molPanel.setFile(f);
                } else {
                    MolImporter importer = new MolImporter(mis, misformat);
                    MolFragLoader loader = new MolFragLoader(importer);
                    IntRange range = !molindexes.equals("") ? new IntRange(molindexes) : new IntRange("1-" + nmols);
                    loader.setRange(range);
                    mol = loader.loadFrags();
                    importer.close();
                    this.moleculeFile = null;
                    this.molPanel.setFile(null);
                }
            } else {
                freeLoadSave = new FreeLoadSave();
                imp = MolLoader.createImporter(mis, fmtopts[1], this.debug);
                doc = freeLoadSave.readDocument(imp);
                if (doc != null) {
                    mol = (Molecule)doc.getMainMoleculeGraph();
                }
                this.moleculeFile = f;
                this.molPanel.setFile(f);
            }
        }
        catch (Exception ex) {
            this.molPanel.getErrorDisplay().error("Cannot read molecule " + filename + ". " + molindexes, ex);
            this.moleculeFile = null;
            return true;
        }
        this.molecule = mol;
        this.molPanel.prepareMol(this.molecule);
        this.moleculeIsReaction = mol.isReaction();
        return true;
    }

    private long countRecordsInFile(File f) {
        LongVector positions = new LongVector();
        try {
            FileInputStream fis = new FileInputStream(f);
            ProgressMonitorInputStream pis = new ProgressMonitorInputStream(this.molPanel, "Examining " + f.getPath(), fis);
            if (this.format == null) {
                this.format = MFileFormatUtil.getUnguessableFormat(f.getPath());
            }
            MolInputStream mis = new MolInputStream((InputStream)pis, this.format, null, f.getPath());
            MRecordImporter mi = MolLoader.createImporter(mis, null, this.debug);
            positions = this.examine(mi, null, false);
            return positions.size() / 2;
        }
        catch (IOException ioex) {
            System.err.println("Cannot count records in the file");
            return -1L;
        }
    }

    private int prepareSaving(File f) {
        String msg;
        int r;
        Molecule mol = this.molecule;
        this.moleculeFooterStr = null;
        this.moleculeStr = null;
        this.moleculeHeaderStr = null;
        this.moleculeFooterData = null;
        this.moleculeData = null;
        this.moleculeHeaderData = null;
        if (this.format == null) {
            this.format = mol.getInputFormat();
        }
        if (mol.getDim() <= 2 && (this.format.equals("xyz") || this.format.equals("pov")) && (r = JOptionPane.showConfirmDialog(this.molPanel, msg = "Are you sure you want to save this 2D structure in " + this.format.toUpperCase() + " format?!?", "Don't save a 2D molecule in a 3D format", 1, 2)) != 0) {
            return r == 1 ? 1 : 0;
        }
        try {
            MolExportModule cv = MFileFormatUtil.createExportModule(this.format);
            if (cv == null) {
                throw new Exception("Cannot load export module for `" + this.format + "'");
            }
            if (this.molPanel.getSaveGlobalGUIProperties() && cv instanceof MrvExport) {
                MPropertyContainer gp = this.molPanel.getGlobalGUIProperties();
                ((MrvExport)cv).setGlobalGUIProperties(gp);
            }
            Object o1 = this.format.equals("pdf") ? cv.open(this.format + this.createExportDisplayProperties(this.format, mol)) : cv.open(this.format);
            Object o2 = null;
            if (this.format.equals(MFileFormat.NAME.getName()) && mol.getFragCount() == 1) {
                FreeLoadSave freeLoadSave = new FreeLoadSave();
                o2 = freeLoadSave.convert(cv, mol);
            }
            if (o2 == null) {
                o2 = cv.convert(mol);
            }
            Object o3 = cv.close();
            if (o2 != null && o2 instanceof String) {
                this.moleculeHeaderStr = (String)o1;
                this.moleculeStr = (String)o2;
                this.moleculeFooterStr = (String)o3;
            } else {
                this.moleculeHeaderData = (byte[])o1;
                this.moleculeData = (byte[])o2;
                this.moleculeFooterData = (byte[])o3;
                if (this.moleculeData != null) {
                    if (this.moleculeHeaderData == null) {
                        this.moleculeHeaderData = new byte[0];
                    }
                    if (this.moleculeFooterData == null) {
                        this.moleculeFooterData = new byte[0];
                    }
                }
            }
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
            this.molPanel.callback("setFileFromLoadSave", this);
            this.molecule = null;
            return 0;
        }
        catch (Throwable ex) {
            this.molPanel.getErrorDisplay().error("Cannot convert molecule to `" + this.format + "' format", ex);
            this.molPanel.callback("setFileFromLoadSave", this);
            this.molecule = null;
            return 0;
        }
        if (f.exists()) {
            String fmt = this.format;
            if (fmt.equals("cml") || fmt.equals("mrv") || fmt.equals("sdf") || fmt.equals("cssdf") || fmt.equals("rdf") || fmt.equals("csrdf") || fmt.equals("smiles") || fmt.equals("abbrevgroup") || fmt.equals("smarts") || fmt.equals("cxsmiles") || fmt.equals("cxsmarts") || fmt.equals("inchi")) {
                long rcount = this.countRecordsInFile(f);
                String message = "The file " + f.getName() + " already exists.\n\nDo you want to:";
                if (rcount > 1L) {
                    message = "The file " + f.getName() + " is an existing multimolecule file.\n" + "\nDo you want to:";
                    if (f.equals(this.moleculeFile)) {
                        Object[] options = new String[]{"Replace the whole file", "Overwrite the current molecule in the file.", "Overwrite an other molecule in the file.", "Append molecule to the existing file.", "Save changes to another file."};
                        int res = MessagePanel.showOptionDialog(this.molPanel, "Overwrite", message, options, options[0]);
                        switch (res) {
                            case 0: {
                                return 3;
                            }
                            case 1: {
                                return 5;
                            }
                            case 2: {
                                return 2;
                            }
                            case 3: {
                                return 4;
                            }
                            case 4: {
                                return 1;
                            }
                        }
                    } else {
                        Object[] options = new String[]{"Replace the whole file", "Overwrite a single molecule in the file.", "Append molecule to the existing file.", "Save changes to another file."};
                        int res = MessagePanel.showOptionDialog(this.molPanel, "Overwrite", message, options, options[0]);
                        switch (res) {
                            case 0: {
                                return 3;
                            }
                            case 1: {
                                return 2;
                            }
                            case 2: {
                                return 4;
                            }
                            case 3: {
                                return 1;
                            }
                        }
                    }
                } else {
                    Object[] options = new String[]{"Replace existing file", "Save changes to another file.", "Append structure to existing file."};
                    int res = MessagePanel.showOptionDialog(this.molPanel, "Overwrite", message, options, options[0]);
                    switch (res) {
                        case 0: {
                            return 3;
                        }
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            return 4;
                        }
                    }
                }
            } else {
                if (this.command[2].equals("saveAs")) {
                    int mode = JOptionPane.showConfirmDialog(this.molPanel, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
                    return mode == 0 ? 2 : 1;
                }
                return 2;
            }
            return 0;
        }
        return 3;
    }

    private String createExportDisplayProperties(String fileFormat, Molecule mol) {
        return ImageExportUtil.createImageExporterParameter(ImageExportUtil.mergeProperties(this.molPanel.getUserSettings(), this.molPanel.getGlobalGUIProperties(), this.molPanel.getBounds()), fileFormat, mol.getDocument());
    }

    private int confirmOverwrite(File f) {
        if (f.exists()) {
            int mode = JOptionPane.showConfirmDialog(this.molPanel, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 2 : 1;
        }
        return 3;
    }

    private byte[] binMolData() {
        byte[] data = new byte[this.moleculeHeaderData.length + this.moleculeData.length + this.moleculeFooterData.length];
        System.arraycopy(this.moleculeHeaderData, 0, data, 0, this.moleculeHeaderData.length);
        System.arraycopy(this.moleculeData, 0, data, this.moleculeHeaderData.length, this.moleculeData.length);
        System.arraycopy(this.moleculeFooterData, 0, data, this.moleculeHeaderData.length + this.moleculeData.length, this.moleculeFooterData.length);
        return data;
    }

    private boolean save(File f) {
        StringBuffer sb = new StringBuffer();
        switch (this.saveMode) {
            case 2: 
            case 5: {
                if (this.moleculeStr != null) {
                    return this.sdfOverwrite(f, this.moleculeStr, null);
                }
                return this.sdfOverwrite(f, null, this.binMolData());
            }
            case 3: {
                if (this.moleculeStr != null) {
                    if (this.moleculeHeaderStr != null) {
                        sb.append(this.moleculeHeaderStr);
                    }
                    if (this.moleculeStr != null) {
                        sb.append(this.moleculeStr);
                    }
                    if (this.moleculeFooterStr != null) {
                        sb.append(this.moleculeFooterStr);
                    }
                    return this.simpleWrite(f, sb.toString(), false);
                }
                return this.simpleWrite(f, this.binMolData(), false);
            }
            case 4: {
                if (this.parent.moleculeFile != null && f != null && !f.equals(this.parent.moleculeFile)) {
                    this.importedMoleculeIndex = Math.round(this.countRecordsInFile(f));
                }
                if (this.moleculeStr != null) {
                    boolean isXml;
                    if (this.moleculeFooterStr == null) {
                        String eol = null;
                        try {
                            RandomAccessFile raf = new RandomAccessFile(f, "r");
                            if (raf.length() != 0L) {
                                eol = this.findEOL(raf);
                                if (eol != null) {
                                    long pos = raf.length() - (long)eol.length();
                                    raf.seek(pos);
                                    byte[] bb = new byte[eol.length()];
                                    if (raf.read(bb) == -1 || !new String(bb).endsWith(eol)) {
                                        sb.append("\n");
                                    }
                                } else {
                                    sb.append("\n");
                                }
                                raf.close();
                            }
                        }
                        catch (IOException ioex) {
                            ioex.printStackTrace();
                        }
                        sb.append(this.moleculeStr);
                        if (eol != null) {
                            return this.simpleWrite(f, sb.toString(), true, eol);
                        }
                        return this.simpleWrite(f, sb.toString(), true);
                    }
                    MFileFormat[] mff = MFileFormatUtil.findFormats(this.format, 0L, 0L);
                    boolean bl = isXml = (mff[0].getFlags() & 0x4000L) != 0L;
                    if (isXml) {
                        return this.appendToXml(f);
                    }
                    return false;
                }
                if (this.moleculeFooterData.length == 0) {
                    return this.simpleWrite(f, this.moleculeData, true);
                }
                throw new RuntimeException("saving binary format with footer is not supported");
            }
        }
        return false;
    }

    private boolean appendToXml(File f) {
        RandomAccessFile raf = null;
        LongVector positions = new LongVector();
        try {
            FileInputStream fis = new FileInputStream(f);
            ProgressMonitorInputStream pis = new ProgressMonitorInputStream(this.molPanel, "Examining " + f.getPath(), fis);
            MolInputStream mis = new MolInputStream((InputStream)pis, this.format, null, f.getPath());
            MRecordImporter mi = MolLoader.createImporter(mis, null, this.debug);
            positions = this.examine(mi, null, false);
            raf = new RandomAccessFile(f, "rw");
            raf.seek(0L);
            String eol = this.findEOL(raf);
            if (eol == null) {
                eol = SYSTEM_EOL;
            }
            raf.seek(0L);
            if (mi.getRecordReader() instanceof MHeaderReader) {
                MHeaderReader hreader = (MHeaderReader)((Object)mi.getRecordReader());
                String xmlhdr = hreader.getXmlDeclarationHeader();
                StringBuffer insertsb = new StringBuffer();
                String rootElement = hreader.getRootElement();
                boolean isXmlHead = xmlhdr != null && xmlhdr.length() > 0;
                int insrtpos = 0;
                if (isXmlHead) {
                    if (rootElement == null) {
                        insrtpos = xmlhdr.length();
                        raf.seek(insrtpos - 1);
                        int b = -1;
                        while ((b = raf.read()) != -1 && (char)b != '<') {
                            ++insrtpos;
                        }
                        if (insrtpos > xmlhdr.length()) {
                            --insrtpos;
                        }
                        insertsb.append("<cml>\n");
                    }
                } else if (rootElement == null) {
                    insertsb.append(this.moleculeHeaderStr);
                } else {
                    int x = this.moleculeHeaderStr.indexOf("<cml");
                    insertsb.append(this.moleculeHeaderStr.substring(0, x));
                }
                String enc = Encoding.DEFAULT.name();
                long oldlength = raf.length();
                if (insertsb.length() > 0) {
                    StringBuffer sb = this.replaceEOL(insertsb.toString(), eol);
                    this.replaceFileContents(raf, insrtpos, insrtpos, sb.toString().getBytes(enc));
                }
                long newlength = raf.length();
                long diff = newlength - oldlength;
                long lasttagendpos = positions.get(positions.size() - 1);
                if ((lasttagendpos += diff) == newlength) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.moleculeStr);
                    sb.append(this.moleculeFooterStr);
                    raf.close();
                    this.simpleWrite(f, sb.toString(), true, eol);
                    return true;
                }
                long pos = lasttagendpos;
                raf.seek(pos);
                int b = -1;
                while ((b = raf.read()) != -1 && (char)b != '<') {
                    ++pos;
                }
                StringBuffer molsb = new StringBuffer();
                if (pos == lasttagendpos) {
                    molsb.append("\n");
                }
                molsb.append(this.moleculeStr);
                if (rootElement == null || !rootElement.equals("cml")) {
                    molsb.append(this.moleculeFooterStr);
                }
                StringBuffer sb = this.replaceEOL(molsb.toString(), eol);
                this.replaceFileContents(raf, pos, pos, sb.toString().getBytes(enc));
            }
        }
        catch (Exception ex) {
            int r = JOptionPane.showConfirmDialog(this.molPanel, "Cannot read file " + f.getName() + " in " + this.format + " format.\n" + "Overwrite?", "Cannot read file", 1, 2);
            if (r == 0) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                return this.simpleWrite(f, this.moleculeStr, false);
            }
            return false;
        }
        return true;
    }

    private boolean sdfOverwrite(File f, String molstr, byte[] moldata) {
        byte[] data;
        RandomAccessFile raf = null;
        LongVector positions = new LongVector();
        boolean encapsulated = false;
        try {
            FileInputStream fis = new FileInputStream(f);
            ProgressMonitorInputStream pis = new ProgressMonitorInputStream(this.molPanel, "Examining " + f.getPath(), fis);
            if (this.format == null) {
                this.format = MFileFormatUtil.getUnguessableFormat(f.getPath());
            }
            MolInputStream mis = new MolInputStream((InputStream)pis, this.format, null, f.getPath());
            MRecordImporter mi = MolLoader.createImporter(mis, null, this.debug);
            positions = this.examine(mi, null, false);
            fis.close();
            encapsulated = mi.getRecordReader().getEncapsulatedReader() != null;
            raf = new RandomAccessFile(f, "rw");
            raf.seek(0L);
            if (molstr != null) {
                String eol = this.findEOL(raf);
                if (eol == null) {
                    eol = SYSTEM_EOL;
                }
                StringBuffer molstr2 = this.replaceEOL(molstr, eol);
                if (mi.getRecordReader() instanceof MHeaderReader) {
                    int n = molstr2.length();
                    molstr2.setLength(n - eol.length());
                }
                molstr = molstr2.toString();
                data = molstr.getBytes(Encoding.DEFAULT.name());
            } else {
                data = moldata;
            }
        }
        catch (Exception ex) {
            int r = JOptionPane.showConfirmDialog(this.molPanel, "Cannot read file " + f.getName() + " in " + this.format + " format.\n" + "Overwrite?", "Cannot read file", 1, 2);
            if (r == 0) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                if (molstr != null) {
                    return this.simpleWrite(f, molstr, false);
                }
                return this.simpleWrite(f, moldata, false);
            }
            return false;
        }
        if (encapsulated && moldata != null) {
            int r;
            if (positions.size() > 2 && (r = JOptionPane.showConfirmDialog(this.molPanel, "Overwriting a single structure in an existing " + this.format + " file is not implemented.\n" + "You will lose " + positions.size() / 2 + " records " + "by overwriting the file.\n" + "Proceed?", "Cannot save into multimolecule file", 1, 2)) != 0) {
                return false;
            }
            return this.simpleWrite(f, moldata, false);
        }
        int nmols = positions.size() / 2;
        int k = 0;
        if (nmols > 1) {
            String msg = "\nThe file contains " + nmols + " molecules.\n\n" + "Please enter molecule record number\nto overwrite";
            int n = k = this.command[2].equals("save") || f.equals(this.parent.moleculeFile) ? this.importedMoleculeIndex : -1;
            if (this.saveMode == 2) {
                k = this.enterMolIndex(msg + " (1-" + nmols + ")", "Enter position", nmols, k);
            }
            if (k < 0) {
                return false;
            }
        }
        long start = 0L;
        long end = 0L;
        if (nmols > 0) {
            start = positions.get(2 * k);
            end = positions.get(2 * k + 1);
        }
        try {
            this.replaceFileContents(raf, start, end, data);
            raf.close();
        }
        catch (IOException ex) {
            this.molPanel.getErrorDisplay().error("Cannot write file " + f.getName(), ex);
            return false;
        }
        this.importedMoleculeIndex = k;
        return true;
    }

    private StringBuffer replaceEOL(String str, String eol) {
        StringBuffer newBuf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            newBuf.append(c == '\n' ? eol : String.valueOf(c));
        }
        if (!str.endsWith("\n")) {
            newBuf.append(eol);
        }
        return newBuf;
    }

    private String findEOL(RandomAccessFile raf) throws IOException {
        int c;
        String eol = "";
        while ((c = raf.read()) != -1) {
            if (c != 13 && c != 10) continue;
            eol = eol + String.valueOf((char)c);
            int cc = raf.read();
            if (cc != 13 && cc != 10 || cc == c) break;
            eol = eol + String.valueOf((char)cc);
            break;
        }
        if (eol.length() == 0) {
            eol = null;
        }
        return eol;
    }

    private String inputDialog(String message, String title, int defi) {
        String s = defi >= 0 ? String.valueOf(defi + 1) : null;
        JPanel contentPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        JTextArea text = new JTextArea();
        text.setText(message);
        text.setEditable(false);
        text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)text, cc.xy(1, 1));
        JTextField inputField = new JTextField();
        inputField.setText(s);
        contentPanel.add((Component)inputField, cc.xy(1, 3));
        if (this.moleculeFile == null) {
            this.moleculeFile = this.molPanel.getFile();
        }
        MoleculeViewer mw = defi >= 0 ? new MoleculeViewer(this.moleculeFile.getPath(), defi) : new MoleculeViewer(this.moleculeFile.getPath());
        contentPanel.add((Component)mw, cc.xywh(3, 1, 1, 5));
        int v = JOptionPane.showConfirmDialog(this.molPanel, contentPanel, title, 2, 3, null);
        String value = null;
        if (v == 0) {
            value = inputField.getText();
        }
        mw.clear();
        return value;
    }

    private boolean enterMoreMolIndex(int nmols) {
        this.icells = null;
        String s = this.inputDialog("\nThe file contains " + nmols + " molecules.\n\n" + "Please enter molecule record numbers\n" + "to save (min: 1 max: " + nmols + ").\n\n" + "( e.g.: 4-7,9,11 )", "Molecule record to save", -1);
        if (s == null) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(s, ",");
        try {
            TreeSet<Integer> scells = new TreeSet<Integer>();
            while (stk.hasMoreTokens()) {
                String tk = stk.nextToken();
                int x = tk.indexOf("-");
                if (x > -1) {
                    int start = Integer.parseInt(tk.substring(0, x)) - 1;
                    int end = Integer.parseInt(tk.substring(x + 1)) - 1;
                    if (start < 0) {
                        start = 0;
                    }
                    if (end >= nmols) {
                        end = nmols - 1;
                    }
                    for (int i = start; i <= end; ++i) {
                        scells.add(new Integer(i));
                    }
                    continue;
                }
                int index = Integer.decode(tk) - 1;
                if (0 <= index && index < nmols) {
                    scells.add(new Integer(index));
                    continue;
                }
                System.err.println("Warning:" + (index + 1) + " is out of range (1-" + nmols + ").");
            }
            if (scells.size() > 0) {
                this.icells = new int[scells.size()];
                Iterator it = scells.iterator();
                for (int i = 0; i < this.icells.length; ++i) {
                    this.icells[i] = (Integer)it.next();
                }
                return true;
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "Invalid input number(s)", "Input warning", 2);
            return false;
        }
        return false;
    }

    private int enterMolIndex(String msg, String title, int nmols, int defi) {
        int k;
        do {
            try {
                String s = this.inputDialog(msg, title, defi);
                if (s == null) {
                    return -1;
                }
                k = Integer.parseInt(s) - 1;
            }
            catch (NumberFormatException ex) {
                k = -1;
            }
        } while (k < 0 || k >= nmols);
        return k;
    }

    private String enterMolIndexesForOpen(String msg, String title, int nmols, int defi) {
        boolean valid;
        String s = null;
        do {
            try {
                IntRange range;
                int end;
                int start;
                int index;
                int x;
                String tk;
                s = this.inputDialog(msg, title, defi);
                if (s == null) {
                    return null;
                }
                valid = true;
                StringTokenizer stk = new StringTokenizer(s, ",");
                if (stk.countTokens() == 1) {
                    tk = stk.nextToken().trim();
                    x = tk.indexOf("-");
                    if (x < 0) {
                        index = Integer.decode(tk);
                        if (index <= 0 || nmols < index) {
                            JOptionPane.showMessageDialog(null, "Warning: " + index + " is out of range (1-" + nmols + ").", "Input warning", 2);
                            valid = false;
                        } else {
                            this.importedMoleculeIndex = index - 1;
                        }
                    } else {
                        String str = tk.substring(0, x);
                        start = str.length() > 0 ? Integer.parseInt(str) : 1;
                        str = tk.substring(x + 1);
                        int n = end = str.length() > 0 ? Integer.parseInt(str) : nmols;
                        if (start <= 0) {
                            JOptionPane.showMessageDialog(null, "Warning: " + start + " is out of range (1-" + nmols + ").", "Input warning", 2);
                            valid = false;
                        }
                        if (end > nmols) {
                            JOptionPane.showMessageDialog(null, "Warning: " + end + " is out of range (1-" + nmols + ").", "Input warning", 2);
                            valid = false;
                        }
                    }
                }
                while (stk.hasMoreTokens() && valid) {
                    tk = stk.nextToken().trim();
                    x = tk.indexOf("-");
                    if (x > -1) {
                        String str = tk.substring(0, x);
                        start = str.length() > 0 ? Integer.parseInt(str) : 1;
                        str = tk.substring(x + 1);
                        int n = end = str.length() > 0 ? Integer.parseInt(str) : nmols;
                        if (start <= 0) {
                            JOptionPane.showMessageDialog(null, "Warning: " + start + " is out of range (1-" + nmols + ").", "Input warning", 2);
                            valid = false;
                        }
                        if (end <= nmols) continue;
                        JOptionPane.showMessageDialog(null, "Warning: " + end + " is out of range (1-" + nmols + ").", "Input warning", 2);
                        valid = false;
                        continue;
                    }
                    index = Integer.decode(tk);
                    if (index > 0 && nmols >= index) continue;
                    JOptionPane.showMessageDialog(null, "Warning: " + index + " is out of range (1-" + nmols + ").", "Input warning", 2);
                    valid = false;
                }
                if (!valid || (range = s.equals("") ? new IntRange("1-" + nmols) : new IntRange(s)).size() <= 100) continue;
                JOptionPane.showMessageDialog(null, "Warning: the number of records you specified is too high; the maximum number of molcules to load is 100.", "Input warning", 2);
                valid = false;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Invalid input number(s). ", "Input warning", 2);
                valid = false;
            }
        } while (!valid);
        return s;
    }

    private LongVector examine(MRecordImporter imp, IntVector linenums, boolean setformat) throws MolFormatException, IOException {
        MRecordReader rr = imp.getRecordReader();
        LongVector positions = rr.detectRecordPositions(linenums);
        if (setformat) {
            for (MRecordReader rr1 = rr; rr1 != null; rr1 = rr1.getEncapsulatedReader()) {
                this.format = rr1.getRecognizedFormat();
            }
        }
        return positions;
    }

    private static class MolPositionListener
    implements PropertyChangeListener {
        static final int DEFAULT_POSITION = -1;
        private int molPosition = -1;

        private MolPositionListener() {
        }

        public int getMolPosition() {
            return this.molPosition;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("molPosition".equals(evt.getPropertyName())) {
                this.molPosition = Integer.parseInt(evt.getNewValue().toString());
            }
        }
    }

    private static class ExtensionHandler
    implements PropertyChangeListener {
        private ExtensionHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            final JFileChooser chooser = (JFileChooser)evt.getSource();
            if ("fileFilterChanged".equals(evt.getPropertyName())) {
                String fileName = this.getFileName(chooser);
                if (fileName == null) {
                    return;
                }
                String ext = MFileFormatUtil.getFileExtensionLC(fileName);
                if (ext == null) {
                    return;
                }
                FileFilter filter = chooser.getFileFilter();
                File newFile = new File(chooser.getCurrentDirectory(), fileName);
                if (filter instanceof MolFileFilter && !chooser.getFileFilter().accept(newFile) && this.isValidExtension(chooser, newFile)) {
                    String newExtension = ((MolFileFilter)filter).getExtension();
                    final String newFileName = fileName.substring(0, fileName.lastIndexOf(ext) - 1) + "." + newExtension;
                    final File currDir = chooser.getCurrentDirectory();
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            chooser.setSelectedFile(new File(currDir, newFileName));
                        }
                    });
                }
            }
        }

        private boolean isValidExtension(JFileChooser chooser, File file) {
            FileFilter[] filters = chooser.getChoosableFileFilters();
            for (int i = 0; i < filters.length; ++i) {
                if (filters[i] == chooser.getAcceptAllFileFilter() || !filters[i].accept(file)) continue;
                return true;
            }
            return false;
        }

        private String getFileName(JFileChooser chooser) {
            File file = chooser.getSelectedFile();
            if (file != null && !file.isDirectory()) {
                return file.getName();
            }
            if (file == null && chooser.getUI() instanceof BasicFileChooserUI) {
                return ((BasicFileChooserUI)chooser.getUI()).getFileName();
            }
            try {
                Method method = chooser.getUI().getClass().getMethod("getFileName", new Class[0]);
                if (method.getReturnType() == String.class) {
                    return (String)method.invoke((Object)chooser.getUI(), new Object[0]);
                }
            }
            catch (SecurityException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }
}

