/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MessagePanel
extends JPanel {
    private int selectedIndex = -1;

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private void setSelectedIndex(int x) {
        this.selectedIndex = x;
    }

    public static MessagePanel createMessagePanel(String message, Object[] selectOptions, Object initialOption) {
        final MessagePanel panel = new MessagePanel();
        EmptyBorder border = new EmptyBorder(5, 0, 0, 15);
        panel.setBorder(border);
        panel.setLayout(new BorderLayout());
        if (message != null) {
            JTextArea textArea = new JTextArea(message);
            textArea.setBackground(panel.getBackground());
            textArea.setEditable(false);
            panel.add((Component)textArea, "North");
        }
        JPanel optionsPanel = new JPanel();
        panel.add((Component)optionsPanel, "Center");
        Box vbox = Box.createVerticalBox();
        optionsPanel.add(vbox);
        final ButtonGroup bgroup = new ButtonGroup();
        for (int i = 0; i < selectOptions.length; ++i) {
            JRadioButton rb = new JRadioButton(selectOptions[i].toString());
            bgroup.add(rb);
            vbox.add(rb);
            if (selectOptions[i].equals(initialOption)) {
                rb.setSelected(true);
                panel.setSelectedIndex(i);
            }
            rb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Enumeration<AbstractButton> options = bgroup.getElements();
                        int i = 0;
                        while (options.hasMoreElements()) {
                            JRadioButton rb = (JRadioButton)options.nextElement();
                            if (rb.isSelected()) {
                                panel.setSelectedIndex(i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return panel;
    }

    public static int showOptionDialog(Component parent, String title, String message, Object[] selectOptions, Object initialOption) {
        MessagePanel panel = MessagePanel.createMessagePanel(message, selectOptions, initialOption);
        int res = JOptionPane.showOptionDialog(parent, panel, title, 2, 3, null, null, null);
        int selectedIndex = panel.getSelectedIndex();
        if (res == 0) {
            return selectedIndex;
        }
        return -1;
    }
}

