/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.DocumentSettingsConstants;
import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.PageSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;

public class Print
extends JFrame
implements CallbackIface,
Runnable,
WindowListener,
Printable {
    protected double atomSize = 0.4;
    protected double bondSpacing = 0.18;
    protected int dispopts = 0;
    protected MolPanel molPanel = null;
    private Molecule molecule = null;
    private MDocument document = null;
    public Image img;

    @Override
    public int print(Graphics g, PageFormat format2, int pageIndex) {
        Dimension image = new Dimension((int)Math.ceil(format2.getImageableWidth()), (int)Math.ceil(format2.getImageableHeight()));
        Dimension page = new Dimension((int)Math.ceil(format2.getWidth()), (int)Math.ceil(format2.getHeight()));
        if (this.molPanel == null) {
            MolPainterCommon p = new MolPainterCommon();
            p.setDispopts(this.dispopts);
            p.setBondSpacing(this.bondSpacing);
            MolPainter painter = new MolPainter(p);
            painter.setBackground(Color.white);
            painter.setAtomSize(this.atomSize);
            painter.setBoundsFor(this.molecule, false, false);
            if (this.document != null) {
                PageSettings ps = this.document.getPageSettings();
                if (ps.getRowCount() > 0 && ps.getColumnCount() > 0 && (pageIndex >= ps.getColumnCount() * ps.getRowCount() || pageIndex < 0)) {
                    return 1;
                }
                if (!ps.isMultiPageEnabled()) {
                    if (pageIndex != 0) {
                        return 1;
                    }
                    painter.setScale(0.9 * painter.maxScale(image));
                    Rectangle bounds = painter.getBounds();
                    g.translate((page.width - bounds.width) / 2, (page.height - bounds.height) / 2);
                    painter.paintDocument((Graphics2D)g, this.document, null);
                } else {
                    double mw = format2.getImageableWidth() / Math.abs(ps.getWidth() - ps.getLeftMargin() - ps.getRightMargin());
                    double mh = format2.getImageableHeight() / Math.abs(ps.getHeight() - ps.getTopMargin() - ps.getBottomMargin());
                    double m = Math.min(mw, mh);
                    painter.setPrinterScale(m);
                    int column = pageIndex % ps.getColumnCount();
                    int row = pageIndex / ps.getColumnCount();
                    double left = format2.getImageableX();
                    double top = format2.getImageableY();
                    DPoint3 origo = new DPoint3(0.0, 0.0, 0.0);
                    painter.calcGP(origo);
                    DPoint3 transformedPointOnX = new DPoint3(ps.getWidth() - ps.getLeftMargin() - ps.getRightMargin(), 0.0, 0.0);
                    painter.calcGP(transformedPointOnX);
                    DPoint3 transformedPointOnY = new DPoint3(0.0, ps.getHeight() - ps.getTopMargin() - ps.getBottomMargin(), 0.0);
                    painter.calcGP(transformedPointOnY);
                    double clipWidth = Math.abs(transformedPointOnX.x - origo.x);
                    double clipHeight = Math.abs(transformedPointOnY.y - origo.y);
                    transformedPointOnX = new DPoint3(ps.getWidth(), 0.0, 0.0);
                    painter.calcGP(transformedPointOnX);
                    transformedPointOnY = new DPoint3(0.0, ps.getHeight(), 0.0);
                    painter.calcGP(transformedPointOnY);
                    double width = Math.abs(transformedPointOnX.x - origo.x);
                    double height = Math.abs(transformedPointOnY.y - origo.y);
                    transformedPointOnX.x = ps.getLeftMargin();
                    painter.calcGP(transformedPointOnX);
                    transformedPointOnY.y = ps.getTopMargin();
                    painter.calcGP(transformedPointOnY);
                    double diffLeft = left - Math.abs(transformedPointOnX.x - origo.x);
                    double diffTop = top - Math.abs(transformedPointOnY.y - origo.y);
                    double y = (double)row * height;
                    double x = (double)column * width;
                    DPoint3 marginUpperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
                    marginUpperLeft.x += ps.getWidth() * (double)column + ps.getLeftMargin();
                    marginUpperLeft.y += ps.getHeight() * (double)row + ps.getTopMargin();
                    painter.calcGP(marginUpperLeft);
                    DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
                    upperLeft.x += ps.getWidth() * (double)column;
                    upperLeft.y += ps.getHeight() * (double)row;
                    painter.calcGP(upperLeft);
                    DPoint3 diffPoint = (DPoint3)ps.getUpperLeftPoint().clone();
                    painter.calcGP(diffPoint);
                    g.translate((int)Math.ceil(0.0 - x - diffPoint.x + diffLeft), (int)Math.ceil(0.0 - y - diffPoint.y + diffTop));
                    g.setClip((int)Math.ceil(marginUpperLeft.x), (int)Math.ceil(marginUpperLeft.y), (int)Math.ceil(clipWidth), (int)Math.ceil(clipHeight));
                    painter.paintDocument((Graphics2D)g, this.document, null);
                    g.setClip((int)Math.ceil(upperLeft.x), (int)Math.ceil(upperLeft.y), (int)Math.ceil(width), (int)Math.ceil(height));
                    painter.paintMultipageHeader((Graphics2D)g, this.document);
                }
            }
            return 0;
        }
        if (pageIndex != 0) {
            return 1;
        }
        Color oldcolor = this.molPanel.getBackground();
        this.molPanel.setBackground(Color.white);
        g.setColor(this.molPanel.getBackground());
        Dimension margin = new Dimension((int)Math.ceil((double)(page.width - image.width) / 2.0), (int)Math.ceil((double)(page.height - image.height) / 2.0));
        this.printVisibleComponents((Graphics2D)g, image, margin);
        this.molPanel.setBackground(oldcolor);
        return 0;
    }

    protected void printVisibleComponents(Graphics2D g, Dimension image, Dimension margin) {
        Dimension d = this.molPanel.getSize();
        Component[] comps = this.molPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JScrollBar) && !(comps[i] instanceof Scrollbar)) continue;
            if (comps[i].getSize().width > comps[i].getSize().height) {
                d.height -= comps[i].getSize().height;
                continue;
            }
            d.width -= comps[i].getSize().width;
        }
        double realScaleX = (double)image.width / (double)d.width;
        double realScaleY = (double)image.height / (double)d.height;
        double realScale = realScaleX < realScaleY ? realScaleX : realScaleY;
        Point offset = new Point(margin.width, margin.height);
        if (realScaleX < realScaleY) {
            if (realScaleY > 1.0) {
                offset.y = (int)Math.ceil(((double)image.height - (double)d.height * realScale) / 2.0) + margin.height;
            }
        } else if (realScaleX > 1.0) {
            offset.x = (int)Math.ceil(((double)image.width - (double)d.width * realScale) / 2.0) + margin.width;
        }
        g.fillRect(offset.x, offset.y, (int)Math.ceil((double)d.width * realScale) + 3, (int)Math.ceil((double)d.height * realScale) + 3);
        Rectangle fullrect = new Rectangle(offset.x, offset.y, (int)Math.ceil((double)d.width * realScale), (int)Math.ceil((double)d.height * realScale));
        g.setClip(fullrect);
        for (int i = 0; i < comps.length; ++i) {
            Dimension d0;
            if (comps[i] instanceof JScrollBar || comps[i] instanceof Scrollbar) continue;
            Dimension compDefSize = comps[i].getSize();
            Point p = comps[i].getLocation();
            Font defFont = null;
            Image img = null;
            String label = null;
            int fontSize = -1;
            if (comps[i] instanceof ViewCanvas) {
                if (compDefSize.height == 1) {
                    comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), 1);
                } else if (compDefSize.width == 1) {
                    comps[i].setSize(1, (int)Math.ceil((double)compDefSize.height * realScale));
                } else {
                    comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
                }
            } else if (comps[i] instanceof MolButton) {
                label = ((MolButton)comps[i]).getText();
                if (label != null) {
                    defFont = ((MolButton)comps[i]).getFont();
                    fontSize = (int)Math.ceil((double)defFont.getSize() * realScale);
                } else {
                    img = comps[i].createImage(compDefSize.width, compDefSize.height);
                    comps[i].paint(img.getGraphics());
                }
                comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
            } else if (comps[i] instanceof JLabel || comps[i] instanceof JTextArea) {
                String string = label = comps[i] instanceof JLabel ? ((JLabel)comps[i]).getText() : ((JTextArea)comps[i]).getText();
                if (label != null) {
                    defFont = comps[i] instanceof JLabel ? ((JLabel)comps[i]).getFont() : ((JTextArea)comps[i]).getFont();
                    fontSize = (int)Math.floor((double)defFont.getSize() * realScale);
                    comps[i].setFont(defFont.deriveFont((float)fontSize));
                }
                comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
            }
            int a = (int)Math.ceil((double)p.x * realScale) + offset.x;
            int b = (int)Math.ceil((double)p.y * realScale) + offset.y;
            if (!(comps[i] instanceof MolButton || (comps[i] instanceof JLabel || comps[i] instanceof JTextArea) && label != null)) {
                g.translate(a, b);
                comps[i].paint(g);
                comps[i].setSize(compDefSize);
                g.translate(-a, -b);
            } else if (label != null) {
                d0 = comps[i].getSize();
                Color defColor = g.getColor();
                g.setClip(a, b, d0.width, d0.height);
                g.setColor(Color.black);
                g.setFont(defFont.deriveFont((float)fontSize));
                if (comps[i] instanceof JTextArea) {
                    StringTokenizer textrows = new StringTokenizer(label, "\n");
                    b += fontSize;
                    while (textrows.hasMoreTokens()) {
                        label = textrows.nextToken();
                        g.drawString(label, a, b);
                        b += fontSize;
                    }
                } else {
                    g.drawString(label, a, b + fontSize);
                }
                g.setClip(fullrect);
                g.setColor(defColor);
            } else {
                d0 = comps[i].getSize();
                g.setClip(a, b, d0.width, d0.height);
                g.drawImage(img, a, b, d0.width, d0.height, null);
                img.flush();
                g.setClip(fullrect);
            }
            if (label != null) {
                comps[i].setFont(defFont);
            }
            comps[i].setSize(compDefSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callback(String method, Object arg) {
        block26: {
            if (method.equals("setMolPanel")) {
                this.molPanel = (MolPanel)arg;
            } else if (method.equals("print")) {
                PageFormat format2;
                Object paper;
                PrinterJob printerJob;
                try {
                    printerJob = PrinterJob.getPrinterJob();
                }
                catch (SecurityException sex) {
                    this.showWarning();
                    return null;
                }
                PageFormat defFormat = new PageFormat();
                if (this.document != null) {
                    PageSettings ps = this.document.getPageSettings();
                    paper = defFormat.getPaper();
                    double left = ps.getLeftMargin() / 4.2 * 72.0;
                    double right = ps.getRightMargin() / 4.2 * 72.0;
                    double top = ps.getTopMargin() / -4.2 * 72.0;
                    double bottom = ps.getBottomMargin() / -4.2 * 72.0;
                    double[] pos = this.getPosition(ps.getWidth());
                    if (pos != null) {
                        ((Paper)paper).setSize(pos[0], pos[1]);
                        ((Paper)paper).setImageableArea(left, top, pos[0] - left - right, pos[1] - top - bottom);
                    }
                    defFormat.setPaper((Paper)paper);
                }
                if ((format2 = printerJob.pageDialog(defFormat)) != defFormat) {
                    printerJob.setPrintable(this, format2);
                    if (printerJob.printDialog()) {
                        try {
                            if (this.molecule != null) {
                                paper = this.molecule.getLock();
                                synchronized (paper) {
                                    printerJob.print();
                                    break block26;
                                }
                            }
                            printerJob.print();
                        }
                        catch (SecurityException sex) {
                            this.molPanel.getErrorDisplay().firewallError(sex, null);
                        }
                        catch (PrinterException pex) {
                            pex.printStackTrace();
                        }
                    }
                }
            } else if (method.equals("setAtomSize")) {
                this.atomSize = (Double)arg;
            } else if (method.equals("setBondSpacing")) {
                this.bondSpacing = (Double)arg;
            } else if (method.equals("setDispopts")) {
                this.dispopts = (Integer)arg;
            } else if (method.equals("setMol")) {
                Molecule m;
                this.molecule = m = (Molecule)arg;
                this.document = m != null ? m.getDocument() : null;
            } else if (method.equals("setDocument")) {
                MDocument d;
                this.document = d = (MDocument)arg;
                this.molecule = d != null ? (Molecule)d.getMainMoleculeGraph() : null;
            }
        }
        return null;
    }

    private double[] getPosition(double width) {
        double[] ps = null;
        int index = -1;
        int n = DocumentSettingsConstants.MOL_XPOS.length - 1;
        for (int i = 0; i < n; ++i) {
            if (DocumentSettingsConstants.MOL_XPOS[i] != width) continue;
            index = i;
        }
        if (index >= 0) {
            ps = new double[]{DocumentSettingsConstants.XPOS[index], DocumentSettingsConstants.YPOS[index]};
        }
        return ps;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
            this.setVisible(false);
            this.dispose();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void showWarning() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(1, 1));
        JPanel p = new JPanel();
        contentPane.add(p);
        p.setBackground(new Color(0x800000));
        p.setLayout(new GridLayout(1, 1));
        JLabel l = new JLabel("Printing not allowed");
        l.setHorizontalAlignment(0);
        l.setVerticalAlignment(0);
        l.setFont(new Font("Times", 1, 18));
        l.setForeground(new Color(0xFFFFFF));
        p.add(l);
        this.getRootPane().setPreferredSize(new Dimension(300, 100));
        this.setTitle("Warning");
        this.addWindowListener(this);
        this.pack();
        this.setVisible(true);
        new Thread(this).start();
    }
}

