/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream
extends InputStream {
    private InputStream inputStream;
    private int bufferedBits;
    private long bitPosition;

    public BitInputStream(InputStream is) {
        this.inputStream = is;
        this.bufferedBits = 0;
        this.bitPosition = 0L;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.read(8);
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    public int read(int nbits) throws IOException, EOFException {
        if (nbits == 0) {
            return 0;
        }
        int bufpos = (int)(this.bitPosition & 7L);
        if (bufpos == 0 && (this.bufferedBits = this.inputStream.read()) == -1) {
            throw new EOFException("End of file reached");
        }
        int res = 0;
        if (nbits <= 8 - bufpos) {
            int mask = -1 >>> 32 - nbits;
            res = this.bufferedBits >>> bufpos & mask;
        } else {
            int ibit;
            int mask = -1 >>> 32 - ibit;
            res = this.bufferedBits >>> bufpos & mask;
            for (ibit = 8 - bufpos; ibit < nbits - 7; ibit += 8) {
                int x = this.inputStream.read();
                if (x == -1) {
                    throw new EOFException("End of file reached");
                }
                res |= (x & 0xFF) << ibit;
            }
            if (ibit != nbits) {
                this.bufferedBits = this.inputStream.read();
                if (this.bufferedBits == -1) {
                    throw new EOFException("End of file reached");
                }
                mask = -1 >>> 32 - (nbits - ibit);
                res |= (this.bufferedBits & mask) << ibit;
            }
        }
        this.bitPosition += (long)nbits;
        return res;
    }

    public boolean readBoolean() throws IOException, EOFException {
        int bufpos = (int)(this.bitPosition & 7L);
        if (bufpos == 0 && (this.bufferedBits = this.inputStream.read()) == -1) {
            throw new EOFException("End of file reached");
        }
        int res = this.bufferedBits >>> bufpos & 1;
        ++this.bitPosition;
        return res == 1;
    }

    public long getBitPosition() {
        return this.bitPosition;
    }

    public void skipFractionalByte() {
        int bufpos = (int)(this.bitPosition & 7L);
        if (bufpos != 0) {
            this.bitPosition += (long)(8 - bufpos);
            bufpos = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

