/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream {
    private int bufferedBits = 0;
    private int nbuffered = 0;
    private long bitPosition = 0L;

    public BitOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public void write(int value) throws IOException {
        this.write(value, 8);
    }

    public void write(int bits, int nbits) throws IOException {
        if (nbits == 0) {
            return;
        }
        this.bufferedBits |= bits << this.nbuffered & 0xFF;
        if (this.nbuffered + nbits < 8) {
            this.nbuffered += nbits;
        } else {
            int ibit;
            this.out.write(this.bufferedBits);
            for (ibit = 8 - this.nbuffered; ibit < nbits - 7; ibit += 8) {
                this.out.write(bits >>> ibit & 0xFF);
            }
            this.bufferedBits = ibit < 32 ? bits >>> ibit & 0xFF : 0;
            this.nbuffered = this.nbuffered + nbits & 7;
        }
        this.bitPosition += (long)nbits;
    }

    public void writeBoolean(boolean v) throws IOException {
        int bits = v ? 1 : 0;
        this.bufferedBits |= bits << this.nbuffered & 0xFF;
        if (this.nbuffered < 7) {
            ++this.nbuffered;
        } else {
            int ibit = 8 - this.nbuffered;
            this.out.write(this.bufferedBits);
            this.bufferedBits = bits >>> ibit & 0xFF;
            this.nbuffered = 0;
        }
        ++this.bitPosition;
    }

    public long getBitPosition() {
        return this.bitPosition;
    }

    public void byteAlign() throws IOException {
        if (this.nbuffered != 0) {
            this.bitPosition += (long)(8 - this.nbuffered);
            this.out.write(this.bufferedBits);
            this.nbuffered = 0;
        }
        this.bufferedBits = 0;
    }

    @Override
    public void flush() throws IOException {
        this.byteAlign();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.byteAlign();
        super.close();
    }

    public static int countBits(int max) {
        if (max < 0) {
            return 32;
        }
        if (max >= 0x400000) {
            return 31;
        }
        if (max == 0) {
            return 0;
        }
        int nbits = 1;
        while (1 << nbits - 1 <= max) {
            ++nbits;
        }
        return nbits - 1;
    }
}

