/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.awt.EventQueue;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;

public abstract class MDocSource {
    public abstract MDocument nextDoc() throws IOException;

    public void close() throws IOException {
    }

    public String getDocLabel(int k, MDocument doc) {
        return String.valueOf(k + 1);
    }

    public abstract boolean skipRecord() throws IOException;

    public abstract boolean isRewindable();

    public abstract void seekRecord(int var1, MProgressMonitor var2) throws EOFException, IOException;

    public final void seekRecordAtFraction(double q, int start, int n, int ncols, MProgressMonitor pmon) throws IOException {
        if (this.isEndReached()) {
            int m = n == 0 ? this.getRecordCountMax() : Math.min(this.getRecordCountMax(), start + n);
            int k = start + (int)(q * (double)(m - start + ncols - 1) / (double)ncols) * ncols;
            if (k > m) {
                k = m;
            }
            this.seekRecord(k, pmon);
            return;
        }
        if (q == 1.0 && n == 0) {
            this.getRecordCount();
            this.seekForward(Integer.MAX_VALUE, pmon, 0, null);
            return;
        }
        int max = n == 0 ? this.estimateNumRecords() - start : Math.min(this.estimateNumRecords() - start, n);
        int k = start + (int)(q * (double)max / (double)ncols) * ncols;
        if (k < this.getRecordCountMax()) {
            this.seekRecord(k, null);
            return;
        }
        this.seekRecord(this.getRecordCountMax(), null);
        int min = this.getRecordCount() - start;
        if (pmon != null) {
            int start1000 = 1000 * min / max;
            int end1000 = (int)(1000.0 * q);
            String starts = q == 0.0 ? "0" : start1000 / 10 + "." + start1000 % 10;
            String ends = q == 1.0 ? "100" : end1000 / 10 + "." + end1000 % 10;
            pmon.initProgressMonitor("Reading records " + starts + "%-" + ends + "%", start + min, k);
        }
        boolean r = true;
        while (r) {
            int nskip = ncols - (this.getRecordCount() - start) % ncols;
            for (int i = 0; i < nskip && r; ++i) {
                r = this.skipRecord();
            }
            max = n == 0 ? this.estimateNumRecords() - start : Math.min(this.estimateNumRecords() - start, n);
            k = start + (int)(q * (double)max / (double)ncols) * ncols;
            if (pmon != null) {
                pmon.setMaximum(k);
                pmon.setProgressValue(this.getRecordCount());
                if (pmon.isCanceled()) {
                    return;
                }
            }
            if (k == this.getRecordCount()) break;
            if (k >= this.getRecordCount()) continue;
            if (!this.isRewindable()) break;
            this.seekRecord(k, null);
            break;
        }
        if (pmon != null) {
            pmon.setMaximum(this.getRecordCount());
        }
    }

    protected abstract void seekVisitedRecord(int var1) throws IOException;

    public final int seekForward(int k, MProgressMonitor pmon, int dt, Runnable sizeupdater) throws IOException {
        int k2;
        if (this.isRewindable()) {
            if (k <= this.getRecordCountMax()) {
                this.seekVisitedRecord(k);
                k2 = k;
            } else {
                this.seekVisitedRecord(this.getRecordCountMax());
                k2 = this.skipRecords(this.getRecordCountMax(), k, pmon, dt, sizeupdater);
            }
        } else {
            k2 = this.skipRecords(this.getRecordCount(), k, pmon, dt, sizeupdater);
        }
        return k2;
    }

    protected final int skipRecords(int start, int end, final MProgressMonitor pmon, int dt, Runnable sizeupdater) throws IOException {
        if (pmon != null) {
            if (pmon.isCanceled()) {
                return start;
            }
            if (EventQueue.isDispatchThread()) {
                if (end == Integer.MAX_VALUE) {
                    int max = this.estimateNumRecords();
                    pmon.initProgressMonitor("Reading records " + (start + 1) + "-...", start, max);
                } else {
                    pmon.initProgressMonitor("Reading records " + (start + 1) + "-" + (end + 1), start, end);
                }
            } else {
                final int fstart = start;
                final int fend = end;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (pmon.isCanceled()) {
                                return;
                            }
                            if (fend == Integer.MAX_VALUE) {
                                int max = MDocSource.this.estimateNumRecords();
                                pmon.initProgressMonitor("Reading records " + (fstart + 1) + "-...", fstart, max);
                            } else {
                                pmon.initProgressMonitor("Reading records " + (fstart + 1) + "-" + (fend + 1), fstart, fend);
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
        int ipm = 0;
        int npm = 1;
        long tpm0 = System.currentTimeMillis();
        if (pmon != null && pmon.isCanceled()) {
            return start;
        }
        int prevmax = this.getRecordCountMax();
        long prev_size_update_time = System.currentTimeMillis();
        boolean size_update_needed = false;
        for (int i = start; i < end; ++i) {
            if (this.skipRecord()) {
                if (sizeupdater != null && this.getRecordCountMax() != prevmax) {
                    long t = System.currentTimeMillis();
                    if (t - prev_size_update_time >= (long)dt) {
                        sizeupdater.run();
                        prevmax = this.getRecordCountMax();
                        prev_size_update_time = t;
                        size_update_needed = false;
                    } else {
                        size_update_needed = true;
                    }
                }
                if (pmon == null) continue;
                if (++ipm >= npm) {
                    int max = this.estimateNumRecords();
                    if (EventQueue.isDispatchThread()) {
                        pmon.setMaximum(max);
                        pmon.setProgressValue(i);
                    } else {
                        try {
                            final int j = i;
                            final int fmax = max;
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    pmon.setMaximum(fmax);
                                    pmon.setProgressValue(j);
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        catch (InvocationTargetException ex) {
                            ex.printStackTrace();
                        }
                    }
                    long tpm1 = System.currentTimeMillis();
                    ipm = 0;
                    if (tpm1 - tpm0 < 50L) {
                        npm *= 2;
                    } else if (tpm1 - tpm0 > 100L) {
                        npm = npm > 1 ? npm / 2 : 1;
                    }
                    tpm0 = tpm1;
                }
                if (!pmon.isCanceled()) continue;
                if (size_update_needed && sizeupdater != null) {
                    sizeupdater.run();
                }
                return i;
            }
            if (size_update_needed && sizeupdater != null) {
                sizeupdater.run();
            }
            if (pmon != null) {
                pmon.setMaximum(i);
            }
            return i;
        }
        if (size_update_needed && sizeupdater != null) {
            sizeupdater.run();
        }
        if (pmon != null) {
            if (EventQueue.isDispatchThread()) {
                pmon.setProgressValue(pmon.getMaximum());
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            pmon.setProgressValue(pmon.getMaximum());
                        }
                    });
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return end;
    }

    public abstract boolean isEndReached();

    public abstract int getRecordCount();

    public abstract int getRecordCountMax();

    public abstract int estimateNumRecords();

    public final MoleculeIterator getMoleculeIterator() {
        return new MyMoleculeIterator();
    }

    class MyMoleculeIterator
    implements MoleculeIterator {
        Molecule nextMolecule = null;
        Throwable throwable = null;
        double progress;

        public MyMoleculeIterator() {
            this.readNext();
        }

        @Override
        public Molecule next() {
            Molecule m = this.nextMolecule;
            if (this.throwable != null) {
                String message = this.throwable.getMessage();
                this.throwable = null;
                this.readNext();
                throw new NoSuchElementException("Cannot read next molecule. " + message);
            }
            this.readNext();
            return m;
        }

        private void readNext() {
            MDocument d = null;
            try {
                d = MDocSource.this.nextDoc();
            }
            catch (Throwable t) {
                this.throwable = t;
                return;
            }
            if (d != null) {
                this.nextMolecule = (Molecule)d.getMainMoleculeGraph();
                int pos = MDocSource.this.getRecordCount();
                int all = MDocSource.this.estimateNumRecords();
                this.progress = all != 0 ? (double)(pos - 1) / (double)all : 0.0;
            } else {
                this.nextMolecule = null;
                this.progress = 1.0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextMolecule != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public double estimateProgress() {
            return this.progress;
        }
    }
}

