/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class MolImportModule {
    private MolInputStream molInputStream = null;

    public void setOptions(String options) throws IllegalArgumentException {
        if (options != null && options.length() != 0) {
            throw new IllegalArgumentException("Unknown options \"" + options + "\"");
        }
    }

    public void initMolImport(MRecord record, String fname) throws MolFormatException, IOException {
        String molstr = record.getMolString();
        String enc = record.getEncoding();
        byte[] moldata = enc != null ? molstr.getBytes(record.getEncoding()) : molstr.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(moldata);
        this.molInputStream = new MolInputStream((InputStream)bais, record.getFormat(), enc, fname);
        this.initMolImport(this.molInputStream);
    }

    public void initMolImport(MolInputStream is) throws MolFormatException, IOException {
    }

    public abstract boolean readMol(Molecule var1) throws MolFormatException, IOException;

    public abstract Molecule createMol();

    public boolean isDocumentImporter() {
        return false;
    }

    public MDocument readDocument(MDocument doc) throws IOException {
        return null;
    }

    public int getLineCount() {
        return this.molInputStream != null ? this.molInputStream.getLineCount() : 0;
    }

    public PreferredView getPreferredView() {
        return PreferredView.Default;
    }

    public static enum PreferredView {
        Matrix,
        Spreadsheet,
        Default;

    }
}

