/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import java.io.IOException;
import java.io.InputStream;

public class MonitorableInputStream
extends InputStream {
    private InputStream is;
    private long size;
    private long pos;

    public MonitorableInputStream(InputStream is, int size) {
        this.is = is;
        this.size = size;
        this.pos = 0L;
    }

    @Override
    public int read() throws IOException {
        int c = this.is.read();
        if (c != -1) {
            ++this.pos;
        }
        return c;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        int n = this.is.read(data, offset, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        long n = this.is.skip(l);
        this.pos += n;
        return n;
    }

    @Override
    public int available() {
        return (int)(this.size - this.pos);
    }

    public long getPosition() {
        return this.pos;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

