/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.SeekableInputStream;
import chemaxon.marvin.util.text.EncodingUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PositionedInputStream
extends BufferedInputStream {
    protected ByteBuffer lineByteBuffer = ByteBuffer.allocate(128);
    protected int lineCurrentColumn = 0;
    private ByteBuffer byteBuf = null;
    private int lineCount = 0;
    private long lastLinePointer = 0L;
    private String lastLine = null;
    private byte[] lastLineBytes = new byte[128];
    private int lastLineByteCount = 0;
    private ByteBuffer lastEOLByteBuffer = null;
    private StringBuffer grabLinesBuffer = null;
    private String grabbedLines = null;
    protected Encoding encoding = null;
    private int desiredBufsize = 0;
    private int initialChunkSize;
    private long filePointer = 0L;

    public PositionedInputStream(InputStream is) throws IOException {
        super(is);
        this.init(null, 1024);
    }

    public PositionedInputStream(InputStream is, int size) throws IOException {
        this(is, size, null, 1024);
    }

    public PositionedInputStream(InputStream is, String enc) throws IOException {
        super(is);
        this.init(enc, 1024);
    }

    public PositionedInputStream(InputStream is, int size, String enc) throws IOException {
        this(is, size, enc, 1024);
    }

    protected PositionedInputStream(InputStream is, int size, String enc, int initialChunkSize) throws IOException {
        super(is, size);
        this.init(enc, initialChunkSize);
    }

    private void init(String enc, int initialChunkSize) throws IOException {
        this.byteBuf = ByteBuffer.wrap(this.buf);
        this.encoding = Encoding.forName(enc);
        for (int i = 0; (i < initialChunkSize || i != this.count) && this.bufincRead() != -1; ++i) {
        }
        this.pos = 0;
        if (this.encoding == null && this.count >= 2) {
            this.encoding = EncodingUtil.getEncoding(this.buf, 0, this.count);
        }
        this.setByteOrder(this.byteBuf);
        this.setByteOrder(this.lineByteBuffer);
    }

    public void setDesiredBufferSize(int size) {
        this.desiredBufsize = size;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.filePointer;
        }
        return c;
    }

    protected final int bufincRead() throws IOException {
        if (this.pos == this.count) {
            byte[] saved = new byte[this.count];
            System.arraycopy(this.buf, 0, saved, 0, this.count);
            int c = super.read();
            byte[] tmp = new byte[saved.length + this.count];
            System.arraycopy(saved, 0, tmp, 0, saved.length);
            System.arraycopy(this.buf, 0, tmp, saved.length, this.count);
            this.buf = tmp;
            this.byteBuf = ByteBuffer.wrap(this.buf);
            this.setByteOrder(this.byteBuf);
            this.pos = this.count > 0 ? saved.length + 1 : saved.length;
            this.count = this.buf.length;
            return c;
        }
        int c = super.read();
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = super.read(b, off, len);
        if (l > 0) {
            this.filePointer += (long)l;
        }
        return l;
    }

    @Override
    public long skip(long n) throws IOException {
        long l = super.skip(n);
        if (l > 0L) {
            this.filePointer += l;
        }
        return l;
    }

    @Override
    public void reset() throws IOException {
        int p = this.pos;
        super.reset();
        this.filePointer += (long)(this.pos - p);
    }

    public final void startGrabLines() {
        this.grabLinesBuffer = new StringBuffer();
    }

    public final String endGrabLines() {
        if (this.grabLinesBuffer != null) {
            this.grabbedLines = this.grabLinesBuffer.toString();
            this.grabLinesBuffer = null;
            return this.grabbedLines;
        }
        return null;
    }

    public final String getGrabbedLines() {
        return this.grabbedLines;
    }

    public String readLine() throws IOException {
        String s;
        int wlen = 1;
        if (this.encoding != null) {
            wlen = this.encoding.wordLength();
        }
        this.lastLinePointer = this.filePointer;
        if (!this.putNextCharIntoBuf()) {
            this.lastLine = null;
            this.lastLineByteCount = 0;
            return null;
        }
        this.lineCurrentColumn = 0;
        int eollen = 0;
        if (wlen == 1) {
            eollen = this.readLine8bit();
        } else if (wlen == 2) {
            eollen = this.readLine16bit();
        } else {
            throw new IOException(this.encoding.name() + " not supported by readLine");
        }
        ++this.lineCount;
        int numbytes = wlen * this.lineCurrentColumn;
        byte[] lineBuf = this.lineByteBuffer.array();
        String string = s = this.encoding == null ? new String(lineBuf, 0, numbytes) : this.encoding.convert(lineBuf, 0, numbytes);
        if (this.grabLinesBuffer != null) {
            this.grabLinesBuffer.append(s);
            this.grabLinesBuffer.append('\n');
        }
        this.lastLine = s;
        this.saveLine(eollen, wlen, lineBuf, numbytes);
        if (this.lastEOLByteBuffer == null || eollen != 0 && this.lastEOLByteBuffer.capacity() != wlen * eollen) {
            this.lastEOLByteBuffer = ByteBuffer.allocate(wlen * eollen);
        }
        this.setByteOrder(this.lastEOLByteBuffer);
        this.putEOL(eollen, wlen, numbytes);
        return s;
    }

    public boolean skipLine() throws IOException {
        int wlen = 1;
        if (this.encoding != null) {
            wlen = this.encoding.wordLength();
        }
        this.lastLinePointer = this.filePointer;
        this.lastLine = null;
        this.lastLineByteCount = 0;
        this.lineCurrentColumn = 0;
        if (!this.putNextCharIntoBuf()) {
            return false;
        }
        int eollen = 0;
        if (wlen == 1) {
            eollen = this.skipLine8bit();
        } else if (wlen == 2) {
            eollen = this.skipLine16bit();
        } else {
            throw new IOException(this.encoding.name() + " not supported by skipLine");
        }
        ++this.lineCount;
        return true;
    }

    private void saveLine(int eollen, int wlen, byte[] lineBuf, int numbytes) {
        if (this.lastLineBytes.length < numbytes + wlen * eollen) {
            this.lastLineBytes = new byte[numbytes + wlen * eollen];
            this.lastLineByteCount = 0;
        } else {
            this.lastLineByteCount = 0;
        }
        System.arraycopy(lineBuf, 0, this.lastLineBytes, 0, numbytes);
        this.lastLineByteCount = numbytes;
    }

    private void putEOL(int eollen, int wlen, int numbytes) {
        byte[] ll = this.lastLineBytes;
        if (eollen == 1) {
            if (wlen == 1) {
                ll[numbytes] = 10;
            } else if (wlen == 2) {
                if (this.lineByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    ll[numbytes] = 0;
                    ll[numbytes + 1] = 10;
                } else {
                    ll[numbytes] = 10;
                    ll[numbytes + 1] = 0;
                }
            } else if (wlen == 4) {
                if (this.lineByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    ll[numbytes] = 0;
                    ll[numbytes + 1] = 0;
                    ll[numbytes + 2] = 0;
                    ll[numbytes + 3] = 10;
                } else {
                    ll[numbytes] = 10;
                    ll[numbytes + 1] = 0;
                    ll[numbytes + 2] = 0;
                    ll[numbytes + 3] = 0;
                }
            }
            this.setWord(this.lastEOLByteBuffer, 0, 10);
        } else if (eollen == 2) {
            if (wlen == 1) {
                ll[numbytes] = 13;
                ll[numbytes + 1] = 10;
            } else if (wlen == 2) {
                if (this.lineByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    ll[numbytes] = 0;
                    ll[numbytes + 1] = 13;
                    ll[numbytes + 2] = 0;
                    ll[numbytes + 3] = 10;
                } else {
                    ll[numbytes] = 13;
                    ll[numbytes + 1] = 0;
                    ll[numbytes + 2] = 10;
                    ll[numbytes + 3] = 0;
                }
            } else if (wlen == 4) {
                if (this.lineByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    ll[numbytes] = 0;
                    ll[numbytes + 1] = 0;
                    ll[numbytes + 2] = 0;
                    ll[numbytes + 3] = 13;
                    ll[numbytes + 4] = 0;
                    ll[numbytes + 5] = 0;
                    ll[numbytes + 6] = 0;
                    ll[numbytes + 7] = 10;
                } else {
                    ll[numbytes] = 13;
                    ll[numbytes + 1] = 0;
                    ll[numbytes + 2] = 0;
                    ll[numbytes + 3] = 0;
                    ll[numbytes + 4] = 10;
                    ll[numbytes + 5] = 0;
                    ll[numbytes + 6] = 0;
                    ll[numbytes + 7] = 0;
                }
            }
            this.setWord(this.lastEOLByteBuffer, 0, 13);
            this.setWord(this.lastEOLByteBuffer, wlen, 10);
        }
        this.lastLineByteCount += eollen * wlen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readLine8bit() throws IOException {
        int eollen = 0;
        long fp = this.filePointer;
        try {
            int c;
            do {
                int preveol = 0;
                while (this.pos < this.count) {
                    int b = this.buf[this.pos];
                    ++this.pos;
                    ++fp;
                    if (b != 13 && b != 10) {
                        byte[] lineBuf = this.lineByteBuffer.array();
                        if (this.lineCurrentColumn >= lineBuf.length) {
                            byte[] tmp = new byte[lineBuf.length << 1];
                            System.arraycopy(lineBuf, 0, tmp, 0, this.lineCurrentColumn);
                            lineBuf = tmp;
                            this.lineByteBuffer = ByteBuffer.wrap(tmp);
                        }
                        lineBuf[this.lineCurrentColumn++] = b;
                        continue;
                    }
                    preveol = b;
                    ++eollen;
                    break;
                }
                if ((c = super.read()) != -1) {
                    --this.pos;
                }
                if (preveol == 0) continue;
                if ((c == 13 || c == 10) && c != preveol) {
                    ++this.pos;
                    ++fp;
                    ++eollen;
                }
                break;
            } while (c != -1);
        }
        finally {
            this.filePointer = fp;
        }
        return eollen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int skipLine8bit() throws IOException {
        int eollen = 0;
        long fp = this.filePointer;
        try {
            int c;
            do {
                int preveol = 0;
                while (this.pos < this.count) {
                    int b = this.buf[this.pos];
                    ++this.pos;
                    ++fp;
                    if (b != 13 && b != 10) continue;
                    preveol = b;
                    ++eollen;
                    break;
                }
                if ((c = super.read()) != -1) {
                    --this.pos;
                }
                if (preveol == 0) continue;
                if ((c == 13 || c == 10) && c != preveol) {
                    ++this.pos;
                    ++fp;
                    ++eollen;
                }
                break;
            } while (c != -1);
        }
        finally {
            this.filePointer = fp;
        }
        return eollen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readLine16bit() throws IOException {
        int eollen = 0;
        long fp = this.filePointer;
        try {
            int c;
            do {
                int preveol = 0;
                while (this.pos < this.count) {
                    short b = this.byteBuf.getShort(this.pos);
                    this.pos += 2;
                    fp += 2L;
                    if (b != 13 && b != 10) {
                        byte[] lineBuf = this.lineByteBuffer.array();
                        if (2 * this.lineCurrentColumn >= lineBuf.length) {
                            byte[] tmp = new byte[lineBuf.length << 1];
                            System.arraycopy(lineBuf, 0, tmp, 0, 2 * this.lineCurrentColumn);
                            lineBuf = tmp;
                            this.lineByteBuffer = ByteBuffer.wrap(tmp);
                            this.setByteOrder(this.lineByteBuffer);
                        }
                        this.lineByteBuffer.putShort(2 * this.lineCurrentColumn, b);
                        ++this.lineCurrentColumn;
                        continue;
                    }
                    preveol = b;
                    ++eollen;
                    break;
                }
                if ((c = super.read()) != -1 && (c = super.read()) != -1) {
                    c = this.byteBuf.getShort(this.pos -= 2);
                }
                if (preveol == 0) continue;
                if ((c == 13 || c == 10) && c != preveol) {
                    this.pos += 2;
                    fp += 2L;
                    ++eollen;
                }
                break;
            } while (c != -1);
        }
        finally {
            this.filePointer = fp;
        }
        return eollen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int skipLine16bit() throws IOException {
        int eollen = 0;
        long fp = this.filePointer;
        try {
            int c;
            do {
                int preveol = 0;
                while (this.pos < this.count) {
                    short b = this.byteBuf.getShort(this.pos);
                    this.pos += 2;
                    fp += 2L;
                    if (b != 13 && b != 10) continue;
                    preveol = b;
                    ++eollen;
                    break;
                }
                if ((c = super.read()) != -1 && (c = super.read()) != -1) {
                    c = this.byteBuf.getShort(this.pos -= 2);
                }
                if (preveol == 0) continue;
                if ((c == 13 || c == 10) && c != preveol) {
                    this.pos += 2;
                    fp += 2L;
                    ++eollen;
                }
                break;
            } while (c != -1);
        }
        finally {
            this.filePointer = fp;
        }
        return eollen;
    }

    protected int getWord(ByteBuffer bb, int i) {
        if (this.encoding != null) {
            int wlen = this.encoding.wordLength();
            if (wlen == 1) {
                return bb.get(i) & 0xFFFF;
            }
            if (wlen == 2) {
                return bb.getShort(i) & 0xFFFF;
            }
            return 0;
        }
        return bb.get(i) & 0xFFFF;
    }

    protected void setWord(ByteBuffer bb, int i, int c) {
        if (this.encoding != null) {
            int wlen = this.encoding.wordLength();
            if (wlen == 1) {
                bb.put(i, (byte)(c & 0xFF));
            } else if (wlen == 2) {
                bb.putShort(i, (short)c);
            }
        } else {
            bb.put(i, (byte)(c & 0xFF));
        }
    }

    private boolean putNextCharIntoBuf() throws IOException {
        int wlen = this.encoding != null ? this.encoding.wordLength() : 1;
        for (int i = 0; i < wlen; ++i) {
            if (super.read() != -1) continue;
            return false;
        }
        this.pos -= wlen;
        return true;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public final void putBackLine() throws IOException {
        this.putBackLine(0);
    }

    public final void putBackLine(int col) throws IOException {
        int slen;
        byte[] sbytes;
        if (col != 0) {
            sbytes = this.cutLastLine(col);
            slen = sbytes.length;
        } else {
            sbytes = this.lastLineBytes;
            slen = this.lastLineByteCount;
        }
        if (sbytes != null) {
            int d;
            if (slen <= this.pos) {
                this.pos -= slen;
                d = this.buf.length - this.desiredBufsize;
                if (d > 0 && d <= this.pos) {
                    byte[] buf2 = new byte[this.desiredBufsize];
                    this.pos -= d;
                    this.count -= d;
                    System.arraycopy(this.buf, d, buf2, 0, this.count);
                    this.buf = buf2;
                    this.byteBuf = ByteBuffer.wrap(buf2);
                    this.setByteOrder(this.byteBuf);
                }
            } else {
                d = slen - this.pos;
                int count2 = this.count + d;
                byte[] buf2 = count2 <= this.buf.length ? this.buf : new byte[count2];
                System.arraycopy(this.buf, 0, buf2, d, this.count);
                this.buf = buf2;
                this.byteBuf = ByteBuffer.wrap(buf2);
                this.setByteOrder(this.byteBuf);
                this.count = count2;
                this.pos = 0;
                for (int i = 0; i < d; ++i) {
                    this.buf[i] = sbytes[i];
                }
            }
            this.lineCurrentColumn = 0;
            this.filePointer -= (long)slen;
            --this.lineCount;
            if (this.grabLinesBuffer != null) {
                int n = this.grabLinesBuffer.length() - this.lastLine.length() - 1;
                this.grabLinesBuffer.setLength(n >= 0 ? n : 0);
            }
        } else {
            throw new IOException("no line to put back");
        }
    }

    protected final void resetFilePointer() {
        this.filePointer = 0L;
        this.lineCount = 0;
    }

    public final long getFilePointer() {
        return this.filePointer;
    }

    public boolean isSeekable() {
        return this.in instanceof SeekableInputStream || this.in instanceof ByteArrayInputStream;
    }

    public void seek(long p, int lcount) throws IOException {
        if (this.in instanceof SeekableInputStream || this.in instanceof ByteArrayInputStream && this.in.markSupported()) {
            if (p != this.getFilePointer()) {
                if (p >= 0L && p < (long)this.count) {
                    this.pos = (int)p;
                } else {
                    this.count = 0;
                    this.pos = 0;
                }
                this.lineCount = lcount;
                this.lineCurrentColumn = 0;
                this.lastLinePointer = 0L;
                this.lastLine = null;
                this.lastLineByteCount = 0;
                this.filePointer = p;
                if (this.in instanceof SeekableInputStream) {
                    SeekableInputStream sin = (SeekableInputStream)this.in;
                    sin.seek(p);
                } else if (this.in.markSupported()) {
                    this.in.reset();
                    this.in.skip(p);
                }
                this.count = 0;
                this.pos = 0;
            }
        } else {
            long delta = p - this.getFilePointer();
            if (delta > 0L) {
                do {
                    this.skip(delta);
                } while ((delta = p - this.getFilePointer()) > 0L);
                this.lineCount = lcount;
            } else if (delta < 0L) {
                throw new IOException("internal error: input stream is not seekable");
            }
        }
    }

    public long length() throws IOException {
        if (!(this.in instanceof SeekableInputStream)) {
            throw new IOException("input stream is not seekable");
        }
        SeekableInputStream sin = (SeekableInputStream)this.in;
        return sin.length();
    }

    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(Encoding enc) {
        this.encoding = enc;
        if (enc != null) {
            ByteOrder order = enc.order();
            if (order == null) {
                order = ByteOrder.BIG_ENDIAN;
            }
            this.byteBuf.order(order);
            this.lineByteBuffer.order(order);
        }
    }

    public final void setEncoding(String enc) {
        this.setEncoding(Encoding.forName(enc));
    }

    protected void setByteOrder(ByteBuffer bb) {
        ByteOrder order;
        ByteOrder byteOrder = order = this.encoding != null ? this.encoding.order() : null;
        if (order == null) {
            order = ByteOrder.BIG_ENDIAN;
        }
        bb.order(order);
    }

    private byte[] cutLastLine(int col) {
        byte[] sbytes;
        Encoding enc = this.getEncoding();
        String encname = enc != null ? enc.name() : null;
        String starts = this.lastLine.substring(0, col);
        byte[] startbytes = null;
        byte[] allbytes = null;
        if (encname != null) {
            try {
                startbytes = starts.getBytes(encname);
                allbytes = this.lastLine.getBytes(encname);
            }
            catch (UnsupportedEncodingException ex) {
                encname = null;
            }
        }
        if (encname == null) {
            startbytes = starts.getBytes();
            allbytes = this.lastLine.getBytes();
        }
        if (this.lastEOLByteBuffer != null) {
            int eollen = this.lastEOLByteBuffer.capacity();
            sbytes = new byte[allbytes.length - startbytes.length + eollen];
            System.arraycopy(allbytes, startbytes.length, sbytes, 0, sbytes.length - eollen);
            this.lastEOLByteBuffer.get(sbytes, sbytes.length - eollen, eollen);
        } else {
            sbytes = new byte[allbytes.length - startbytes.length];
            System.arraycopy(allbytes, startbytes.length, sbytes, 0, sbytes.length);
        }
        this.lastLine = this.lastLine.substring(col);
        return sbytes;
    }
}

